/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.osw.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.OmadacBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapForMspDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapsDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswBackupDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.i;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.CliSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.DecodeCliPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.AbstractOswPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswQosConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.e;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.loopbackinterface.OswLoopbackInterfacePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.t;
import com.tplink.smb.omada.manager.port.mongo.device.osw.x;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51520, b=d.SWITCH)
public class OswRestoreUnitV51520
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswRestoreUnitV51520.class);
    private static final OswRestoreUnitV51520 instance = new OswRestoreUnitV51520();
    private final e oswMaintMongoRepository = e.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final j oswNetworkMaintMongoRepository = j.a();
    private final t oswStaticRoutingMaintMongoRepository = t.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.c oswLoopbackInterfaceMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.c.a();
    private final x oswVrfMaintMongoRepository = x.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.n deviceRecordRepository = com.tplink.smb.omada.manager.port.mongo.device.n.a();
    private final com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService = (com.tplink.smb.omada.manager.device.api.internal.device.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.device.api.internal.device.b.class);

    public static OswRestoreUnitV51520 getInstance() {
        return instance;
    }

    private OswRestoreUnitV51520() {
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        boolean lanNetworkInvalid;
        log.info("start restore osw V10008000...");
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(d.af.A());
        Map siteIdMaps = (Map)restoreCacheMap.get(d.Q.A());
        Map mapIdMap = restoreCacheMap.getOrDefault(d.aI.A(), new HashMap());
        Map cliConfigMap = (Map)restoreCacheMap.computeIfAbsent(d.aD.A(), key -> new HashMap());
        Map oswProfileMap = (Map)restoreCacheMap.computeIfAbsent(d.ah.A(), k2 -> new HashMap());
        Map portTagIdMap = (Map)restoreCacheMap.computeIfAbsent(d.av.A(), k2 -> new HashMap());
        Map oswTemplateIdMap = (Map)restoreCacheMap.computeIfAbsent("deviceTemplateIdMap", k2 -> new HashMap());
        boolean siteInvalid = siteIdMaps == null;
        boolean bl = lanNetworkInvalid = lanNetworkIdMap == null;
        if (siteInvalid || lanNetworkInvalid) {
            log.error("V10008000 Failed to restore osw in omadac {} because of Failed get lanNetworkInfo maps from restore cache. reason: siteIdMaps is null {} or lanNetworkInfoMaps is null {}.", new Object[]{omadacId, siteInvalid, lanNetworkInvalid});
            throw new com.tplink.smb.omada.backup.api.d.c("Reason: siteIdMaps is null " + siteInvalid + "or lanNetworkInfoMaps is null." + lanNetworkInvalid);
        }
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        DeviceRestoreInfoMapsDTO deviceRestoreInfoMapsDTO = (DeviceRestoreInfoMapsDTO)restoreCacheMap.computeIfAbsent("deviceOmadacRefer", key -> new DeviceRestoreInfoMapsDTO(new HashMap<String, String>(32)));
        DeviceRestoreInfoMapForMspDTO deviceRestoreInfoMapForMspDTO = (DeviceRestoreInfoMapForMspDTO)restoreCacheMap.computeIfAbsent("deviceOmadacReferMsp", key -> new DeviceRestoreInfoMapForMspDTO(new HashMap<String, Map<String, String>>(16)));
        Map vrfIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Z.A(), v2 -> new HashMap());
        OmadacBKDTO omadacBKDTO = (OmadacBKDTO)restoreCacheMap.get(d.s.A());
        if (Objects.isNull(omadacBKDTO)) {
            log.error("omadacSetting is null, restore osw V10008000 failed, omadac {}", (Object)omadacId);
            return;
        }
        String oldOmadacId = Optional.ofNullable(omadacBKDTO).map(OmadacBKDTO::getId).orElse(null);
        boolean restoreSelf = T.a((String)oldOmadacId, (String)omadacId.a());
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            OswBackupDTO dto = (OswBackupDTO)jsonParser.readValueAs(OswBackupDTO.class);
            if (dto == null) continue;
            this.handleOswTemplateRestore(omadacId, dto, siteIdMaps, lanNetworkIdMap, portTagIdMap, restoreCacheMap);
            if (Objects.isNull(dto.getOsw())) continue;
            OswPO osw = dto.getOsw();
            if (Objects.nonNull(osw.getLocation())) {
                osw.getLocation().setMapId((String)mapIdMap.get(osw.getLocation().getMapId()));
            }
            osw.setMvlanNetworkId((String)lanNetworkIdMap.get(osw.getMvlanNetworkId()));
            osw.setOmadacId(omadacId.a());
            this.reEncryptHwIdAndOemId(omadacId, osw);
            String siteId = (String)siteIdMaps.get(osw.getSiteId());
            osw.setSiteId(siteId);
            osw.setId(null);
            osw.setTemplateId(oswTemplateIdMap.getOrDefault(osw.getTemplateId(), osw.getTemplateId()));
            Map<Integer, String> lagIdMap = this.handleOswLag(dto.getOswLagPOS(), omadacId, siteId, lanNetworkIdMap, portTagIdMap);
            this.handleOswPort(dto.getOswPortPOS(), omadacId, siteId, lanNetworkIdMap, portTagIdMap, lagIdMap);
            this.handleOswVlanIf(dto, omadacId, siteId, lanNetworkIdMap, vrfIdMap);
            this.handleOswStaticRouting(dto, omadacId, siteId, vrfIdMap);
            this.handleDeviceCli(osw.getCliSetting(), cliConfigMap);
            this.handleOswLoopbackInterface(dto, omadacId, siteId);
            if (!restoreSelf) {
                osw.setRemember(Boolean.valueOf(false));
            }
            if (restoreSelf) {
                if (Boolean.TRUE.equals(osw.getRemember())) {
                    offlineAddRecordPO = this.deviceRecordRepository.a(new a(osw.getMac()));
                    if (Objects.isNull(offlineAddRecordPO)) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(osw.getMac()).c(osw.getSn()).a(Boolean.valueOf(true)).b());
                    } else if (!Objects.equals(omadacId.a(), offlineAddRecordPO.getOmadacId())) {
                        osw.setRemember(Boolean.valueOf(false));
                    }
                } else {
                    offlineAddRecordPO = this.deviceRecordRepository.a(omadacId, new a(osw.getMac()));
                    if (Objects.nonNull(offlineAddRecordPO) && !Boolean.TRUE.equals(osw.getAddedInAdvance())) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(osw.getMac()).c(osw.getSn()).a(Boolean.valueOf(false)).b());
                    }
                }
            }
            this.handleOswSwitchQos(osw.getQosConfig(), oswProfileMap);
            this.oswMaintMongoRepository.a(osw);
            deviceRestoreInfoMapsDTO.getDeviceControllerIdOmadacMapper().put(osw.getMac(), osw.getControllerId());
            deviceRestoreInfoMapForMspDTO.getDeviceMacControllerIdMaps().computeIfAbsent(omadacId.a(), key -> new HashMap()).put(osw.getMac(), osw.getControllerId());
            log.info("Finish to restore osw V1000800...");
        }
    }

    private void handleOswSwitchQos(OswQosConfigPO qosConfig, Map<String, String> profileMap) {
        if (Objects.nonNull(qosConfig)) {
            if (Objects.nonNull(qosConfig.getDscpDot1pMappingId())) {
                qosConfig.setDscpDot1pMappingId(profileMap.get(qosConfig.getDscpDot1pMappingId()));
            }
            if (Objects.nonNull(qosConfig.getDot1pQueueMappingId())) {
                qosConfig.setDot1pQueueMappingId(profileMap.get(qosConfig.getDot1pQueueMappingId()));
            }
            if (Objects.nonNull(qosConfig.getQueueSchedulerMappingId())) {
                qosConfig.setQueueSchedulerMappingId(profileMap.get(qosConfig.getQueueSchedulerMappingId()));
            }
        }
    }

    private void handleOswTemplateRestore(c omadacId, OswBackupDTO dto, Map<String, String> siteIdMaps, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<String, Object> restoreCacheMap) {
        if (dto.getOswTemplate() == null) {
            return;
        }
        Map vrfIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Z.A(), v2 -> new HashMap());
        Map oswTemplateIdMap = (Map)restoreCacheMap.computeIfAbsent("deviceTemplateIdMap", k2 -> new HashMap());
        OswTemplatePO oswTemplate = dto.getOswTemplate();
        String siteTemplateId = siteIdMaps.getOrDefault(oswTemplate.getSiteTemplateId(), oswTemplate.getSiteTemplateId());
        String oldTemplateId = oswTemplate.getId();
        oswTemplate.setOmadacId(omadacId.a());
        oswTemplate.setSiteTemplateId(siteTemplateId);
        oswTemplate.setMvlanNetworkId(lanNetworkIdMap.getOrDefault(oswTemplate.getMvlanNetworkId(), oswTemplate.getMvlanNetworkId()));
        String newTemplateId = this.oswMaintMongoRepository.c();
        oswTemplateIdMap.put(oldTemplateId, newTemplateId);
        oswTemplate.setDeviceTemplateId(newTemplateId);
        oswTemplate.setMac(newTemplateId);
        oswTemplate.setId(newTemplateId);
        this.oswMaintMongoRepository.a(oswTemplate);
        Map<Integer, String> lagIdMap = this.handleOswLagTemplate(dto.getOswLagTemplatePOS(), omadacId, siteTemplateId, lanNetworkIdMap, portTagIdMap, newTemplateId);
        this.handleOswPortTemplate(dto.getOswPortTemplatePOS(), omadacId, siteTemplateId, lanNetworkIdMap, portTagIdMap, lagIdMap, newTemplateId);
        this.handleOswVrfTemplate(omadacId, siteTemplateId, oldTemplateId, newTemplateId);
        this.handleOswVlanIfTemplate(dto.getVlanIfTemplates(), omadacId, siteTemplateId, lanNetworkIdMap, newTemplateId, vrfIdMap);
        this.handleOswStaticRoutingTemplate(dto.getStaticRoutingTemplates(), omadacId, siteTemplateId, newTemplateId, vrfIdMap);
        restoreCacheMap.put("deviceTemplateIdMap", oswTemplateIdMap);
    }

    private void handleOswVrfTemplate(c omadacId, String siteTemplateId, String oldTemplateId, String newTemplateId) {
        List oswVrfTemplatePOS = this.oswVrfMaintMongoRepository.a(omadacId.a(), siteTemplateId, oldTemplateId);
        oswVrfTemplatePOS.forEach(oswVrfTemplatePO -> oswVrfTemplatePO.setDeviceTemplateId(newTemplateId));
        this.oswVrfMaintMongoRepository.a(new ArrayList(oswVrfTemplatePOS), n.b);
    }

    private void handleOswStaticRoutingTemplate(List<OswStaticRoutingTemplatePO> staticRoutingTemplates, c omadacId, String siteTemplateId, String newTemplateId, Map<String, String> vrfIdMap) {
        if (CollectionUtils.isEmpty(staticRoutingTemplates)) {
            return;
        }
        for (OswStaticRoutingTemplatePO oswStaticRoutingPO : staticRoutingTemplates) {
            oswStaticRoutingPO.setId(null);
            oswStaticRoutingPO.setOmadacId(omadacId.a());
            oswStaticRoutingPO.setSiteTemplateId(siteTemplateId);
            oswStaticRoutingPO.setDeviceTemplateId(newTemplateId);
            oswStaticRoutingPO.setVrfId(vrfIdMap.get(oswStaticRoutingPO.getVrfId()));
            oswStaticRoutingPO.setNextHopVrfId(vrfIdMap.get(oswStaticRoutingPO.getNextHopVrfId()));
        }
        this.oswStaticRoutingMaintMongoRepository.a(new ArrayList<OswStaticRoutingTemplatePO>(staticRoutingTemplates), n.b);
    }

    private void handleOswVlanIfTemplate(List<OswNetworkTemplatePO> vlanIfTemplates, c omadacId, String siteTemplateId, Map<String, String> lanNetworkIdMap, String newTemplateId, Map<String, String> vrfIdMap) {
        if (!CollectionUtils.isEmpty(vlanIfTemplates)) {
            HashSet<String> vrfIds = new HashSet<String>();
            for (OswNetworkTemplatePO oswNetwork : vlanIfTemplates) {
                oswNetwork.setId(null);
                oswNetwork.setOmadacId(omadacId.a());
                oswNetwork.setSiteTemplateId(siteTemplateId);
                oswNetwork.setDeviceTemplateId(newTemplateId);
                oswNetwork.setLanNetworkId(lanNetworkIdMap.get(oswNetwork.getLanNetworkId()));
                oswNetwork.setVrfId(vrfIdMap.get(oswNetwork.getVrfId()));
                vrfIds.add(oswNetwork.getVrfId());
                if (oswNetwork.getDhcpServer() != null) {
                    oswNetwork.getDhcpServer().setVrfId(vrfIdMap.get(oswNetwork.getDhcpServer().getVrfId()));
                    vrfIds.add(oswNetwork.getDhcpServer().getVrfId());
                }
                if (oswNetwork.getDhcpRelay() == null) continue;
                oswNetwork.getDhcpRelay().setVrfId(vrfIdMap.get(oswNetwork.getDhcpRelay().getVrfId()));
                vrfIds.add(oswNetwork.getDhcpRelay().getVrfId());
            }
            Map vrfMap = this.oswVrfMaintMongoRepository.a(omadacId, siteTemplateId, vrfIds, n.b);
            vlanIfTemplates.forEach(vlanIf -> {
                vlanIf.setVrf((String)vrfMap.get(vlanIf.getVrfId()));
                if (vlanIf.getDhcpServer() != null && vlanIf.getDhcpServer().getVrfId() != null) {
                    vlanIf.getDhcpServer().setVrf((String)vrfMap.get(vlanIf.getDhcpServer().getVrfId()));
                }
                if (vlanIf.getDhcpRelay() != null && vlanIf.getDhcpRelay().getVrfId() != null) {
                    vlanIf.getDhcpRelay().setVrf((String)vrfMap.get(vlanIf.getDhcpRelay().getVrfId()));
                }
            });
            this.oswNetworkMaintMongoRepository.a(new ArrayList<OswNetworkTemplatePO>(vlanIfTemplates), n.b);
        }
    }

    private void handleOswPortTemplate(List<OswPortTemplatePO> oswPorts, c omadacId, String siteTemplateId, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<Integer, String> lagIdMap, String newTemplateId) {
        if (!CollectionUtils.isEmpty(oswPorts)) {
            for (OswPortTemplatePO oswPort : oswPorts) {
                oswPort.setId(null);
                oswPort.setOmadacId(omadacId.a());
                oswPort.setSiteTemplateId(siteTemplateId);
                oswPort.setDeviceTemplateId(newTemplateId);
                oswPort.setOswMac(newTemplateId);
                oswPort.setLagId(lagIdMap.getOrDefault(oswPort.getLag(), oswPort.getLagId()));
                oswPort.setLanProfileId(lanNetworkIdMap.getOrDefault(oswPort.getLanProfileId(), oswPort.getLanProfileId()));
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswPort, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswPort, lanNetworkIdMap);
            }
            this.oswPortMaintMongoRepository.a(new ArrayList<OswPortTemplatePO>(oswPorts), n.b);
        }
    }

    private Map<Integer, String> handleOswLagTemplate(List<OswLagTemplatePO> oswLags, c omadacId, String siteTemplateId, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, String deviceTemplateId) {
        HashMap<Integer, String> lagIdNumMap = new HashMap<Integer, String>(12);
        if (!CollectionUtils.isEmpty(oswLags)) {
            for (OswLagTemplatePO oswLag : oswLags) {
                lagIdNumMap.put(oswLag.getLag(), oswLag.getId());
                oswLag.setId(null);
                oswLag.setOmadacId(omadacId.a());
                oswLag.setSiteTemplateId(siteTemplateId);
                oswLag.setSiteId(siteTemplateId);
                oswLag.setLanProfileId(lanNetworkIdMap.get(oswLag.getLanProfileId()));
                oswLag.setDeviceTemplateId(deviceTemplateId);
                oswLag.setOswMac(deviceTemplateId);
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswLag, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswLag, lanNetworkIdMap);
            }
            List oswLagPOS = IterableUtils.toList((Iterable)this.oswLagMaintMongoRepository.a(new ArrayList<OswLagTemplatePO>(oswLags), n.b));
            if (!CollectionUtils.isEmpty((Collection)oswLagPOS)) {
                oswLagPOS.forEach(oswLagPO -> {
                    String id = (String)lagIdNumMap.get(oswLagPO.getLag());
                    if (id != null) {
                        lagIdNumMap.replace(oswLagPO.getLag(), oswLagPO.getId());
                    }
                });
            }
        }
        return lagIdNumMap;
    }

    private void handleDeviceCli(CliSettingPO cliSetting, Map<String, String> cliConfigMap) {
        if (Objects.nonNull(cliSetting) && !CollectionUtils.isEmpty((Collection)cliSetting.getCliConfigs())) {
            for (DecodeCliPO decodeCli : cliSetting.getCliConfigs()) {
                decodeCli.setConfigId(cliConfigMap.getOrDefault(decodeCli.getConfigId(), decodeCli.getConfigId()));
            }
        }
    }

    private void handleOswPort(List<OswPortPO> oswPorts, c omadacId, String siteId, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap, Map<Integer, String> lagIdMap) {
        if (!CollectionUtils.isEmpty(oswPorts)) {
            for (OswPortPO oswPort : oswPorts) {
                oswPort.setId(null);
                oswPort.setOmadacId(omadacId.a());
                oswPort.setSiteId(siteId);
                oswPort.setLagId(lagIdMap.get(oswPort.getLag()));
                oswPort.setLanProfileId(lanNetworkIdMap.get(oswPort.getLanProfileId()));
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswPort, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswPort, lanNetworkIdMap);
            }
            this.oswPortMaintMongoRepository.a(oswPorts);
        }
    }

    private Map<Integer, String> handleOswLag(List<OswLagPO> oswLags, c omadacId, String siteId, Map<String, String> lanNetworkIdMap, Map<String, String> portTagIdMap) {
        HashMap<Integer, String> lagIdNumMap = new HashMap<Integer, String>(12);
        if (!CollectionUtils.isEmpty(oswLags)) {
            for (OswLagPO oswLag : oswLags) {
                lagIdNumMap.put(oswLag.getLag(), oswLag.getId());
                oswLag.setId(null);
                oswLag.setOmadacId(omadacId.a());
                oswLag.setSiteId(siteId);
                oswLag.setLanProfileId(lanNetworkIdMap.get(oswLag.getLanProfileId()));
                com.tplink.smb.omada.backup.core.d.a.a((AbstractOswPortSettingPO)oswLag, portTagIdMap);
                com.tplink.smb.omada.backup.core.d.a.b((AbstractOswPortSettingPO)oswLag, lanNetworkIdMap);
            }
            List oswLagPOS = IterableUtils.toList((Iterable)this.oswLagMaintMongoRepository.a(new ArrayList<OswLagPO>(oswLags), n.a));
            if (!CollectionUtils.isEmpty((Collection)oswLagPOS)) {
                oswLagPOS.stream().forEach(oswLagPO -> {
                    String id = (String)lagIdNumMap.get(oswLagPO.getLag());
                    if (id != null) {
                        lagIdNumMap.replace(oswLagPO.getLag(), oswLagPO.getId());
                    }
                });
            }
        }
        return lagIdNumMap;
    }

    private void handleOswVlanIf(OswBackupDTO dto, c omadacId, String siteId, Map<String, String> lanNetworkIdMap, Map<String, String> vrfIdMap) {
        List<OswNetworkPO> vlanIfs = dto.getVlanIfs();
        if (!CollectionUtils.isEmpty(vlanIfs)) {
            for (OswNetworkPO oswNetwork : vlanIfs) {
                oswNetwork.setId(null);
                oswNetwork.setOmadacId(omadacId.a());
                oswNetwork.setSite(siteId);
                oswNetwork.setLanNetworkId(lanNetworkIdMap.get(oswNetwork.getLanNetworkId()));
                oswNetwork.setVrfId(vrfIdMap.get(oswNetwork.getVrfId()));
                if (oswNetwork.getDhcpServer() != null) {
                    oswNetwork.getDhcpServer().setVrfId(vrfIdMap.get(oswNetwork.getDhcpServer().getVrfId()));
                }
                if (oswNetwork.getDhcpRelay() == null) continue;
                oswNetwork.getDhcpRelay().setVrfId(vrfIdMap.get(oswNetwork.getDhcpRelay().getVrfId()));
            }
            this.oswNetworkMaintMongoRepository.a(vlanIfs);
        }
    }

    private void handleOswStaticRouting(OswBackupDTO dto, c omadacId, String siteId, Map<String, String> vrfIdMap) {
        List<OswStaticRoutingPO> staticRoutings = dto.getStaticRoutings();
        if (CollectionUtils.isEmpty(staticRoutings)) {
            return;
        }
        for (OswStaticRoutingPO oswStaticRoutingPO : staticRoutings) {
            oswStaticRoutingPO.setId(null);
            oswStaticRoutingPO.setOmadacId(omadacId.a());
            oswStaticRoutingPO.setSiteId(siteId);
            oswStaticRoutingPO.setVrfId(vrfIdMap.get(oswStaticRoutingPO.getVrfId()));
            oswStaticRoutingPO.setNextHopVrfId(vrfIdMap.get(oswStaticRoutingPO.getNextHopVrfId()));
        }
        this.oswStaticRoutingMaintMongoRepository.a(staticRoutings);
    }

    private void handleOswLoopbackInterface(OswBackupDTO dto, c omadacId, String siteId) {
        List<OswLoopbackInterfacePO> loopbackInterfacePOS = dto.getLoopbackInterfacePOS();
        if (CollectionUtils.isEmpty(loopbackInterfacePOS)) {
            return;
        }
        for (OswLoopbackInterfacePO oswLoopbackInterfacePO : loopbackInterfacePOS) {
            oswLoopbackInterfacePO.setOmadacId(omadacId.a());
            oswLoopbackInterfacePO.setSiteId(siteId);
        }
        this.oswLoopbackInterfaceMaintMongoRepository.a(loopbackInterfacePOS);
    }

    private void reEncryptHwIdAndOemId(c omadacId, OswPO osw) {
        try {
            if (!T.a((String)osw.getHwId())) {
                String oldEncryptedHwId = osw.getHwId();
                String hwId = b.f((String)oldEncryptedHwId);
                String newEncryptedHwId = b.d((String)hwId);
                osw.setHwId(newEncryptedHwId);
            }
            if (!T.a((String)osw.getOemId())) {
                String oldEncryptedOemId = osw.getOemId();
                String oemId = b.f((String)oldEncryptedOemId);
                String newEncryptedOemId = b.d((String)oemId);
                osw.setOemId(newEncryptedOemId);
            }
        }
        catch (com.tplink.smb.omada.common.h.b e2) {
            log.warn("Restoring osw: failed decrypt/encrypt hwId/oemId, omadacId={}, osw: {}", new Object[]{omadacId, osw, e2});
        }
    }
}

