/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.osw.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.OmadacBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapForMspDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapsDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osw.dto.OswBackupDTO;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.i;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.CliSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.cliconfig.DecodeCliPO;
import com.tplink.smb.omada.manager.port.mongo.device.n;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswNetworkPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.OswQosConfigPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.e;
import com.tplink.smb.omada.manager.port.mongo.device.osw.j;
import com.tplink.smb.omada.manager.port.mongo.device.osw.lag.OswLagPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.loopbackinterface.OswLoopbackInterfacePO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.port.OswPortPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.q;
import com.tplink.smb.omada.manager.port.mongo.device.osw.staticroute.OswStaticRoutingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osw.t;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.SWITCH)
public class OswRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswRestoreUnitV50000.class);
    private static final OswRestoreUnitV50000 instance = new OswRestoreUnitV50000();
    private final e oswMaintMongoRepository = e.a();
    private final q oswPortMaintMongoRepository = q.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.a oswLagMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.a.a();
    private final j oswNetworkMaintMongoRepository = j.a();
    private final t oswStaticRoutingMaintMongoRepository = t.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.osw.c oswLoopbackInterfaceMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.osw.c.a();
    private final n deviceRecordRepository = n.a();
    private final com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService = (com.tplink.smb.omada.manager.device.api.internal.device.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.device.api.internal.device.b.class);

    public static OswRestoreUnitV50000 getInstance() {
        return instance;
    }

    private OswRestoreUnitV50000() {
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        boolean lanNetworkInvalid;
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(d.af.A());
        Map siteIdMaps = (Map)restoreCacheMap.get(d.Q.A());
        Map mapIdMap = restoreCacheMap.getOrDefault(d.aI.A(), new HashMap());
        Map cliConfigMap = (Map)restoreCacheMap.computeIfAbsent(d.aD.A(), key -> new HashMap());
        Map oswProfileMap = (Map)restoreCacheMap.computeIfAbsent(d.ah.A(), k2 -> new HashMap());
        boolean siteInvalid = siteIdMaps == null;
        boolean bl = lanNetworkInvalid = lanNetworkIdMap == null;
        if (siteInvalid || lanNetworkInvalid) {
            log.info("V50000 Failed to restore osw in omadac {} because of Failed get lanNetworkInfo maps from restore cache. reason: siteIdMaps is null {} or lanNetworkInfoMaps is null {}.", new Object[]{omadacId, siteInvalid, lanNetworkInvalid});
            throw new com.tplink.smb.omada.backup.api.d.c("Reason: siteIdMaps is null " + siteInvalid + "or lanNetworkInfoMaps is null." + lanNetworkInvalid);
        }
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        DeviceRestoreInfoMapsDTO deviceRestoreInfoMapsDTO = (DeviceRestoreInfoMapsDTO)restoreCacheMap.computeIfAbsent("deviceOmadacRefer", key -> new DeviceRestoreInfoMapsDTO(new HashMap<String, String>(32)));
        DeviceRestoreInfoMapForMspDTO deviceRestoreInfoMapForMspDTO = (DeviceRestoreInfoMapForMspDTO)restoreCacheMap.computeIfAbsent("deviceOmadacReferMsp", key -> new DeviceRestoreInfoMapForMspDTO(new HashMap<String, Map<String, String>>(16)));
        OmadacBKDTO omadacBKDTO = (OmadacBKDTO)restoreCacheMap.get(d.s.A());
        String oldOmadacId = Optional.ofNullable(omadacBKDTO).map(OmadacBKDTO::getId).orElse(null);
        boolean restoreSelf = T.a((String)oldOmadacId, (String)omadacId.a());
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            OswBackupDTO dto = (OswBackupDTO)jsonParser.readValueAs(OswBackupDTO.class);
            if (dto == null || dto.getOsw() == null) continue;
            OswPO osw = dto.getOsw();
            if (Objects.nonNull(osw.getLocation())) {
                osw.getLocation().setMapId((String)mapIdMap.get(osw.getLocation().getMapId()));
            }
            osw.setMvlanNetworkId((String)lanNetworkIdMap.get(osw.getMvlanNetworkId()));
            osw.setOmadacId(omadacId.a());
            this.reEncryptHwIdAndOemId(omadacId, osw);
            String siteId = (String)siteIdMaps.get(osw.getSiteId());
            osw.setSiteId(siteId);
            osw.setId(null);
            Map<Integer, String> lagIdMap = this.handleOswLag(dto.getOswLagPOS(), omadacId, siteId, lanNetworkIdMap);
            this.handleOswPort(dto.getOswPortPOS(), omadacId, siteId, lanNetworkIdMap, lagIdMap);
            this.handleOswVlanIf(dto, omadacId, siteId, lanNetworkIdMap);
            this.handleOswStaticRouting(dto, omadacId, siteId);
            this.handleDeviceCli(osw.getCliSetting(), cliConfigMap);
            this.handleOswLoopbackInterface(dto, omadacId, siteId);
            if (!restoreSelf) {
                osw.setRemember(Boolean.valueOf(false));
            }
            if (restoreSelf) {
                if (Boolean.TRUE.equals(osw.getRemember())) {
                    offlineAddRecordPO = this.deviceRecordRepository.a(new a(osw.getMac()));
                    if (Objects.isNull(offlineAddRecordPO)) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(osw.getMac()).c(osw.getSn()).a(Boolean.valueOf(true)).b());
                    } else if (!Objects.equals(omadacId.a(), offlineAddRecordPO.getOmadacId())) {
                        osw.setRemember(Boolean.valueOf(false));
                    }
                } else {
                    offlineAddRecordPO = this.deviceRecordRepository.a(omadacId, new a(osw.getMac()));
                    if (Objects.nonNull(offlineAddRecordPO) && !Boolean.TRUE.equals(osw.getAddedInAdvance())) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(osw.getMac()).c(osw.getSn()).a(Boolean.valueOf(false)).b());
                    }
                }
            }
            this.handleOswSwitchQos(osw.getQosConfig(), oswProfileMap);
            this.oswMaintMongoRepository.a(osw);
            deviceRestoreInfoMapsDTO.getDeviceControllerIdOmadacMapper().put(osw.getMac(), osw.getControllerId());
            deviceRestoreInfoMapForMspDTO.getDeviceMacControllerIdMaps().computeIfAbsent(omadacId.a(), key -> new HashMap()).put(osw.getMac(), osw.getControllerId());
        }
    }

    private void handleOswSwitchQos(OswQosConfigPO qosConfig, Map<String, String> profileMap) {
        if (Objects.nonNull(qosConfig)) {
            if (Objects.nonNull(qosConfig.getDscpDot1pMappingId())) {
                qosConfig.setDscpDot1pMappingId(profileMap.get(qosConfig.getDscpDot1pMappingId()));
            }
            if (Objects.nonNull(qosConfig.getDot1pQueueMappingId())) {
                qosConfig.setDot1pQueueMappingId(profileMap.get(qosConfig.getDot1pQueueMappingId()));
            }
            if (Objects.nonNull(qosConfig.getQueueSchedulerMappingId())) {
                qosConfig.setQueueSchedulerMappingId(profileMap.get(qosConfig.getQueueSchedulerMappingId()));
            }
        }
    }

    private void handleDeviceCli(CliSettingPO cliSetting, Map<String, String> cliConfigMap) {
        if (Objects.nonNull(cliSetting) && !CollectionUtils.isEmpty((Collection)cliSetting.getCliConfigs())) {
            for (DecodeCliPO decodeCli : cliSetting.getCliConfigs()) {
                decodeCli.setConfigId(cliConfigMap.getOrDefault(decodeCli.getConfigId(), decodeCli.getConfigId()));
            }
        }
    }

    private void handleOswPort(List<OswPortPO> oswPorts, c omadacId, String siteId, Map<String, String> lanNetworkIdMap, Map<Integer, String> lagIdMap) {
        if (!CollectionUtils.isEmpty(oswPorts)) {
            for (OswPortPO oswPort : oswPorts) {
                oswPort.setId(null);
                oswPort.setOmadacId(omadacId.a());
                oswPort.setSiteId(siteId);
                oswPort.setLagId(lagIdMap.get(oswPort.getLag()));
                oswPort.setLanProfileId(lanNetworkIdMap.get(oswPort.getLanProfileId()));
            }
            this.oswPortMaintMongoRepository.a(oswPorts);
        }
    }

    private Map<Integer, String> handleOswLag(List<OswLagPO> oswLags, c omadacId, String siteId, Map<String, String> lanNetworkIdMap) {
        HashMap<Integer, String> lagIdNumMap = new HashMap<Integer, String>(12);
        if (!CollectionUtils.isEmpty(oswLags)) {
            for (OswLagPO oswLag : oswLags) {
                lagIdNumMap.put(oswLag.getLag(), oswLag.getId());
                oswLag.setId(null);
                oswLag.setOmadacId(omadacId.a());
                oswLag.setSiteId(siteId);
                oswLag.setLanProfileId(lanNetworkIdMap.get(oswLag.getLanProfileId()));
            }
            List oswLagPOS = IterableUtils.toList((Iterable)this.oswLagMaintMongoRepository.a(oswLags));
            if (!CollectionUtils.isEmpty((Collection)oswLagPOS)) {
                oswLagPOS.stream().forEach(oswLagPO -> {
                    String id = (String)lagIdNumMap.get(oswLagPO.getLag());
                    if (id != null) {
                        lagIdNumMap.replace(oswLagPO.getLag(), oswLagPO.getId());
                    }
                });
            }
        }
        return lagIdNumMap;
    }

    private void handleOswVlanIf(OswBackupDTO dto, c omadacId, String siteId, Map<String, String> lanNetworkIdMap) {
        List<OswNetworkPO> vlanIfs = dto.getVlanIfs();
        if (!CollectionUtils.isEmpty(vlanIfs)) {
            for (OswNetworkPO oswNetwork : vlanIfs) {
                oswNetwork.setId(null);
                oswNetwork.setOmadacId(omadacId.a());
                oswNetwork.setSite(siteId);
                oswNetwork.setLanNetworkId(lanNetworkIdMap.get(oswNetwork.getLanNetworkId()));
            }
            this.oswNetworkMaintMongoRepository.a(vlanIfs);
        }
    }

    private void handleOswStaticRouting(OswBackupDTO dto, c omadacId, String siteId) {
        List<OswStaticRoutingPO> staticRoutings = dto.getStaticRoutings();
        if (CollectionUtils.isEmpty(staticRoutings)) {
            return;
        }
        for (OswStaticRoutingPO oswStaticRoutingPO : staticRoutings) {
            oswStaticRoutingPO.setId(null);
            oswStaticRoutingPO.setOmadacId(omadacId.a());
            oswStaticRoutingPO.setSiteId(siteId);
        }
        this.oswStaticRoutingMaintMongoRepository.a(staticRoutings);
    }

    private void handleOswLoopbackInterface(OswBackupDTO dto, c omadacId, String siteId) {
        List<OswLoopbackInterfacePO> loopbackInterfacePOS = dto.getLoopbackInterfacePOS();
        if (CollectionUtils.isEmpty(loopbackInterfacePOS)) {
            return;
        }
        for (OswLoopbackInterfacePO oswLoopbackInterfacePO : loopbackInterfacePOS) {
            oswLoopbackInterfacePO.setId(null);
            oswLoopbackInterfacePO.setOmadacId(omadacId.a());
            oswLoopbackInterfacePO.setSiteId(siteId);
        }
        this.oswLoopbackInterfaceMaintMongoRepository.a(loopbackInterfacePOS);
    }

    private void reEncryptHwIdAndOemId(c omadacId, OswPO osw) {
        try {
            if (!T.a((String)osw.getHwId())) {
                String oldEncryptedHwId = osw.getHwId();
                String hwId = b.f((String)oldEncryptedHwId);
                String newEncryptedHwId = b.d((String)hwId);
                osw.setHwId(newEncryptedHwId);
            }
            if (!T.a((String)osw.getOemId())) {
                String oldEncryptedOemId = osw.getOemId();
                String oemId = b.f((String)oldEncryptedOemId);
                String newEncryptedOemId = b.d((String)oemId);
                osw.setOemId(newEncryptedOemId);
            }
        }
        catch (com.tplink.smb.omada.common.h.b e2) {
            log.warn("Restoring osw: failed decrypt/encrypt hwId/oemId, omadacId={}, osw: {}", new Object[]{omadacId, osw, e2});
        }
    }
}

