/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.osg.siteimport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapsDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osg.dto.OsgDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.judgement.a.e;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.analyze.api.dto.InterfaceTypeEnum;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.lannetwork.LanNetworkTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.device.LocationPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApChannelPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.SsidOverridePO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgVoipSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.GATEWAY)
public class OsgSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsgSiteImportUnit.class);
    private static final OsgSiteImportUnit instance = new OsgSiteImportUnit();
    private final c osgMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d apMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.a apChannelMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final com.tplink.smb.omada.backup.core.unit.devicebrief.c forgetNotInWhitelistAfterRestore = (com.tplink.smb.omada.backup.core.unit.devicebrief.c)a.b(com.tplink.smb.omada.backup.core.unit.devicebrief.c.class);
    private static e judgeService = (e)a.b(e.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();

    private OsgSiteImportUnit() {
    }

    public static OsgSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        Set macsToForget = restoreCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.D.A(), new HashSet());
        DeviceRestoreInfoMapsDTO deviceRestoreInfoMapsDTO = (DeviceRestoreInfoMapsDTO)restoreCacheMap.computeIfAbsent("deviceOmadacRefer", key -> new DeviceRestoreInfoMapsDTO(new HashMap<String, String>(32)));
        Map profileIdMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            OsgDTO osgDTO = (OsgDTO)jsonParser.readValueAs(OsgDTO.class);
            if (Objects.isNull(osgDTO) || CollectionUtils.isEmpty(osgDTO.getOsgList())) continue;
            List<OsgPO> osgPOs = osgDTO.getOsgList();
            for (OsgPO osgPO : osgPOs) {
                Optional osgInDbOptional;
                if (!this.validateNumLimit(omadacId)) {
                    macsToForget.add(osgPO.getMac());
                }
                if ((osgInDbOptional = this.osgMaintMongoRepository.a(omadacId, osgPO.getMac())).isPresent()) continue;
                Map<String, String> lanNetworkMaps = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
                Map<String, String> callBlockingProfileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ay.A());
                this.handleOsgVoipSetting(osgPO, callBlockingProfileIdMap, lanNetworkMaps);
                osgPO.setOmadacId(omadacId.a());
                osgPO.setSiteId(newSiteId.a());
                osgPO.setId(null);
                osgPO.setTemplateId(null);
                osgPO.setServicesOverride(null);
                osgPO.setAdvancedOverride(null);
                osgPO.setRadiosOverride(null);
                osgPO.setWlansOverride(null);
                LocationPO location = osgPO.getLocation();
                if (Objects.nonNull(location)) {
                    Map mapIdMap = siteImportIdCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.aI.A(), new HashMap());
                    location.setMapId((String)mapIdMap.get(location.getMapId()));
                }
                this.handleWirelessRouter(omadacId, newSiteId, osgPO, osgDTO.getWirelessRouterChannel());
                this.handleOduInfo(osgPO, profileIdMap);
                this.osgMaintMongoRepository.a(osgPO);
                deviceRestoreInfoMapsDTO.getDeviceControllerIdOmadacMapper().put(osgPO.getMac(), osgPO.getControllerId());
                if ((!OmadacType.t() || com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.p != com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.a((String)osgPO.getCompoundModel()) && com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.q != com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.a((String)osgPO.getCompoundModel())) && com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.F != com.tplink.smb.omada.maintenance.compatible.unit.siteconfig.wirednetwork.dto.b.a((String)osgPO.getCompoundModel())) continue;
                HashSet<String> deviceMacsToForget = new HashSet<String>(1);
                deviceMacsToForget.add(osgPO.getMac());
                this.forgetNotInWhitelistAfterRestore.a(omadacId, deviceMacsToForget);
            }
        }
    }

    private void handleOsgVoipSetting(OsgPO osgPO, Map<String, String> callBlockingProfileIdMap, Map<String, String> lanNetworkMaps) {
        if (Objects.isNull(osgPO.getVoipSetting())) {
            return;
        }
        OsgVoipSettingPO osgVoipSettingPO = osgPO.getVoipSetting();
        if (Boolean.TRUE.equals(osgVoipSettingPO.getCallBlockingEnable())) {
            osgVoipSettingPO.setCallBlockingProfileId(callBlockingProfileIdMap.get(osgVoipSettingPO.getCallBlockingProfileId()));
        }
        Integer boundInterfaceType = osgVoipSettingPO.getBoundInterfaceType();
        if (Objects.equals(InterfaceTypeEnum.b.a(), boundInterfaceType)) {
            osgVoipSettingPO.setBoundInterface(lanNetworkMaps.get(osgVoipSettingPO.getBoundInterface()));
        } else if (Objects.equals(InterfaceTypeEnum.c.a(), boundInterfaceType)) {
            osgVoipSettingPO.setVirtualWanId(lanNetworkMaps.get(osgVoipSettingPO.getVirtualWanId()));
        }
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c {
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        OsgDTO osgDTO = (OsgDTO)dataObject;
        Map wlanGroupIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), v2 -> new HashMap(2));
        Map profileIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Optional.ofNullable(osgDTO.getOsgTemplate()).ifPresent(osgTemplate -> {
            String oldTemplateId = osgTemplate.getId();
            osgTemplate.setId(null);
            osgTemplate.setOmadacId(omadacId.a());
            osgTemplate.setSiteTemplateId(newSiteTemplateId.a());
            osgTemplate.setWlanId(wlanGroupIdMap.getOrDefault(osgTemplate.getWlanId(), osgTemplate.getWlanId()));
            if (Objects.nonNull(osgTemplate.getSsid()) && !CollectionUtils.isEmpty((Map)profileIdMap)) {
                osgTemplate.getSsid().setMacFilterId(profileIdMap.getOrDefault(osgTemplate.getSsid().getMacFilterId(), osgTemplate.getSsid().getMacFilterId()));
            }
            String newTemplateId = this.osgMaintMongoRepository.a(osgTemplate);
            Map osgTemplateIdMap = siteImportIdCacheMap.computeIfAbsent("deviceTemplateIdMap", k2 -> new HashMap());
            osgTemplateIdMap.put(oldTemplateId, newTemplateId);
            siteImportIdCacheMap.put("deviceTemplateIdMap", osgTemplateIdMap);
            List interfaceNetworks = this.lanNetworkMaintMongoRepository.b(omadacId, newSiteTemplateId.a());
            for (LanNetworkTemplatePO interfaceNetwork : interfaceNetworks) {
                if (interfaceNetwork.getDeviceMac() == null || !osgTemplateIdMap.containsKey(interfaceNetwork.getDeviceMac())) continue;
                interfaceNetwork.setDeviceMac((String)osgTemplateIdMap.get(interfaceNetwork.getDeviceMac()));
                this.lanNetworkMaintMongoRepository.a(interfaceNetwork);
            }
        });
    }

    private boolean validateNumLimit(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        log.debug("validateNumLimit OmadacType {}", (Object)OmadacType.b());
        if (!judgeService.a("hardware_type")) {
            return true;
        }
        Integer maxNum = Optional.ofNullable((Integer)judgeService.a("specification_limits", "validate_num_limit", Integer.class)).orElse(-1);
        return -1 != maxNum && this.osgMaintMongoRepository.d(omadacId) < (long)maxNum.intValue();
    }

    private void handleWirelessRouter(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, OsgPO osgPO, ApChannelPO channelPO) {
        if (!Boolean.TRUE.equals(osgPO.getWirelessRouter())) {
            return;
        }
        WlanGroupPO wlanGroupPO = this.wlanGroupMaintMongoRepository.b(omadacId, newSiteId, osgPO.getWlanName());
        if (wlanGroupPO == null) {
            log.warn("WlanGroup {} not exist in omadacId {} site-siteName {}", new Object[]{osgPO.getWlanName(), omadacId, newSiteId});
            return;
        }
        osgPO.setWlanId(wlanGroupPO.getId());
        if (!CollectionUtils.isEmpty((Collection)osgPO.getSsidOverrides())) {
            List ssidList = this.ssidMaintMongoRepository.a(omadacId, newSiteId, osgPO.getWlanId());
            if (!CollectionUtils.isEmpty((Collection)ssidList)) {
                for (SsidOverridePO ssidOverride : osgPO.getSsidOverrides()) {
                    String overrideName = ssidOverride.getGlobalSsid();
                    for (SsidPO ssid : ssidList) {
                        if (!ssid.getName().equals(overrideName)) continue;
                        ssidOverride.setIndex(ssid.getEntryId());
                    }
                }
            } else {
                osgPO.setSsidOverrides(null);
            }
        }
        this.handleInvalidChildAp(omadacId.a(), osgPO);
        this.handleWirelessRouterChannel(omadacId.a(), channelPO);
    }

    private void handleInvalidChildAp(String omadacId, OsgPO osgPO) {
        if (osgPO.getMeshConf() != null && !CollectionUtils.isEmpty((Collection)osgPO.getMeshConf().getChildApMacs())) {
            for (String childMac : osgPO.getMeshConf().getChildApMacs()) {
                ApPO childApPO = this.apMaintMongoRepository.b(omadacId, childMac);
                if (childApPO != null && childApPO.getMeshConf() != null && Objects.equals(childApPO.getMeshConf().getParentApMac(), osgPO.getMac())) continue;
                osgPO.getMeshConf().getChildApMacs().remove(childMac);
            }
        }
    }

    private void handleWirelessRouterChannel(String omadacId, ApChannelPO apChannelPO) {
        if (apChannelPO != null) {
            apChannelPO.setId(null);
            apChannelPO.setOmadacId(omadacId);
            this.apChannelMaintMongoRepository.a(apChannelPO);
        }
    }

    private void handleOduInfo(OsgPO osgPO, Map<String, String> profileMap) {
        if (!Boolean.TRUE.equals(osgPO.getDeviceMisc().getSupportIppt())) {
            return;
        }
        if (Objects.nonNull(osgPO.getSsid()) && !CollectionUtils.isEmpty(profileMap)) {
            osgPO.getSsid().setMacFilterId(profileMap.get(osgPO.getSsid().getMacFilterId()));
        }
    }
}

