/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.osg.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.OmadacBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapForMspDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapsDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osg.dto.OsgDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.a;
import com.tplink.smb.omada.manager.analyze.api.dto.InterfaceTypeEnum;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.i;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApChannelPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApPO;
import com.tplink.smb.omada.manager.port.mongo.device.n;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgVoipSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.GATEWAY)
public class OsgRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsgRestoreUnitV50000.class);
    private static OsgRestoreUnitV50000 instance = new OsgRestoreUnitV50000();
    private final c osgMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d apMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.a apChannelMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.a.a();
    private final n deviceRecordRepository = n.a();
    private final com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService = (com.tplink.smb.omada.manager.device.api.internal.device.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.device.api.internal.device.b.class);

    private OsgRestoreUnitV50000() {
    }

    public static OsgRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void beforeRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        restoreCacheMap.put(d.aM.A(), this.osgMaintMongoRepository.b(omadacId));
        if (OmadacType.t()) {
            Optional osgPO = this.osgMaintMongoRepository.a(omadacId);
            osgPO.ifPresent(osg -> {
                restoreCacheMap.put("integrated_gateway", osg);
                if (osg.getAdoptInfo() != null) {
                    restoreCacheMap.put("integrated_gateway_adopt_user_self", osg.getAdoptInfo().getUsername());
                    restoreCacheMap.put("integrated_gateway_adopt_psw_self", osg.getAdoptInfo().getPassword());
                }
                if (osg.getPendingAdoptInfo() != null) {
                    restoreCacheMap.put("integrated_gateway_pending_adopt_user_self", osg.getPendingAdoptInfo().getUsername());
                    restoreCacheMap.put("integrated_gateway_pending_adopt_psw_self", osg.getPendingAdoptInfo().getPassword());
                }
            });
        }
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        Map mapIdMap = restoreCacheMap.getOrDefault(d.aI.A(), new HashMap());
        Map wirelessMap = (Map)restoreCacheMap.computeIfAbsent(d.ag.A(), k2 -> new HashMap());
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(d.af.A());
        Map callBlockingProfileIdMap = (Map)restoreCacheMap.computeIfAbsent(d.ay.A(), k2 -> new HashMap());
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        DeviceRestoreInfoMapsDTO deviceRestoreInfoMapsDTO = (DeviceRestoreInfoMapsDTO)restoreCacheMap.computeIfAbsent("deviceOmadacRefer", key -> new DeviceRestoreInfoMapsDTO(new HashMap<String, String>(32)));
        DeviceRestoreInfoMapForMspDTO deviceRestoreInfoMapForMspDTO = (DeviceRestoreInfoMapForMspDTO)restoreCacheMap.computeIfAbsent("deviceOmadacReferMsp", key -> new DeviceRestoreInfoMapForMspDTO(new HashMap<String, Map<String, String>>(32)));
        OmadacBKDTO omadacBKDTO = (OmadacBKDTO)restoreCacheMap.get(d.s.A());
        String oldOmadacId = Optional.ofNullable(omadacBKDTO).map(OmadacBKDTO::getId).orElse(null);
        boolean restoreSelf = T.a((String)oldOmadacId, (String)omadacId.a());
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            OsgDTO osgDTO = (OsgDTO)jsonParser.readValueAs(OsgDTO.class);
            if (Objects.isNull(osgDTO) || Objects.isNull(osgDTO.getOsg())) continue;
            OsgPO osgPO = osgDTO.getOsg();
            if (Objects.nonNull(osgPO.getLocation())) {
                osgPO.getLocation().setMapId((String)mapIdMap.get(osgPO.getLocation().getMapId()));
            }
            this.reEncryptHwIdAndOemId(omadacId, osgPO);
            osgPO.setOmadacId(omadacId.a());
            osgPO.setSiteId((String)siteMap.get(osgPO.getSiteId()));
            osgPO.setId(null);
            this.handleIntegratedGateway(osgPO, restoreCacheMap);
            this.handleWirelessRouter(omadacId.a(), wirelessMap, osgPO, osgDTO.getWirelessRouterChannel());
            this.handleOsgVoipSetting(osgPO, callBlockingProfileIdMap, lanNetworkIdMap);
            if (!restoreSelf) {
                osgPO.setRemember(Boolean.valueOf(false));
            }
            if (restoreSelf) {
                if (Boolean.TRUE.equals(osgPO.getRemember())) {
                    offlineAddRecordPO = this.deviceRecordRepository.a(new a(osgPO.getMac()));
                    if (Objects.isNull(offlineAddRecordPO)) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(osgPO.getMac()).c(osgPO.getSn()).a(Boolean.valueOf(true)).b());
                    } else if (!Objects.equals(omadacId.a(), offlineAddRecordPO.getOmadacId())) {
                        osgPO.setRemember(Boolean.valueOf(false));
                    }
                } else {
                    offlineAddRecordPO = this.deviceRecordRepository.a(omadacId, new a(osgPO.getMac()));
                    if (Objects.nonNull(offlineAddRecordPO) && !Boolean.TRUE.equals(osgPO.getAddedInAdvance())) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(osgPO.getMac()).c(osgPO.getSn()).a(Boolean.valueOf(false)).b());
                    }
                }
            }
            this.osgMaintMongoRepository.a(osgPO);
            deviceRestoreInfoMapsDTO.getDeviceControllerIdOmadacMapper().put(osgPO.getMac(), osgPO.getControllerId());
            deviceRestoreInfoMapForMspDTO.getDeviceMacControllerIdMaps().computeIfAbsent(omadacId.a(), key -> new HashMap()).put(osgPO.getMac(), osgPO.getControllerId());
        }
    }

    private void handleWirelessRouter(String omadacId, Map<String, String> wirelessMap, OsgPO osgPO, ApChannelPO channelPO) {
        if (!Boolean.TRUE.equals(osgPO.getWirelessRouter())) {
            return;
        }
        osgPO.setWlanId(wirelessMap.get(osgPO.getWlanId()));
        this.handleInvalidChildAp(omadacId, osgPO);
        this.handleWirelessRouterChannel(omadacId, channelPO);
    }

    private void handleOsgVoipSetting(OsgPO osgPO, Map<String, String> callBlockingProfileIdMap, Map<String, String> lanNetworkMaps) {
        if (Objects.isNull(osgPO.getVoipSetting())) {
            return;
        }
        OsgVoipSettingPO osgVoipSettingPO = osgPO.getVoipSetting();
        if (Boolean.TRUE.equals(osgVoipSettingPO.getCallBlockingEnable())) {
            osgVoipSettingPO.setCallBlockingProfileId(callBlockingProfileIdMap.get(osgVoipSettingPO.getCallBlockingProfileId()));
        }
        Integer boundInterfaceType = osgVoipSettingPO.getBoundInterfaceType();
        if (Objects.equals(InterfaceTypeEnum.b.a(), boundInterfaceType)) {
            osgVoipSettingPO.setBoundInterface(lanNetworkMaps.get(osgVoipSettingPO.getBoundInterface()));
        } else if (Objects.equals(InterfaceTypeEnum.c.a(), boundInterfaceType)) {
            osgVoipSettingPO.setVirtualWanId(lanNetworkMaps.get(osgVoipSettingPO.getVirtualWanId()));
        }
    }

    private void handleInvalidChildAp(String omadacId, OsgPO osgPO) {
        if (osgPO.getMeshConf() == null) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)osgPO.getMeshConf().getChildApMacs())) {
            for (String childMac : osgPO.getMeshConf().getChildApMacs()) {
                ApPO childApPO = this.apMaintMongoRepository.b(omadacId, childMac);
                if (childApPO != null && childApPO.getMeshConf() != null && Objects.equals(childApPO.getMeshConf().getParentApMac(), osgPO.getMac())) continue;
                osgPO.getMeshConf().getChildApMacs().remove(childMac);
            }
        }
    }

    private void handleWirelessRouterChannel(String omadacId, ApChannelPO apChannelPO) {
        if (apChannelPO != null) {
            apChannelPO.setId(null);
            apChannelPO.setOmadacId(omadacId);
            this.apChannelMaintMongoRepository.a(apChannelPO);
        }
    }

    public void handleIntegratedGateway(OsgPO osgPO, Map<String, Object> restoreCacheMap) {
        if (!OmadacType.t()) {
            return;
        }
        String defaultSiteId = (String)restoreCacheMap.get("DEFAULT_SITE");
        if (!osgPO.getSiteId().equals(defaultSiteId)) {
            return;
        }
        OsgPO integratedGateway = (OsgPO)restoreCacheMap.get("integrated_gateway");
        if (integratedGateway == null) {
            return;
        }
        restoreCacheMap.put("integrated_gateway_mac_in_backup_file", osgPO.getMac());
        log.debug("change osgPO info for integrated gateway {} to {}", (Object)osgPO.getMac(), (Object)integratedGateway.getMac());
        if (Objects.equals(osgPO.getName(), osgPO.getMac())) {
            osgPO.setName(integratedGateway.getName());
        }
        osgPO.setMac(integratedGateway.getMac());
        if (osgPO.getAdoptInfo() != null) {
            osgPO.getAdoptInfo().setUsername((String)Optional.ofNullable(restoreCacheMap.get("integrated_gateway_adopt_user_self")).map(String::valueOf).orElse(null));
            osgPO.getAdoptInfo().setPassword((String)Optional.ofNullable(restoreCacheMap.get("integrated_gateway_adopt_psw_self")).map(String::valueOf).orElse(null));
        }
        if (osgPO.getPendingAdoptInfo() != null) {
            osgPO.getPendingAdoptInfo().setUsername((String)Optional.ofNullable(restoreCacheMap.get("integrated_gateway_pending_adopt_user_self")).map(String::valueOf).orElse(null));
            osgPO.getPendingAdoptInfo().setPassword((String)Optional.ofNullable(restoreCacheMap.get("integrated_gateway_pending_adopt_psw_self")).map(String::valueOf).orElse(null));
        }
        osgPO.setId(integratedGateway.getId());
        restoreCacheMap.put("integrated_gateway_mac_self", integratedGateway.getMac());
    }

    private void reEncryptHwIdAndOemId(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, OsgPO osgPO) {
        try {
            if (!T.a((String)osgPO.getHwId())) {
                String oldEncryptedHwId = osgPO.getHwId();
                String hwId = b.f((String)oldEncryptedHwId);
                String newEncryptedHwId = b.d((String)hwId);
                osgPO.setHwId(newEncryptedHwId);
            }
            if (!T.a((String)osgPO.getOemId())) {
                String oldEncryptedOemId = osgPO.getOemId();
                String oemId = b.f((String)oldEncryptedOemId);
                String newEncryptedOemId = b.d((String)oemId);
                osgPO.setOemId(newEncryptedOemId);
            }
        }
        catch (com.tplink.smb.omada.common.h.b e2) {
            log.warn("Restoring osg: failed decrypt/encrypt hwId/oemId, omadacId={}, osgPO: {}", new Object[]{omadacId, osgPO, e2});
        }
    }
}

