/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.osg;

import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.api.e.a;
import com.tplink.smb.omada.backup.core.d.i;
import com.tplink.smb.omada.backup.core.unit.siteconfig.osg.dto.OsgDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.map.MapPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.map.b;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.a(a=com.tplink.smb.omada.backup.api.c.d.GATEWAY)
public class OsgBackupUnit
extends com.tplink.smb.omada.backup.api.b.d<OsgDTO> {
    private static OsgBackupUnit instance = new OsgBackupUnit();
    private final c osgMaintMongoRepository = c.a();
    private final b mapMaintMongoRepository = b.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.a apChannelMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.a.a();

    private OsgBackupUnit() {
    }

    public static OsgBackupUnit getInstance() {
        return instance;
    }

    public void backup(a wrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, com.tplink.smb.omada.backup.api.c.d keyEnum, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        wrapper.a(keyEnum.A());
        OsgDTO osgDTO = this.readFromDB(omadacId, siteId, false);
        if (!CollectionUtils.isEmpty(osgDTO.getOsgList())) {
            for (OsgPO osg : osgDTO.getOsgList()) {
                osg.setConfigSyncStatus(null);
                if (!h.e.equals((Object)backupTypeEnum)) continue;
                osg.setSn(i.a(osg.getSn()));
                osg.setDeviceKey(i.a(osg.getDeviceKey()));
                if (osg.getAdoptInfo() != null) {
                    osg.getAdoptInfo().setUsername(i.a(osg.getAdoptInfo().getUsername()));
                    osg.getAdoptInfo().setPassword(i.a(osg.getAdoptInfo().getPassword()));
                }
                if (osg.getPendingAdoptInfo() == null) continue;
                osg.getPendingAdoptInfo().setUsername(i.a(osg.getPendingAdoptInfo().getUsername()));
                osg.getPendingAdoptInfo().setPassword(i.a(osg.getPendingAdoptInfo().getPassword()));
            }
            wrapper.b().writeObject((Object)osgDTO);
        }
        wrapper.f();
    }

    public void backupTemplate(a wrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, String siteTemplateId, com.tplink.smb.omada.backup.api.c.d keyEnum, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        wrapper.a(keyEnum.A());
        OsgDTO osgDTO = this.readFromDB(omadacId, new d(siteTemplateId), true);
        if (Objects.nonNull(osgDTO.getOsgTemplate())) {
            wrapper.b().writeObject((Object)osgDTO);
        }
        wrapper.f();
    }

    public OsgDTO readFromDB(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, boolean siteTemplateRead) throws com.tplink.smb.omada.backup.api.d.a {
        OsgDTO osgDTO = new OsgDTO();
        if (siteTemplateRead) {
            Optional osgTemplateOpt = this.osgMaintMongoRepository.c(omadacId, siteId.a());
            osgTemplateOpt.ifPresent(osgDTO::setOsgTemplate);
        } else {
            List osgs = this.osgMaintMongoRepository.b(omadacId, siteId);
            if (CollectionUtils.isEmpty((Collection)osgs)) {
                return osgDTO;
            }
            osgDTO.setOsgList(osgs);
            for (OsgPO osgPO : osgs) {
                this.unbindMapLocation(osgPO, omadacId, siteId);
                if (Boolean.TRUE.equals(osgPO.getDeviceMisc().getIppt())) continue;
                osgDTO.setWirelessRouterChannel(this.apChannelMaintMongoRepository.a(omadacId.a(), osgPO.getMac()));
            }
        }
        return osgDTO;
    }

    private void unbindMapLocation(@Nonnull OsgPO osg, @Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d siteId) {
        if (!OmadacType.s()) {
            return;
        }
        if (Objects.isNull(osg.getLocation())) {
            return;
        }
        MapPO defaultMap = this.mapMaintMongoRepository.b(omadacId, siteId).orElse(null);
        if (Objects.isNull(defaultMap) || !T.a((String)osg.getLocation().getMapId(), (String)defaultMap.getId())) {
            osg.setLocation(null);
        }
    }
}

