/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.map.siteimport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.maintenance.domain.model.c.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.map.MapPO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.MAP)
public class MapSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapSiteImportUnit.class);
    private static final MapSiteImportUnit instance = new MapSiteImportUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.map.b mapMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.map.b.a();
    private final FileRepository fileRepository = (FileRepository)com.tplink.smb.omada.common.spring.a.b(FileRepository.class);
    private final a checkMapSizeService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);

    public static MapSiteImportUnit getInstance() {
        return instance;
    }

    private MapSiteImportUnit() {
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map mapIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.aI.A(), k2 -> new HashMap());
        jsonParserWrapper.c();
        jsonParserWrapper.c();
        List mapList = jsonParserWrapper.b(MapPO.class);
        if (CollectionUtils.isEmpty((Collection)mapList)) {
            return;
        }
        List<MapPO> restoreMapList = this.restoreMap(omadacId, newSiteId, mapList);
        this.restoreFileData(jsonParserWrapper, omadacId, restoreMapList);
        for (MapPO mapPO : restoreMapList) {
            String oldMapId = mapPO.getId();
            mapPO.setId(null);
            String newMapId = this.mapMongoRepository.a(mapPO);
            mapIdMap.put(oldMapId, newMapId);
        }
        siteImportIdCacheMap.put(com.tplink.smb.omada.backup.api.c.d.aI.A(), mapIdMap);
    }

    private List<MapPO> restoreMap(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, List<MapPO> mapList) {
        ArrayList<MapPO> restoreMapList = new ArrayList<MapPO>();
        long mapCnt = this.mapMongoRepository.b(omadacId);
        Iterator<MapPO> iterator = mapList.iterator();
        while (iterator.hasNext()) {
            MapPO mapPO = iterator.next();
            mapPO.setOmadacId(omadacId.a());
            mapPO.setSiteId(newSiteId.a());
            if (mapPO.defaultMap()) {
                restoreMapList.add(mapPO);
                continue;
            }
            if (!this.checkMapParam(mapPO, omadacId, mapCnt)) {
                iterator.remove();
                continue;
            }
            if (this.checkMapSizeService.a(mapPO.getLength().longValue(), omadacId)) {
                log.warn("Total file size has reached maximum in omadac {}, ignore map {}", (Object)omadacId, (Object)mapPO.getName());
                iterator.remove();
                continue;
            }
            ++mapCnt;
            restoreMapList.add(mapPO);
        }
        return restoreMapList;
    }

    private void restoreFileData(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, List<MapPO> restoreMapList) {
        if (CollectionUtils.isEmpty(restoreMapList)) {
            return;
        }
        Map<String, List<MapPO>> restoreFileIdMap = restoreMapList.stream().filter(mapPO -> !Objects.isNull(mapPO.getFileId())).collect(Collectors.groupingBy(MapPO::getFileId));
        InputStream in = null;
        try {
            JsonParser jsonParser = jsonParserWrapper.h();
            jsonParser.nextToken();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (!jsonParser.currentToken().equals((Object)JsonToken.FIELD_NAME)) continue;
                String fileId = jsonParser.currentName();
                String fileData = jsonParser.nextTextValue();
                List<MapPO> mapList = restoreFileIdMap.get(fileId);
                if (CollectionUtils.isEmpty(mapList)) continue;
                for (MapPO mapPO2 : mapList) {
                    if (mapPO2 == null) continue;
                    Optional existsOptional = this.mapMongoRepository.a(omadacId, mapPO2.getMd5());
                    if (existsOptional.isPresent()) {
                        mapPO2.setFileId(((MapPO)existsOptional.get()).getFileId());
                        continue;
                    }
                    if (T.a((String)fileData)) {
                        log.error("fileData could not be found according to this fileId {} in omadac {}", (Object)mapPO2.getFileId(), (Object)omadacId);
                        restoreMapList.remove(mapPO2);
                        continue;
                    }
                    in = new ByteArrayInputStream(c.b((String)fileData));
                    String newFileId = this.fileRepository.saveFile(omadacId.a() + "/" + mapPO2.getSiteId(), null, mapPO2.getName(), in);
                    if (T.a((String)newFileId)) {
                        log.error("Fail to safe picture for map {} in omadac {}, ignore it", (Object)mapPO2.getName(), (Object)omadacId);
                        restoreMapList.remove(mapPO2);
                        continue;
                    }
                    mapPO2.setFileId(newFileId);
                }
            }
            jsonParser.nextToken();
        }
        catch (Exception e2) {
            log.warn("failed to site import map in omadacId {}, error message:{}", (Object)omadacId.a(), (Object)e2.getMessage());
            throw new com.tplink.smb.omada.backup.api.d.c("Failed to restore map file data");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e3) {
                    log.error(e3.getMessage(), (Throwable)e3);
                }
            }
        }
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        String oldSiteId;
        String oldCustomerId;
        Map<String, String> siteIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Q.A());
        if (CollectionUtils.isEmpty(siteIdMap)) {
            return;
        }
        String oldOmadacId = omadacId.a();
        Map<String, String> customerIdMap = siteImportIdCacheMap.get("customerIdMap");
        if (!CollectionUtils.isEmpty(customerIdMap) && (oldCustomerId = customerIdMap.get(omadacId.a())) != null) {
            oldOmadacId = oldCustomerId;
        }
        if ((oldSiteId = siteIdMap.get(newSiteId.a())) == null) {
            return;
        }
        List mapList = this.mapMongoRepository.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(oldOmadacId), new d(oldSiteId));
        Map mapIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.aI.A(), v2 -> new HashMap());
        long mapCnt = this.mapMongoRepository.b(omadacId);
        Iterator iterator = mapList.iterator();
        while (iterator.hasNext()) {
            MapPO mapPO = (MapPO)iterator.next();
            if (mapPO.defaultMap()) {
                String oldId = mapPO.getId();
                mapPO.setId(null);
                mapPO.setOmadacId(omadacId.a());
                mapPO.setSiteId(newSiteId.a());
                mapIdsMap.put(oldId, this.mapMongoRepository.a(mapPO));
                continue;
            }
            if (!this.checkMapParam(mapPO, omadacId, mapCnt)) {
                iterator.remove();
                continue;
            }
            Optional existsOptional = this.mapMongoRepository.a(omadacId, mapPO.getMd5());
            if (existsOptional.isPresent()) {
                mapPO.setFileId(((MapPO)existsOptional.get()).getFileId());
            } else {
                InputStream in = null;
                try {
                    in = this.fileRepository.readFile(mapPO.getFileId());
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)outputStream);
                    String fileData = c.c((byte[])outputStream.toByteArray());
                    if (!this.checkMapFileParam(omadacId, fileData, mapPO)) {
                        iterator.remove();
                        continue;
                    }
                }
                catch (Exception e2) {
                    log.warn("failed to site import map in omadacId {}, error message:{}", (Object)omadacId.a(), (Object)e2.getMessage());
                    throw new com.tplink.smb.omada.backup.api.d.c("Failed to restore map file data");
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        log.error(e3.getMessage(), (Throwable)e3);
                    }
                    continue;
                }
            }
            String oldId = mapPO.getId();
            mapPO.setId(null);
            mapPO.setOmadacId(omadacId.a());
            mapPO.setSiteId(newSiteId.a());
            mapIdsMap.put(oldId, this.mapMongoRepository.a(mapPO));
            ++mapCnt;
        }
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }

    private boolean checkMapParam(MapPO mapPO, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, long mapCnt) {
        if (T.a((String)mapPO.getFileId())) {
            log.error("Failed find picture for map {} while restore maps in omadac {}, ignore it", (Object)omadacId, (Object)mapPO.getName());
            return false;
        }
        if (mapPO.getLength() > 0x800000L) {
            log.warn("Too large map with size {}. omadacId {}, ignore it", (Object)mapPO.getLength(), (Object)omadacId);
            return false;
        }
        if (mapCnt >= (long)b.G()) {
            log.warn("Total map num has reached maximum in omadac {}, ignore map {}", (Object)omadacId, (Object)mapPO.getName());
            return false;
        }
        return true;
    }

    private boolean checkMapFileParam(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, String fileData, MapPO mapPO) {
        if (fileData == null) {
            log.error("fileData could not be found for map {} with {} in omadac {}", new Object[]{mapPO.getName(), mapPO.getFileId(), omadacId});
            return false;
        }
        if (this.checkMapSizeService.a(mapPO.getLength().longValue(), omadacId)) {
            log.warn("Total file size has reached maximum in omadac {}, ignore map {}", (Object)omadacId, (Object)mapPO.getName());
            return false;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(c.b((String)fileData));
        String fileId = this.fileRepository.saveFile(omadacId.a() + "/" + mapPO.getSiteId(), null, mapPO.getName(), (InputStream)in);
        if (fileId == null) {
            log.error("Fail to safe picture for map {} in omadac {}, ignore it", (Object)mapPO.getName(), (Object)omadacId);
            return false;
        }
        mapPO.setFileId(fileId);
        return true;
    }
}

