/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.map.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.maintenance.domain.model.c.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.map.MapPO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.MAP)
public class MapRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapRestoreUnitV50000.class);
    private static final MapRestoreUnitV50000 instance = new MapRestoreUnitV50000();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.map.b mapMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.map.b.a();
    private final FileRepository fileRepository = (FileRepository)com.tplink.smb.omada.common.spring.a.b(FileRepository.class);
    private final a checkMapSizeService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);

    public static MapRestoreUnitV50000 getInstance() {
        return instance;
    }

    private MapRestoreUnitV50000() {
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        Map mapIdMap = (Map)restoreCacheMap.computeIfAbsent(d.aI.A(), k2 -> new HashMap());
        jsonParserWrapper.c();
        jsonParserWrapper.c();
        List mapList = jsonParserWrapper.b(MapPO.class);
        this.checkBackUpMap(mapList, omadacId);
        List<MapPO> restoreMapList = this.restoreMap(omadacId, mapList, siteMap);
        this.restoreFileData(jsonParserWrapper, omadacId, restoreMapList);
        for (MapPO mapPO : restoreMapList) {
            String oldMapId = mapPO.getId();
            mapPO.setId(null);
            String newMapId = this.mapMongoRepository.a(mapPO);
            mapIdMap.put(oldMapId, newMapId);
        }
        restoreCacheMap.put(d.aI.A(), mapIdMap);
    }

    private List<MapPO> restoreMap(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, List<MapPO> mapList, Map<String, String> siteMap) {
        ArrayList<MapPO> restoreMapList = new ArrayList<MapPO>();
        long mapCnt = this.mapMongoRepository.b(omadacId);
        long mapSizeSum = 0L;
        Iterator<MapPO> iterator = mapList.iterator();
        while (iterator.hasNext()) {
            MapPO mapPO = iterator.next();
            mapPO.setOmadacId(omadacId.a());
            String newSiteId = siteMap.get(mapPO.getSiteId());
            if (newSiteId == null) {
                log.warn("siteId={} fail to match new site id, omadacId={}", (Object)mapPO.getSiteId(), (Object)omadacId);
                continue;
            }
            mapPO.setSiteId(newSiteId);
            if (mapPO.defaultMap()) {
                restoreMapList.add(mapPO);
                continue;
            }
            if (!this.checkMapParam(mapPO, omadacId)) {
                iterator.remove();
                continue;
            }
            if (mapCnt >= (long)b.G()) {
                log.warn("Total map num has reached maximum in omadac {}, ignore map {}", (Object)omadacId, (Object)mapPO.getName());
                iterator.remove();
                continue;
            }
            if (this.checkMapSizeService.a(mapSizeSum += Objects.isNull(mapPO.getLength()) ? 0L : mapPO.getLength(), omadacId)) {
                log.warn("Total file size has reached maximum in omadac {}, ignore map {}", (Object)omadacId, (Object)mapPO.getName());
                iterator.remove();
                continue;
            }
            ++mapCnt;
            restoreMapList.add(mapPO);
        }
        return restoreMapList;
    }

    private void restoreFileData(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, List<MapPO> restoreMapList) {
        if (CollectionUtils.isEmpty(restoreMapList)) {
            return;
        }
        Map<String, List<MapPO>> restoreFileIdMap = restoreMapList.stream().filter(mapPO -> !Objects.isNull(mapPO.getFileId())).collect(Collectors.groupingBy(MapPO::getFileId));
        try {
            JsonParser jsonParser = jsonParserWrapper.h();
            jsonParser.nextToken();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (!jsonParser.currentToken().equals((Object)JsonToken.FIELD_NAME)) continue;
                String fileId = jsonParser.currentName();
                String fileData = jsonParser.nextTextValue();
                List<MapPO> mapList = restoreFileIdMap.get(fileId);
                if (CollectionUtils.isEmpty(mapList)) continue;
                for (MapPO mapPO2 : mapList) {
                    if (mapPO2 == null) continue;
                    if (T.a((String)fileData)) {
                        log.error("fileData could not be found according to this fileId {} in omadac {}", (Object)mapPO2.getFileId(), (Object)omadacId);
                        restoreMapList.remove(mapPO2);
                        continue;
                    }
                    ByteArrayInputStream in = new ByteArrayInputStream(c.b((String)fileData));
                    String newFileId = this.fileRepository.saveFile(omadacId.a() + "/" + mapPO2.getSiteId(), null, mapPO2.getName(), (InputStream)in);
                    if (T.a((String)newFileId)) {
                        log.error("Fail to safe picture for map {} in omadac {}, ignore it", (Object)mapPO2.getName(), (Object)omadacId);
                        restoreMapList.remove(mapPO2);
                        continue;
                    }
                    mapPO2.setFileId(newFileId);
                }
            }
            jsonParser.nextToken();
        }
        catch (Exception e2) {
            log.warn("V50000 failed to restore map in omadacId {}, error message:{}", (Object)omadacId.a(), (Object)e2.getMessage());
            throw new com.tplink.smb.omada.backup.api.d.c("Failed to restore map file data");
        }
    }

    private void checkBackUpMap(@Nullable List<MapPO> mapList, @Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        if (Objects.isNull(mapList) || CollectionUtils.isEmpty(mapList)) {
            log.error("Failed to find any map while restore maps {} in omadac {}", mapList, (Object)omadacId);
            throw new com.tplink.smb.omada.backup.api.d.c("Failed to find any map while restore maps");
        }
    }

    private boolean checkMapParam(MapPO mapPO, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        if (T.a((String)mapPO.getFileId())) {
            log.error("Failed find picture for map {} while restore maps in omadac {}, ignore it", (Object)omadacId, (Object)mapPO.getName());
            return false;
        }
        if (mapPO.getLength() > 0x800000L) {
            log.warn("Too large map with size {}. omadacId {}, ignore it", (Object)mapPO.getLength(), (Object)omadacId);
            return false;
        }
        return true;
    }
}

