/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.map;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.core.unit.siteconfig.map.dto.MapBackupDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.map.MapPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.map.b;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.a(a=com.tplink.smb.omada.backup.api.c.d.MAP)
public class MapBackupUnit
extends com.tplink.smb.omada.backup.api.b.d<MapBackupDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapBackupUnit.class);
    private static final MapBackupUnit instance = new MapBackupUnit();
    private final b mapMongoRepository = b.a();
    private final FileRepository fileRepository = (FileRepository)a.b(FileRepository.class);

    public static MapBackupUnit getInstance() {
        return instance;
    }

    private MapBackupUnit() {
    }

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, com.tplink.smb.omada.backup.api.c.d keyEnum, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        wrapper.b().writeFieldName(com.tplink.smb.omada.backup.api.c.d.aI.A());
        wrapper.c();
        wrapper.a("maps");
        ArrayList<MapPO> mapList = new ArrayList<MapPO>();
        this.readControllerMap(mapList, omadacId, siteId);
        if (CollectionUtils.isEmpty(mapList)) {
            log.error("no maps exist in this omadac {} site {}.", (Object)omadacId, (Object)siteId);
            throw new com.tplink.smb.omada.backup.api.d.a("no maps exist in this omadac " + omadacId + " site " + siteId);
        }
        for (MapPO mapPO : mapList) {
            wrapper.b().writeObject((Object)mapPO);
        }
        wrapper.f();
        this.writeMapFileData(wrapper, mapList, omadacId, siteId);
        wrapper.d();
    }

    public MapBackupDTO readFromDB(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d siteId, boolean siteTemplateRead) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        return null;
    }

    private void readControllerMap(@Nonnull List<MapPO> mapList, @Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d siteId) {
        mapList.addAll(this.mapMongoRepository.a(omadacId, siteId));
        if (CollectionUtils.isEmpty(mapList)) {
            log.error("no maps exist in this omadac {} site {}.", (Object)omadacId, (Object)siteId);
            throw new com.tplink.smb.omada.backup.api.d.a("no maps exist");
        }
    }

    private void writeMapFileData(com.tplink.smb.omada.backup.api.e.a wrapper, @Nonnull List<MapPO> mapList, @Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d siteId) throws IOException {
        wrapper.b().writeFieldName("files");
        wrapper.c();
        Iterator<MapPO> iterator = mapList.iterator();
        while (iterator.hasNext()) {
            MapPO mapPO = iterator.next();
            if (mapPO.defaultMap()) continue;
            if (mapPO.getFileId() == null) {
                log.error("Failed find picture for map {} in omadac {} site {}, ignore it", new Object[]{mapPO.getName(), omadacId, siteId});
                iterator.remove();
                continue;
            }
            InputStream inputStream = this.fileRepository.readFile(mapPO.getFileId());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            inputStream.close();
            String fileData = c.c((byte[])outputStream.toByteArray());
            if (fileData == null) {
                log.error("Failed find picture {} for map {} in omadac {} site {}, ignore it", new Object[]{mapPO.getFileId(), mapPO.getName(), omadacId, siteId});
                iterator.remove();
                continue;
            }
            wrapper.a(mapPO.getFileId(), fileData);
        }
        wrapper.d();
    }
}

