/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.mail.siteimport;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.d.c;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.mail.dto.MailDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.mail.MailServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.mail.MailServerTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.mail.a;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=d.MAIL)
public class MailSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    private static final MailSiteImportUnit instance = new MailSiteImportUnit();
    private final a mailServerRepository = a.a();

    private MailSiteImportUnit() {
    }

    public static MailSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, c {
        MailDTO mail = (MailDTO)jsonParserWrapper.a(MailDTO.class);
        if (mail == null) {
            return;
        }
        this.handleServer(omadacId, newSiteId, mail.getServers(), siteImportIdCacheMap, false);
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, c {
        if (dataObject == null || dataObject.getClass() != MailDTO.class) {
            return;
        }
        MailDTO mail = (MailDTO)dataObject;
        this.handleServer(omadacId, newSiteId, mail.getServers(), siteImportIdCacheMap, true);
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws c, IOException {
        Map<Object, Object> mailMap;
        Map<Object, Object> map = mailMap = siteImportIdCacheMap.get("mailServerIdMap") == null ? new HashMap() : siteImportIdCacheMap.get("mailServerIdMap");
        if (dataObject == null || dataObject.getClass() != MailDTO.class) {
            return;
        }
        MailDTO mailDTO = (MailDTO)dataObject;
        List<MailServerTemplatePO> templates = mailDTO.getServersTemplate();
        if (!CollectionUtils.isEmpty(templates)) {
            templates.forEach(template -> {
                String oldId = template.getId();
                template.setOmadacId(omadacId.a());
                template.setSiteTemplateId(newSiteTemplateId.a());
                template.setId(null);
                mailMap.put(oldId, this.mailServerRepository.a(template));
            });
        }
        siteImportIdCacheMap.put("mailServerIdMap", mailMap);
    }

    private void handleServer(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, com.tplink.smb.omada.maintenance.common.b.a.a.d siteId, List<MailServerPO> poList, Map<String, Map<String, String>> siteImportIdCacheMap, boolean isSiteCopy) {
        Map<Object, Object> mailServerIdMap;
        Map<Object, Object> map = mailServerIdMap = siteImportIdCacheMap.get("mailServerIdMap") == null ? new HashMap() : siteImportIdCacheMap.get("mailServerIdMap");
        if (!CollectionUtils.isEmpty(poList)) {
            poList.forEach(server -> {
                if (isSiteCopy && server.getMac() != null) {
                    return;
                }
                String oldId = server.getId();
                server.setOmadacId(omadacId.a());
                server.setSiteId(siteId.a());
                server.setTemplateId(null);
                server.setOverride(null);
                server.setId(null);
                mailServerIdMap.put(oldId, this.mailServerRepository.b(server));
            });
        }
        siteImportIdCacheMap.put("mailServerIdMap", mailServerIdMap);
    }
}

