/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.ips.restore;

import com.tplink.smb.ecsp.common.util.CollectionUtils;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ips.dto.IpsBackupDTO;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.configuration.api.web.site.ips.dto.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.BaseIpsPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.BlacklistPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.IpsSignaturePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.WhitelistPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.h;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.i;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51000, b=d.IPS)
public class IpsRestoreUnitV51000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpsRestoreUnitV51000.class);
    private static final IpsRestoreUnitV51000 instance = new IpsRestoreUnitV51000();
    private final h ipsSettingMaintMongoRepository = h.a();
    private final i ipsSignatureMaintMongoRepository = i.a();
    private final b ipsBlackListMaintMongoRepository = b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.l ipsWhiteListMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.ips.l.a();

    private IpsRestoreUnitV51000() {
    }

    public static IpsRestoreUnitV51000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        IpsBackupDTO ipsBackupDTO = (IpsBackupDTO)jsonParserWrapper.a(IpsBackupDTO.class);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(d.Y.A(), key -> new HashMap());
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(d.af.A());
        Optional.ofNullable(ipsBackupDTO.getIpsSetting()).ifPresent(po -> {
            po.setOmadacId(omadacId.a());
            po.setSiteId((String)siteMap.get(po.getSiteId()));
            po.setId(null);
            if (po.getTimeRangeId() != null) {
                po.setTimeRangeId((String)profileMap.get(po.getTimeRangeId()));
            }
            this.ipsSettingMaintMongoRepository.a((BaseIpsPO)po);
        });
        this.handleIpsSignature(ipsBackupDTO, omadacId, siteMap);
        this.handleIpsBlackList(ipsBackupDTO, omadacId, siteMap);
        this.handleIpsWhiteList(ipsBackupDTO, omadacId, siteMap, lanNetworkIdMap);
    }

    private void handleIpsSignature(IpsBackupDTO ipsBackupDTO, c omadacId, Map<String, String> siteMap) {
        List<IpsSignaturePO> ipsSignaturePOS = ipsBackupDTO.getSignatures();
        log.debug("restore ips Signatures: {}", ipsSignaturePOS);
        if (CollectionUtils.isEmpty(ipsSignaturePOS)) {
            return;
        }
        ipsSignaturePOS.forEach(po -> {
            po.setOmadacId(omadacId.a());
            po.setSiteId((String)siteMap.get(po.getSiteId()));
            po.setId(null);
        });
        this.ipsSignatureMaintMongoRepository.a(ipsSignaturePOS);
    }

    private void handleIpsBlackList(IpsBackupDTO ipsBackupDTO, c omadacId, Map<String, String> siteMap) {
        List<BlacklistPO> blacklists = ipsBackupDTO.getBlacklists();
        log.debug("restore ips blacklist: {}", blacklists);
        if (CollectionUtils.isEmpty(blacklists)) {
            return;
        }
        blacklists.forEach(po -> {
            po.setOmadacId(omadacId.a());
            po.setSiteId((String)siteMap.get(po.getSiteId()));
            po.setId(null);
        });
        this.ipsBlackListMaintMongoRepository.a(blacklists);
    }

    private void handleIpsWhiteList(IpsBackupDTO ipsBackupDTO, c omadacId, Map<String, String> siteMap, Map<String, String> lanNetworkIdMap) {
        List<WhitelistPO> whitelists = ipsBackupDTO.getWhitelists();
        log.debug("restore ips whitelist: {}", whitelists);
        if (CollectionUtils.isEmpty(whitelists)) {
            return;
        }
        whitelists.forEach(po -> {
            po.setOmadacId(omadacId.a());
            String siteId = (String)siteMap.get(po.getSiteId());
            po.setSiteId(siteId);
            po.setId(null);
            if (Objects.equals(e.b.b(), po.getTrafficType())) {
                if (log.isDebugEnabled()) {
                    log.debug("ips white list is po : {}, omdacId:{}, siteId: {}", new Object[]{x.a((Object)po), omadacId, siteId});
                }
                if (lanNetworkIdMap.containsKey(po.getTrafficSource())) {
                    String newId = (String)lanNetworkIdMap.get(po.getTrafficSource());
                    po.setTrafficSource(newId);
                    if (log.isDebugEnabled()) {
                        log.debug("ips white list new network id is {}, omdacId:{}, siteId: {}", new Object[]{newId, omadacId, siteId});
                    }
                }
            }
        });
        this.ipsWhiteListMaintMongoRepository.a(whitelists);
    }
}

