/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.iot.restore.siteimport;

import com.tplink.smb.omada.backup.core.unit.siteconfig.iot.dto.IotConfigDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.iot.BaseIotServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.iot.IotBtIbeaconPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.iot.IotServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.iot.IotServerTemplatePO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.IOT)
public class IotConfigSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IotConfigSiteImportUnit.class);
    private static final IotConfigSiteImportUnit instance = new IotConfigSiteImportUnit();
    private final b iotServerMaintMongoRepository = b.a();
    private final a iotBtIbeaconMaintMongoRepository = a.a();
    private static final Integer BUILD_IN = 0;

    private IotConfigSiteImportUnit() {
    }

    public static IotConfigSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        IotConfigDTO iotConfigDTO = (IotConfigDTO)jsonParserWrapper.a(IotConfigDTO.class);
        this.siteCopyWrite(iotConfigDTO, omadacId, newSiteId, siteImportIdCacheMap);
        List<IotBtIbeaconPO> iotBtIbeacons = iotConfigDTO.getIotBtIbeacon();
        if (!CollectionUtils.isEmpty(iotBtIbeacons)) {
            this.copyIotBtIbeacon(omadacId, newSiteId, iotBtIbeacons);
        }
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        HashMap<String, String> profileIdMap;
        List<IotServerPO> iotServers = ((IotConfigDTO)dataObject).getIotServers();
        List<IotBtIbeaconPO> iotBtIbeacons = ((IotConfigDTO)dataObject).getIotBtIbeacon();
        Map<String, String> map = profileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()) == null ? new HashMap<String, String>() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
        if (!CollectionUtils.isEmpty(iotServers)) {
            this.copyIotServer(omadacId, newSiteId, iotServers, profileIdMap);
        }
        if (!CollectionUtils.isEmpty(iotBtIbeacons)) {
            iotBtIbeacons.removeIf(po -> !Objects.equals(po.getBuildIn(), BUILD_IN));
            this.copyIotBtIbeacon(omadacId, newSiteId, iotBtIbeacons);
        }
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        IotConfigDTO iotConfig = (IotConfigDTO)dataObject;
        List<IotServerTemplatePO> iotServerTemplatePOList = iotConfig.getIotServerTemplate();
        if (!CollectionUtils.isEmpty(iotServerTemplatePOList)) {
            iotServerTemplatePOList.forEach(templatePO -> {
                templatePO.setOmadacId(omadacId.a());
                templatePO.setSiteTemplateId(newSiteTemplateId.a());
                templatePO.setId(null);
                this.iotServerMaintMongoRepository.a((BaseIotServerPO)templatePO);
            });
        }
    }

    private void copyIotBtIbeacon(c omadacId, d newSiteId, List<IotBtIbeaconPO> iotBtIbeacons) {
        if (CollectionUtils.isEmpty(iotBtIbeacons)) {
            return;
        }
        for (IotBtIbeaconPO iotBtIbeaconPO : iotBtIbeacons) {
            iotBtIbeaconPO.setId(null);
            iotBtIbeaconPO.setOmadacId(omadacId.a());
            iotBtIbeaconPO.setSiteId(newSiteId.a());
        }
        this.iotBtIbeaconMaintMongoRepository.a(iotBtIbeacons);
    }

    private void copyIotServer(c omadacId, d siteId, List<IotServerPO> iotServers, Map<String, String> profileIdMap) {
        if (CollectionUtils.isEmpty(iotServers)) {
            return;
        }
        for (IotServerPO iotServerPO : iotServers) {
            iotServerPO.setId(null);
            iotServerPO.setOmadacId(omadacId.a());
            iotServerPO.setSiteId(siteId.a());
            iotServerPO.setTemplateId(null);
            iotServerPO.setOverride(null);
            if (!Objects.nonNull(iotServerPO.getSslTls()) || !Boolean.TRUE.equals(iotServerPO.getSslTls().getEnable())) continue;
            iotServerPO.getSslTls().setCaCertId(profileIdMap.get(iotServerPO.getSslTls().getCaCertId()));
            if (!Objects.nonNull(iotServerPO.getSslTls().getClientCertId())) continue;
            iotServerPO.getSslTls().setClientCertId(profileIdMap.get(iotServerPO.getSslTls().getClientCertId()));
        }
        this.iotServerMaintMongoRepository.a(iotServers);
    }
}

