/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.firewall.siteimport;

import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.unit.siteconfig.firewall.dto.FirewallBKO;
import com.tplink.smb.omada.common.util.e;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.BaseOsgSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.OsgSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.OsgSiteSettingTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.acl.AclPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.acl.AclTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.attackdefense.AttackDefenseTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.b;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.urlfiltering.UrlFilteringPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.urlfiltering.UrlFilteringTemplatePO;
import com.tplink.smb.omada.portal.port.mongo.omada.a.a;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.FIREWALL)
public class FirewallSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirewallSiteImportUnit.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.a aclMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.a.a();
    private final g urlFilteringMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a osgSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osg.a.a();
    private final b firewallConfigMongoRepository = b.a();
    private final c ipMacBindingMaintMongoRepository = c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.e osgMacFilterMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.firewall.e.a();
    private final a getSequenceNumService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private static final FirewallSiteImportUnit instance = new FirewallSiteImportUnit();

    private FirewallSiteImportUnit() {
    }

    public static FirewallSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        FirewallBKO backupFirewall = (FirewallBKO)jsonParserWrapper.a(FirewallBKO.class);
        this.handleFirewallWithModel(backupFirewall, omadacId, newSiteId, siteImportIdCacheMap, false);
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        FirewallBKO backupFirewall = (FirewallBKO)dataObject;
        this.handleFirewallWithModel(backupFirewall, omadacId, newSiteId, siteImportIdCacheMap, true);
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        FirewallBKO backupFirewall = (FirewallBKO)dataObject;
        this.handleFirewallWithModelTemplateCopy(backupFirewall, omadacId, newSiteTemplateId.a(), siteImportIdCacheMap);
    }

    private void handleFirewallWithModelTemplateCopy(FirewallBKO backupFirewall, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, String newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        this.handleAclTemplateCopy(backupFirewall, omadacId, newSiteTemplateId, siteImportIdCacheMap);
        this.handleUrlFilteringTemplateCopy(backupFirewall, omadacId, newSiteTemplateId, siteImportIdCacheMap);
        Optional.ofNullable(backupFirewall.getAttackDefense()).ifPresent(attackDefenseBKO -> this.osgSiteSettingMaintMongoRepository.a(omadacId, newSiteTemplateId).ifPresent(osgSiteSetting -> {
            AttackDefenseTemplatePO attackDefensePO = attackDefenseBKO.toTemplatePO();
            osgSiteSetting.setAttackDefense(attackDefensePO);
            this.handleIpMacBindingGlobalTemplateCopy((OsgSiteSettingTemplatePO)osgSiteSetting, backupFirewall, siteImportIdCacheMap);
            osgSiteSetting.setMacFilterGlobalSetting(backupFirewall.getMacFilterGlobalTemplate());
            this.osgSiteSettingMaintMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
        }));
        Optional.ofNullable(backupFirewall.getFirewallConfigTemplate()).ifPresent(firewallConfigTemplatePO -> {
            firewallConfigTemplatePO.setId(null);
            firewallConfigTemplatePO.setOmadacId(omadacId.a());
            firewallConfigTemplatePO.setSiteTemplateId(newSiteTemplateId);
            this.firewallConfigMongoRepository.a(firewallConfigTemplatePO);
        });
        Optional.ofNullable(backupFirewall.getIpMacBindingsTemplate()).ifPresent(ipMacBindingPOS -> {
            ArrayList saved = new ArrayList();
            ipMacBindingPOS.forEach(ipMacBindingPO -> {
                ipMacBindingPO.setId(null);
                ipMacBindingPO.setOmadacId(omadacId.a());
                ipMacBindingPO.setSiteTemplateId(newSiteTemplateId);
                if (Objects.equals(1, ipMacBindingPO.getInterfaceType())) {
                    ipMacBindingPO.setInterfaceId((String)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A())).get(ipMacBindingPO.getInterfaceId()));
                }
                saved.add(ipMacBindingPO);
            });
            this.ipMacBindingMaintMongoRepository.a(saved, n.b);
        });
        Optional.ofNullable(backupFirewall.getMacFiltersTemplate()).ifPresent(macFilterPOS -> {
            ArrayList saved = new ArrayList();
            macFilterPOS.forEach(macFilterPO -> {
                macFilterPO.setOmadacId(omadacId.a());
                macFilterPO.setSiteTemplateId(newSiteTemplateId);
                macFilterPO.setId(null);
                if (!CollectionUtils.isEmpty((Collection)macFilterPO.getMacGroupIds())) {
                    macFilterPO.setMacGroupIds(e.a((List)macFilterPO.getMacGroupIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()))));
                }
                saved.add(macFilterPO);
            });
            this.osgMacFilterMaintMongoRepository.a(saved, n.b);
        });
    }

    private void handleIpMacBindingGlobalTemplateCopy(OsgSiteSettingTemplatePO osgSiteSetting, FirewallBKO backupFirewall, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (backupFirewall.getIpMacBindingGlobalTemplate() == null) {
            return;
        }
        osgSiteSetting.setIpMacBinding(backupFirewall.getIpMacBindingGlobalTemplate());
        if (CollectionUtils.isEmpty((Collection)backupFirewall.getIpMacBindingGlobalTemplate().getLanIds())) {
            return;
        }
        osgSiteSetting.getIpMacBinding().setLanIds(e.a((List)backupFirewall.getIpMacBindingGlobalTemplate().getLanIds(), siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A())));
    }

    private void handleUrlFilteringTemplateCopy(FirewallBKO backupFirewall, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, String newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        Map wiredNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap());
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map wirelessNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        Optional.ofNullable(backupFirewall.getUrlFilterGlobalTemplate()).ifPresent(urlFilterGlobalPO -> {
            urlFilterGlobalPO.setId(null);
            urlFilterGlobalPO.setOmadacId(omadacId.a());
            urlFilterGlobalPO.setSiteTemplateId(newSiteTemplateId);
            this.urlFilteringMongoRepository.a(urlFilterGlobalPO);
        });
        List<UrlFilteringTemplatePO> urlFilteringPOList = backupFirewall.getUrlFilteringsTemplate();
        if (CollectionUtils.isEmpty(urlFilteringPOList)) {
            return;
        }
        ArrayList saved = new ArrayList();
        urlFilteringPOList.forEach(urlFilteringPO -> {
            urlFilteringPO.setId(null);
            urlFilteringPO.setOmadacId(omadacId.a());
            urlFilteringPO.setSiteTemplateId(newSiteTemplateId);
            if (urlFilteringPO.getTimeRangeId() != null) {
                urlFilteringPO.setTimeRangeId((String)profileMap.get(urlFilteringPO.getTimeRangeId()));
            }
            switch (urlFilteringPO.getSourceType()) {
                case 0: {
                    urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: {
                    urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)profileMap));
                    break;
                }
                case 2: {
                    urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)wirelessNetworkMap));
                    break;
                }
                default: {
                    log.error("import url filtering failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)urlFilteringPO.getSourceType());
                }
            }
            saved.add(urlFilteringPO);
        });
        this.urlFilteringMongoRepository.a(saved, n.b);
    }

    private void handleAclTemplateCopy(FirewallBKO backupFirewall, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, String newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        Map wiredNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap());
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map wirelessNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        List<AclTemplatePO> aclPOList = backupFirewall.getAclsTemplate();
        if (CollectionUtils.isEmpty(aclPOList)) {
            return;
        }
        aclPOList.forEach(aclPO -> {
            aclPO.setId(null);
            aclPO.setOmadacId(omadacId.a());
            aclPO.setSiteTemplateId(newSiteTemplateId);
            aclPO.setCustomAclOsws(null);
            aclPO.setCustomAclPorts(null);
            aclPO.setVlanNetworkId((String)wiredNetworkMap.get(aclPO.getVlanNetworkId()));
            if (aclPO.getDirection() != null && !CollectionUtils.isEmpty((Collection)aclPO.getDirection().getVpnInIds())) {
                aclPO.getDirection().setVpnInIds(e.a((List)aclPO.getDirection().getVpnInIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.al.A()))));
            }
            if (aclPO.getTimeRangeId() != null) {
                aclPO.setTimeRangeId((String)profileMap.get(aclPO.getTimeRangeId()));
            }
            switch (aclPO.getSourceType()) {
                case 0: 
                case 11: {
                    aclPO.setSourceIds(e.a((List)aclPO.getSourceIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    aclPO.setSourceIds(e.a((List)aclPO.getSourceIds(), (Map)profileMap));
                    break;
                }
                case 4: {
                    aclPO.setSourceIds(e.a((List)aclPO.getSourceIds(), (Map)wirelessNetworkMap));
                    break;
                }
                default: {
                    log.error("import acl failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)aclPO.getSourceType());
                }
            }
            switch (aclPO.getDestinationType()) {
                case 0: 
                case 11: {
                    aclPO.setDestinationIds(e.a((List)aclPO.getDestinationIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    aclPO.setDestinationIds(e.a((List)aclPO.getDestinationIds(), (Map)profileMap));
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    log.error("import acl failed in omadac {}. invalid parameter destinationType {}", (Object)omadacId, (Object)aclPO.getDestinationType());
                }
            }
        });
        this.aclMongoRepository.a(new ArrayList<AclTemplatePO>(aclPOList));
    }

    private void handleFirewallWithModel(FirewallBKO backupFirewall, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean copySite) {
        this.handleAcl(backupFirewall, omadacId, newSiteId, siteImportIdCacheMap, copySite);
        this.handleUrlFiltering(backupFirewall, omadacId, newSiteId, siteImportIdCacheMap);
        Optional.ofNullable(backupFirewall.getAttackDefense()).ifPresent(attackDefenseBKO -> this.osgSiteSettingMaintMongoRepository.a(omadacId, newSiteId).ifPresent(osgSiteSetting -> {
            osgSiteSetting.setAttackDefense(attackDefenseBKO.toPO());
            this.handleIpMacBindingGlobal((OsgSiteSettingPO)osgSiteSetting, backupFirewall, siteImportIdCacheMap);
            osgSiteSetting.setMacFilterGlobalSetting(backupFirewall.getMacFilterGlobal());
            this.osgSiteSettingMaintMongoRepository.a((BaseOsgSiteSettingPO)osgSiteSetting);
        }));
        Optional.ofNullable(backupFirewall.getUrlFilterGlobalPO()).ifPresent(urlFilterGlobalPO -> {
            urlFilterGlobalPO.setId(null);
            urlFilterGlobalPO.setOmadacId(omadacId.a());
            urlFilterGlobalPO.setSiteId(newSiteId.a());
            this.urlFilteringMongoRepository.a(urlFilterGlobalPO);
        });
        Optional.ofNullable(backupFirewall.getFirewallConfig()).ifPresent(firewallConfigPO -> {
            firewallConfigPO.setId(null);
            firewallConfigPO.setTemplateId(null);
            firewallConfigPO.setOverride(null);
            firewallConfigPO.setOmadacId(omadacId.a());
            firewallConfigPO.setSiteId(newSiteId.a());
            this.firewallConfigMongoRepository.a(firewallConfigPO);
        });
        Optional.ofNullable(backupFirewall.getIpMacBindings()).ifPresent(ipMacBindingPOS -> {
            ipMacBindingPOS.forEach(ipMacBindingPO -> {
                ipMacBindingPO.setId(null);
                ipMacBindingPO.setOmadacId(omadacId.a());
                ipMacBindingPO.setSiteId(newSiteId.a());
                if (Objects.equals(1, ipMacBindingPO.getInterfaceType())) {
                    ipMacBindingPO.setInterfaceId((String)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A())).get(ipMacBindingPO.getInterfaceId()));
                }
            });
            this.ipMacBindingMaintMongoRepository.a(new ArrayList(ipMacBindingPOS));
        });
        Optional.ofNullable(backupFirewall.getMacFilters()).ifPresent(macFilterPOS -> {
            macFilterPOS.forEach(macFilterPO -> {
                macFilterPO.setOmadacId(omadacId.a());
                macFilterPO.setSiteId(newSiteId.a());
                macFilterPO.setOverride(null);
                macFilterPO.setTemplateId(null);
                macFilterPO.setId(null);
                if (!CollectionUtils.isEmpty((Collection)macFilterPO.getMacGroupIds())) {
                    macFilterPO.setMacGroupIds(e.a((List)macFilterPO.getMacGroupIds(), (Map)((Map)siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()))));
                }
            });
            this.osgMacFilterMaintMongoRepository.a(new ArrayList(macFilterPOS));
        });
    }

    private void handleIpMacBindingGlobal(OsgSiteSettingPO osgSiteSetting, FirewallBKO backupFirewall, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (backupFirewall.getIpMacBindingGlobal() == null) {
            return;
        }
        osgSiteSetting.setIpMacBinding(backupFirewall.getIpMacBindingGlobal());
        if (CollectionUtils.isEmpty((Collection)backupFirewall.getIpMacBindingGlobal().getLanIds())) {
            return;
        }
        osgSiteSetting.getIpMacBinding().setLanIds(e.a((List)backupFirewall.getIpMacBindingGlobal().getLanIds(), siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A())));
    }

    private void handleAcl(@Nonnull FirewallBKO backupFirewall, @Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d siteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean copySite) {
        Map wiredNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap());
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map wirelessNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        Map vpnMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.al.A(), k2 -> new HashMap());
        Map vrfMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Z.A(), v2 -> new HashMap());
        List<AclPO> aclPOList = backupFirewall.getAcls();
        aclPOList.forEach(aclPO -> {
            aclPO.setId(null);
            aclPO.setOmadacId(omadacId.a());
            aclPO.setSiteId(siteId.a());
            aclPO.setTemplateId(null);
            aclPO.setOverride(null);
            if (copySite) {
                aclPO.setCustomAclOsws(null);
                aclPO.setCustomAclPorts(null);
            }
            aclPO.setVlanNetworkId((String)wiredNetworkMap.get(aclPO.getVlanNetworkId()));
            if (aclPO.getDirection() != null && !CollectionUtils.isEmpty((Collection)aclPO.getDirection().getVpnInIds())) {
                aclPO.getDirection().setVpnInIds(e.a((List)aclPO.getDirection().getVpnInIds(), (Map)vpnMap));
            }
            if (aclPO.getTimeRangeId() != null) {
                aclPO.setTimeRangeId((String)profileMap.get(aclPO.getTimeRangeId()));
            }
            if (Objects.equals(aclPO.getBindingType(), 3) && !CollectionUtils.isEmpty((Collection)aclPO.getCustomAclDevices())) {
                aclPO.getCustomAclDevices().forEach(device -> device.setVrfId((String)vrfMap.get(device.getVrfId())));
            }
            if (Objects.equals(aclPO.getBindingType(), 1) && !CollectionUtils.isEmpty((Collection)aclPO.getCustomAclPorts())) {
                aclPO.getCustomAclPorts().forEach(port -> port.setVrfId((String)vrfMap.get(port.getVrfId())));
            }
            switch (aclPO.getSourceType()) {
                case 0: 
                case 11: {
                    aclPO.setSourceIds(e.a((List)aclPO.getSourceIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    aclPO.setSourceIds(e.a((List)aclPO.getSourceIds(), (Map)profileMap));
                    break;
                }
                case 4: {
                    aclPO.setSourceIds(e.a((List)aclPO.getSourceIds(), (Map)wirelessNetworkMap));
                    break;
                }
                default: {
                    log.error("import acl failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)aclPO.getSourceType());
                }
            }
            switch (aclPO.getDestinationType()) {
                case 0: 
                case 11: {
                    aclPO.setDestinationIds(e.a((List)aclPO.getDestinationIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    aclPO.setDestinationIds(e.a((List)aclPO.getDestinationIds(), (Map)profileMap));
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    log.error("import acl failed in omadac {}. invalid parameter destinationType {}", (Object)omadacId, (Object)aclPO.getDestinationType());
                }
            }
        });
        this.aclMongoRepository.a(new ArrayList<AclPO>(aclPOList));
    }

    private void handleUrlFiltering(@Nonnull FirewallBKO backupFirewall, @Nonnull com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, @Nonnull d siteId, Map<String, Map<String, String>> siteImportIdCacheMap) {
        this.urlFilteringMongoRepository.b(omadacId, siteId);
        Map wiredNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), k2 -> new HashMap());
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map wirelessNetworkMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        List<UrlFilteringPO> urlFilteringPOList = backupFirewall.getUrlFilterings();
        urlFilteringPOList.forEach(urlFilteringPO -> {
            urlFilteringPO.setId(null);
            urlFilteringPO.setOmadacId(omadacId.a());
            urlFilteringPO.setSiteId(siteId.a());
            urlFilteringPO.setTemplateId(null);
            urlFilteringPO.setOverride(null);
            urlFilteringPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), siteId.a(), UrlFilteringPO.class)));
            switch (urlFilteringPO.getSourceType()) {
                case 0: {
                    urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)wiredNetworkMap));
                    break;
                }
                case 1: {
                    urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)profileMap));
                    break;
                }
                case 2: {
                    urlFilteringPO.setSourceIds(e.a((List)urlFilteringPO.getSourceIds(), (Map)wirelessNetworkMap));
                    break;
                }
                default: {
                    log.error("import url filtering failed in omadac {}. invalid parameter sourceType {}", (Object)omadacId, (Object)urlFilteringPO.getSourceType());
                }
            }
        });
        this.urlFilteringMongoRepository.a(new ArrayList<UrlFilteringPO>(urlFilteringPOList));
    }
}

