/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.dpi.siteimport;

import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.dpi.dto.DpiSiteSettingDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.g;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiFilterPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiFilterTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiProtocolTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRestrictionPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRestrictionTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRulePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRuleTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiSettingsPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiSettingsTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiSiteCapacityPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.GlobalApplicationPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.GlobalFamilyPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.a.e;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.DPI)
public class DpiSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DpiSiteImportUnit.class);
    private static final DpiSiteImportUnit instance = new DpiSiteImportUnit();
    private final e dpiSettingMaintMongoRepository = e.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.b dpiProtocolMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.d dpiRulesMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.a dpiFiltersMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.c dpiRestrictionsMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.c.a();
    private final com.tplink.smb.omada.manager.dpi.api.internal.service.a applicationControlInternalApiService = (com.tplink.smb.omada.manager.dpi.api.internal.service.a)a.b(com.tplink.smb.omada.manager.dpi.api.internal.service.a.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.schedule.a scheduleMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.schedule.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final LockService lockService = (LockService)a.b(LockService.class);
    private static final String DPI_TEMPLATE_PROTOCOL_LOCK = "dpi:template:protocol";
    private static final long GET_LOCK_WAITING_TIME_MS = 30000L;

    private DpiSiteImportUnit() {
    }

    public static DpiSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List<GlobalFamilyPO> globalFamilyPOList;
        List<GlobalApplicationPO> globalApplicationPOList;
        DpiSiteSettingDTO dto = (DpiSiteSettingDTO)jsonParserWrapper.a(DpiSiteSettingDTO.class);
        if (!g.a()) {
            return;
        }
        if (Objects.isNull(dto)) {
            return;
        }
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        DpiSettingsPO dpiSettingsPO = dto.getDpiSettingsPO();
        List<DpiRestrictionPO> dpiRestrictionPOList = dto.getDpiRestrictionPOList();
        List<DpiFilterPO> dpiFilterPOList = dto.getDpiFilterPOList();
        List<DpiRulePO> dpiRulePOList = dto.getDpiRulePOList();
        this.clearNewSitePrevData(omadacId.a(), newSiteId.a());
        DpiSiteCapacityPO dpiSiteCapacityPO = dto.getDpiSiteCapacityPO();
        if (Objects.nonNull(dpiSiteCapacityPO)) {
            dpiSiteCapacityPO.setOmadacId(omadacId.a());
            dpiSiteCapacityPO.setSiteId(newSiteId.a());
            dpiSiteCapacityPO.setId(null);
            this.dpiProtocolMaintMongoRepository.a(dpiSiteCapacityPO);
        }
        if (Objects.nonNull(dpiSettingsPO)) {
            dpiSettingsPO.setOmadacId(omadacId.a());
            dpiSettingsPO.setSiteId(newSiteId.a());
            dpiSettingsPO.setOverride(null);
            dpiSettingsPO.setTemplateId(null);
            this.dpiSettingMaintMongoRepository.a(dpiSettingsPO);
        }
        List templateApplicationIDS = Optional.ofNullable(this.dpiProtocolMaintMongoRepository.h()).map(list -> list.stream().map(GlobalApplicationPO::getApplicationId).collect(Collectors.toList())).orElse(Collections.emptyList());
        List globalApplicationIDS = Optional.ofNullable(dto.getGlobalApplicationPOList()).map(list -> list.stream().map(GlobalApplicationPO::getApplicationId).collect(Collectors.toList())).orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(dpiRulePOList)) {
            dpiRulePOList.forEach(dpiRulePO -> {
                dpiRulePO.setOmadacId(omadacId.a());
                dpiRulePO.setSiteId(newSiteId.a());
                dpiRulePO.setApplications(dpiRulePO.getApplications().stream().filter(app -> templateApplicationIDS.contains(app) || globalApplicationIDS.contains(app)).collect(Collectors.toList()));
                dpiRulePO.setId(null);
                dpiRulePO.setOverride(null);
                dpiRulePO.setTemplateId(null);
                if (dpiRulePO.getSchedule() != null) {
                    dpiRulePO.setSchedule((String)profileMap.get(dpiRulePO.getSchedule()));
                }
            });
            this.dpiRulesMaintMongoRepository.a(dpiRulePOList);
        }
        if (!CollectionUtils.isEmpty(dpiRestrictionPOList)) {
            dpiRestrictionPOList.forEach(dpiRestrictionPO -> {
                dpiRestrictionPO.setOmadacId(omadacId.a());
                dpiRestrictionPO.setSiteId(newSiteId.a());
                String sourceNetworkId = dpiRestrictionPO.getNetworkId();
                dpiRestrictionPO.setNetworkId(netIdsMap.getOrDefault(sourceNetworkId, sourceNetworkId));
                dpiRestrictionPO.setId(null);
                dpiRestrictionPO.setOverride(null);
                dpiRestrictionPO.setTemplateId(null);
            });
            this.dpiRestrictionsMaintMongoRepository.b(dpiRestrictionPOList);
        }
        if (!CollectionUtils.isEmpty(dpiFilterPOList)) {
            dpiFilterPOList.forEach(dpiFilterPO -> {
                dpiFilterPO.setOmadacId(omadacId.a());
                dpiFilterPO.setSiteId(newSiteId.a());
                dpiFilterPO.setId(null);
                dpiFilterPO.setOverride(null);
                dpiFilterPO.setTemplateId(null);
            });
            this.dpiFiltersMaintMongoRepository.a(dpiFilterPOList);
        }
        if (!OmadacType.s()) {
            this.applicationControlInternalApiService.a();
        }
        if (!CollectionUtils.isEmpty(globalApplicationPOList = dto.getGlobalApplicationPOList())) {
            String version = globalApplicationPOList.get(0).getVersion();
            this.lockService.doWithTryLock("manager:dpi.global.application.lock", (Object)version, 30000L, TimeUnit.MILLISECONDS, () -> {
                if (!this.dpiProtocolMaintMongoRepository.c(version)) {
                    globalApplicationPOList.forEach(globalApplicationPO -> globalApplicationPO.setId(null));
                    this.dpiProtocolMaintMongoRepository.c(globalApplicationPOList);
                }
                return true;
            }, () -> {
                log.warn("get insertAllGlobalApplication lock fail, a same version global application is being inserted, version: {}", (Object)version);
                return false;
            });
        }
        if (!CollectionUtils.isEmpty(globalFamilyPOList = dto.getGlobalFamilyPOList())) {
            String version = globalFamilyPOList.get(0).getVersion();
            this.lockService.doWithTryLock("manager:dpi.global.family.lock", (Object)version, 30000L, TimeUnit.MILLISECONDS, () -> {
                if (!this.dpiProtocolMaintMongoRepository.d(version)) {
                    globalFamilyPOList.forEach(globalFamilyPO -> globalFamilyPO.setId(null));
                    this.dpiProtocolMaintMongoRepository.d(globalFamilyPOList);
                    this.dpiProtocolMaintMongoRepository.b(new DpiProtocolTemplatePO(version));
                }
                return true;
            }, () -> {
                log.warn("get insertGlobalFamily lock fail");
                return false;
            });
        }
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        DpiSiteSettingDTO dto = (DpiSiteSettingDTO)dataObject;
        if (!g.a()) {
            return;
        }
        if (Objects.isNull(dto)) {
            return;
        }
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        DpiSettingsPO dpiSettingsPO = dto.getDpiSettingsPO();
        List<DpiRestrictionPO> dpiRestrictionPOList = dto.getDpiRestrictionPOList();
        List<DpiFilterPO> dpiFilterPOList = dto.getDpiFilterPOList();
        List<DpiRulePO> dpiRulePOList = dto.getDpiRulePOList();
        this.clearNewSitePrevData(omadacId.a(), newSiteId.a());
        if (Objects.nonNull(dpiSettingsPO)) {
            dpiSettingsPO.setOmadacId(omadacId.a());
            dpiSettingsPO.setSiteId(newSiteId.a());
            dpiSettingsPO.setOverride(null);
            dpiSettingsPO.setTemplateId(null);
            this.dpiSettingMaintMongoRepository.a(dpiSettingsPO);
        }
        if (!CollectionUtils.isEmpty(dpiRulePOList)) {
            dpiRulePOList.forEach(dpiRulePO -> {
                dpiRulePO.setOmadacId(omadacId.a());
                dpiRulePO.setSiteId(newSiteId.a());
                dpiRulePO.setId(null);
                dpiRulePO.setOverride(null);
                dpiRulePO.setUnSupport(Boolean.valueOf(false));
                dpiRulePO.setTemplateId(null);
                if (dpiRulePO.getSchedule() != null) {
                    dpiRulePO.setSchedule((String)profileMap.get(dpiRulePO.getSchedule()));
                }
            });
            this.dpiRulesMaintMongoRepository.a(dpiRulePOList);
        }
        if (!CollectionUtils.isEmpty(dpiRestrictionPOList)) {
            dpiRestrictionPOList.forEach(dpiRestrictionPO -> {
                dpiRestrictionPO.setOmadacId(omadacId.a());
                dpiRestrictionPO.setSiteId(newSiteId.a());
                String sourceNetworkId = dpiRestrictionPO.getNetworkId();
                dpiRestrictionPO.setNetworkId(netIdsMap.getOrDefault(sourceNetworkId, sourceNetworkId));
                dpiRestrictionPO.setId(null);
                dpiRestrictionPO.setUnSupport(Boolean.valueOf(false));
                dpiRestrictionPO.setOverride(null);
                dpiRestrictionPO.setTemplateId(null);
            });
            this.dpiRestrictionsMaintMongoRepository.b(dpiRestrictionPOList);
        }
        if (!CollectionUtils.isEmpty(dpiFilterPOList)) {
            dpiFilterPOList.forEach(dpiFilterPO -> {
                dpiFilterPO.setOmadacId(omadacId.a());
                dpiFilterPO.setSiteId(newSiteId.a());
                dpiFilterPO.setId(null);
                dpiFilterPO.setUnSupport(Boolean.valueOf(false));
                dpiFilterPO.setOverride(null);
                dpiFilterPO.setTemplateId(null);
            });
            this.dpiFiltersMaintMongoRepository.a(dpiFilterPOList);
        }
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        DpiSiteSettingDTO dto = (DpiSiteSettingDTO)dataObject;
        if (!g.a()) {
            return;
        }
        if (Objects.isNull(dto)) {
            return;
        }
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), k2 -> new HashMap());
        Map netIdsMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        DpiSettingsTemplatePO dpiSettingsPOTemplate = dto.getDpiSettingsPOTemplate();
        List<DpiRestrictionTemplatePO> dpiRestrictionPOListTemplate = dto.getDpiRestrictionPOListTemplate();
        List<DpiFilterTemplatePO> dpiFilterPOListTemplate = dto.getDpiFilterPOListTemplate();
        List<DpiRuleTemplatePO> dpiRulePOListTemplate = dto.getDpiRulePOListTemplate();
        this.clearNewSiteTemplatePrevData(omadacId.a(), newSiteTemplateId.a());
        if (Objects.nonNull(dpiSettingsPOTemplate)) {
            dpiSettingsPOTemplate.setId(null);
            dpiSettingsPOTemplate.setOmadacId(omadacId.a());
            dpiSettingsPOTemplate.setSiteTemplateId(newSiteTemplateId.a());
            this.dpiSettingMaintMongoRepository.a(dpiSettingsPOTemplate);
        }
        if (!CollectionUtils.isEmpty(dpiRulePOListTemplate)) {
            dpiRulePOListTemplate.forEach(dpiRulePO -> {
                dpiRulePO.setOmadacId(omadacId.a());
                dpiRulePO.setSiteTemplateId(newSiteTemplateId.a());
                dpiRulePO.setId(null);
                if (dpiRulePO.getSchedule() != null) {
                    dpiRulePO.setSchedule((String)profileMap.get(dpiRulePO.getSchedule()));
                }
            });
            this.dpiRulesMaintMongoRepository.b(dpiRulePOListTemplate);
        }
        if (!CollectionUtils.isEmpty(dpiRestrictionPOListTemplate)) {
            dpiRestrictionPOListTemplate.forEach(dpiRestrictionPO -> {
                dpiRestrictionPO.setOmadacId(omadacId.a());
                dpiRestrictionPO.setSiteTemplateId(newSiteTemplateId.a());
                String sourceNetworkId = dpiRestrictionPO.getNetworkId();
                dpiRestrictionPO.setNetworkId(netIdsMap.getOrDefault(sourceNetworkId, sourceNetworkId));
                dpiRestrictionPO.setId(null);
            });
            this.dpiRestrictionsMaintMongoRepository.c(dpiRestrictionPOListTemplate);
        }
        if (!CollectionUtils.isEmpty(dpiFilterPOListTemplate)) {
            dpiFilterPOListTemplate.forEach(dpiFilterPO -> {
                dpiFilterPO.setOmadacId(omadacId.a());
                dpiFilterPO.setSiteTemplateId(newSiteTemplateId.a());
                dpiFilterPO.setId(null);
            });
            this.dpiFiltersMaintMongoRepository.b(dpiFilterPOListTemplate);
        }
    }

    private void clearNewSitePrevData(String omadacId, String siteId) {
        this.dpiSettingMaintMongoRepository.b(omadacId, siteId);
        this.dpiProtocolMaintMongoRepository.d(omadacId, siteId);
        this.dpiRestrictionsMaintMongoRepository.b(omadacId, siteId);
        this.dpiFiltersMaintMongoRepository.b(omadacId, siteId);
        this.dpiRulesMaintMongoRepository.b(omadacId, siteId);
    }

    private void clearNewSiteTemplatePrevData(String omadacId, String templateId) {
        this.dpiSettingMaintMongoRepository.c(omadacId, templateId);
        this.dpiRestrictionsMaintMongoRepository.c(omadacId, templateId);
        this.dpiFiltersMaintMongoRepository.c(omadacId, templateId);
        this.dpiRulesMaintMongoRepository.c(omadacId, templateId);
    }
}

