/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.dpi.restore;

import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.dpi.dto.DpiSiteSettingDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.g;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.ApplicationPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.BaseDpiFilterPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.BaseDpiRestrictionPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.BaseDpiRulePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiFilterPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiFilterTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiProtocolPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRestrictionPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRestrictionTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRulePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiRuleTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiSettingsPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiSettingsTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.FamilyPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.GlobalApplicationPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.UnSupportApplicationPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.a.e;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V10000920, b=d.DPI)
public class DpiRestoreUnitV10000920
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DpiRestoreUnitV10000920.class);
    private static DpiRestoreUnitV10000920 instance = new DpiRestoreUnitV10000920();
    private final e dpiSettingMaintMongoRepository = e.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.b dpiProtocolMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.b.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.a dpiFiltersMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.c dpiRestrictionsMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.a.d dpiRulesMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.a.d.a();
    private LockService lockService = (LockService)a.b(LockService.class);
    private static final long GET_LOCK_WAITING_TIME_MS = 30000L;

    private DpiRestoreUnitV10000920() {
    }

    public static DpiRestoreUnitV10000920 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List<GlobalApplicationPO> globalApplicationPOList;
        List<DpiRulePO> dpiRulePOList;
        List<DpiFilterPO> dpiFilterPOList;
        List<DpiRestrictionPO> dpiRestrictionPOList;
        DpiProtocolPO dpiProtocolPO;
        DpiSettingsPO dpiSettingsPO;
        DpiSiteSettingDTO dto = (DpiSiteSettingDTO)jsonParserWrapper.a(DpiSiteSettingDTO.class);
        if (!g.a()) {
            return;
        }
        if (Objects.isNull(dto)) {
            return;
        }
        Map siteMap = restoreCacheMap.getOrDefault(d.Q.A(), new HashMap());
        Map profileMap = restoreCacheMap.getOrDefault(d.Y.A(), new HashMap());
        Map netIdsMap = (Map)restoreCacheMap.computeIfAbsent(d.af.A(), v2 -> new HashMap());
        Map dpiMap = (Map)restoreCacheMap.computeIfAbsent(d.bd.A(), v2 -> new HashMap());
        this.handleTemplate(omadacId, dto, siteMap, netIdsMap, profileMap, dpiMap);
        List<UnSupportApplicationPO> unSupportApplicationPos = dto.getUnSupportApplicationPos();
        if (!CollectionUtils.isEmpty(unSupportApplicationPos)) {
            unSupportApplicationPos.forEach(unSupportApplicationPo -> {
                unSupportApplicationPo.setOmadacId(omadacId.a());
                unSupportApplicationPo.setSiteId((String)siteMap.get(unSupportApplicationPo.getSiteId()));
                unSupportApplicationPo.setId(null);
            });
            this.dpiProtocolMaintMongoRepository.b(unSupportApplicationPos);
        }
        if (Objects.nonNull(dpiSettingsPO = dto.getDpiSettingsPO())) {
            dpiSettingsPO.setOmadacId(omadacId.a());
            dpiSettingsPO.setSiteId((String)siteMap.get(dpiSettingsPO.getSiteId()));
            if (dpiSettingsPO.getTemplateId() != null) {
                dpiSettingsPO.setTemplateId((String)dpiMap.get(dpiSettingsPO.getTemplateId()));
            }
            dpiSettingsPO.setId(null);
            this.dpiSettingMaintMongoRepository.a(dpiSettingsPO);
        }
        if (Objects.nonNull(dpiProtocolPO = dto.getDpiProtocolPO())) {
            dpiProtocolPO.setOmadacId(omadacId.a());
            dpiProtocolPO.setSiteId((String)siteMap.get(dpiProtocolPO.getSiteId()));
            dpiProtocolPO.setId(null);
            this.dpiProtocolMaintMongoRepository.a(dpiProtocolPO);
        }
        if (!CollectionUtils.isEmpty(dpiRestrictionPOList = dto.getDpiRestrictionPOList())) {
            dpiRestrictionPOList.forEach(dpiRestrictionPO -> {
                dpiRestrictionPO.setOmadacId(omadacId.a());
                dpiRestrictionPO.setSiteId((String)siteMap.get(dpiRestrictionPO.getSiteId()));
                String sourceNetworkId = dpiRestrictionPO.getNetworkId();
                dpiRestrictionPO.setNetworkId(netIdsMap.getOrDefault(sourceNetworkId, sourceNetworkId));
                if (dpiRestrictionPO.getTemplateId() != null) {
                    dpiRestrictionPO.setTemplateId((String)dpiMap.get(dpiRestrictionPO.getTemplateId()));
                }
                dpiRestrictionPO.setId(null);
                if (dpiRestrictionPO.getUnSupport() == null) {
                    dpiRestrictionPO.setUnSupport(Boolean.valueOf(false));
                }
            });
            this.dpiRestrictionsMaintMongoRepository.b(dpiRestrictionPOList);
        }
        if (!CollectionUtils.isEmpty(dpiFilterPOList = dto.getDpiFilterPOList())) {
            dpiFilterPOList.forEach(dpiFilterPO -> {
                dpiFilterPO.setOmadacId(omadacId.a());
                dpiFilterPO.setSiteId((String)siteMap.get(dpiFilterPO.getSiteId()));
                if (dpiFilterPO.getTemplateId() != null) {
                    dpiFilterPO.setTemplateId((String)dpiMap.get(dpiFilterPO.getTemplateId()));
                }
                dpiFilterPO.setId(null);
                if (dpiFilterPO.getUnSupport() == null) {
                    dpiFilterPO.setUnSupport(Boolean.valueOf(false));
                }
            });
            this.dpiFiltersMaintMongoRepository.a(dpiFilterPOList);
        }
        if (!CollectionUtils.isEmpty(dpiRulePOList = dto.getDpiRulePOList())) {
            dpiRulePOList.forEach(dpiRulePO -> {
                dpiRulePO.setOmadacId(omadacId.a());
                dpiRulePO.setSiteId((String)siteMap.get(dpiRulePO.getSiteId()));
                if (dpiRulePO.getTemplateId() != null) {
                    dpiRulePO.setTemplateId((String)dpiMap.get(dpiRulePO.getTemplateId()));
                }
                dpiRulePO.setId(null);
                if (dpiRulePO.getSchedule() != null) {
                    dpiRulePO.setSchedule((String)profileMap.get(dpiRulePO.getSchedule()));
                }
                if (dpiRulePO.getUnSupport() == null) {
                    dpiRulePO.setUnSupport(Boolean.valueOf(false));
                }
            });
            this.dpiRulesMaintMongoRepository.a(dpiRulePOList);
        }
        if (!CollectionUtils.isEmpty(globalApplicationPOList = dto.getGlobalApplicationPOList())) {
            String version = globalApplicationPOList.get(0).getVersion();
            this.lockService.doWithTryLock("manager:dpi.global.application.lock", (Object)version, 30000L, TimeUnit.MILLISECONDS, () -> {
                if (!this.dpiProtocolMaintMongoRepository.c(version)) {
                    globalApplicationPOList.forEach(globalApplicationPO -> globalApplicationPO.setId(null));
                    this.dpiProtocolMaintMongoRepository.c(globalApplicationPOList);
                } else {
                    this.insertIfMoreGlobalApplication(globalApplicationPOList);
                }
                return true;
            }, () -> {
                log.warn("get insertAllGlobalApplication lock fail, a same version global application is being inserted, version: {}", (Object)version);
                return false;
            });
        } else if (!CollectionUtils.isEmpty(dto.getApplicationPOList())) {
            List<ApplicationPO> oldApplicationPOList = dto.getApplicationPOList();
            String protocolVer = dpiProtocolPO.getProtocolVer();
            this.lockService.doWithTryLock("manager:dpi.global.application.lock", (Object)protocolVer, 30000L, TimeUnit.MILLISECONDS, () -> {
                ArrayList<GlobalApplicationPO> newGlobalApplicationList = new ArrayList<GlobalApplicationPO>();
                oldApplicationPOList.forEach(applicationPO -> newGlobalApplicationList.add(this.toGlobalApplicationPO((ApplicationPO)applicationPO, protocolVer)));
                if (!this.dpiProtocolMaintMongoRepository.c(protocolVer)) {
                    this.dpiProtocolMaintMongoRepository.c(newGlobalApplicationList);
                } else {
                    this.insertIfMoreGlobalApplication(newGlobalApplicationList);
                }
                return true;
            }, () -> {
                log.warn("get insertAllGlobalApplication lock fail, a same version global application is being inserted, version: {}", (Object)protocolVer);
                return false;
            });
        }
        List<FamilyPO> familyPOList = dto.getFamilyPOList();
        if (!CollectionUtils.isEmpty(familyPOList)) {
            familyPOList.forEach(familyPO -> {
                familyPO.setOmadacId(omadacId.a());
                familyPO.setSiteId((String)siteMap.get(familyPO.getSiteId()));
                familyPO.setId(null);
            });
            this.dpiProtocolMaintMongoRepository.a(familyPOList);
        }
    }

    private GlobalApplicationPO toGlobalApplicationPO(ApplicationPO applicationPO, String protocolVer) {
        GlobalApplicationPO globalApplicationPO = new GlobalApplicationPO();
        globalApplicationPO.setName(applicationPO.getName());
        globalApplicationPO.setDescription(applicationPO.getDescription());
        globalApplicationPO.setApplicationId(applicationPO.getApplicationId());
        globalApplicationPO.setFamilyId(applicationPO.getFamilyId());
        globalApplicationPO.setVersion(protocolVer);
        return globalApplicationPO;
    }

    private void handleTemplate(c omadacId, DpiSiteSettingDTO dto, Map<String, String> newSiteIdMap, Map<String, String> netIdsMap, Map<String, String> profileMap, Map<String, String> dpiMap) {
        DpiSettingsTemplatePO dpiSettingsPOTemplate = dto.getDpiSettingsPOTemplate();
        List<DpiRestrictionTemplatePO> dpiRestrictionPOListTemplate = dto.getDpiRestrictionPOListTemplate();
        List<DpiFilterTemplatePO> dpiFilterPOListTemplate = dto.getDpiFilterPOListTemplate();
        List<DpiRuleTemplatePO> dpiRulePOListTemplate = dto.getDpiRulePOListTemplate();
        if (Objects.nonNull(dpiSettingsPOTemplate)) {
            dpiSettingsPOTemplate.setOmadacId(omadacId.a());
            if (newSiteIdMap.containsKey(dpiSettingsPOTemplate.getSiteTemplateId())) {
                dpiSettingsPOTemplate.setSiteTemplateId(newSiteIdMap.get(dpiSettingsPOTemplate.getSiteTemplateId()));
            }
            String originId = dpiSettingsPOTemplate.getId();
            dpiSettingsPOTemplate.setId(null);
            dpiMap.put(originId, Optional.ofNullable(this.dpiSettingMaintMongoRepository.a(dpiSettingsPOTemplate)).orElse(null));
        }
        if (!CollectionUtils.isEmpty(dpiRulePOListTemplate)) {
            dpiRulePOListTemplate.forEach(dpiRulePO -> {
                dpiRulePO.setOmadacId(omadacId.a());
                if (newSiteIdMap.containsKey(dpiRulePO.getSiteTemplateId())) {
                    dpiRulePO.setSiteTemplateId((String)newSiteIdMap.get(dpiRulePO.getSiteTemplateId()));
                }
                if (dpiRulePO.getSchedule() != null) {
                    dpiRulePO.setSchedule((String)profileMap.get(dpiRulePO.getSchedule()));
                }
                String originId = dpiRulePO.getId();
                dpiRulePO.setId(null);
                dpiMap.put(originId, Optional.ofNullable(this.dpiRulesMaintMongoRepository.a(dpiRulePO)).map(BaseDpiRulePO::getId).orElse(null));
            });
        }
        if (!CollectionUtils.isEmpty(dpiRestrictionPOListTemplate)) {
            dpiRestrictionPOListTemplate.forEach(dpiRestrictionPO -> {
                dpiRestrictionPO.setOmadacId(omadacId.a());
                if (newSiteIdMap.containsKey(dpiRestrictionPO.getSiteTemplateId())) {
                    dpiRestrictionPO.setSiteTemplateId((String)newSiteIdMap.get(dpiRestrictionPO.getSiteTemplateId()));
                }
                String sourceNetworkId = dpiRestrictionPO.getNetworkId();
                dpiRestrictionPO.setNetworkId(netIdsMap.getOrDefault(sourceNetworkId, sourceNetworkId));
                String originId = dpiRestrictionPO.getId();
                dpiRestrictionPO.setId(null);
                dpiMap.put(originId, Optional.ofNullable(this.dpiRestrictionsMaintMongoRepository.a(dpiRestrictionPO)).map(BaseDpiRestrictionPO::getId).orElse(null));
            });
        }
        if (!CollectionUtils.isEmpty(dpiFilterPOListTemplate)) {
            dpiFilterPOListTemplate.forEach(dpiFilterPO -> {
                dpiFilterPO.setOmadacId(omadacId.a());
                if (newSiteIdMap.containsKey(dpiFilterPO.getSiteTemplateId())) {
                    dpiFilterPO.setSiteTemplateId((String)newSiteIdMap.get(dpiFilterPO.getSiteTemplateId()));
                }
                String originId = dpiFilterPO.getId();
                dpiFilterPO.setId(null);
                dpiMap.put(originId, Optional.ofNullable(this.dpiFiltersMaintMongoRepository.a(dpiFilterPO)).map(BaseDpiFilterPO::getId).orElse(null));
            });
        }
    }

    public OperationResponse insertIfMoreGlobalApplication(List<GlobalApplicationPO> importGlobalApps) {
        String protocolVer = importGlobalApps.get(0).getVersion();
        long oldGlobalAppCount = this.dpiProtocolMaintMongoRepository.e(protocolVer);
        int importGlobalAppCount = importGlobalApps.size();
        if ((long)importGlobalAppCount > oldGlobalAppCount) {
            this.dpiProtocolMaintMongoRepository.h(importGlobalApps);
        }
        return OperationResponse.SUCCESS;
    }
}

