/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.dpi.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.g;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.DpiProtocolTemplatePO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.GlobalApplicationPO;
import com.tplink.smb.omada.manager.dpi.port.mongo.dpi.GlobalFamilyPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.a.b;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V60000, b=d.DPI_GLOBAL_DATA)
public class DpiGlobalDataRestoreUnitV60000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DpiGlobalDataRestoreUnitV60000.class);
    private final b dpiProtocolMaintMongoRepository = b.a();
    private final LockService lockService = (LockService)a.b(LockService.class);
    public static final String GLOBAL_APPLICATION_PO_LIST = "globalApplicationPOList";
    public static final String GLOBAL_FAMILY_PO_LIST = "globalFamilyPOList";
    private static final long GET_LOCK_WAITING_TIME_MS = 30000L;
    private static final DpiGlobalDataRestoreUnitV60000 instance = new DpiGlobalDataRestoreUnitV60000();

    private DpiGlobalDataRestoreUnitV60000() {
    }

    public static DpiGlobalDataRestoreUnitV60000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        long startTime = System.currentTimeMillis();
        JsonParser jsonParser = jsonParserWrapper.h();
        ArrayList<GlobalApplicationPO> globalApplicationPOList = new ArrayList<GlobalApplicationPO>();
        ArrayList<GlobalFamilyPO> globalFamilyPOList = new ArrayList<GlobalFamilyPO>();
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (!GLOBAL_APPLICATION_PO_LIST.equals(name) && !GLOBAL_FAMILY_PO_LIST.equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restring {} - Skip unknown JSON member: {}", (Object)d.be, (Object)name);
                continue;
            }
            log.debug("Restoring {} - Found JSON member: {}, promote restore", (Object)d.be, (Object)name);
            if (GLOBAL_APPLICATION_PO_LIST.equals(name)) {
                jsonParser.nextToken();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    GlobalApplicationPO globalApplicationPO = (GlobalApplicationPO)jsonParser.readValueAs(GlobalApplicationPO.class);
                    if (Objects.isNull(globalApplicationPO)) continue;
                    globalApplicationPOList.add(globalApplicationPO);
                }
                continue;
            }
            jsonParser.nextToken();
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                GlobalFamilyPO globalFamilyPO = (GlobalFamilyPO)jsonParser.readValueAs(GlobalFamilyPO.class);
                if (Objects.isNull(globalFamilyPO)) continue;
                globalFamilyPOList.add(globalFamilyPO);
            }
        }
        long parseJsonTime = System.currentTimeMillis();
        log.debug("parse json time {} ms", (Object)(parseJsonTime - startTime));
        if (!g.a()) {
            return;
        }
        if (CollectionUtils.isEmpty(globalApplicationPOList) || CollectionUtils.isEmpty(globalFamilyPOList)) {
            return;
        }
        Map<String, List<GlobalApplicationPO>> appMap = globalApplicationPOList.stream().filter(app -> T.a((Object)app.getVersion())).collect(Collectors.groupingBy(GlobalApplicationPO::getVersion));
        Map<String, List<GlobalFamilyPO>> familyMap = globalFamilyPOList.stream().filter(family -> T.a((Object)family.getVersion())).collect(Collectors.groupingBy(GlobalFamilyPO::getVersion));
        appMap.forEach((version, apps) -> this.lockService.doWithTryLock("manager:dpi.global.application.lock", version, 30000L, TimeUnit.MILLISECONDS, () -> {
            if (!this.dpiProtocolMaintMongoRepository.c(version)) {
                this.dpiProtocolMaintMongoRepository.c(apps);
            }
            return true;
        }, () -> {
            log.warn("get insertAllGlobalApplication lock fail, a same version global application is being inserted, version: {}", version);
            return false;
        }));
        familyMap.forEach((version, families) -> this.lockService.doWithTryLock("manager:dpi.global.family.lock", version, 30000L, TimeUnit.MILLISECONDS, () -> {
            if (!this.dpiProtocolMaintMongoRepository.d(version)) {
                this.dpiProtocolMaintMongoRepository.d(families);
                this.dpiProtocolMaintMongoRepository.b(new DpiProtocolTemplatePO(version));
            }
            return true;
        }, () -> {
            log.warn("get insertGlobalFamily lock fail, a same version global family is being inserted, version: {}", version);
            return false;
        }));
        long endTime = System.currentTimeMillis();
        log.debug("set dpi global data time {} ms", (Object)(endTime - parseJsonTime));
        log.debug("restore dpi global data time {} ms", (Object)(endTime - startTime));
    }
}

