/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.client.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.siteconfig.client.dto.ClientUniqueDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.client.dto.KnownClientBackupDTO;
import com.tplink.smb.omada.client.port.mongo.omada.a;
import com.tplink.smb.omada.client.port.mongo.omada.client.ClientPO;
import com.tplink.smb.omada.client.port.mongo.omada.client.ClientRateLimitSettingPO;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=com.tplink.smb.omada.backup.api.c.d.KNOWN_CLIENT)
public class KnownClientRestoreUnitv50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KnownClientRestoreUnitv50000.class);
    private static final int KBPS = 1;
    private final a clientMaintMongoRepository = a.a();
    private static final KnownClientRestoreUnitv50000 instance = new KnownClientRestoreUnitv50000();

    public static KnownClientRestoreUnitv50000 getInstance() {
        return instance;
    }

    private KnownClientRestoreUnitv50000() {
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        long existCount = this.clientMaintMongoRepository.c(omadacId);
        long restoreLimit = (long)b.j() - existCount;
        long count = 0L;
        jsonParser.nextToken();
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        ArrayList<ClientPO> clientPOList = new ArrayList<ClientPO>(1000);
        HashSet<ClientUniqueDTO> existClientSet = new HashSet<ClientUniqueDTO>();
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            KnownClientBackupDTO backupDTO = (KnownClientBackupDTO)jsonParser.readValueAs(KnownClientBackupDTO.class);
            if (backupDTO == null || count >= restoreLimit || skipData) continue;
            String newSiteId = (String)siteMap.get(backupDTO.getSiteId());
            if (newSiteId == null) {
                log.warn("Restoring known client: Cannot find mapped siteId, omadacId={}, known client: {}", (Object)omadacId, (Object)backupDTO);
                return;
            }
            ClientUniqueDTO clientUniqueDTO = new ClientUniqueDTO();
            clientUniqueDTO.setOmadacId(omadacId.a());
            clientUniqueDTO.setSiteId(newSiteId);
            clientUniqueDTO.setMac(backupDTO.getMac());
            if (existClientSet.contains(clientUniqueDTO)) {
                log.warn("Client {} has duplicate backups, only one saved", (Object)clientUniqueDTO);
                continue;
            }
            existClientSet.add(clientUniqueDTO);
            ClientPO clientPO = this.clientMaintMongoRepository.a(omadacId, new d(newSiteId), backupDTO.getMac());
            if (clientPO == null) {
                clientPO = this.trans2ClientDOWithDefaultSetting(backupDTO);
                clientPO.setId(null);
                ++count;
            } else {
                KnownClientBackupDTO.copyClientStat(backupDTO, clientPO);
            }
            clientPO.setOmadacId(omadacId.a());
            clientPO.setSiteId(newSiteId);
            clientPOList.add(clientPO);
            if (clientPOList.size() < 1000) continue;
            this.clientMaintMongoRepository.a(clientPOList);
            clientPOList.clear();
        }
        this.clientMaintMongoRepository.a(clientPOList);
    }

    private ClientPO trans2ClientDOWithDefaultSetting(KnownClientBackupDTO backupDTO) {
        ClientPO clientPO = new ClientPO();
        KnownClientBackupDTO.copyClientStat(backupDTO, clientPO);
        clientPO.setBlock(Boolean.valueOf(false));
        ClientRateLimitSettingPO rateLimit = new ClientRateLimitSettingPO();
        rateLimit.setEnable(Boolean.valueOf(false));
        rateLimit.setUpEnable(Boolean.valueOf(false));
        rateLimit.setDownEnable(Boolean.valueOf(false));
        rateLimit.setUpUnit(Integer.valueOf(1));
        rateLimit.setDownUnit(Integer.valueOf(1));
        clientPO.setRateLimit(rateLimit);
        return clientPO;
    }
}

