/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.client.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.d.c;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.client.dto.ClientSettingBackupDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.client.dto.ClientSettingBackupListDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.client.dto.ClientUniqueDTO;
import com.tplink.smb.omada.client.port.mongo.omada.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.CLIENT_SETTING)
public class ClientSettingRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientSettingRestoreUnitV50000.class);
    public static final String UNKNOWN_CLIENT_TYPE = "unknown";
    private final a clientMaintMongoRepository = a.a();
    private static final ClientSettingRestoreUnitV50000 instance = new ClientSettingRestoreUnitV50000();

    public static ClientSettingRestoreUnitV50000 getInstance() {
        return instance;
    }

    private ClientSettingRestoreUnitV50000() {
    }

    public void restore(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, c {
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        Map profileMap = (Map)restoreCacheMap.computeIfAbsent(d.Y.A(), k2 -> new HashMap());
        ClientSettingBackupListDTO backupListDTO = (ClientSettingBackupListDTO)jsonParserWrapper.a(ClientSettingBackupListDTO.class);
        List<ClientSettingBackupDTO> clients = backupListDTO.getClientSettings();
        if (CollectionUtils.isEmpty(clients)) {
            log.debug("ClientSettingList is empty when restore.");
            return;
        }
        ArrayList clientPOList = new ArrayList();
        HashSet existClientSet = new HashSet();
        clients.forEach(backupDTO -> {
            String siteId = (String)siteMap.get(backupDTO.getSiteId());
            if (siteId == null) {
                log.warn("Restoring ap: Cannot find mapped siteId, omadacId={}, ap: {}", (Object)omadacId, backupDTO);
                return;
            }
            ClientUniqueDTO clientUniqueDTO = new ClientUniqueDTO();
            clientUniqueDTO.setOmadacId(omadacId.a());
            clientUniqueDTO.setSiteId(siteId);
            clientUniqueDTO.setMac(backupDTO.getMac());
            if (existClientSet.contains(clientUniqueDTO)) {
                log.warn("Client {} has duplicate backups, only one saved", (Object)clientUniqueDTO);
                return;
            }
            existClientSet.add(clientUniqueDTO);
            clientPOList.add(ClientSettingBackupDTO.toPO(omadacId.a(), siteId, (String)profileMap.get(backupDTO.getRateLimit().getRateLimitId()), backupDTO));
        });
        this.clientMaintMongoRepository.a(clientPOList);
    }
}

