/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.embed.RadiusAcctServerBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.embed.RadiusAuthServerBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.embed.RadiusCoaServerBKDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAcctServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAuthServerPO;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusProfileBKDTO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadiusProfileBKDTO.class);
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="siteId")
    private String siteId;
    @JsonProperty(value="entryId")
    private Integer entryId;
    @JsonProperty(value="radsecConfigured")
    private Boolean radsecConfigured;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="authServer")
    private List<RadiusAuthServerBKDTO> authServer;
    @JsonProperty(value="radiusAccountingEnable")
    private Boolean radiusAccountingEnable;
    @JsonProperty(value="interimUpdateEnable")
    private Boolean interimUpdateEnable;
    @JsonProperty(value="interimUpdateInterval")
    private Integer interimUpdateInterval;
    @JsonProperty(value="acctServer")
    private List<RadiusAcctServerBKDTO> acctServer;
    @JsonProperty(value="wirelessVlanAssignment")
    private Boolean wirelessVlanAssignment;
    @JsonProperty(value="coaEnable")
    private Boolean coaEnable;
    @JsonProperty(value="coaServer")
    private List<RadiusCoaServerBKDTO> coaServer;
    @JsonProperty(value="proxy")
    private Boolean proxy;
    @JsonProperty(value="requireMessageAuthenticator")
    private Boolean requireMessageAuthenticator;
    @JsonProperty(value="builtInServer")
    private Boolean builtInServer;
    @JsonProperty(value="serverEnable")
    private Boolean serverEnable;
    @JsonProperty(value="tunnelReplyEnable")
    private Boolean tunnelReplyEnable;
    @JsonProperty(value="builtInServerSecret")
    private String builtInServerSecret;
    @JsonProperty(value="acctTimeout")
    private Integer acctTimeout;
    @JsonProperty(value="templateId")
    private String templateId;
    @JsonProperty(value="override")
    private Boolean override;

    @Nonnull
    public static RadiusProfileBKDTO fromTemplatePO(@Nonnull RadiusProfileTemplatePO po) {
        RadiusProfileBKDTO dto = new RadiusProfileBKDTO().setId(po.getId()).setSiteId(null).setEntryId(po.getEntryId()).setRadsecConfigured(RadiusProfileBKDTO.radsecEnable(po)).setName(po.getName()).setAuthServer(po.getAuthServer().stream().map(RadiusAuthServerBKDTO::fromPO).collect(Collectors.toList())).setRadiusAccountingEnable(po.getRadiusAccountingEnable()).setInterimUpdateEnable(po.getInterimUpdateEnable()).setInterimUpdateInterval(po.getInterimUpdateInterval()).setWirelessVlanAssignment(po.getWirelessVlanAssignment()).setCoaEnable(po.getCoaEnable()).setBuiltInServer(Boolean.TRUE.equals(po.getBuiltInServer())).setServerEnable(Boolean.TRUE.equals(po.getServerEnable())).setTunnelReplyEnable(Boolean.TRUE.equals(po.getTunnelReplyEnable())).setBuiltInServerSecret(po.getBuiltInServerSecret()).setProxy(po.getProxy()).setRequireMessageAuthenticator(Boolean.TRUE.equals(po.getRequireMessageAuthenticator())).setAcctTimeout(po.getAcctTimeout()).setTemplateId(po.getId()).setOverride(false);
        if (Boolean.TRUE.equals(dto.getRadiusAccountingEnable())) {
            dto.setAcctServer(po.getAcctServer().stream().map(RadiusAcctServerBKDTO::fromPO).collect(Collectors.toList()));
        }
        if (Boolean.TRUE.equals(dto.getCoaEnable())) {
            dto.setCoaServer(po.getCoaServer().stream().map(RadiusCoaServerBKDTO::fromPO).collect(Collectors.toList()));
        }
        return dto;
    }

    @Nonnull
    public static RadiusProfileBKDTO fromPO(@Nonnull RadiusProfilePO po) {
        RadiusProfileBKDTO dto = new RadiusProfileBKDTO().setId(po.getId()).setSiteId(po.getSiteId()).setEntryId(po.getEntryId()).setRadsecConfigured(Boolean.TRUE.equals(po.getRadsecConfigured())).setName(po.getName()).setAuthServer(po.getAuthServer().stream().map(RadiusAuthServerBKDTO::fromPO).collect(Collectors.toList())).setRadiusAccountingEnable(po.getRadiusAccountingEnable()).setInterimUpdateEnable(po.getInterimUpdateEnable()).setInterimUpdateInterval(po.getInterimUpdateInterval()).setWirelessVlanAssignment(po.getWirelessVlanAssignment()).setCoaEnable(po.getCoaEnable()).setProxy(Boolean.TRUE.equals(po.getProxy())).setRequireMessageAuthenticator(Boolean.TRUE.equals(po.getRequireMessageAuthenticator())).setBuiltInServer(Boolean.TRUE.equals(po.getBuiltInServer())).setServerEnable(Boolean.TRUE.equals(po.getServerEnable())).setTunnelReplyEnable(Boolean.TRUE.equals(po.getTunnelReplyEnable())).setBuiltInServerSecret(po.getBuiltInServerSecret()).setAcctTimeout(po.getAcctTimeout());
        if (Boolean.TRUE.equals(dto.getRadiusAccountingEnable())) {
            dto.setAcctServer(po.getAcctServer().stream().map(RadiusAcctServerBKDTO::fromPO).collect(Collectors.toList()));
        }
        if (Boolean.TRUE.equals(dto.getCoaEnable())) {
            dto.setCoaServer(po.getCoaServer().stream().map(RadiusCoaServerBKDTO::fromPO).collect(Collectors.toList()));
        }
        dto.setTemplateId(po.getTemplateId());
        dto.setOverride(po.getOverride());
        return dto;
    }

    @Nonnull
    public static RadiusProfilePO toPO(@Nonnull RadiusProfileBKDTO dto) {
        RadiusProfilePO radiusProfile = new RadiusProfilePO();
        radiusProfile.setId(dto.getId());
        radiusProfile.setSiteId(dto.getSiteId());
        radiusProfile.setEntryId(dto.getEntryId());
        radiusProfile.setRadsecConfigured(Boolean.valueOf(Boolean.TRUE.equals(dto.getRadsecConfigured())));
        radiusProfile.setName(dto.getName());
        radiusProfile.setAuthServer(dto.getAuthServer().stream().map(RadiusAuthServerBKDTO::toPO).collect(Collectors.toList()));
        radiusProfile.setRadiusAccountingEnable(dto.getRadiusAccountingEnable());
        radiusProfile.setInterimUpdateEnable(dto.getInterimUpdateEnable());
        radiusProfile.setInterimUpdateInterval(dto.getInterimUpdateInterval());
        radiusProfile.setAcctServer(Boolean.TRUE.equals(dto.getRadiusAccountingEnable()) ? dto.getAcctServer().stream().map(RadiusAcctServerBKDTO::toPO).collect(Collectors.toList()) : null);
        radiusProfile.setWirelessVlanAssignment(dto.getWirelessVlanAssignment());
        radiusProfile.setCoaEnable(dto.getCoaEnable());
        radiusProfile.setCoaServer(Boolean.TRUE.equals(dto.getCoaEnable()) ? dto.getCoaServer().stream().map(RadiusCoaServerBKDTO::toPO).collect(Collectors.toList()) : null);
        radiusProfile.setBuiltInServer(Boolean.valueOf(Boolean.TRUE.equals(dto.getBuiltInServer())));
        radiusProfile.setServerEnable(Boolean.valueOf(Boolean.TRUE.equals(dto.getServerEnable())));
        radiusProfile.setTunnelReplyEnable(Boolean.valueOf(Boolean.TRUE.equals(dto.getTunnelReplyEnable())));
        radiusProfile.setBuiltInServerSecret(dto.getBuiltInServerSecret()).setAcctTimeout(dto.getAcctTimeout());
        radiusProfile.setTemplateId(dto.getTemplateId());
        radiusProfile.setOverride(dto.getOverride());
        radiusProfile.setProxy(Boolean.valueOf(Boolean.TRUE.equals(dto.getProxy())));
        radiusProfile.setRequireMessageAuthenticator(Boolean.valueOf(Boolean.TRUE.equals(dto.getRequireMessageAuthenticator())));
        return radiusProfile;
    }

    private static boolean radsecEnable(RadiusProfileTemplatePO po) {
        if (po.getAuthServer() == null) {
            log.warn("The authServer in RadiusProfileTemplatePO is empty, failed to do siteTemplateSyncToSiteWrite, omadacId {}, siteTemplateId {}", (Object)po.getOmadacId(), (Object)po.getSiteTemplateId());
            return false;
        }
        for (RadiusAuthServerPO radiusAuthServer : po.getAuthServer()) {
            if (!Boolean.TRUE.equals(radiusAuthServer.getRadSecEnable())) continue;
            return true;
        }
        if (Boolean.TRUE.equals(po.getRadiusAccountingEnable())) {
            if (po.getAcctServer() == null) {
                log.warn("The acctServer in RadiusProfileTemplatePO is empty, failed to do siteTemplateSyncToSiteWrite, omadacId {}, siteTemplateId {}", (Object)po.getOmadacId(), (Object)po.getSiteTemplateId());
                return false;
            }
            for (RadiusAcctServerPO radiusAcctServer : po.getAcctServer()) {
                if (!Boolean.TRUE.equals(radiusAcctServer.getRadSecEnable())) continue;
                return true;
            }
        }
        return false;
    }

    @Generated
    public RadiusProfileBKDTO() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Integer getEntryId() {
        return this.entryId;
    }

    @Generated
    public Boolean getRadsecConfigured() {
        return this.radsecConfigured;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<RadiusAuthServerBKDTO> getAuthServer() {
        return this.authServer;
    }

    @Generated
    public Boolean getRadiusAccountingEnable() {
        return this.radiusAccountingEnable;
    }

    @Generated
    public Boolean getInterimUpdateEnable() {
        return this.interimUpdateEnable;
    }

    @Generated
    public Integer getInterimUpdateInterval() {
        return this.interimUpdateInterval;
    }

    @Generated
    public List<RadiusAcctServerBKDTO> getAcctServer() {
        return this.acctServer;
    }

    @Generated
    public Boolean getWirelessVlanAssignment() {
        return this.wirelessVlanAssignment;
    }

    @Generated
    public Boolean getCoaEnable() {
        return this.coaEnable;
    }

    @Generated
    public List<RadiusCoaServerBKDTO> getCoaServer() {
        return this.coaServer;
    }

    @Generated
    public Boolean getProxy() {
        return this.proxy;
    }

    @Generated
    public Boolean getRequireMessageAuthenticator() {
        return this.requireMessageAuthenticator;
    }

    @Generated
    public Boolean getBuiltInServer() {
        return this.builtInServer;
    }

    @Generated
    public Boolean getServerEnable() {
        return this.serverEnable;
    }

    @Generated
    public Boolean getTunnelReplyEnable() {
        return this.tunnelReplyEnable;
    }

    @Generated
    public String getBuiltInServerSecret() {
        return this.builtInServerSecret;
    }

    @Generated
    public Integer getAcctTimeout() {
        return this.acctTimeout;
    }

    @Generated
    public String getTemplateId() {
        return this.templateId;
    }

    @Generated
    public Boolean getOverride() {
        return this.override;
    }

    @JsonProperty(value="id")
    @Generated
    public RadiusProfileBKDTO setId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="siteId")
    @Generated
    public RadiusProfileBKDTO setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    @JsonProperty(value="entryId")
    @Generated
    public RadiusProfileBKDTO setEntryId(Integer entryId) {
        this.entryId = entryId;
        return this;
    }

    @JsonProperty(value="radsecConfigured")
    @Generated
    public RadiusProfileBKDTO setRadsecConfigured(Boolean radsecConfigured) {
        this.radsecConfigured = radsecConfigured;
        return this;
    }

    @JsonProperty(value="name")
    @Generated
    public RadiusProfileBKDTO setName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="authServer")
    @Generated
    public RadiusProfileBKDTO setAuthServer(List<RadiusAuthServerBKDTO> authServer) {
        this.authServer = authServer;
        return this;
    }

    @JsonProperty(value="radiusAccountingEnable")
    @Generated
    public RadiusProfileBKDTO setRadiusAccountingEnable(Boolean radiusAccountingEnable) {
        this.radiusAccountingEnable = radiusAccountingEnable;
        return this;
    }

    @JsonProperty(value="interimUpdateEnable")
    @Generated
    public RadiusProfileBKDTO setInterimUpdateEnable(Boolean interimUpdateEnable) {
        this.interimUpdateEnable = interimUpdateEnable;
        return this;
    }

    @JsonProperty(value="interimUpdateInterval")
    @Generated
    public RadiusProfileBKDTO setInterimUpdateInterval(Integer interimUpdateInterval) {
        this.interimUpdateInterval = interimUpdateInterval;
        return this;
    }

    @JsonProperty(value="acctServer")
    @Generated
    public RadiusProfileBKDTO setAcctServer(List<RadiusAcctServerBKDTO> acctServer) {
        this.acctServer = acctServer;
        return this;
    }

    @JsonProperty(value="wirelessVlanAssignment")
    @Generated
    public RadiusProfileBKDTO setWirelessVlanAssignment(Boolean wirelessVlanAssignment) {
        this.wirelessVlanAssignment = wirelessVlanAssignment;
        return this;
    }

    @JsonProperty(value="coaEnable")
    @Generated
    public RadiusProfileBKDTO setCoaEnable(Boolean coaEnable) {
        this.coaEnable = coaEnable;
        return this;
    }

    @JsonProperty(value="coaServer")
    @Generated
    public RadiusProfileBKDTO setCoaServer(List<RadiusCoaServerBKDTO> coaServer) {
        this.coaServer = coaServer;
        return this;
    }

    @JsonProperty(value="proxy")
    @Generated
    public RadiusProfileBKDTO setProxy(Boolean proxy) {
        this.proxy = proxy;
        return this;
    }

    @JsonProperty(value="requireMessageAuthenticator")
    @Generated
    public RadiusProfileBKDTO setRequireMessageAuthenticator(Boolean requireMessageAuthenticator) {
        this.requireMessageAuthenticator = requireMessageAuthenticator;
        return this;
    }

    @JsonProperty(value="builtInServer")
    @Generated
    public RadiusProfileBKDTO setBuiltInServer(Boolean builtInServer) {
        this.builtInServer = builtInServer;
        return this;
    }

    @JsonProperty(value="serverEnable")
    @Generated
    public RadiusProfileBKDTO setServerEnable(Boolean serverEnable) {
        this.serverEnable = serverEnable;
        return this;
    }

    @JsonProperty(value="tunnelReplyEnable")
    @Generated
    public RadiusProfileBKDTO setTunnelReplyEnable(Boolean tunnelReplyEnable) {
        this.tunnelReplyEnable = tunnelReplyEnable;
        return this;
    }

    @JsonProperty(value="builtInServerSecret")
    @Generated
    public RadiusProfileBKDTO setBuiltInServerSecret(String builtInServerSecret) {
        this.builtInServerSecret = builtInServerSecret;
        return this;
    }

    @JsonProperty(value="acctTimeout")
    @Generated
    public RadiusProfileBKDTO setAcctTimeout(Integer acctTimeout) {
        this.acctTimeout = acctTimeout;
        return this;
    }

    @JsonProperty(value="templateId")
    @Generated
    public RadiusProfileBKDTO setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @JsonProperty(value="override")
    @Generated
    public RadiusProfileBKDTO setOverride(Boolean override) {
        this.override = override;
        return this;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof RadiusProfileBKDTO)) {
            return false;
        }
        RadiusProfileBKDTO other = (RadiusProfileBKDTO)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$entryId = this.getEntryId();
        Integer other$entryId = other.getEntryId();
        if (this$entryId == null ? other$entryId != null : !((Object)this$entryId).equals(other$entryId)) {
            return false;
        }
        Boolean this$radsecConfigured = this.getRadsecConfigured();
        Boolean other$radsecConfigured = other.getRadsecConfigured();
        if (this$radsecConfigured == null ? other$radsecConfigured != null : !((Object)this$radsecConfigured).equals(other$radsecConfigured)) {
            return false;
        }
        Boolean this$radiusAccountingEnable = this.getRadiusAccountingEnable();
        Boolean other$radiusAccountingEnable = other.getRadiusAccountingEnable();
        if (this$radiusAccountingEnable == null ? other$radiusAccountingEnable != null : !((Object)this$radiusAccountingEnable).equals(other$radiusAccountingEnable)) {
            return false;
        }
        Boolean this$interimUpdateEnable = this.getInterimUpdateEnable();
        Boolean other$interimUpdateEnable = other.getInterimUpdateEnable();
        if (this$interimUpdateEnable == null ? other$interimUpdateEnable != null : !((Object)this$interimUpdateEnable).equals(other$interimUpdateEnable)) {
            return false;
        }
        Integer this$interimUpdateInterval = this.getInterimUpdateInterval();
        Integer other$interimUpdateInterval = other.getInterimUpdateInterval();
        if (this$interimUpdateInterval == null ? other$interimUpdateInterval != null : !((Object)this$interimUpdateInterval).equals(other$interimUpdateInterval)) {
            return false;
        }
        Boolean this$wirelessVlanAssignment = this.getWirelessVlanAssignment();
        Boolean other$wirelessVlanAssignment = other.getWirelessVlanAssignment();
        if (this$wirelessVlanAssignment == null ? other$wirelessVlanAssignment != null : !((Object)this$wirelessVlanAssignment).equals(other$wirelessVlanAssignment)) {
            return false;
        }
        Boolean this$coaEnable = this.getCoaEnable();
        Boolean other$coaEnable = other.getCoaEnable();
        if (this$coaEnable == null ? other$coaEnable != null : !((Object)this$coaEnable).equals(other$coaEnable)) {
            return false;
        }
        Boolean this$proxy = this.getProxy();
        Boolean other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        Boolean this$requireMessageAuthenticator = this.getRequireMessageAuthenticator();
        Boolean other$requireMessageAuthenticator = other.getRequireMessageAuthenticator();
        if (this$requireMessageAuthenticator == null ? other$requireMessageAuthenticator != null : !((Object)this$requireMessageAuthenticator).equals(other$requireMessageAuthenticator)) {
            return false;
        }
        Boolean this$builtInServer = this.getBuiltInServer();
        Boolean other$builtInServer = other.getBuiltInServer();
        if (this$builtInServer == null ? other$builtInServer != null : !((Object)this$builtInServer).equals(other$builtInServer)) {
            return false;
        }
        Boolean this$serverEnable = this.getServerEnable();
        Boolean other$serverEnable = other.getServerEnable();
        if (this$serverEnable == null ? other$serverEnable != null : !((Object)this$serverEnable).equals(other$serverEnable)) {
            return false;
        }
        Boolean this$tunnelReplyEnable = this.getTunnelReplyEnable();
        Boolean other$tunnelReplyEnable = other.getTunnelReplyEnable();
        if (this$tunnelReplyEnable == null ? other$tunnelReplyEnable != null : !((Object)this$tunnelReplyEnable).equals(other$tunnelReplyEnable)) {
            return false;
        }
        Integer this$acctTimeout = this.getAcctTimeout();
        Integer other$acctTimeout = other.getAcctTimeout();
        if (this$acctTimeout == null ? other$acctTimeout != null : !((Object)this$acctTimeout).equals(other$acctTimeout)) {
            return false;
        }
        Boolean this$override = this.getOverride();
        Boolean other$override = other.getOverride();
        if (this$override == null ? other$override != null : !((Object)this$override).equals(other$override)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<RadiusAuthServerBKDTO> this$authServer = this.getAuthServer();
        List<RadiusAuthServerBKDTO> other$authServer = other.getAuthServer();
        if (this$authServer == null ? other$authServer != null : !((Object)this$authServer).equals(other$authServer)) {
            return false;
        }
        List<RadiusAcctServerBKDTO> this$acctServer = this.getAcctServer();
        List<RadiusAcctServerBKDTO> other$acctServer = other.getAcctServer();
        if (this$acctServer == null ? other$acctServer != null : !((Object)this$acctServer).equals(other$acctServer)) {
            return false;
        }
        List<RadiusCoaServerBKDTO> this$coaServer = this.getCoaServer();
        List<RadiusCoaServerBKDTO> other$coaServer = other.getCoaServer();
        if (this$coaServer == null ? other$coaServer != null : !((Object)this$coaServer).equals(other$coaServer)) {
            return false;
        }
        String this$builtInServerSecret = this.getBuiltInServerSecret();
        String other$builtInServerSecret = other.getBuiltInServerSecret();
        if (this$builtInServerSecret == null ? other$builtInServerSecret != null : !this$builtInServerSecret.equals(other$builtInServerSecret)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        return !(this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RadiusProfileBKDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $entryId = this.getEntryId();
        result = result * 59 + ($entryId == null ? 43 : ((Object)$entryId).hashCode());
        Boolean $radsecConfigured = this.getRadsecConfigured();
        result = result * 59 + ($radsecConfigured == null ? 43 : ((Object)$radsecConfigured).hashCode());
        Boolean $radiusAccountingEnable = this.getRadiusAccountingEnable();
        result = result * 59 + ($radiusAccountingEnable == null ? 43 : ((Object)$radiusAccountingEnable).hashCode());
        Boolean $interimUpdateEnable = this.getInterimUpdateEnable();
        result = result * 59 + ($interimUpdateEnable == null ? 43 : ((Object)$interimUpdateEnable).hashCode());
        Integer $interimUpdateInterval = this.getInterimUpdateInterval();
        result = result * 59 + ($interimUpdateInterval == null ? 43 : ((Object)$interimUpdateInterval).hashCode());
        Boolean $wirelessVlanAssignment = this.getWirelessVlanAssignment();
        result = result * 59 + ($wirelessVlanAssignment == null ? 43 : ((Object)$wirelessVlanAssignment).hashCode());
        Boolean $coaEnable = this.getCoaEnable();
        result = result * 59 + ($coaEnable == null ? 43 : ((Object)$coaEnable).hashCode());
        Boolean $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        Boolean $requireMessageAuthenticator = this.getRequireMessageAuthenticator();
        result = result * 59 + ($requireMessageAuthenticator == null ? 43 : ((Object)$requireMessageAuthenticator).hashCode());
        Boolean $builtInServer = this.getBuiltInServer();
        result = result * 59 + ($builtInServer == null ? 43 : ((Object)$builtInServer).hashCode());
        Boolean $serverEnable = this.getServerEnable();
        result = result * 59 + ($serverEnable == null ? 43 : ((Object)$serverEnable).hashCode());
        Boolean $tunnelReplyEnable = this.getTunnelReplyEnable();
        result = result * 59 + ($tunnelReplyEnable == null ? 43 : ((Object)$tunnelReplyEnable).hashCode());
        Integer $acctTimeout = this.getAcctTimeout();
        result = result * 59 + ($acctTimeout == null ? 43 : ((Object)$acctTimeout).hashCode());
        Boolean $override = this.getOverride();
        result = result * 59 + ($override == null ? 43 : ((Object)$override).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<RadiusAuthServerBKDTO> $authServer = this.getAuthServer();
        result = result * 59 + ($authServer == null ? 43 : ((Object)$authServer).hashCode());
        List<RadiusAcctServerBKDTO> $acctServer = this.getAcctServer();
        result = result * 59 + ($acctServer == null ? 43 : ((Object)$acctServer).hashCode());
        List<RadiusCoaServerBKDTO> $coaServer = this.getCoaServer();
        result = result * 59 + ($coaServer == null ? 43 : ((Object)$coaServer).hashCode());
        String $builtInServerSecret = this.getBuiltInServerSecret();
        result = result * 59 + ($builtInServerSecret == null ? 43 : $builtInServerSecret.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RadiusProfileBKDTO(id=" + this.getId() + ", siteId=" + this.getSiteId() + ", entryId=" + this.getEntryId() + ", radsecConfigured=" + this.getRadsecConfigured() + ", name=" + this.getName() + ", authServer=" + this.getAuthServer() + ", radiusAccountingEnable=" + this.getRadiusAccountingEnable() + ", interimUpdateEnable=" + this.getInterimUpdateEnable() + ", interimUpdateInterval=" + this.getInterimUpdateInterval() + ", acctServer=" + this.getAcctServer() + ", wirelessVlanAssignment=" + this.getWirelessVlanAssignment() + ", coaEnable=" + this.getCoaEnable() + ", coaServer=" + this.getCoaServer() + ", proxy=" + this.getProxy() + ", requireMessageAuthenticator=" + this.getRequireMessageAuthenticator() + ", builtInServer=" + this.getBuiltInServer() + ", serverEnable=" + this.getServerEnable() + ", tunnelReplyEnable=" + this.getTunnelReplyEnable() + ", builtInServerSecret=" + this.getBuiltInServerSecret() + ", acctTimeout=" + this.getAcctTimeout() + ", templateId=" + this.getTemplateId() + ", override=" + this.getOverride() + ")";
    }
}

