/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.auth;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.AuthenticationBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.Dot1xSettingBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.Dot1xSettingTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.MacAuthBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.MacAuthTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileTemplateBKDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.maintenance.common.b.a.a.e;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.dot1x.Dot1xSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.LdapProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.LdapProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.mac.MacAuthPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.BaseRadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAcctServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAuthServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.ApDot1xPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.BaseApSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.BaseOswSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.AUTHENTICATION)
public class AuthenticationSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationSiteImportUnit.class);
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d apSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d.a();
    private final a oswSiteSettingMaintMongoRepository = a.a();
    private static final AuthenticationSiteImportUnit instance = new AuthenticationSiteImportUnit();

    private AuthenticationSiteImportUnit() {
    }

    public static AuthenticationSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        AuthenticationBKDTO backupDTO = (AuthenticationBKDTO)jsonParserWrapper.a(AuthenticationBKDTO.class);
        this.siteCopyWrite(backupDTO, omadacId, newSiteId, siteImportIdCacheMap);
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        AuthenticationBKDTO backupDTO = (AuthenticationBKDTO)dataObject;
        this.restoreRadiusProfiles(omadacId, newSiteId, backupDTO.getRadiusProfiles(), siteImportIdCacheMap, true);
        this.restoreLdapProfiles(omadacId, newSiteId, backupDTO.getLdapProfiles(), siteImportIdCacheMap, true);
        this.restoreMacAuth(omadacId, newSiteId, backupDTO.getMacAuth(), siteImportIdCacheMap, true);
        this.restoreDot1x(omadacId, newSiteId, backupDTO.getDot1x(), siteImportIdCacheMap);
        this.restoreApDot1x(omadacId, newSiteId, backupDTO.getApDot1x(), siteImportIdCacheMap);
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        AuthenticationBKDTO backupDTO = (AuthenticationBKDTO)dataObject;
        this.restoreRadiusProfilesTemplate(omadacId, new e(newSiteTemplateId.a()), backupDTO.getRadiusProfilesTemplate(), siteImportIdCacheMap);
        this.restoreLdapProfilesTemplate(omadacId, new e(newSiteTemplateId.a()), backupDTO.getLdapProfilesTemplate(), siteImportIdCacheMap);
        this.restoreMacAuthTemplate(omadacId, new e(newSiteTemplateId.a()), backupDTO.getMacAuthTemplate(), siteImportIdCacheMap);
    }

    private void restoreLdapProfiles(c omadacId, d newSiteId, List<LdapProfileBKDTO> ldapProfiles, Map<String, Map<String, String>> siteImportIdCacheMap, boolean needUnbind) {
        Object existsList;
        if (CollectionUtils.isEmpty(ldapProfiles)) {
            return;
        }
        HashMap<String, String> idCache = new HashMap<String, String>();
        HashMap boundExistsMap = new HashMap();
        if (!needUnbind && !CollectionUtils.isEmpty((Collection)(existsList = this.authenticationMaintRepository.findLdapProfiles(omadacId, newSiteId)))) {
            existsList.forEach(existsPO -> {
                if (existsPO.getTemplateId() != null) {
                    boundExistsMap.put(existsPO.getTemplateId(), existsPO.getId());
                }
            });
        }
        for (LdapProfileBKDTO dto : ldapProfiles) {
            LdapProfilePO po = LdapProfileBKDTO.toPO(dto);
            po.setOmadacId(omadacId.a());
            po.setSiteId(newSiteId.a());
            if (needUnbind) {
                po.setId(null);
                po.setOverride(null);
                po.setTemplateId(null);
            } else if (boundExistsMap.containsKey(po.getTemplateId())) {
                String existsPOId = (String)boundExistsMap.get(po.getTemplateId());
                po.setId(existsPOId);
                boundExistsMap.remove(po.getTemplateId());
            } else {
                po.setId(null);
            }
            LdapProfilePO saved = this.authenticationMaintRepository.save(po);
            idCache.put(dto.getId(), saved.getId());
        }
        if (!CollectionUtils.isEmpty(boundExistsMap)) {
            HashSet idSet = new HashSet(boundExistsMap.values());
            this.authenticationMaintRepository.deleteLdapByOmadacIdAndSiteIdAndIds(omadacId, newSiteId, idSet);
        }
        siteImportIdCacheMap.put("ldapProfileIdOriginToCurrent", idCache);
    }

    private void restoreLdapProfilesTemplate(c omadacId, e siteTemplateId, List<LdapProfileTemplateBKDTO> ldapProfiles, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (CollectionUtils.isEmpty(ldapProfiles)) {
            return;
        }
        HashMap<String, String> idCache = new HashMap<String, String>();
        for (LdapProfileTemplateBKDTO dto : ldapProfiles) {
            LdapProfileTemplatePO po = LdapProfileTemplateBKDTO.toTemplatePO(dto);
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId(siteTemplateId.a());
            LdapProfileTemplatePO inserted = this.authenticationMaintRepository.insert(po);
            idCache.put(dto.getId(), inserted.getId());
        }
        siteImportIdCacheMap.put("ldapProfileIdOriginToCurrent", idCache);
    }

    private void restoreRadiusProfiles(c omadacId, d siteId, List<RadiusProfileBKDTO> radiusProfiles, Map<String, Map<String, String>> siteImportIdCacheMap, boolean needUnbind) {
        Object existsList;
        if (CollectionUtils.isEmpty(radiusProfiles)) {
            return;
        }
        HashMap<String, String> idCache = new HashMap<String, String>();
        HashMap boundExistsMap = new HashMap();
        if (!needUnbind && !CollectionUtils.isEmpty((Collection)(existsList = this.authenticationMaintRepository.findRadiusProfiles(omadacId, siteId)))) {
            existsList.forEach(existsPO -> {
                if (existsPO.getTemplateId() != null) {
                    boundExistsMap.put(existsPO.getTemplateId(), existsPO);
                }
            });
        }
        for (RadiusProfileBKDTO radiusBackupDTO : radiusProfiles) {
            RadiusProfilePO po = RadiusProfileBKDTO.toPO(radiusBackupDTO);
            if (Boolean.TRUE.equals(po.getBuiltInServer())) {
                RadiusProfilePO existBuiltProfile = this.authenticationMaintRepository.findBuiltInProfile();
                if (existBuiltProfile == null) continue;
                idCache.put(radiusBackupDTO.getId(), existBuiltProfile.getId());
                continue;
            }
            po.setOmadacId(omadacId.a());
            po.setSiteId(siteId.a());
            if (po.getEntryId() == null) {
                com.tplink.smb.omada.portal.port.mongo.omada.a.a getSequenceNumService = (com.tplink.smb.omada.portal.port.mongo.omada.a.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.portal.port.mongo.omada.a.a.class);
                po.setEntryId(getSequenceNumService.b(omadacId.a(), siteId.a(), RadiusProfilePO.class));
            }
            if (needUnbind) {
                po.setId(null);
                po.setOverride(null);
                po.setTemplateId(null);
            } else if (boundExistsMap.containsKey(po.getTemplateId())) {
                RadiusProfilePO radiusProfilePO = (RadiusProfilePO)boundExistsMap.get(po.getTemplateId());
                po.setId(radiusProfilePO.getId());
                if (radiusProfilePO.getEntryId() == null) {
                    com.tplink.smb.omada.portal.port.mongo.omada.a.a getSequenceNumService = (com.tplink.smb.omada.portal.port.mongo.omada.a.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.portal.port.mongo.omada.a.a.class);
                    radiusProfilePO.setEntryId(getSequenceNumService.b(omadacId.a(), siteId.a(), RadiusProfilePO.class));
                }
                po.setEntryId(radiusProfilePO.getEntryId());
                boundExistsMap.remove(po.getTemplateId());
            } else {
                po.setId(null);
            }
            HashMap profileMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()) == null ? new HashMap() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
            List authServer = po.getAuthServer();
            for (RadiusAuthServerPO radiusAuthServerPO : authServer) {
                String clientCert;
                if (!Boolean.TRUE.equals(radiusAuthServerPO.getRadSecEnable())) continue;
                String caCert = radiusAuthServerPO.getCaCert();
                if (caCert != null) {
                    radiusAuthServerPO.setCaCert(profileMap.getOrDefault(caCert, caCert));
                }
                if ((clientCert = radiusAuthServerPO.getClientCert()) == null) continue;
                radiusAuthServerPO.setClientCert(profileMap.getOrDefault(clientCert, clientCert));
            }
            if (Boolean.TRUE.equals(po.getRadiusAccountingEnable())) {
                List acctServer = po.getAcctServer();
                for (RadiusAcctServerPO radiusAcctServerPO : acctServer) {
                    String clientCert;
                    if (!Boolean.TRUE.equals(radiusAcctServerPO.getRadSecEnable())) continue;
                    String caCert = radiusAcctServerPO.getCaCert();
                    if (caCert != null) {
                        radiusAcctServerPO.setCaCert(profileMap.getOrDefault(caCert, caCert));
                    }
                    if ((clientCert = radiusAcctServerPO.getClientCert()) == null) continue;
                    radiusAcctServerPO.setClientCert(profileMap.getOrDefault(clientCert, clientCert));
                }
            }
            RadiusProfilePO inserted = this.authenticationMaintRepository.saveAndReturn(po);
            idCache.put(radiusBackupDTO.getId(), inserted.getId());
            DomainEventBusHolder.getPublisher().publishSync(((b.a)((Object)((b.a)((Object)((b.a)((Object)((b.a)((Object)b.a().a(omadacId))).a(siteId))).a(radiusBackupDTO.getId()))).b(inserted.getId()))).b());
        }
        if (!CollectionUtils.isEmpty(boundExistsMap)) {
            HashSet idSet = new HashSet(boundExistsMap.values().stream().map(BaseRadiusProfilePO::getId).collect(Collectors.toSet()));
            this.authenticationMaintRepository.deleteRadiusByOmadacIdAndSiteIdAndIds(omadacId, siteId, idSet);
        }
        siteImportIdCacheMap.put("radiusProfileIdOriginToCurrent", idCache);
    }

    private void restoreRadiusProfilesTemplate(c omadacId, e siteTemplateId, List<RadiusProfileTemplateBKDTO> radiusProfiles, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (CollectionUtils.isEmpty(radiusProfiles)) {
            return;
        }
        HashMap<String, String> idCache = new HashMap<String, String>();
        for (RadiusProfileTemplateBKDTO radiusBackupDTO : radiusProfiles) {
            RadiusProfileTemplatePO po = RadiusProfileTemplateBKDTO.toPO(radiusBackupDTO);
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId(siteTemplateId.a());
            if (po.getEntryId() == null) {
                com.tplink.smb.omada.portal.port.mongo.omada.a.a getSequenceNumService = (com.tplink.smb.omada.portal.port.mongo.omada.a.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.portal.port.mongo.omada.a.a.class);
                po.setEntryId(getSequenceNumService.b(omadacId.a(), siteTemplateId.a(), RadiusProfilePO.class));
            }
            HashMap profileMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()) == null ? new HashMap() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
            List authServer = po.getAuthServer();
            for (RadiusAuthServerPO radiusAuthServerPO : authServer) {
                String clientCert;
                if (!Boolean.TRUE.equals(radiusAuthServerPO.getRadSecEnable())) continue;
                String caCert = radiusAuthServerPO.getCaCert();
                if (caCert != null) {
                    radiusAuthServerPO.setCaCert(profileMap.getOrDefault(caCert, caCert));
                }
                if ((clientCert = radiusAuthServerPO.getClientCert()) == null) continue;
                radiusAuthServerPO.setClientCert(profileMap.getOrDefault(clientCert, clientCert));
            }
            if (Boolean.TRUE.equals(po.getRadiusAccountingEnable())) {
                List acctServer = po.getAcctServer();
                for (RadiusAcctServerPO radiusAcctServerPO : acctServer) {
                    String clientCert;
                    if (!Boolean.TRUE.equals(radiusAcctServerPO.getRadSecEnable())) continue;
                    String caCert = radiusAcctServerPO.getCaCert();
                    if (caCert != null) {
                        radiusAcctServerPO.setCaCert(profileMap.getOrDefault(caCert, caCert));
                    }
                    if ((clientCert = radiusAcctServerPO.getClientCert()) == null) continue;
                    radiusAcctServerPO.setClientCert(profileMap.getOrDefault(clientCert, clientCert));
                }
            }
            RadiusProfileTemplatePO inserted = this.authenticationMaintRepository.insert(po);
            idCache.put(radiusBackupDTO.getId(), inserted.getId());
            DomainEventBusHolder.getPublisher().publishSync(((b.a)((Object)((b.a)((Object)((b.a)((Object)((b.a)((Object)b.a().a(omadacId))).a(new d(siteTemplateId.a())))).a(radiusBackupDTO.getId()))).b(inserted.getId()))).b());
        }
        siteImportIdCacheMap.put("radiusProfileIdOriginToCurrent", idCache);
    }

    private void restoreMacAuth(c omadacId, d siteId, MacAuthBKDTO macAuthBackupDTO, Map<String, Map<String, String>> siteImportIdCacheMap, boolean needUnbind) {
        String oldLdapProfileId;
        if (macAuthBackupDTO == null) {
            return;
        }
        MacAuthPO macAuthPO = MacAuthBKDTO.toPO(macAuthBackupDTO);
        Map radiusIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        Map ldapProfileIdMap = siteImportIdCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = macAuthPO.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            String newRadiusProfileId = radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId);
            macAuthPO.setRadiusProfileId(newRadiusProfileId);
        }
        if ((oldLdapProfileId = macAuthPO.getLdapProfileId()) != null) {
            String newLdapProfileId = ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId);
            macAuthPO.setLdapProfileId(newLdapProfileId);
        }
        if (needUnbind) {
            macAuthPO.setOverride(null);
        }
        this.apSiteSettingMaintMongoRepository.a(omadacId, siteId).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setMacAuth(macAuthPO);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }

    private void restoreMacAuthTemplate(c omadacId, e siteTemplateId, MacAuthTemplateBKDTO macAuthBackupDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        String oldLdapProfileId;
        if (macAuthBackupDTO == null) {
            return;
        }
        MacAuthPO macAuthPO = MacAuthTemplateBKDTO.toPO(macAuthBackupDTO);
        Map radiusIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        Map ldapProfileIdMap = siteImportIdCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = macAuthPO.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            String newRadiusProfileId = radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId);
            macAuthPO.setRadiusProfileId(newRadiusProfileId);
        }
        if ((oldLdapProfileId = macAuthPO.getLdapProfileId()) != null) {
            String newLdapProfileId = ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId);
            macAuthPO.setLdapProfileId(newLdapProfileId);
        }
        this.apSiteSettingMaintMongoRepository.b(omadacId, siteTemplateId.a()).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setMacAuth(macAuthPO);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }

    private void restoreDot1xTemplate(c omadacId, e siteId, Dot1xSettingTemplateBKDTO dot1xSettingBKDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        Dot1xSettingPO po = dot1xSettingBKDTO.toOswDot1xPO(omadacId.a(), siteId.a());
        Map radiusIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.oswSiteSettingMaintMongoRepository.a(omadacId, siteId.a()).ifPresent(oswSiteSettingPO -> {
            oswSiteSettingPO.setDot1x(po);
            this.oswSiteSettingMaintMongoRepository.a((BaseOswSiteSettingPO)oswSiteSettingPO);
        });
    }

    private void restoreDot1x(c omadacId, d siteId, Dot1xSettingBKDTO dot1xSettingBKDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        Dot1xSettingPO po = dot1xSettingBKDTO.toOswDot1xPO(omadacId.a(), siteId.a());
        Map radiusIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        Map vrfMap = siteImportIdCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.Z.A(), Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        if (!CollectionUtils.isEmpty((Collection)po.getVrfConfig())) {
            po.getVrfConfig().forEach(vrfConfigPO -> {
                vrfConfigPO.setAccountVrfId((String)vrfMap.get(vrfConfigPO.getAccountVrfId()));
                vrfConfigPO.setAuthVrfId((String)vrfMap.get(vrfConfigPO.getAuthVrfId()));
            });
        }
        this.oswSiteSettingMaintMongoRepository.a(omadacId, siteId).ifPresent(oswSiteSettingPO -> {
            oswSiteSettingPO.setDot1x(po);
            this.oswSiteSettingMaintMongoRepository.a((BaseOswSiteSettingPO)oswSiteSettingPO);
        });
    }

    private void restoreApDot1x(c omadacId, d siteId, Dot1xSettingBKDTO dot1xSettingBKDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        ApDot1xPO po = dot1xSettingBKDTO.toApDot1xPO(omadacId.a(), siteId.a());
        Map radiusIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.apSiteSettingMaintMongoRepository.a(omadacId, siteId).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setApDot1x(po);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }

    private void restoreApDot1xTemplate(c omadacId, e siteId, Dot1xSettingTemplateBKDTO dot1xSettingBKDTO, Map<String, Map<String, String>> siteImportIdCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        ApDot1xPO po = dot1xSettingBKDTO.toApDot1xPO(omadacId.a(), siteId.a());
        Map radiusIdMap = siteImportIdCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.apSiteSettingMaintMongoRepository.b(omadacId, siteId.a()).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setApDot1x(po);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }
}

