/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.auth;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.a;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.AuthenticationBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.Dot1xSettingBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.Dot1xSettingTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.MacAuthBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.MacAuthTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileTemplateBKDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.dot1x.Dot1xSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.LdapProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.ldap.LdapProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.mac.MacAuthPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfileTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.ApDot1xPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.BaseApSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.BaseOswSiteSettingPO;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51524, b=com.tplink.smb.omada.backup.api.c.d.AUTHENTICATION)
public class AuthenticationRestoreUnitV51524
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationRestoreUnitV51524.class);
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d apSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a oswSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a.a();
    private static final AuthenticationRestoreUnitV51524 instance = new AuthenticationRestoreUnitV51524();

    private AuthenticationRestoreUnitV51524() {
    }

    public static AuthenticationRestoreUnitV51524 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        AuthenticationBKDTO backupDTO = (AuthenticationBKDTO)jsonParserWrapper.a(AuthenticationBKDTO.class);
        Map<String, String> siteIdMap = restoreCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.Q.A(), Collections.emptyMap());
        if (siteIdMap.isEmpty()) {
            log.warn("Restoring authentication: siteIdMap is empty!");
            throw new com.tplink.smb.omada.backup.api.d.c("siteIdMap is empty");
        }
        this.restoreRadiusProfilesTemplate(omadacId, backupDTO.getRadiusProfilesTemplate(), siteIdMap, restoreCacheMap);
        this.restoreLdapProfilesTemplate(omadacId, backupDTO.getLdapProfilesTemplate(), siteIdMap, restoreCacheMap);
        this.restoreMacAuthTemplate(omadacId, backupDTO.getMacAuthTemplate(), siteIdMap, restoreCacheMap);
        this.restoreRadiusProfiles(omadacId, backupDTO.getRadiusProfiles(), siteIdMap, restoreCacheMap);
        this.restoreLdapProfiles(omadacId, backupDTO.getLdapProfiles(), siteIdMap, restoreCacheMap);
        this.restoreMacAuth(omadacId, backupDTO.getMacAuth(), siteIdMap, restoreCacheMap);
        this.restoreDot1x(omadacId, backupDTO.getDot1x(), siteIdMap, restoreCacheMap);
        this.restoreApDot1x(omadacId, backupDTO.getApDot1x(), siteIdMap, restoreCacheMap);
    }

    private void restoreLdapProfiles(c omadacId, List<LdapProfileBKDTO> ldapProfiles, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(ldapProfiles)) {
            return;
        }
        Map idCache = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", new HashMap());
        for (LdapProfileBKDTO ldapBackupDTO : ldapProfiles) {
            LdapProfilePO po = LdapProfileBKDTO.toPO(ldapBackupDTO);
            String currentSiteId = siteIdMap.get(ldapBackupDTO.getSiteId());
            if (currentSiteId == null) {
                log.error("Restoring ldapProfile: Cannot find mapped siteId by v5 backup ldapProfile: {}", (Object)ldapBackupDTO);
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            po.setTemplateId(po.getTemplateId() == null ? null : (String)idCache.getOrDefault(po.getTemplateId(), null));
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteId(currentSiteId);
            LdapProfilePO inserted = this.authenticationMaintRepository.insert(po);
            idCache.put(ldapBackupDTO.getId(), inserted.getId());
        }
        restoreCacheMap.put("ldapProfileIdOriginToCurrent", idCache);
    }

    private void restoreLdapProfilesTemplate(c omadacId, List<LdapProfileTemplateBKDTO> ldapProfiles, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(ldapProfiles)) {
            return;
        }
        Map idCache = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", new HashMap());
        for (LdapProfileTemplateBKDTO ldapBackupDTO : ldapProfiles) {
            LdapProfileTemplatePO po = LdapProfileTemplateBKDTO.toTemplatePO(ldapBackupDTO);
            String currentSiteId = siteIdMap.get(ldapBackupDTO.getSiteTemplateId());
            if (currentSiteId == null) {
                log.error("Restoring ldapProfile: Cannot find mapped siteTemplateId by v5 backup ldapProfileTemplate: {}", (Object)ldapBackupDTO);
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteTemplateId.");
            }
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId(currentSiteId);
            LdapProfileTemplatePO inserted = this.authenticationMaintRepository.insert(po);
            idCache.put(ldapBackupDTO.getId(), inserted.getId());
        }
        restoreCacheMap.put("ldapProfileIdOriginToCurrent", idCache);
    }

    private void restoreRadiusProfilesTemplate(c omadacId, List<RadiusProfileTemplateBKDTO> radiusProfiles, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(radiusProfiles)) {
            return;
        }
        Map idCache = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", new HashMap());
        for (RadiusProfileTemplateBKDTO radiusBackupDTO : radiusProfiles) {
            RadiusProfileTemplatePO po = RadiusProfileTemplateBKDTO.toPO(radiusBackupDTO);
            if (Boolean.TRUE.equals(po.getBuiltInServer())) {
                RadiusProfilePO existBuiltProfile = this.authenticationMaintRepository.findBuiltInProfile();
                if (existBuiltProfile == null) continue;
                idCache.put(radiusBackupDTO.getId(), existBuiltProfile.getId());
                continue;
            }
            String currentSiteId = siteIdMap.get(radiusBackupDTO.getSiteTemplateId());
            if (currentSiteId == null) {
                log.error("Restoring radiusProfile: Cannot find mapped siteId by v5 backup radiusProfile: {}", (Object)radiusBackupDTO);
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteTemplateId(currentSiteId);
            RadiusProfileTemplatePO inserted = this.authenticationMaintRepository.insert(po);
            idCache.put(radiusBackupDTO.getId(), inserted.getId());
            DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(new d(currentSiteId)))).a(radiusBackupDTO.getId()))).b(inserted.getId()))).b());
        }
        restoreCacheMap.put("radiusProfileIdOriginToCurrent", idCache);
    }

    private void restoreRadiusProfiles(c omadacId, List<RadiusProfileBKDTO> radiusProfiles, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(radiusProfiles)) {
            return;
        }
        Map idCache = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", new HashMap());
        for (RadiusProfileBKDTO radiusBackupDTO : radiusProfiles) {
            RadiusProfilePO po = RadiusProfileBKDTO.toPO(radiusBackupDTO);
            if (Boolean.TRUE.equals(po.getBuiltInServer())) {
                RadiusProfilePO existBuiltProfile = this.authenticationMaintRepository.findBuiltInProfile();
                if (existBuiltProfile == null) continue;
                idCache.put(radiusBackupDTO.getId(), existBuiltProfile.getId());
                continue;
            }
            String currentSiteId = siteIdMap.get(radiusBackupDTO.getSiteId());
            if (currentSiteId == null) {
                log.error("Restoring radiusProfile: Cannot find mapped siteId by v5 backup radiusProfile: {}", (Object)radiusBackupDTO);
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteId(currentSiteId);
            Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
            if (po.getTemplateId() != null) {
                po.setTemplateId((String)radiusIdMap.get(po.getTemplateId()));
            }
            RadiusProfilePO inserted = this.authenticationMaintRepository.insert(po);
            idCache.put(radiusBackupDTO.getId(), inserted.getId());
            DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(new d(currentSiteId)))).a(radiusBackupDTO.getId()))).b(inserted.getId()))).b());
        }
        restoreCacheMap.put("radiusProfileIdOriginToCurrent", idCache);
    }

    private void restoreMacAuth(c omadacId, MacAuthBKDTO macAuthBackupDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        String oldLdapProfileId;
        if (macAuthBackupDTO == null) {
            return;
        }
        MacAuthPO macAuthPO = MacAuthBKDTO.toPO(macAuthBackupDTO);
        String currentSiteId = siteIdMap.getOrDefault(macAuthBackupDTO.getSiteId(), macAuthBackupDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring macAuth: Cannot find mapped siteId by v5 backup macAuth: {}", (Object)macAuthBackupDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId");
        }
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        Map ldapProfileIdMap = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = macAuthPO.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            String newRadiusProfileId = radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId);
            macAuthPO.setRadiusProfileId(newRadiusProfileId);
        }
        if ((oldLdapProfileId = macAuthPO.getLdapProfileId()) != null) {
            String newLdapProfileId = ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId);
            macAuthPO.setLdapProfileId(newLdapProfileId);
        }
        this.apSiteSettingMaintMongoRepository.a(omadacId, new d(currentSiteId)).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setMacAuth(macAuthPO);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }

    private void restoreMacAuthTemplate(c omadacId, MacAuthTemplateBKDTO macAuthBackupDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        String oldLdapProfileId;
        if (macAuthBackupDTO == null) {
            return;
        }
        MacAuthPO macAuthPO = MacAuthTemplateBKDTO.toPO(macAuthBackupDTO);
        String currentSiteId = siteIdMap.getOrDefault(macAuthBackupDTO.getSiteTemplateId(), macAuthBackupDTO.getSiteTemplateId());
        if (currentSiteId == null) {
            log.error("Restoring macAuth: Cannot find mapped siteTemplateId by v5 backup macAuthTemplate: {}", (Object)macAuthBackupDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteTemplateId");
        }
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        Map ldapProfileIdMap = restoreCacheMap.getOrDefault("ldapProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = macAuthPO.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            String newRadiusProfileId = radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId);
            macAuthPO.setRadiusProfileId(newRadiusProfileId);
        }
        if ((oldLdapProfileId = macAuthPO.getLdapProfileId()) != null) {
            String newLdapProfileId = ldapProfileIdMap.getOrDefault(oldLdapProfileId, oldLdapProfileId);
            macAuthPO.setLdapProfileId(newLdapProfileId);
        }
        this.apSiteSettingMaintMongoRepository.b(omadacId, currentSiteId).ifPresent(apSiteSettingTemplatePO -> {
            apSiteSettingTemplatePO.setMacAuth(macAuthPO);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingTemplatePO);
        });
    }

    private void restoreDot1x(c omadacId, Dot1xSettingBKDTO dot1xSettingBKDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        String currentSiteId = siteIdMap.get(dot1xSettingBKDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring 802.1x: Cannot find mapped siteId by v5 backup 802.1x: {}", (Object)dot1xSettingBKDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
        }
        Dot1xSettingPO po = dot1xSettingBKDTO.toOswDot1xPO(omadacId.a(), currentSiteId);
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.oswSiteSettingMaintMongoRepository.a(omadacId, new d(currentSiteId)).ifPresent(oswSiteSettingPO -> {
            oswSiteSettingPO.setDot1x(po);
            this.oswSiteSettingMaintMongoRepository.a((BaseOswSiteSettingPO)oswSiteSettingPO);
        });
    }

    private void restoreDot1xTemplate(c omadacId, Dot1xSettingTemplateBKDTO dot1xSettingBKDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        String currentSiteId = siteIdMap.get(dot1xSettingBKDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring 802.1x: Cannot find mapped siteId by v5 backup 802.1x: {}", (Object)dot1xSettingBKDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
        }
        Dot1xSettingPO po = dot1xSettingBKDTO.toOswDot1xPO(omadacId.a(), currentSiteId);
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.oswSiteSettingMaintMongoRepository.a(omadacId, currentSiteId).ifPresent(oswSiteSettingPO -> {
            oswSiteSettingPO.setDot1x(po);
            this.oswSiteSettingMaintMongoRepository.a((BaseOswSiteSettingPO)oswSiteSettingPO);
        });
    }

    private void restoreApDot1x(c omadacId, Dot1xSettingBKDTO dot1xSettingBKDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        String currentSiteId = siteIdMap.get(dot1xSettingBKDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring eap 802.1x: Cannot find mapped siteId by v5 backup eap 802.1x: {}", (Object)dot1xSettingBKDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
        }
        ApDot1xPO po = dot1xSettingBKDTO.toApDot1xPO(omadacId.a(), currentSiteId);
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.apSiteSettingMaintMongoRepository.a(omadacId, new d(currentSiteId)).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setApDot1x(po);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }

    private void restoreApDot1xTemplate(c omadacId, Dot1xSettingTemplateBKDTO dot1xSettingBKDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        String currentSiteId = siteIdMap.get(dot1xSettingBKDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring eap 802.1x: Cannot find mapped siteId by v5 backup eap 802.1x: {}", (Object)dot1xSettingBKDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
        }
        ApDot1xPO po = dot1xSettingBKDTO.toApDot1xPO(omadacId.a(), currentSiteId);
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.apSiteSettingMaintMongoRepository.b(omadacId, currentSiteId).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setApDot1x(po);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }
}

