/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.auth;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.a;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.Dot1xSettingBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.MacAuthBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.dot1x.Dot1xSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.mac.MacAuthPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.BaseApSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.BaseOswSiteSettingPO;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=com.tplink.smb.omada.backup.api.c.d.AUTHENTICATION)
public class AuthenticationRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationRestoreUnitV50000.class);
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d apSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a oswSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a.a();
    private static final AuthenticationRestoreUnitV50000 instance = new AuthenticationRestoreUnitV50000();

    private AuthenticationRestoreUnitV50000() {
    }

    public static AuthenticationRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.a backupDTO = (com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.a)jsonParserWrapper.a(com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.a.class);
        Map<String, String> siteIdMap = restoreCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.Q.A(), Collections.emptyMap());
        if (siteIdMap.isEmpty()) {
            log.warn("Restoring authentication: siteIdMap is empty!");
            throw new com.tplink.smb.omada.backup.api.d.c("siteIdMap is empty");
        }
        this.restoreRadiusProfiles(omadacId, backupDTO.c(), siteIdMap, restoreCacheMap);
        this.restoreMacAuth(omadacId, backupDTO.a(), siteIdMap, restoreCacheMap);
        this.restoreDot1x(omadacId, backupDTO.b(), siteIdMap, restoreCacheMap);
    }

    private void restoreRadiusProfiles(c omadacId, List<b> radiusProfiles, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (CollectionUtils.isEmpty(radiusProfiles)) {
            return;
        }
        HashMap<String, String> idCache = new HashMap<String, String>();
        for (b radiusBackupDTO : radiusProfiles) {
            RadiusProfilePO po = b.a(radiusBackupDTO);
            String currentSiteId = siteIdMap.get(radiusBackupDTO.b());
            if (currentSiteId == null) {
                log.error("Restoring radiusProfile: Cannot find mapped siteId by v5 backup radiusProfile: {}", (Object)radiusBackupDTO);
                throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
            }
            po.setId(null);
            po.setOmadacId(omadacId.a());
            po.setSiteId(currentSiteId);
            RadiusProfilePO inserted = this.authenticationMaintRepository.insert(po);
            idCache.put(radiusBackupDTO.a(), inserted.getId());
            DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)a.a().a(omadacId))).a(new d(currentSiteId)))).a(radiusBackupDTO.a()))).b(inserted.getId()))).b());
        }
        restoreCacheMap.put("radiusProfileIdOriginToCurrent", idCache);
    }

    private void restoreMacAuth(c omadacId, MacAuthBKDTO macAuthBackupDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (macAuthBackupDTO == null) {
            return;
        }
        MacAuthPO macAuthPO = MacAuthBKDTO.toPO(macAuthBackupDTO);
        String currentSiteId = siteIdMap.getOrDefault(macAuthBackupDTO.getSiteId(), macAuthBackupDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring macAuth: Cannot find mapped siteId by v5 backup macAuth: {}", (Object)macAuthBackupDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId");
        }
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = macAuthPO.getRadiusProfileId();
        String newRadiusProfileId = radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId);
        macAuthPO.setRadiusProfileId(newRadiusProfileId);
        this.apSiteSettingMaintMongoRepository.a(omadacId, new d(currentSiteId)).ifPresent(apSiteSettingPO -> {
            apSiteSettingPO.setMacAuth(macAuthPO);
            this.apSiteSettingMaintMongoRepository.a((BaseApSiteSettingPO)apSiteSettingPO);
        });
    }

    private void restoreDot1x(c omadacId, Dot1xSettingBKDTO dot1xSettingBKDTO, Map<String, String> siteIdMap, Map<String, Object> restoreCacheMap) {
        if (dot1xSettingBKDTO == null) {
            return;
        }
        String currentSiteId = siteIdMap.get(dot1xSettingBKDTO.getSiteId());
        if (currentSiteId == null) {
            log.error("Restoring 802.1x: Cannot find mapped siteId by v5 backup 802.1x: {}", (Object)dot1xSettingBKDTO);
            throw new com.tplink.smb.omada.backup.api.d.c("Cannot find mapped siteId.");
        }
        Dot1xSettingPO po = dot1xSettingBKDTO.toOswDot1xPO(omadacId.a(), currentSiteId);
        Map radiusIdMap = restoreCacheMap.getOrDefault("radiusProfileIdOriginToCurrent", Collections.emptyMap());
        String oldRadiusProfileId = po.getRadiusProfileId();
        if (oldRadiusProfileId != null) {
            po.setRadiusProfileId(radiusIdMap.getOrDefault(oldRadiusProfileId, oldRadiusProfileId));
        }
        this.oswSiteSettingMaintMongoRepository.a(omadacId, new d(currentSiteId)).ifPresent(oswSiteSettingPO -> {
            oswSiteSettingPO.setDot1x(po);
            this.oswSiteSettingMaintMongoRepository.a((BaseOswSiteSettingPO)oswSiteSettingPO);
        });
    }
}

