/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.auth;

import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.AuthenticationBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.Dot1xSettingBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.Dot1xSettingTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.LdapProfileTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.MacAuthBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.MacAuthTemplateBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.auth.dto.RadiusProfileTemplateBKDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.BaseApSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.BaseOswSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

@com.tplink.smb.omada.backup.api.a.a(a=com.tplink.smb.omada.backup.api.c.d.AUTHENTICATION)
public class AuthenticationBackupUnit
extends com.tplink.smb.omada.backup.api.b.d<AuthenticationBKDTO> {
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d apSiteSettingMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d.a();
    private final a oswSiteSettingMaintMongoRepository = a.a();
    private static final AuthenticationBackupUnit instance = new AuthenticationBackupUnit();

    private AuthenticationBackupUnit() {
    }

    public static AuthenticationBackupUnit getInstance() {
        return instance;
    }

    public AuthenticationBKDTO readFromDB(c omadacId, d siteId, boolean siteTemplateRead) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        if (siteTemplateRead) {
            AuthenticationBKDTO backupDTO = new AuthenticationBKDTO();
            backupDTO.setMacAuthTemplate(this.backupMacAuthTemplate(omadacId, siteId.a()));
            backupDTO.setRadiusProfilesTemplate(this.backupRadiusProfileTemplates(omadacId, siteId.a()));
            backupDTO.setLdapProfilesTemplate(this.backupLdapProfileTemplates(omadacId, siteId.a()));
            return backupDTO;
        }
        AuthenticationBKDTO backupDTO = new AuthenticationBKDTO();
        backupDTO.setMacAuth(this.backupMacAuth(omadacId, siteId));
        backupDTO.setRadiusProfiles(this.backupRadiusProfiles(omadacId, siteId));
        backupDTO.setDot1x(this.backupDot1x(omadacId, siteId));
        backupDTO.setLdapProfiles(this.backupLdapProfiles(omadacId, siteId));
        backupDTO.setApDot1x(this.backupApDot1x(omadacId, siteId));
        return backupDTO;
    }

    private List<LdapProfileBKDTO> backupLdapProfiles(c omadacId, d siteId) {
        return this.authenticationMaintRepository.findLdapProfiles(omadacId, siteId).stream().map(LdapProfileBKDTO::fromPO).collect(Collectors.toList());
    }

    private MacAuthBKDTO backupMacAuth(c omadacId, d siteId) {
        return this.apSiteSettingMongoRepository.a(omadacId, siteId).map(BaseApSiteSettingPO::getMacAuth).map(po -> MacAuthBKDTO.fromPO(po).setSiteId(siteId.a())).orElse(null);
    }

    private List<RadiusProfileBKDTO> backupRadiusProfiles(c omadacId, d siteId) {
        return this.authenticationMaintRepository.findRadiusProfiles(omadacId, siteId).stream().map(RadiusProfileBKDTO::fromPO).collect(Collectors.toList());
    }

    private Dot1xSettingBKDTO backupDot1x(c omadacId, d siteId) {
        return this.oswSiteSettingMaintMongoRepository.a(omadacId, siteId).map(BaseOswSiteSettingPO::getDot1x).map(dot1x -> Dot1xSettingBKDTO.fromPO(dot1x, siteId)).orElse(null);
    }

    private Dot1xSettingBKDTO backupApDot1x(c omadacId, d siteId) {
        return this.apSiteSettingMongoRepository.a(omadacId, siteId).map(BaseApSiteSettingPO::getApDot1x).map(dot1x -> Dot1xSettingBKDTO.fromPO(dot1x, siteId)).orElse(null);
    }

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, d siteId, com.tplink.smb.omada.backup.api.c.d keyEnum, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        AuthenticationBKDTO element = this.readFromDB(omadacId, siteId, false);
        if (element != null) {
            if (h.e.equals((Object)backupTypeEnum)) {
                if (element.getRadiusProfiles() != null) {
                    element.getRadiusProfiles().forEach(radiusProfileBKDTO -> {
                        if (radiusProfileBKDTO.getAuthServer() != null) {
                            radiusProfileBKDTO.getAuthServer().forEach(radiusAuthServerBKDTO -> {
                                radiusAuthServerBKDTO.setRadiusServerIp(null);
                                radiusAuthServerBKDTO.setRadiusPwd(null);
                            });
                        }
                        if (radiusProfileBKDTO.getAcctServer() != null) {
                            radiusProfileBKDTO.getAcctServer().forEach(radiusAcctServerBKDTO -> {
                                radiusAcctServerBKDTO.setAccountingServerIp(null);
                                radiusAcctServerBKDTO.setAccountingServerPwd(null);
                            });
                        }
                    });
                }
                if (element.getRadiusProfilesTemplate() != null) {
                    element.getRadiusProfilesTemplate().forEach(radiusProfileBKDTO -> {
                        if (radiusProfileBKDTO.getAuthServer() != null) {
                            radiusProfileBKDTO.getAuthServer().forEach(radiusAuthServerBKDTO -> {
                                radiusAuthServerBKDTO.setRadiusServerIp(null);
                                radiusAuthServerBKDTO.setRadiusPwd(null);
                            });
                        }
                        if (radiusProfileBKDTO.getAcctServer() != null) {
                            radiusProfileBKDTO.getAcctServer().forEach(radiusAcctServerBKDTO -> {
                                radiusAcctServerBKDTO.setAccountingServerIp(null);
                                radiusAcctServerBKDTO.setAccountingServerPwd(null);
                            });
                        }
                    });
                }
                if (element.getLdapProfiles() != null) {
                    element.getLdapProfiles().forEach(ldapProfileBKDTO -> {
                        ldapProfileBKDTO.setServer(null);
                        ldapProfileBKDTO.setRegularDn(null);
                        ldapProfileBKDTO.setRegularPassword(null);
                    });
                }
                if (element.getLdapProfilesTemplate() != null) {
                    element.getLdapProfilesTemplate().forEach(ldapProfileTemplateBKDTO -> {
                        ldapProfileTemplateBKDTO.setServer(null);
                        ldapProfileTemplateBKDTO.setRegularDn(null);
                        ldapProfileTemplateBKDTO.setRegularPassword(null);
                    });
                }
            }
            wrapper.a(keyEnum.A(), (Object)element);
        }
    }

    private List<LdapProfileTemplateBKDTO> backupLdapProfileTemplates(c omadacId, String siteTemplateId) {
        return this.authenticationMaintRepository.findLdapProfileTemplates(omadacId, siteTemplateId).stream().map(LdapProfileTemplateBKDTO::fromTemplatePO).collect(Collectors.toList());
    }

    private MacAuthTemplateBKDTO backupMacAuthTemplate(c omadacId, String siteTemplateId) {
        return this.apSiteSettingMongoRepository.b(omadacId, siteTemplateId).map(BaseApSiteSettingPO::getMacAuth).map(po -> MacAuthTemplateBKDTO.fromPO(po).setSiteTemplateId(siteTemplateId)).orElse(null);
    }

    private List<RadiusProfileTemplateBKDTO> backupRadiusProfileTemplates(c omadacId, String siteTemplateId) {
        return this.authenticationMaintRepository.findRadiusProfilesTemplates(omadacId, siteTemplateId).stream().map(RadiusProfileTemplateBKDTO::fromTemplatePO).collect(Collectors.toList());
    }

    private Dot1xSettingTemplateBKDTO backupDot1xTemplate(c omadacId, String siteTemplateId) {
        return this.oswSiteSettingMaintMongoRepository.a(omadacId, siteTemplateId).map(BaseOswSiteSettingPO::getDot1x).map(dot1x -> Dot1xSettingTemplateBKDTO.fromPO(dot1x, new d(siteTemplateId))).orElse(null);
    }

    private Dot1xSettingTemplateBKDTO backupApDot1xTemplate(c omadacId, String siteTemplateId) {
        return this.apSiteSettingMongoRepository.b(omadacId, siteTemplateId).map(BaseApSiteSettingPO::getApDot1x).map(dot1x -> Dot1xSettingTemplateBKDTO.fromPO(dot1x, new d(siteTemplateId))).orElse(null);
    }
}

