/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.ap.siteimport;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapsDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ap.dto.ApDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.common.util.F;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.LocationPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApLanPortNetworkInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApLanPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApVoipSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.MeshConfPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.SsidOverridePO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.a;
import com.tplink.smb.omada.manager.port.mongo.device.osg.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.AP)
public class ApSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApSiteImportUnit.class);
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d apMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final a apChannelMaintMongoRepository = a.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c lanNetworkMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.device.olt.b oltMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.olt.b.a();
    private final c osgMaintMongoRepository = c.a();
    private static final String DEFAULT_DIGIT_MAP_PROFILE_ID = "VoIP-DefaultDigitMapProfile-ID";
    private static final ApSiteImportUnit instance = new ApSiteImportUnit();
    private static final int AP_MVLAN_DEFAULT_MODE = 0;

    private ApSiteImportUnit() {
    }

    public static ApSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        Set macsToForget = restoreCacheMap.getOrDefault(com.tplink.smb.omada.backup.api.c.d.D.A(), new HashSet());
        DeviceRestoreInfoMapsDTO deviceRestoreInfoMapsDTO = (DeviceRestoreInfoMapsDTO)restoreCacheMap.computeIfAbsent("deviceOmadacRefer", key -> new DeviceRestoreInfoMapsDTO(new HashMap<String, String>(32)));
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            Map<String, String> mapMap;
            ApPO apPOInDb;
            ApDTO apDTO = (ApDTO)jsonParserWrapper.a(ApDTO.class);
            ApPO apPO = apDTO.getAp();
            if (apPO == null) continue;
            if (F.d((String)omadacId.a())) {
                boolean reachLimitOfSite;
                boolean reachLimitOfOmadac = this.deviceMaintRepository.countDeviceNumber(omadacId.a()) >= (long)b.a((String)omadacId.a());
                boolean bl = reachLimitOfSite = this.deviceMaintRepository.countDeviceNumberOfSite(omadacId.a(), newSiteId.a()) >= (long)b.b((String)omadacId.a());
                if (reachLimitOfOmadac || reachLimitOfSite) {
                    macsToForget.add(apPO.getMac());
                }
            }
            if (OmadacType.y()) {
                if (this.deviceMaintRepository.countDeviceNumber(omadacId.a()) + 4L * this.oltMaintMongoRepository.c(omadacId.a(), DeviceTypeEnum.d.b()) - this.osgMaintMongoRepository.d(omadacId) >= (long)b.s()) {
                    macsToForget.add(apPO.getMac());
                }
            } else if (!OmadacType.s() && this.apMaintMongoRepository.c(omadacId.a(), DeviceTypeEnum.a.b()) >= (long)b.t()) {
                macsToForget.add(apPO.getMac());
            }
            if ((apPOInDb = this.apMaintMongoRepository.b(omadacId.a(), apPO.getMac())) != null) continue;
            WlanGroupPO wlanGroupPO = this.wlanGroupMaintMongoRepository.b(omadacId, newSiteId, apPO.getWlanName());
            if (wlanGroupPO == null) {
                log.warn("WlanGroup {} not exist in omadacId {} site-siteName {}", new Object[]{apPO.getWlanName(), omadacId, newSiteId});
                continue;
            }
            apPO.setWlanId(wlanGroupPO.getId());
            if (!CollectionUtils.isEmpty((Collection)apPO.getSsidOverrides())) {
                List ssidList = this.ssidMaintMongoRepository.a(omadacId, newSiteId, wlanGroupPO.getId());
                if (!CollectionUtils.isEmpty((Collection)ssidList)) {
                    for (SsidOverridePO ssidOverride : apPO.getSsidOverrides()) {
                        String overrideName = ssidOverride.getGlobalSsid();
                        for (SsidPO ssid : ssidList) {
                            if (!ssid.getName().equals(overrideName)) continue;
                            ssidOverride.setIndex(ssid.getEntryId());
                        }
                    }
                } else {
                    apPO.setSsidOverrides(null);
                }
            }
            Map<String, String> lanNetworkMaps = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
            Map<String, String> callBlockingProfileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ay.A());
            Map<String, String> digitMapProfileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ax.A());
            this.handleMvlanNetwork(apPO, omadacId, lanNetworkMaps);
            this.handleApVoipSetting(apPO, callBlockingProfileIdMap, digitMapProfileIdMap);
            this.handleApLanPortSettingNetworkMapped(apPO, lanNetworkMaps);
            this.handleVoipVlanSetting(apPO, omadacId, lanNetworkMaps);
            LocationPO location = apPO.getLocation();
            if (location != null && !CollectionUtils.isEmpty(mapMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.aI.A()))) {
                String mapIdNew = mapMap.get(location.getMapId());
                location.setMapId(mapIdNew);
            }
            apPO.setOmadacId(omadacId.a());
            apPO.setSiteId(newSiteId.a());
            apPO.setId(null);
            this.apMaintMongoRepository.a(apPO);
            if (apDTO.getApChannel() != null) {
                apDTO.getApChannel().setId(null);
                apDTO.getApChannel().setOmadacId(omadacId.a());
                this.apChannelMaintMongoRepository.a(apDTO.getApChannel());
            }
            deviceRestoreInfoMapsDTO.getDeviceControllerIdOmadacMapper().put(apPO.getMac(), apPO.getControllerId());
        }
        this.checkApMeshConf(omadacId.a(), newSiteId.a());
    }

    public void siteTemplateCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }

    private void checkApMeshConf(String omadacId, String siteId) {
        List apPOList = this.apMaintMongoRepository.a(omadacId, siteId, DeviceTypeEnum.a.b());
        if (CollectionUtils.isEmpty((Collection)apPOList)) {
            return;
        }
        for (ApPO apPO : apPOList) {
            if (apPO == null || apPO.getMeshConf() == null) continue;
            this.checkParentAp(omadacId, apPO);
            this.checkChildAp(omadacId, apPO);
            this.apMaintMongoRepository.a(apPO);
        }
    }

    private void checkParentAp(String omadacId, ApPO apPO) {
        MeshConfPO meshConfPO;
        if (!(T.a((String)apPO.getMeshConf().getParentApMac()) || (meshConfPO = this.apMaintMongoRepository.e(omadacId, apPO.getMeshConf().getParentApMac())) != null && !CollectionUtils.isEmpty((Collection)meshConfPO.getChildApMacs()) && meshConfPO.getChildApMacs().contains(apPO.getMac()))) {
            apPO.getMeshConf().setParentApMac(null);
        }
    }

    private void checkChildAp(String omadacId, ApPO apPO) {
        if (!CollectionUtils.isEmpty((Collection)apPO.getMeshConf().getChildApMacs())) {
            for (String childMac : apPO.getMeshConf().getChildApMacs()) {
                ApPO childApPO = this.apMaintMongoRepository.b(omadacId, childMac);
                if (childApPO != null && childApPO.getMeshConf() != null && Objects.equals(childApPO.getMeshConf().getParentApMac(), apPO.getMac())) continue;
                apPO.getMeshConf().getChildApMacs().remove(childMac);
            }
        }
    }

    private void handleMvlanNetwork(ApPO apPO, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, String> lanNetworkMaps) {
        if (apPO.getApMvlanSetting() != null && apPO.getApMvlanSetting().getLanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkMaps)) {
            this.lanNetworkMaintMongoRepository.a(omadacId.a(), lanNetworkMaps.get(apPO.getApMvlanSetting().getLanNetworkId())).ifPresent(lanNetworkPO -> apPO.getApMvlanSetting().setLanNetworkId(lanNetworkPO.getId()));
        }
        if (apPO.getMvlanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkMaps)) {
            this.lanNetworkMaintMongoRepository.a(omadacId.a(), lanNetworkMaps.get(apPO.getMvlanNetworkId())).ifPresent(lanNetworkPO -> apPO.setMvlanNetworkId(lanNetworkPO.getId()));
        }
    }

    private void handleApLanPortSettingNetworkMapped(ApPO ap, Map<String, String> lanNetworkIdMap) {
        if (CollectionUtils.isEmpty((Collection)ap.getLanPortSettings())) {
            return;
        }
        for (ApLanPortSettingPO lanPort : ap.getLanPortSettings()) {
            if (!T.c((String)lanPort.getLocalVlanNetworkId())) {
                lanPort.setLocalVlanNetworkId(lanNetworkIdMap.get(lanPort.getLocalVlanNetworkId()));
                lanPort.setLocalVlanNetworkVlanId(lanPort.getLocalVlanNetworkVlanId());
            }
            if (!CollectionUtils.isEmpty((Collection)lanPort.getTaggedNetworkId())) {
                lanPort.setTaggedNetworkId(this.getNetworkListMapped(lanPort.getTaggedNetworkId(), lanNetworkIdMap));
            }
            if (CollectionUtils.isEmpty((Collection)lanPort.getUntaggedNetworkId())) continue;
            lanPort.setUntaggedNetworkId(this.getNetworkListMapped(lanPort.getUntaggedNetworkId(), lanNetworkIdMap));
        }
    }

    private List<ApLanPortNetworkInfoPO> getNetworkListMapped(List<ApLanPortNetworkInfoPO> networkList, Map<String, String> lanNetworkIdMap) {
        ArrayList<ApLanPortNetworkInfoPO> resultList = new ArrayList<ApLanPortNetworkInfoPO>();
        for (ApLanPortNetworkInfoPO network : networkList) {
            if (T.c((String)network.getNetworkId())) continue;
            String originNetworkId = network.getNetworkId();
            Integer vlanId = network.getVlanId();
            String newNetworkId = lanNetworkIdMap.get(originNetworkId);
            resultList.add(new ApLanPortNetworkInfoPO(newNetworkId, vlanId));
        }
        return resultList;
    }

    private void handleApVoipSetting(ApPO apPO, Map<String, String> callBlockingProfileIdMap, Map<String, String> digitMapProfileIdMap) {
        if (Objects.isNull(apPO.getVoipSetting())) {
            return;
        }
        ApVoipSettingPO apVoipSettingPO = apPO.getVoipSetting();
        if (Boolean.TRUE.equals(apVoipSettingPO.getCallBlockingEnable())) {
            apVoipSettingPO.setCallBlockingProfileId(callBlockingProfileIdMap.get(apVoipSettingPO.getCallBlockingProfileId()));
        }
        if (!T.a((String)apVoipSettingPO.getDigitMapProfileId(), (String)DEFAULT_DIGIT_MAP_PROFILE_ID)) {
            apVoipSettingPO.setDigitMapProfileId(digitMapProfileIdMap.get(apVoipSettingPO.getDigitMapProfileId()));
        }
    }

    public void siteCopyWrite(Object dataObject, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c {
    }

    private void handleVoipVlanSetting(ApPO apPO, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, String> lanNetworkMaps) {
        if (apPO.getVoipVlanSetting() != null && apPO.getVoipVlanSetting().getLanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkMaps)) {
            this.lanNetworkMaintMongoRepository.a(omadacId.a(), lanNetworkMaps.get(apPO.getVoipVlanSetting().getLanNetworkId())).ifPresent(lanNetworkPO -> apPO.getVoipVlanSetting().setLanNetworkId(lanNetworkPO.getId()));
        }
    }
}

