/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.siteconfig.ap.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.OmadacBKDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapForMspDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.DeviceRestoreInfoMapsDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.ap.dto.ApDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.i;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.DevicePO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApChannelPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApLanPortNetworkInfoPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApLanPortSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.ApVoipSettingPO;
import com.tplink.smb.omada.manager.port.mongo.device.ap.MeshConfPO;
import com.tplink.smb.omada.manager.port.mongo.device.n;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.AP)
public class ApRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApRestoreUnitV50000.class);
    private static final ApRestoreUnitV50000 instance = new ApRestoreUnitV50000();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.d apMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.device.ap.a apChannelMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.ap.a.a();
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final n deviceRecordRepository = n.a();
    private final com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService = (com.tplink.smb.omada.manager.device.api.internal.device.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.device.api.internal.device.b.class);
    private static final String REGION_CODE_HONGKONG = "Hong Kong";
    private static final String REGION_HK = "HK";
    private static final String REGION_CODE_RUSSIA = "Russia";
    private static final String REGION_RU = "RU";
    private static final String DEFAULT_DIGIT_MAP_PROFILE_ID = "VoIP-DefaultDigitMapProfile-ID";

    public static ApRestoreUnitV50000 getInstance() {
        return instance;
    }

    private ApRestoreUnitV50000() {
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        boolean lanNetworkInvalid;
        Map lanNetworkIdMap = (Map)restoreCacheMap.get(d.af.A());
        Map siteIdMaps = (Map)restoreCacheMap.get(d.Q.A());
        Map mapIdMap = restoreCacheMap.getOrDefault(d.aI.A(), new HashMap());
        Map wirelessMap = (Map)restoreCacheMap.computeIfAbsent(d.ag.A(), k2 -> new HashMap());
        Map callBlockingProfileIdMap = (Map)restoreCacheMap.computeIfAbsent(d.ay.A(), k2 -> new HashMap());
        Map digitMapProfileIdMap = (Map)restoreCacheMap.computeIfAbsent(d.ax.A(), k2 -> new HashMap());
        boolean siteInvalid = siteIdMaps == null;
        boolean bl = lanNetworkInvalid = lanNetworkIdMap == null;
        if (siteInvalid || lanNetworkInvalid) {
            log.info("V50000 failed to restore ap in omadacId {} because of failed get lanNetworkInfo maps from restorecache. reason: siteIdMaps is null or lanNetworkInfoMaps is null. siteInvalid:{}, lanNetworkInvalid:{}", new Object[]{omadacId, siteInvalid, lanNetworkInvalid});
            throw new com.tplink.smb.omada.backup.api.d.c("Reason: siteIdMaps is null" + siteInvalid + "or lanNetworkInfoMaps is null." + lanNetworkInvalid);
        }
        JsonParser jsonParser = jsonParserWrapper.h();
        jsonParser.nextToken();
        DeviceRestoreInfoMapsDTO deviceRestoreInfoMapsDTO = (DeviceRestoreInfoMapsDTO)restoreCacheMap.computeIfAbsent("deviceOmadacRefer", key -> new DeviceRestoreInfoMapsDTO(new HashMap<String, String>(32)));
        DeviceRestoreInfoMapForMspDTO deviceRestoreInfoMapForMspDTO = (DeviceRestoreInfoMapForMspDTO)restoreCacheMap.computeIfAbsent("deviceOmadacReferMsp", key -> new DeviceRestoreInfoMapForMspDTO(new HashMap<String, Map<String, String>>(16)));
        OmadacBKDTO omadacBKDTO = (OmadacBKDTO)restoreCacheMap.get(d.s.A());
        String oldOmadacId = Optional.ofNullable(omadacBKDTO).map(OmadacBKDTO::getId).orElse(null);
        boolean restoreSelf = T.a((String)oldOmadacId, (String)omadacId.a());
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            String siteId;
            ApDTO apDTO = (ApDTO)jsonParser.readValueAs(ApDTO.class);
            if (Objects.isNull(apDTO) || Objects.isNull(apDTO.getAp())) continue;
            ApPO apPO = apDTO.getAp();
            if (Objects.nonNull(apPO.getLocation())) {
                apPO.getLocation().setMapId((String)mapIdMap.get(apPO.getLocation().getMapId()));
            }
            apPO.setWlanId((String)wirelessMap.get(apPO.getWlanId()));
            this.handleMvlanNetwork(apPO, lanNetworkIdMap);
            apPO.setOmadacId(omadacId.a());
            this.reEncryptHwIdAndOemId(omadacId, apPO);
            this.handleApLanPortSettingNetworkMapped(apPO, lanNetworkIdMap);
            this.handleApVoipSettingMapped(apPO, callBlockingProfileIdMap, digitMapProfileIdMap);
            this.handleVoipVlanSetting(apPO, lanNetworkIdMap);
            if (Objects.nonNull(apPO.getShowModel())) {
                String showModel = apPO.getShowModel();
                if (showModel.contains(REGION_CODE_HONGKONG)) {
                    apPO.setShowModel(showModel.replace(REGION_CODE_HONGKONG, REGION_HK));
                } else if (showModel.contains(REGION_CODE_RUSSIA)) {
                    apPO.setShowModel(showModel.replace(REGION_CODE_RUSSIA, REGION_RU));
                }
            }
            if ((siteId = (String)siteIdMaps.get(apPO.getSiteId())) == null) {
                log.warn("Restoring ap: Cannot find mapped siteId, omadacId={}, ap: {}", (Object)omadacId, (Object)apPO);
                continue;
            }
            apPO.setSiteId(siteId);
            apPO.setId(null);
            if (!restoreSelf) {
                apPO.setRemember(Boolean.valueOf(false));
            }
            if (restoreSelf) {
                if (Boolean.TRUE.equals(apPO.getRemember())) {
                    offlineAddRecordPO = this.deviceRecordRepository.a(new a(apPO.getMac()));
                    if (Objects.isNull(offlineAddRecordPO)) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(apPO.getMac()).c(apPO.getSn()).a(Boolean.valueOf(true)).b());
                    } else if (!Objects.equals(omadacId.a(), offlineAddRecordPO.getOmadacId())) {
                        apPO.setRemember(Boolean.valueOf(false));
                    }
                } else {
                    offlineAddRecordPO = this.deviceRecordRepository.a(omadacId, new a(apPO.getMac()));
                    if (Objects.nonNull(offlineAddRecordPO) && !Boolean.TRUE.equals(apPO.getAddedInAdvance())) {
                        this.deviceInternalApiService.a(i.a().a(omadacId.a()).b(apPO.getMac()).c(apPO.getSn()).a(Boolean.valueOf(false)).b());
                    }
                }
            }
            this.apMaintMongoRepository.a(apPO);
            this.handleApChannel(apDTO.getApChannel(), omadacId);
            deviceRestoreInfoMapsDTO.getDeviceControllerIdOmadacMapper().put(apPO.getMac(), apPO.getControllerId());
            deviceRestoreInfoMapForMspDTO.getDeviceMacControllerIdMaps().computeIfAbsent(omadacId.a(), key -> new HashMap()).put(apPO.getMac(), apPO.getControllerId());
        }
    }

    private void handleApLanPortSettingNetworkMapped(ApPO ap, Map<String, String> lanNetworkIdMap) {
        if (CollectionUtils.isEmpty((Collection)ap.getLanPortSettings())) {
            return;
        }
        for (ApLanPortSettingPO lanPort : ap.getLanPortSettings()) {
            if (!T.c((String)lanPort.getLocalVlanNetworkId())) {
                lanPort.setLocalVlanNetworkId(lanNetworkIdMap.get(lanPort.getLocalVlanNetworkId()));
                lanPort.setLocalVlanNetworkVlanId(lanPort.getLocalVlanNetworkVlanId());
            }
            if (!CollectionUtils.isEmpty((Collection)lanPort.getTaggedNetworkId())) {
                lanPort.setTaggedNetworkId(this.getNetworkListMapped(lanPort.getTaggedNetworkId(), lanNetworkIdMap));
            }
            if (CollectionUtils.isEmpty((Collection)lanPort.getUntaggedNetworkId())) continue;
            lanPort.setUntaggedNetworkId(this.getNetworkListMapped(lanPort.getUntaggedNetworkId(), lanNetworkIdMap));
        }
    }

    private void handleApVoipSettingMapped(ApPO ap, Map<String, String> callBlockingProfileIdMap, Map<String, String> digitMapProfileIdMap) {
        if (Objects.isNull(ap.getVoipSetting())) {
            return;
        }
        ApVoipSettingPO apVoipSettingPO = ap.getVoipSetting();
        if (Boolean.TRUE.equals(apVoipSettingPO.getCallBlockingEnable())) {
            apVoipSettingPO.setCallBlockingProfileId(callBlockingProfileIdMap.get(apVoipSettingPO.getCallBlockingProfileId()));
        }
        if (!T.a((String)apVoipSettingPO.getDigitMapProfileId(), (String)DEFAULT_DIGIT_MAP_PROFILE_ID)) {
            apVoipSettingPO.setDigitMapProfileId(digitMapProfileIdMap.get(apVoipSettingPO.getDigitMapProfileId()));
        }
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        try {
            Map apPOMap = this.apMaintMongoRepository.b(omadacId.a());
            if (CollectionUtils.isEmpty((Map)apPOMap)) {
                return;
            }
            ArrayList<DevicePO> apPOSToSave = new ArrayList<DevicePO>(8);
            for (DevicePO apPO : apPOMap.values()) {
                if (apPO == null || this.getMeshConf(apPO) == null) continue;
                this.checkParentAp(apPO, apPOSToSave, apPOMap);
                this.checkChildAp(apPO, apPOSToSave, apPOMap);
            }
            this.deviceMaintRepository.saveAll(apPOSToSave);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
        }
    }

    private MeshConfPO getMeshConf(DevicePO devicePO) {
        if (devicePO == null) {
            return null;
        }
        if (DeviceTypeEnum.a.c(devicePO.getType())) {
            return ((ApPO)devicePO).getMeshConf();
        }
        if (DeviceTypeEnum.b.c(devicePO.getType())) {
            return ((OsgPO)devicePO).getMeshConf();
        }
        log.warn("wrong device type when get parent mesh config in {} , parent mac {},", (Object)devicePO.getOmadacId(), (Object)com.tplink.smb.omada.common.util.e.a.d((String)devicePO.getMac()));
        return null;
    }

    private List<ApLanPortNetworkInfoPO> getNetworkListMapped(List<ApLanPortNetworkInfoPO> networkList, Map<String, String> lanNetworkIdMap) {
        ArrayList<ApLanPortNetworkInfoPO> resultList = new ArrayList<ApLanPortNetworkInfoPO>();
        for (ApLanPortNetworkInfoPO network : networkList) {
            if (T.c((String)network.getNetworkId())) continue;
            String originNetworkId = network.getNetworkId();
            Integer vlanId = network.getVlanId();
            String newNetworkId = lanNetworkIdMap.get(originNetworkId);
            resultList.add(new ApLanPortNetworkInfoPO(newNetworkId, vlanId));
        }
        return resultList;
    }

    private boolean isMultiVlanNetwork(@Nonnull String networkId) {
        return networkId.contains("_");
    }

    private String jointMultiLanNetworkId(String networkId, Integer vlanId) {
        return networkId + "_" + vlanId;
    }

    private void checkParentAp(DevicePO apPO, List<DevicePO> apPOSToSave, Map<String, DevicePO> apPOMap) {
        DevicePO parentAp;
        MeshConfPO parentMeshConfPO;
        MeshConfPO meshConfPO = this.getMeshConf(apPO);
        if (!(meshConfPO == null || T.a((String)meshConfPO.getParentApMac()) || (parentMeshConfPO = this.getMeshConf(parentAp = apPOMap.get(meshConfPO.getParentApMac()))) != null && !CollectionUtils.isEmpty((Collection)parentMeshConfPO.getChildApMacs()) && parentMeshConfPO.getChildApMacs().contains(apPO.getMac()))) {
            meshConfPO.setParentApMac(null);
            apPOSToSave.add(apPO);
        }
    }

    private void checkChildAp(DevicePO apPO, List<DevicePO> apPOSToSave, Map<String, DevicePO> apPOMap) {
        MeshConfPO meshConfPO = this.getMeshConf(apPO);
        if (meshConfPO != null && !CollectionUtils.isEmpty((Collection)meshConfPO.getChildApMacs())) {
            Iterator it = meshConfPO.getChildApMacs().iterator();
            while (it.hasNext()) {
                String childMac = (String)it.next();
                DevicePO childApPO = apPOMap.get(childMac);
                MeshConfPO childMeshConfPO = this.getMeshConf(childApPO);
                if (childApPO != null && childMeshConfPO != null && Objects.equals(childMeshConfPO.getParentApMac(), apPO.getMac())) continue;
                it.remove();
                apPOSToSave.add(apPO);
            }
        }
    }

    private void handleApChannel(ApChannelPO apChannelPO, c omadacId) {
        if (apChannelPO != null) {
            apChannelPO.setId(null);
            apChannelPO.setOmadacId(omadacId.a());
            this.apChannelMaintMongoRepository.a(apChannelPO);
        }
    }

    private void reEncryptHwIdAndOemId(c omadacId, ApPO apPO) {
        try {
            if (!T.a((String)apPO.getHwId())) {
                String oldEncryptedHwId = apPO.getHwId();
                String hwId = b.f((String)oldEncryptedHwId);
                String newEncryptedHwId = b.d((String)hwId);
                apPO.setHwId(newEncryptedHwId);
            }
            if (!T.a((String)apPO.getOemId())) {
                String oldEncryptedOemId = apPO.getOemId();
                String oemId = b.f((String)oldEncryptedOemId);
                String newEncryptedOemId = b.d((String)oemId);
                apPO.setOemId(newEncryptedOemId);
            }
        }
        catch (com.tplink.smb.omada.common.h.b e2) {
            log.warn("Restoring ap: failed decrypt/encrypt hwId/oemId, omadacId={}, ap: {}", new Object[]{omadacId, apPO, e2});
        }
    }

    private void handleMvlanNetwork(ApPO apPO, Map<String, String> lanNetworkIdMap) {
        if (apPO.getApMvlanSetting() != null && apPO.getApMvlanSetting().getLanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkIdMap)) {
            apPO.getApMvlanSetting().setLanNetworkId(lanNetworkIdMap.get(apPO.getApMvlanSetting().getLanNetworkId()));
        }
        if (apPO.getMvlanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkIdMap)) {
            apPO.setMvlanNetworkId(lanNetworkIdMap.get(apPO.getMvlanNetworkId()));
        }
    }

    private void handleVoipVlanSetting(ApPO apPO, Map<String, String> lanNetworkMaps) {
        if (apPO.getVoipVlanSetting() != null && apPO.getVoipVlanSetting().getLanNetworkId() != null && !CollectionUtils.isEmpty(lanNetworkMaps)) {
            apPO.getVoipVlanSetting().setLanNetworkId(lanNetworkMaps.get(apPO.getVoipVlanSetting().getLanNetworkId()));
        }
    }
}

