/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.user.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.globalconfig.user.restore.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.constant.x;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CloudUsersDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.DistributeSitePrivilegeForDefaultDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ModifyUserByCustomerManagedDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.api.shared.RoleEnumDTO;
import com.tplink.smb.omada.identityaccess.port.mongo.j;
import com.tplink.smb.omada.identityaccess.port.mongo.k;
import com.tplink.smb.omada.identityaccess.port.mongo.tenant.TenantPO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.UserPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50843, b=d.USER_INFO)
public class UserRestoreUnitV50843
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserRestoreUnitV50843.class);
    private static final UserRestoreUnitV50843 instance = new UserRestoreUnitV50843();
    private static final String IS_MASTER_ADMIN = "is_master_admin";
    private final k userOperatorMaintMongoRepository = k.a();
    private final g identityAccessInternalApiService = (g)com.tplink.smb.omada.common.spring.a.b(g.class);
    private final j tenantMaintMongoRepository = j.a();

    private UserRestoreUnitV50843() {
    }

    public void beforeRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        List clearUsers = this.userOperatorMaintMongoRepository.d(omadacId);
        if (!CollectionUtils.isEmpty((Collection)clearUsers)) {
            clearUsers = clearUsers.stream().filter(userPO -> !Objects.equals("master_admin_id", userPO.getRoleId()) && !Objects.equals(RoleEnumDTO.CLOUD_ROOT.getValue(), userPO.getRoleType())).collect(Collectors.toList());
        }
        try {
            if (!CollectionUtils.isEmpty((Collection)clearUsers)) {
                List cloudUserDTOS = clearUsers.stream().map(a::a).collect(Collectors.toList());
                this.identityAccessInternalApiService.a(CloudUsersDTO.builder().cloudUserDTOS(cloudUserDTOS).build());
            }
        }
        catch (Exception e2) {
            log.warn("deleteCloudUsers error. omadacId={}", (Object)omadacId.a(), (Object)e2);
        }
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List restoreUsers = jsonParserWrapper.b(UserPO.class);
        restoreCacheMap.put(d.B.A(), restoreUsers);
    }

    public void restorePreloadCache(c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List usersInDb = this.userOperatorMaintMongoRepository.d(omadacId);
        if (!CollectionUtils.isEmpty((Collection)usersInDb)) {
            usersInDb.forEach(userPO -> {
                userPO.setEmail(userPO.getEmail());
                this.userOperatorMaintMongoRepository.a(userPO);
            });
        }
        List restoreUsers = (List)restoreCacheMap.computeIfAbsent(d.B.A(), k2 -> new HashMap());
        Map roleIdMap = (Map)restoreCacheMap.computeIfAbsent("roleIdMap", k2 -> new HashMap());
        Map tenantIdMap = (Map)restoreCacheMap.computeIfAbsent("tenantIdMap", k2 -> new HashMap());
        Map idpIdMap = (Map)restoreCacheMap.computeIfAbsent("idpIdMap", k2 -> new HashMap());
        HashMap<String, String> userIdMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)restoreUsers)) {
            restoreUsers.forEach(userPO -> {
                String oldId = userPO.getId();
                if (OmadacType.s() && Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), userPO.getUserType())) {
                    return;
                }
                if (Objects.equals(UserTypeEnumDTO.EXTERNAL_USER.getValue(), userPO.getUserType())) {
                    log.debug("restore external user, userName: {}, omadacId={}", (Object)userPO.getName(), (Object)omadacId.a());
                    TenantPO tenantPO2 = new TenantPO().setName(userPO.getName()).setType(Integer.valueOf(UserTypeEnumDTO.EXTERNAL_USER.getValue())).setOmadacs(Collections.singleton(omadacId.a())).setCreatedTime(Calendar.getInstance().getTime());
                    TenantPO nTenantPO = this.tenantMaintMongoRepository.a(tenantPO2);
                    userPO.setOmadacId(omadacId.a());
                    userPO.setId(null);
                    userPO.setRoleId(roleIdMap.getOrDefault(userPO.getRoleId(), "viewer_id"));
                    userPO.setTenantId(nTenantPO.getId());
                    if (StringUtils.isNotBlank((CharSequence)userPO.getIdpId())) {
                        userPO.setIdpId((String)idpIdMap.get(userPO.getIdpId()));
                    }
                    String newId = this.userOperatorMaintMongoRepository.a(userPO).getId();
                    userIdMap.put(oldId, newId);
                    return;
                }
                String tenantId = (String)tenantIdMap.get(userPO.getTenantId());
                if (tenantId == null) {
                    log.error("Find no mapped tenant for user, omadacId={}", (Object)omadacId.a());
                    return;
                }
                if (!this.userOperatorMaintMongoRepository.e(omadacId, tenantId) && !"master_admin_id".equals(userPO.getRoleId())) {
                    userPO.setOmadacId(omadacId.a());
                    userPO.setId(null);
                    userPO.setRoleId(roleIdMap.getOrDefault(userPO.getRoleId(), "viewer_id"));
                    userPO.setTenantId(tenantId);
                    if (StringUtils.isNotBlank((CharSequence)userPO.getIdpId())) {
                        userPO.setIdpId((String)idpIdMap.get(userPO.getIdpId()));
                    }
                    String newId = this.userOperatorMaintMongoRepository.a(userPO).getId();
                    this.tenantMaintMongoRepository.g(tenantId).ifPresent(tenantPO -> {
                        Set omadacs = Optional.ofNullable(tenantPO.getOmadacs()).orElse(new HashSet());
                        omadacs.add(omadacId.a());
                        tenantPO.setOmadacs(omadacs);
                        this.tenantMaintMongoRepository.a(tenantPO);
                    });
                    userIdMap.put(oldId, newId);
                }
            });
        }
        restoreCacheMap.put("userIdMap", userIdMap);
        this.updateParentUserIdAndParentExternalUserId(omadacId, userIdMap);
    }

    private void updateParentUserIdAndParentExternalUserId(c omadacId, Map<String, String> userIdMap) {
        List userPOs = this.userOperatorMaintMongoRepository.a(omadacId);
        userPOs.forEach(userPO -> {
            if (StringUtils.isNotBlank((CharSequence)userPO.getParentExternalUserId())) {
                userPO.setParentExternalUserId((String)userIdMap.get(userPO.getParentExternalUserId()));
            }
            if (StringUtils.isNotBlank((CharSequence)userPO.getParentUserId()) && !Objects.equals(IS_MASTER_ADMIN, userPO.getParentUserId())) {
                userPO.setParentUserId(userIdMap.get(userPO.getParentUserId()) == null ? IS_MASTER_ADMIN : (String)userIdMap.get(userPO.getParentUserId()));
            }
        });
        for (UserPO userPO2 : userPOs) {
            this.userOperatorMaintMongoRepository.a(userPO2);
        }
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        List restoreUsers = (List)restoreCacheMap.get(d.B.A());
        ArrayList bindUsers = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)restoreUsers)) {
            restoreUsers.forEach(userPO -> {
                if (Objects.equals(UserTypeEnumDTO.CLOUD_USER.getValue(), userPO.getUserType()) && Boolean.TRUE.equals(userPO.getVerified()) && !"master_admin_id".equals(userPO.getRoleId())) {
                    bindUsers.add(a.a(userPO));
                }
            });
        }
        if (!bindUsers.isEmpty()) {
            this.identityAccessInternalApiService.c(CloudUsersDTO.builder().omadacId(omadacId.a()).cloudUserDTOS(bindUsers).build());
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        Map siteIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        OperationResponse optRes = this.identityAccessInternalApiService.a(DistributeSitePrivilegeForDefaultDTO.builder().omadacId(omadacId.a()).siteIdMap(siteIdMap).build());
        if (!optRes.success()) {
            log.error("omadacId={} distribute site privilege to user error:{}.", (Object)omadacId.a(), (Object)optRes.getMsg());
            throw new com.tplink.smb.omada.backup.api.d.c("distribute site privilege to user error.");
        }
        Integer pattern = (Integer)restoreCacheMap.getOrDefault("omadac_pattern", com.tplink.smb.omada.common.f.c.c.a());
        String mspId = (String)restoreCacheMap.get("mspId");
        if (mspId != null && Objects.equals(com.tplink.smb.omada.common.f.c.a.a(), pattern)) {
            this.identityAccessInternalApiService.a(ModifyUserByCustomerManagedDTO.builder().operationType(x.c.b()).mspId(mspId).customerId(omadacId.a()).build());
        }
    }

    @Generated
    public static UserRestoreUnitV50843 getInstance() {
        return instance;
    }
}

