/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.user.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.RoleEnumDTO;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.constant.x;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.identityaccess.api.internal.dto.DistributeSitePrivilegeForDefaultDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ModifyUserByCustomerManagedDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.port.mongo.j;
import com.tplink.smb.omada.identityaccess.port.mongo.k;
import com.tplink.smb.omada.identityaccess.port.mongo.tenant.TenantPO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.UserPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.USER_INFO)
public class UserRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserRestoreUnitV50000.class);
    private static final UserRestoreUnitV50000 instance = new UserRestoreUnitV50000();
    private final k userOperatorMaintMongoRepository = k.a();
    private final j tenantMaintMongoRepository = j.a();
    private final g identityAccessInternalApiService = (g)a.b(g.class);

    private UserRestoreUnitV50000() {
    }

    public static UserRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List restoreUsers = jsonParserWrapper.b(UserPO.class);
        restoreCacheMap.put(d.B.A(), restoreUsers);
    }

    public void restorePreloadCache(c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List restoreUsers = (List)restoreCacheMap.get(d.B.A());
        List usersInDb = this.userOperatorMaintMongoRepository.d(omadacId);
        if (!CollectionUtils.isEmpty((Collection)usersInDb)) {
            usersInDb.forEach(userPO -> {
                userPO.setEmail(userPO.getEmail());
                this.userOperatorMaintMongoRepository.a(userPO);
            });
        }
        HashMap userIdMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)restoreUsers)) {
            restoreUsers.forEach(userPO -> {
                Optional userPOOptional;
                Optional tenantPOOptional;
                String oldId = userPO.getId();
                RoleEnumDTO role = RoleEnumDTO.resolve((Integer)userPO.getRoleType());
                if (role == null) {
                    if (userPO.getOriginAccountId() != null) {
                        userPO.setRoleType(Integer.valueOf(RoleEnumDTO.CLOUD_VIEWER.getValue()));
                        role = RoleEnumDTO.CLOUD_VIEWER;
                    } else {
                        userPO.setRoleType(Integer.valueOf(RoleEnumDTO.SYSTEM_VIEWER.getValue()));
                        role = RoleEnumDTO.SYSTEM_VIEWER;
                    }
                }
                if (OmadacType.s() && !role.isCloudUser() || role.isRoot()) {
                    return;
                }
                if (!this.userOperatorMaintMongoRepository.d(omadacId, userPO.getName()) && (userPO.getRoleType().equals(RoleEnumDTO.SYSTEM_VIEWER.getValue()) || userPO.getRoleType().equals(RoleEnumDTO.SYSTEM_ADMIN.getValue()))) {
                    userPO.setOmadacId(omadacId.a());
                    userPO.setId(null);
                    userPO.setUserType(Integer.valueOf(role.isCloudUser() ? UserTypeEnumDTO.CLOUD_USER.getValue() : UserTypeEnumDTO.LOCAL_USER.getValue()));
                    String newId = this.userOperatorMaintMongoRepository.a(userPO).getId();
                    userIdMap.put(oldId, newId);
                } else if ((userPO.getRoleType().equals(RoleEnumDTO.CLOUD_ADMIN.getValue()) || userPO.getRoleType().equals(RoleEnumDTO.CLOUD_VIEWER.getValue())) && (tenantPOOptional = this.tenantMaintMongoRepository.d(userPO.getAccountId())).isPresent() && (userPOOptional = this.userOperatorMaintMongoRepository.b(omadacId, ((TenantPO)tenantPOOptional.get()).getId())).isPresent()) {
                    UserPO nUser = (UserPO)userPOOptional.get();
                    userPO.setId(nUser.getId());
                    userPO.setOmadacId(omadacId.a());
                    userPO.setUserType(Integer.valueOf(role.isCloudUser() ? UserTypeEnumDTO.CLOUD_USER.getValue() : UserTypeEnumDTO.LOCAL_USER.getValue()));
                    String newId = this.userOperatorMaintMongoRepository.a(userPO).getId();
                    userIdMap.put(oldId, newId);
                }
            });
        }
        for (Map.Entry userEntry : userIdMap.entrySet()) {
            List userPOList = this.userOperatorMaintMongoRepository.f(omadacId, (String)userEntry.getKey());
            if (userPOList.isEmpty()) continue;
            userPOList.forEach(userPO -> {
                userPO.setParentUserId((String)userEntry.getValue());
                this.userOperatorMaintMongoRepository.a(userPO);
            });
        }
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        Map siteIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        OperationResponse optRes = this.identityAccessInternalApiService.a(DistributeSitePrivilegeForDefaultDTO.builder().omadacId(omadacId.a()).siteIdMap(siteIdMap).build());
        if (!optRes.success()) {
            log.error("omadacId={} distribute site privilege to user error:{}.", (Object)omadacId.a(), (Object)optRes.getMsg());
            throw new com.tplink.smb.omada.backup.api.d.c("distribute site privilege to user error.");
        }
        Integer pattern = (Integer)restoreCacheMap.getOrDefault("omadac_pattern", com.tplink.smb.omada.common.f.c.c.a());
        String mspId = (String)restoreCacheMap.get("mspId");
        if (mspId != null && Objects.equals(com.tplink.smb.omada.common.f.c.a.a(), pattern)) {
            this.identityAccessInternalApiService.a(ModifyUserByCustomerManagedDTO.builder().operationType(x.c.b()).mspId(mspId).customerId(omadacId.a()).build());
        }
    }
}

