/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.tenant.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.globalconfig.tenant.dto.IamUserBackupDTO;
import com.tplink.smb.omada.backup.core.unit.globalconfig.tenant.dto.TenantBackupDTO;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.iam.a;
import com.tplink.smb.omada.iam.b;
import com.tplink.smb.omada.iam.port.mongo.po.IamUserPO;
import com.tplink.smb.omada.iam.port.mongo.po.UiInterfacePO;
import com.tplink.smb.omada.identityaccess.port.mongo.j;
import com.tplink.smb.omada.identityaccess.port.mongo.tenant.TenantPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51506, b=d.TENANT_INFO)
public class TenantRestoreUnitV51506
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantRestoreUnitV51506.class);
    private static final TenantRestoreUnitV51506 instance = new TenantRestoreUnitV51506();
    private final j tenantMaintMongoRepository = j.a();
    private final b iamUserMaintMongoRepository = b.a();
    private final a iamUiInterfaceMaintMongoRepository = a.a();

    private TenantRestoreUnitV51506() {
    }

    public static TenantRestoreUnitV51506 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List restoreTenants = jsonParserWrapper.b(TenantBackupDTO.class);
        restoreCacheMap.put(d.A.A(), restoreTenants);
    }

    public void restorePreloadCache(c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List restoreTenants = (List)restoreCacheMap.get(d.A.A());
        Map tenantMap = (Map)restoreCacheMap.computeIfAbsent("tenantIdMap", k2 -> new HashMap());
        List tenantPOListInDb = this.tenantMaintMongoRepository.c();
        if (!CollectionUtils.isEmpty((Collection)tenantPOListInDb)) {
            tenantPOListInDb.forEach(tenantPO -> {
                tenantPO.setEmail(tenantPO.getEmail());
                tenantPO.setAccountId(tenantPO.getAccountId());
                this.tenantMaintMongoRepository.a(tenantPO);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)restoreTenants)) {
            restoreTenants.forEach(backupDTO -> {
                TenantPO tenantPO = backupDTO.getTenant();
                String oldId = tenantPO.getId();
                if (Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), tenantPO.getType())) {
                    if (OmadacType.s()) {
                        return;
                    }
                    Optional tenantPOOptional = this.tenantMaintMongoRepository.b(tenantPO.getName(), UserTypeEnumDTO.LOCAL_USER);
                    if (tenantPOOptional.isPresent()) {
                        return;
                    }
                    tenantPO.setOmadacs(new HashSet());
                    TenantPO newTenant = this.tenantMaintMongoRepository.a(tenantPO);
                    String newTenantId = newTenant.getId();
                    IamUserBackupDTO iamUserBackupDTO = backupDTO.getIamUser();
                    this.restoreIamUserInfo(newTenantId, iamUserBackupDTO);
                    tenantMap.putIfAbsent(oldId, newTenantId);
                    return;
                }
                if (Objects.equals(UserTypeEnumDTO.CLOUD_USER.getValue(), tenantPO.getType()) && tenantPO.getAccountId() != null) {
                    Optional tenantPOOptional = this.tenantMaintMongoRepository.d(tenantPO.getAccountId());
                    if (tenantPOOptional.isPresent()) {
                        TenantPO newTenant = (TenantPO)tenantPOOptional.get();
                        newTenant.getOmadacs().add(omadacId.a());
                        this.tenantMaintMongoRepository.a(newTenant);
                        String newTenantId = newTenant.getId();
                        tenantMap.putIfAbsent(oldId, newTenantId);
                        return;
                    }
                    TenantPO newTenant = this.tenantMaintMongoRepository.a(tenantPO);
                    String newTenantId = newTenant.getId();
                    IamUserBackupDTO iamUserBackupDTO = backupDTO.getIamUser();
                    this.restoreIamUserInfo(newTenantId, iamUserBackupDTO);
                    tenantMap.putIfAbsent(oldId, newTenantId);
                    return;
                }
                TenantPO nTenant = this.tenantMaintMongoRepository.a(tenantPO);
                IamUserBackupDTO iamUserBackupDTO = backupDTO.getIamUser();
                this.restoreIamUserInfo(nTenant.getId(), iamUserBackupDTO);
                tenantMap.putIfAbsent(oldId, nTenant.getId());
            });
            restoreCacheMap.put("tenantIdMap", tenantMap);
        }
    }

    private void restoreIamUserInfo(String newTenantId, IamUserBackupDTO iamUserBackupDTO) {
        if (OmadacType.s() || Objects.isNull(iamUserBackupDTO)) {
            return;
        }
        IamUserPO iamUserPO = iamUserBackupDTO.toIamUserPO();
        iamUserPO.setId(newTenantId);
        this.iamUserMaintMongoRepository.a(iamUserPO);
        UiInterfacePO iamUiInterfacePO = iamUserBackupDTO.toIamUiInterfacePO();
        if (!Objects.isNull(iamUiInterfacePO)) {
            iamUiInterfacePO.setImaUserId(newTenantId);
            this.iamUiInterfaceMaintMongoRepository.a(iamUiInterfacePO);
        }
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        List tenantPOS = this.tenantMaintMongoRepository.b();
        if (!CollectionUtils.isEmpty((Collection)tenantPOS)) {
            tenantPOS.forEach(tenantPO -> {
                if (CollectionUtils.isEmpty((Collection)tenantPO.getOmadacs()) && CollectionUtils.isEmpty((Collection)tenantPO.getMsps())) {
                    this.tenantMaintMongoRepository.a(tenantPO.getId());
                    this.iamUserMaintMongoRepository.b(tenantPO.getId());
                    this.iamUiInterfaceMaintMongoRepository.b(tenantPO.getId());
                }
            });
        }
    }
}

