/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.tenant;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.core.unit.globalconfig.tenant.dto.IamUserBackupDTO;
import com.tplink.smb.omada.backup.core.unit.globalconfig.tenant.dto.TenantBackupDTO;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.iam.a;
import com.tplink.smb.omada.iam.b;
import com.tplink.smb.omada.iam.port.mongo.po.IamUserPO;
import com.tplink.smb.omada.iam.port.mongo.po.UiInterfacePO;
import com.tplink.smb.omada.identityaccess.port.mongo.j;
import com.tplink.smb.omada.identityaccess.port.mongo.tenant.TenantPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.a(a=d.TENANT_INFO)
public class TenantBackupUnit
extends com.tplink.smb.omada.backup.api.b.b {
    private static final TenantBackupUnit instance = new TenantBackupUnit();
    private final j tenantMaintMongoRepository = j.a();
    private final b iamUserMaintMongoRepository = b.a();
    private final a iamUiInterfaceMaintMongoRepository = a.a();

    private TenantBackupUnit() {
    }

    public static TenantBackupUnit getInstance() {
        return instance;
    }

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        if (h.e.equals((Object)backupTypeEnum)) {
            return;
        }
        List tenantPOS = this.tenantMaintMongoRepository.a(omadacId);
        if (!CollectionUtils.isEmpty((Collection)tenantPOS)) {
            List backupTenants = tenantPOS.stream().filter(tenantPO -> {
                if (Objects.equals(UserTypeEnumDTO.EXTERNAL_USER.getValue(), tenantPO.getType())) {
                    return false;
                }
                if (!OmadacType.s() && Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), tenantPO.getType())) {
                    return true;
                }
                return !Objects.equals("default_name", tenantPO.getName());
            }).map(tenantPO -> {
                tenantPO.setOmadacs(new HashSet());
                tenantPO.setMsps(new HashSet());
                TenantBackupDTO backupDTO = new TenantBackupDTO();
                backupDTO.setTenant((TenantPO)tenantPO);
                if (!OmadacType.s()) {
                    IamUserPO iamUserPO = this.iamUserMaintMongoRepository.a(tenantPO.getId());
                    UiInterfacePO iamUiInterface = this.iamUiInterfaceMaintMongoRepository.a(tenantPO.getId());
                    IamUserBackupDTO iamUserBackupDTO = IamUserBackupDTO.fromIamUserPO(iamUserPO);
                    if (Objects.nonNull(iamUserBackupDTO) && Objects.nonNull(iamUiInterface)) {
                        iamUserBackupDTO.setUiInterface(iamUiInterface);
                    }
                    backupDTO.setIamUser(iamUserBackupDTO);
                }
                return backupDTO;
            }).collect(Collectors.toList());
            wrapper.a(d.A.A(), backupTenants);
        }
    }
}

