/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.systemsetting.restore;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.globalconfig.systemsetting.dto.CertificateDTO;
import com.tplink.smb.omada.backup.core.unit.globalconfig.systemsetting.dto.SystemSettingDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.b;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.identityaccess.port.mongo.j;
import com.tplink.smb.omada.identityaccess.port.mongo.k;
import com.tplink.smb.omada.identityaccess.port.mongo.tenant.TenantPO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.UserPO;
import com.tplink.smb.omada.manager.cluster.api.internal.dto.UpdateEncryptionKeyDTO;
import com.tplink.smb.omada.manager.cluster.api.internal.z;
import com.tplink.smb.omada.system.port.mongo.SystemSettingPO;
import com.tplink.smb.omada.system.port.mongo.component.certificate.CertificateSettingPO;
import com.tplink.smb.omada.system.port.mongo.component.cloud.CloudDeviceInfoPO;
import com.tplink.smb.omada.system.port.mongo.component.hwc.HwcFirmwarePO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.SYSTEM_SETTING)
public class SystemSettingRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemSettingRestoreUnitV50000.class);
    private static final SystemSettingRestoreUnitV50000 instance = new SystemSettingRestoreUnitV50000();
    private final com.tplink.smb.omada.system.port.mongo.d systemSettingMongoRepository = com.tplink.smb.omada.system.port.mongo.d.a();
    private final FileRepository fileRepository = (FileRepository)a.b(FileRepository.class);
    private final k userOperatorMaintMongoRepository = k.a();
    private final j tenantMaintMongoRepository = j.a();
    private final z restoreOperateClusterInternalApiService = (z)a.b(z.class);

    private SystemSettingRestoreUnitV50000() {
    }

    public static SystemSettingRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        SystemSettingDTO systemSettingDTO = (SystemSettingDTO)jsonParserWrapper.a(SystemSettingDTO.class);
        this.handleUpdateAesKey(omadacId, systemSettingDTO);
        restoreCacheMap.put(d.b.A(), systemSettingDTO);
    }

    public void restorePreloadCache(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        SystemSettingDTO dto = (SystemSettingDTO)restoreCacheMap.get(d.b.A());
        if (!OmadacType.s() && !Objects.isNull(dto)) {
            this.systemSettingMongoRepository.b().ifPresent(systemSettingPO -> {
                Optional.ofNullable(dto.getPbkdf2KeySaltIv()).ifPresent(arg_0 -> ((SystemSettingPO)systemSettingPO).setPbkdf2KeySaltIv(arg_0));
                CertificateSettingPO certificateFilPO = this.handleCertificate(dto.getCertificateFile());
                systemSettingPO.setCertificateSetting(certificateFilPO);
                systemSettingPO.setControllerUpdateNotification(Boolean.valueOf(false));
                this.systemSettingMongoRepository.a(systemSettingPO);
            });
        }
        restoreCacheMap.put("AES_KEY_IN_FILE", Optional.ofNullable(dto).map(SystemSettingDTO::getPbkdf2KeySaltIv).orElse(null));
    }

    private CertificateSettingPO handleCertificate(CertificateDTO dto) {
        if (dto == null) {
            CertificateSettingPO defaultPO = new CertificateSettingPO();
            defaultPO.setEnable(Boolean.valueOf(false));
            defaultPO.setNeedTrans(Boolean.valueOf(true));
            return defaultPO;
        }
        CertificateSettingPO certificateSettingPO = dto.toPO();
        if (Boolean.TRUE.equals(dto.getEnable())) {
            try {
                String content = dto.getFileStream();
                ByteArrayInputStream in = new ByteArrayInputStream(c.b((String)content));
                String fileId = this.fileRepository.saveFile("SYSTEM", null, certificateSettingPO.getCerName(), (InputStream)in);
                if (T.a((String)fileId)) {
                    log.error("Fail to safe certificate file {}", (Object)certificateSettingPO.getCerName());
                    certificateSettingPO.setCerName(null);
                    certificateSettingPO.setKeyPassword(null);
                }
                certificateSettingPO.setCerId(fileId);
            }
            catch (Exception e2) {
                log.warn("Error occurred when saving ssl certificate file", (Throwable)e2);
                certificateSettingPO.setCerId(null);
                certificateSettingPO.setCerName(null);
                certificateSettingPO.setKeyPassword(null);
            }
        } else {
            certificateSettingPO.setCerId(null);
            certificateSettingPO.setCerName(null);
            certificateSettingPO.setKeyPassword(null);
        }
        return certificateSettingPO;
    }

    private void handleUpdateAesKey(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, SystemSettingDTO systemSettingDTO) {
        if (systemSettingDTO == null || systemSettingDTO.getPbkdf2KeySaltIv() == null) {
            return;
        }
        String pdkdf2KeySaltIv = systemSettingDTO.getPbkdf2KeySaltIv();
        DecryptFieldDTO decryptFieldDTO = this.handleBeforeUpdate(omadacId);
        if (com.tplink.smb.omada.common.util.system.a.b()) {
            UpdateEncryptionKeyDTO updateEncryptionKeyDTO = new UpdateEncryptionKeyDTO();
            updateEncryptionKeyDTO.setNewPdkdf2KeySaltIv(pdkdf2KeySaltIv);
            this.restoreOperateClusterInternalApiService.a(updateEncryptionKeyDTO);
        }
        b.h((String)pdkdf2KeySaltIv);
        this.handleAfterUpdate(decryptFieldDTO);
    }

    private DecryptFieldDTO handleBeforeUpdate(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        DecryptFieldDTO decryptFieldDTO = new DecryptFieldDTO();
        this.userOperatorMaintMongoRepository.e(omadacId).ifPresent(user -> {
            decryptFieldDTO.setLocalRoot((UserPO)user);
            decryptFieldDTO.setLocalRootEmail(user.getEmail());
            this.tenantMaintMongoRepository.g(user.getTenantId()).ifPresent(tenantPO -> {
                decryptFieldDTO.setLocalRootTenant((TenantPO)tenantPO);
                decryptFieldDTO.setLocalTenantRootEmail(tenantPO.getEmail());
            });
        });
        this.userOperatorMaintMongoRepository.f(omadacId).ifPresent(user -> {
            decryptFieldDTO.setCloudRoot((UserPO)user);
            decryptFieldDTO.setCloudRootAccountId(user.getAccountId());
            decryptFieldDTO.setCloudRootEmail(user.getEmail());
            this.tenantMaintMongoRepository.g(user.getTenantId()).ifPresent(tenantPO -> {
                decryptFieldDTO.setCloudRootTenant((TenantPO)tenantPO);
                decryptFieldDTO.setTenantRootAccountId(tenantPO.getAccountId());
                decryptFieldDTO.setTenantRootEmail(tenantPO.getEmail());
            });
        });
        this.systemSettingMongoRepository.b().ifPresent(systemSettingPO -> {
            decryptFieldDTO.setSystemSettingPO((SystemSettingPO)systemSettingPO);
            Optional.ofNullable(systemSettingPO.getCloudDeviceInfo()).ifPresent(cloudDeviceInfoPO -> {
                decryptFieldDTO.setCloudDeviceInfoPO((CloudDeviceInfoPO)cloudDeviceInfoPO);
                decryptFieldDTO.setDeviceId(cloudDeviceInfoPO.getDeviceId());
            });
            Optional.ofNullable(systemSettingPO.getHwcFirmware()).ifPresent(hwcFirmwarePO -> {
                decryptFieldDTO.setHwcFirmwarePO((HwcFirmwarePO)hwcFirmwarePO);
                decryptFieldDTO.setHwId(hwcFirmwarePO.getEncryptedHwId());
                decryptFieldDTO.setOemId(hwcFirmwarePO.getEncryptedOemId());
            });
        });
        return decryptFieldDTO;
    }

    private void handleAfterUpdate(DecryptFieldDTO decryptFieldDTO) {
        Optional.ofNullable(decryptFieldDTO.getLocalRoot()).ifPresent(userPO -> {
            userPO.setEmail(decryptFieldDTO.getLocalRootEmail());
            this.userOperatorMaintMongoRepository.a(userPO);
            Optional.ofNullable(decryptFieldDTO.getLocalRootTenant()).ifPresent(tenantPO -> {
                tenantPO.setEmail(decryptFieldDTO.getLocalTenantRootEmail());
                this.tenantMaintMongoRepository.a(tenantPO);
            });
        });
        Optional.ofNullable(decryptFieldDTO.getCloudRoot()).ifPresent(userPO -> {
            userPO.setAccountId(decryptFieldDTO.getCloudRootAccountId());
            userPO.setEmail(decryptFieldDTO.getCloudRootEmail());
            this.userOperatorMaintMongoRepository.a(userPO);
            Optional.ofNullable(decryptFieldDTO.getCloudRootTenant()).ifPresent(tenantPO -> {
                tenantPO.setAccountId(decryptFieldDTO.getTenantRootAccountId());
                tenantPO.setEmail(decryptFieldDTO.getTenantRootEmail());
                this.tenantMaintMongoRepository.a(tenantPO);
            });
        });
        Optional.ofNullable(decryptFieldDTO.getSystemSettingPO()).ifPresent(systemSettingPO -> {
            Optional.ofNullable(decryptFieldDTO.getCloudDeviceInfoPO()).ifPresent(cloudDeviceInfoPO -> {
                cloudDeviceInfoPO.setDeviceId(decryptFieldDTO.getDeviceId());
                systemSettingPO.setCloudDeviceInfo(cloudDeviceInfoPO);
            });
            Optional.ofNullable(decryptFieldDTO.getHwcFirmwarePO()).ifPresent(hwcFirmwarePO -> {
                hwcFirmwarePO.setEncryptedHwId(decryptFieldDTO.getHwId());
                hwcFirmwarePO.setEncryptedOemId(decryptFieldDTO.getOemId());
                systemSettingPO.setHwcFirmware(hwcFirmwarePO);
            });
            this.systemSettingMongoRepository.a(systemSettingPO);
        });
    }

    public void afterClusterRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        Optional systemSetting;
        if (!OmadacType.s() && (systemSetting = this.systemSettingMongoRepository.b()).isPresent()) {
            SystemSettingPO systemSettingPO = (SystemSettingPO)systemSetting.get();
            String pbkdf2KeySaltIv = systemSettingPO.getPbkdf2KeySaltIv();
            b.h((String)pbkdf2KeySaltIv);
        }
    }

    public static class DecryptFieldDTO {
        private UserPO localRoot;
        private String localRootEmail;
        private UserPO cloudRoot;
        private String cloudRootEmail;
        private String cloudRootAccountId;
        private TenantPO localRootTenant;
        private String localTenantRootEmail;
        private TenantPO cloudRootTenant;
        private String tenantRootEmail;
        private String tenantRootAccountId;
        private SystemSettingPO systemSettingPO;
        private CloudDeviceInfoPO cloudDeviceInfoPO;
        private String deviceId;
        private HwcFirmwarePO hwcFirmwarePO;
        private String hwId;
        private String oemId;

        @Generated
        public UserPO getLocalRoot() {
            return this.localRoot;
        }

        @Generated
        public String getLocalRootEmail() {
            return this.localRootEmail;
        }

        @Generated
        public UserPO getCloudRoot() {
            return this.cloudRoot;
        }

        @Generated
        public String getCloudRootEmail() {
            return this.cloudRootEmail;
        }

        @Generated
        public String getCloudRootAccountId() {
            return this.cloudRootAccountId;
        }

        @Generated
        public TenantPO getLocalRootTenant() {
            return this.localRootTenant;
        }

        @Generated
        public String getLocalTenantRootEmail() {
            return this.localTenantRootEmail;
        }

        @Generated
        public TenantPO getCloudRootTenant() {
            return this.cloudRootTenant;
        }

        @Generated
        public String getTenantRootEmail() {
            return this.tenantRootEmail;
        }

        @Generated
        public String getTenantRootAccountId() {
            return this.tenantRootAccountId;
        }

        @Generated
        public SystemSettingPO getSystemSettingPO() {
            return this.systemSettingPO;
        }

        @Generated
        public CloudDeviceInfoPO getCloudDeviceInfoPO() {
            return this.cloudDeviceInfoPO;
        }

        @Generated
        public String getDeviceId() {
            return this.deviceId;
        }

        @Generated
        public HwcFirmwarePO getHwcFirmwarePO() {
            return this.hwcFirmwarePO;
        }

        @Generated
        public String getHwId() {
            return this.hwId;
        }

        @Generated
        public String getOemId() {
            return this.oemId;
        }

        @Generated
        public void setLocalRoot(UserPO localRoot) {
            this.localRoot = localRoot;
        }

        @Generated
        public void setLocalRootEmail(String localRootEmail) {
            this.localRootEmail = localRootEmail;
        }

        @Generated
        public void setCloudRoot(UserPO cloudRoot) {
            this.cloudRoot = cloudRoot;
        }

        @Generated
        public void setCloudRootEmail(String cloudRootEmail) {
            this.cloudRootEmail = cloudRootEmail;
        }

        @Generated
        public void setCloudRootAccountId(String cloudRootAccountId) {
            this.cloudRootAccountId = cloudRootAccountId;
        }

        @Generated
        public void setLocalRootTenant(TenantPO localRootTenant) {
            this.localRootTenant = localRootTenant;
        }

        @Generated
        public void setLocalTenantRootEmail(String localTenantRootEmail) {
            this.localTenantRootEmail = localTenantRootEmail;
        }

        @Generated
        public void setCloudRootTenant(TenantPO cloudRootTenant) {
            this.cloudRootTenant = cloudRootTenant;
        }

        @Generated
        public void setTenantRootEmail(String tenantRootEmail) {
            this.tenantRootEmail = tenantRootEmail;
        }

        @Generated
        public void setTenantRootAccountId(String tenantRootAccountId) {
            this.tenantRootAccountId = tenantRootAccountId;
        }

        @Generated
        public void setSystemSettingPO(SystemSettingPO systemSettingPO) {
            this.systemSettingPO = systemSettingPO;
        }

        @Generated
        public void setCloudDeviceInfoPO(CloudDeviceInfoPO cloudDeviceInfoPO) {
            this.cloudDeviceInfoPO = cloudDeviceInfoPO;
        }

        @Generated
        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Generated
        public void setHwcFirmwarePO(HwcFirmwarePO hwcFirmwarePO) {
            this.hwcFirmwarePO = hwcFirmwarePO;
        }

        @Generated
        public void setHwId(String hwId) {
            this.hwId = hwId;
        }

        @Generated
        public void setOemId(String oemId) {
            this.oemId = oemId;
        }

        @Generated
        public String toString() {
            return "SystemSettingRestoreUnitV50000.DecryptFieldDTO(localRoot=" + this.getLocalRoot() + ", localRootEmail=" + this.getLocalRootEmail() + ", cloudRoot=" + this.getCloudRoot() + ", cloudRootEmail=" + this.getCloudRootEmail() + ", cloudRootAccountId=" + this.getCloudRootAccountId() + ", localRootTenant=" + this.getLocalRootTenant() + ", localTenantRootEmail=" + this.getLocalTenantRootEmail() + ", cloudRootTenant=" + this.getCloudRootTenant() + ", tenantRootEmail=" + this.getTenantRootEmail() + ", tenantRootAccountId=" + this.getTenantRootAccountId() + ", systemSettingPO=" + this.getSystemSettingPO() + ", cloudDeviceInfoPO=" + this.getCloudDeviceInfoPO() + ", deviceId=" + this.getDeviceId() + ", hwcFirmwarePO=" + this.getHwcFirmwarePO() + ", hwId=" + this.getHwId() + ", oemId=" + this.getOemId() + ")";
        }
    }
}

