/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.radiusserver;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.globalconfig.radiusserver.dto.RadiusServerDTO;
import com.tplink.smb.omada.client.port.mongo.omada.RadiusServerMaintRepository;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.common.util.system.b;
import com.tplink.smb.omada.identityaccess.port.mongo.g;
import com.tplink.smb.omada.identityaccess.port.mongo.omadac.OmadacPO;
import com.tplink.smb.omada.judgement.a.e;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.RadiusServerTypeDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.BuiltInRadiusCheckResultPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.RadiusFunctionResultPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.RadiusServerCertificatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.radiusserver.RadiusServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.auth.AuthenticationMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.RadiusProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.authentication.radiusprofile.embed.RadiusAuthServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.OswSiteSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.component.osw.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.server.SslVpnServerPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.portal.port.mongo.omada.portal.PortalMaintRepository;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V514300, b=d.RADIUS_SERVER_SETTING)
public class RadiusServerRestoreUnitV514300
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RadiusServerRestoreUnitV514300.class);
    private final RadiusServerMaintRepository radiusServerMaintRepository = RadiusServerMaintRepository.getInstance();
    private final AuthenticationMaintRepository authenticationMaintRepository = AuthenticationMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.configuration.api.internal.omadac.c radiusServerInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.omadac.c)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.configuration.api.internal.omadac.c.class);
    private final g omadacMaintMongoRepository = g.a();
    private final FileRepository fileRepository = (FileRepository)com.tplink.smb.omada.common.spring.a.b(FileRepository.class);
    private static final RadiusServerRestoreUnitV514300 instance = new RadiusServerRestoreUnitV514300();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d apSiteSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.component.ap.d.a();
    private final a oswSiteSettingMaintMongoRepository = a.a();
    private final PortalMaintRepository portalMaintRepository = PortalMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.e sslVpnServerMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.sslvpn.e.a();
    private final e judgeService = (e)com.tplink.smb.omada.common.spring.a.b(e.class);
    private static final int DEFAULT_AUTH_PORT = 1812;
    private static final int DEFAULT_ACCT_PORT = 1813;
    private static final String DEFAULT_OMADAC_ID = "Default";
    private static final String DEFAULT_SITE_ID = "Default";
    private static final String BUILT_IN_RADIUS_PROFILE_NAME = "Built-in Radius Profile";
    private static final int SERVER_ADDRESS_TYPE_CUSTOM = 1;

    public static RadiusServerRestoreUnitV514300 getInstance() {
        return instance;
    }

    private RadiusServerRestoreUnitV514300() {
    }

    public void beforeRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Optional omadac = this.omadacMaintMongoRepository.a(omadacId);
        if (!omadac.isPresent()) {
            return;
        }
        if (Objects.equals(((OmadacPO)omadac.get()).getPattern(), com.tplink.smb.omada.common.f.c.a.a())) {
            jsonParserWrapper.a(RadiusServerDTO.class);
            return;
        }
        RadiusServerDTO radiusServerDTO = (RadiusServerDTO)jsonParserWrapper.a(RadiusServerDTO.class);
        if (radiusServerDTO == null) {
            return;
        }
        RadiusServerPO radiusServerPO = radiusServerDTO.getRadiusServerPO();
        if (radiusServerPO == null) {
            return;
        }
        if (!T.a((String)radiusServerDTO.getCertFileContent()) && !Objects.isNull(radiusServerPO.getRadiusServerCertificate()) && (radiusServerPO = this.handleCertificate(radiusServerDTO.getCertFileContent(), radiusServerPO)) == null) {
            return;
        }
        radiusServerPO.setOmadacId(omadacId.a());
        radiusServerPO.setId(null);
        this.radiusServerMaintRepository.save(radiusServerPO);
        if (this.radiusServerInternalApiService.b() || this.judgeService.a(omadacId.a(), "delete_build_in_radius_oc200")) {
            if (!this.authenticationMaintRepository.builtInProfileExist()) {
                RadiusProfilePO radiusProfilePO = this.buildBuiltInRadiusProfile(radiusServerPO);
                this.authenticationMaintRepository.save(radiusProfilePO);
            } else {
                RadiusProfilePO existed = this.authenticationMaintRepository.findBuiltInProfile();
                RadiusProfilePO radiusProfilePO = this.buildBuiltInRadiusProfile(radiusServerPO);
                radiusProfilePO.setId(existed.getId());
                this.authenticationMaintRepository.save(radiusProfilePO);
            }
        } else {
            this.authenticationMaintRepository.deleteBuiltInProfile();
        }
        this.radiusServerInternalApiService.b(RadiusServerTypeDTO.ACCESS);
        this.radiusServerInternalApiService.b(RadiusServerTypeDTO.ACCOUNTING);
        if (!Boolean.TRUE.equals(radiusServerPO.getEnable()) || radiusServerPO.getSecret() == null) {
            return;
        }
        this.radiusServerInternalApiService.a(Optional.ofNullable(radiusServerPO.getAuthPort()).orElse(1812), Integer.valueOf(1813), radiusServerPO.getSecret());
        this.radiusServerInternalApiService.a(RadiusServerTypeDTO.ACCESS);
        if (Boolean.TRUE.equals(radiusServerPO.getEnable())) {
            this.radiusServerInternalApiService.c();
        }
    }

    public RadiusProfilePO buildBuiltInRadiusProfile(RadiusServerPO radiusServer) {
        List hosts;
        RadiusProfilePO radiusProfile = new RadiusProfilePO();
        String hostIp = Objects.equals(radiusServer.getServerAddressType(), 1) ? radiusServer.getCustomAddress() : (CollectionUtils.isEmpty((Collection)(hosts = b.d())) ? "0.0.0.0" : (String)hosts.get(0));
        RadiusAuthServerPO radiusAuthServer = new RadiusAuthServerPO();
        radiusAuthServer.setRadiusPort(radiusServer.getAuthPort());
        radiusAuthServer.setRadiusPwd(radiusServer.getSecret());
        radiusAuthServer.setRadiusServerIp(hostIp);
        radiusProfile.setOmadacId("Default");
        radiusProfile.setSiteId("Default");
        radiusProfile.setBuiltInServer(Boolean.valueOf(true));
        radiusProfile.setBuiltInServerSecret(radiusServer.getSecret());
        radiusProfile.setTunnelReplyEnable(radiusServer.getTunnelReplyEnable());
        radiusProfile.setWirelessVlanAssignment(radiusServer.getTunnelReplyEnable());
        radiusProfile.setServerEnable(Boolean.valueOf(Boolean.TRUE.equals(radiusServer.getEnable())));
        radiusProfile.setName(BUILT_IN_RADIUS_PROFILE_NAME);
        radiusProfile.setAuthServer(Collections.singletonList(radiusAuthServer));
        radiusProfile.setRadiusAccountingEnable(Boolean.valueOf(false));
        radiusProfile.setInterimUpdateEnable(Boolean.valueOf(false));
        radiusProfile.setInterimUpdateInterval(null);
        radiusProfile.setAcctServer(null);
        radiusProfile.setCoaEnable(Boolean.valueOf(false));
        radiusProfile.setIpType(radiusServer.getServerAddressType());
        return radiusProfile;
    }

    private RadiusServerPO handleCertificate(String fileContent, RadiusServerPO radiusServerPO) {
        RadiusServerPO radiusServerPO2;
        ByteArrayInputStream in = new ByteArrayInputStream(c.b((String)fileContent));
        try {
            RadiusServerCertificatePO radiusServerCertificate = radiusServerPO.getRadiusServerCertificate();
            String fileId = this.fileRepository.saveFile("SYSTEM", null, radiusServerCertificate.getCerName(), (InputStream)in);
            if (T.a((String)fileId)) {
                log.error("Fail to save radius server certificate file {}", (Object)radiusServerPO.getRadiusServerCertificate().getCerName());
                radiusServerCertificate = null;
            } else {
                radiusServerCertificate.setCerId(fileId);
            }
            radiusServerPO.setRadiusServerCertificate(radiusServerCertificate);
            radiusServerPO2 = radiusServerPO;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                log.warn(e2.getMessage(), (Throwable)e2);
                return null;
            }
        }
        ((InputStream)in).close();
        return radiusServerPO2;
    }

    public void afterCompatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        if (!this.judgeService.a(omadacId.a(), "delete_build_in_radius_oc200")) {
            return;
        }
        RadiusProfilePO builtInRadiusProfile = this.authenticationMaintRepository.findBuiltInProfile();
        if (builtInRadiusProfile == null) {
            return;
        }
        builtInRadiusProfile.setServerEnable(Boolean.valueOf(false));
        this.authenticationMaintRepository.save(builtInRadiusProfile);
        String builtInRadiusProfileId = builtInRadiusProfile.getId();
        BuiltInRadiusCheckResultPO builtInRadiusCheckResult = this.authenticationMaintRepository.findBuiltInRadiusCheckResult();
        builtInRadiusCheckResult = BuiltInRadiusCheckResultPO.builder().id(builtInRadiusCheckResult == null ? null : builtInRadiusCheckResult.getId()).result(new HashMap()).build();
        Map siteFunctionMap = builtInRadiusCheckResult.getResult().computeIfAbsent(omadacId.a(), v2 -> new HashMap());
        List ssids = this.ssidMaintMongoRepository.a(omadacId, Integer.valueOf(2), x.a.b());
        for (Object ssid : ssids) {
            if (ssid.getWpaSetting() == null || !Objects.equals(ssid.getWpaSetting().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            RadiusFunctionResultPO functionResult = siteFunctionMap.computeIfAbsent(((SsidPO)ssid).getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            if (functionResult.getWpaeSsid() == null) {
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(ssid.getId());
                functionResult.setWpaeSsid(idSet);
                continue;
            }
            functionResult.getWpaeSsid().add(ssid.getId());
        }
        List apSiteSettings = this.apSiteSettingMaintMongoRepository.a(omadacId);
        for (Object apSiteSetting : apSiteSettings) {
            RadiusFunctionResultPO functionResult;
            if (apSiteSetting.getMacAuth() != null && Boolean.TRUE.equals(apSiteSetting.getMacAuth().getEnable()) && Objects.equals(apSiteSetting.getMacAuth().getRadiusProfileId(), builtInRadiusProfileId)) {
                functionResult = siteFunctionMap.computeIfAbsent(apSiteSetting.getSiteId(), v2 -> new RadiusFunctionResultPO());
                functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
                functionResult.setMacAuthId(apSiteSetting.getId());
            }
            if (apSiteSetting.getApDot1x() == null || !Boolean.TRUE.equals(apSiteSetting.getApDot1x().getEnable()) || !Objects.equals(apSiteSetting.getApDot1x().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            functionResult = siteFunctionMap.computeIfAbsent(apSiteSetting.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            functionResult.setApDot1xId(apSiteSetting.getId());
        }
        List portals = this.portalMaintRepository.findAllPortals(omadacId);
        for (Object portal : portals) {
            HashSet<String> idSet;
            RadiusFunctionResultPO functionResult;
            if (!Boolean.TRUE.equals(portal.getEnable())) continue;
            if (Objects.equals(portal.getAuthType(), 2) && portal.getExternalRadius() != null && Objects.equals(portal.getExternalRadius().getRadiusProfileId(), builtInRadiusProfileId)) {
                functionResult = siteFunctionMap.computeIfAbsent(portal.getSiteId(), v2 -> new RadiusFunctionResultPO());
                functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
                if (functionResult.getPortalId() == null) {
                    idSet = new HashSet<String>();
                    idSet.add(portal.getId());
                    functionResult.setPortalId(idSet);
                } else {
                    functionResult.getPortalId().add(portal.getId());
                }
            }
            if (!Objects.equals(portal.getAuthType(), 11) || portal.getHotspot() == null || portal.getHotspot().getEnabledTypes() == null || !portal.getHotspot().getEnabledTypes().contains(8) || portal.getHotspotRadius() == null || !Objects.equals(portal.getHotspotRadius().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            functionResult = siteFunctionMap.computeIfAbsent(portal.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            if (functionResult.getPortalId() == null) {
                idSet = new HashSet();
                idSet.add(portal.getId());
                functionResult.setPortalId(idSet);
                continue;
            }
            functionResult.getPortalId().add(portal.getId());
        }
        List oswSiteSettings = this.oswSiteSettingMaintMongoRepository.a(omadacId);
        for (OswSiteSettingPO oswSiteSetting : oswSiteSettings) {
            if (oswSiteSetting.getDot1x() == null || !Boolean.TRUE.equals(oswSiteSetting.getDot1x().getEnable()) || !Objects.equals(oswSiteSetting.getDot1x().getRadiusProfileId(), builtInRadiusProfileId)) continue;
            RadiusFunctionResultPO functionResult = siteFunctionMap.computeIfAbsent(oswSiteSetting.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            functionResult.setOswDot1xId(oswSiteSetting.getId());
        }
        List sslVpnServers = this.sslVpnServerMaintMongoRepository.a(omadacId);
        for (SslVpnServerPO sslVpnServer : sslVpnServers) {
            if (sslVpnServer.getRadiusSetting() == null || !Boolean.TRUE.equals(sslVpnServer.getStatus()) || !Objects.equals(sslVpnServer.getAuthType(), 1) || !Objects.equals(sslVpnServer.getRadiusSetting().getRadiusProfile(), builtInRadiusProfileId)) continue;
            RadiusFunctionResultPO functionResult = siteFunctionMap.computeIfAbsent(sslVpnServer.getSiteId(), v2 -> new RadiusFunctionResultPO());
            functionResult.setBuiltInRadiusProfileId(builtInRadiusProfileId);
            functionResult.setSslVpnId(sslVpnServer.getId());
        }
        this.authenticationMaintRepository.save(builtInRadiusCheckResult);
    }
}

