/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.g;
import com.tplink.smb.omada.backup.core.d.d;
import com.tplink.smb.omada.backup.core.restore.dto.MigrationCheckResultDTO;
import com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.OmadacBKDTO;
import com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.a;
import com.tplink.smb.omada.client.api.internal.h;
import com.tplink.smb.omada.client.port.mongo.omada.OmadacClientSettingMaintRepository;
import com.tplink.smb.omada.client.port.mongo.omada.omadac.OmadacClientSettingPO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.w;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.global.common.dto.DstDTO;
import com.tplink.smb.omada.global.common.dto.DstTimeDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.CentralIdDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.EditGlobalSettingsDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.GlobalCommonSettingDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.IPAccessRuleStatusDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.UserInterfaceDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.maintenance.domain.model.e.b;
import com.tplink.smb.omada.maintenance.domain.model.f.e;
import com.tplink.smb.omada.manager.c.y;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.GeneralSettingDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.webui.PrivateLabelingPO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=com.tplink.smb.omada.backup.api.c.l.V10001000, b=com.tplink.smb.omada.backup.api.c.d.OMADAC_SETTING)
public class OmadacSettingRestoreUnitV10001000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadacSettingRestoreUnitV10001000.class);
    private static final OmadacSettingRestoreUnitV10001000 instance = new OmadacSettingRestoreUnitV10001000();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c omadacMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c.a();
    private final OmadacClientSettingMaintRepository omadacClientSettingMaintRepository = OmadacClientSettingMaintRepository.getInstance();
    private final b maintenanceOmadacSettingRepository = (b)com.tplink.smb.omada.common.spring.a.b(b.class);
    private final com.tplink.smb.omada.manager.configuration.api.internal.omadac.b omadacInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.omadac.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.configuration.api.internal.omadac.b.class);
    private final h omadacClientInternalApiService = (h)com.tplink.smb.omada.common.spring.a.b(h.class);
    private final l identityOmadacInternalApiService = (l)com.tplink.smb.omada.common.spring.a.b(l.class);
    private final FileRepository fileRepository = (FileRepository)com.tplink.smb.omada.common.spring.a.b(FileRepository.class);
    private final com.tplink.smb.omada.global.subsystem.api.internal.c globalSettingInternalApiService = (com.tplink.smb.omada.global.subsystem.api.internal.c)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.global.subsystem.api.internal.c.class);
    private final com.tplink.smb.omada.global.subsystem.api.internal.d ipAccessRuleInternalApiService = (com.tplink.smb.omada.global.subsystem.api.internal.d)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.global.subsystem.api.internal.d.class);
    private final d controllerMigrateCheckUtils = (d)com.tplink.smb.omada.common.spring.a.b(d.class);

    private OmadacSettingRestoreUnitV10001000() {
    }

    public static OmadacSettingRestoreUnitV10001000 getInstance() {
        return instance;
    }

    public void beforeRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
    }

    public void restorePreloadCache(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        OperationResponse response;
        com.tplink.smb.omada.dispatcher.common.access.OperationResponse updateIpRuleStatus;
        com.tplink.smb.omada.dispatcher.common.access.OperationResponse uiInRes;
        OmadacBKDTO omadacBKDTO = (OmadacBKDTO)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.s.A());
        if (omadacBKDTO == null) {
            log.debug("No OmadacBKDTO exists, current omadacId is {}.", (Object)omadacId);
            return;
        }
        restoreCacheMap.put("omadacId", omadacBKDTO.getId());
        String restoreLevel = (String)restoreCacheMap.get("restore_level");
        Integer pattern = (Integer)restoreCacheMap.get("omadac_pattern");
        OmadacPO omadacPO = a.b(omadacBKDTO);
        if (Objects.equals(g.c.a(), restoreLevel)) {
            Map customerIdMap = (Map)restoreCacheMap.computeIfAbsent("customerIdMap", k2 -> new HashMap());
            customerIdMap.put(omadacBKDTO.getId(), omadacId.a());
            restoreCacheMap.put("customerIdMap", customerIdMap);
            omadacPO.setPattern(Integer.valueOf(com.tplink.smb.omada.common.f.c.a.a()));
        }
        if (omadacPO.getUiInterface().getControllerNotification() == null) {
            omadacPO.getUiInterface().setControllerNotification(Boolean.valueOf(true));
        }
        if (omadacPO.getUiInterface().getDevicesNotification() == null) {
            omadacPO.getUiInterface().setDevicesNotification(Boolean.valueOf(true));
        }
        if (omadacPO.getUiInterface().getLanguage() == null) {
            omadacPO.getUiInterface().setLanguage(com.tplink.smb.omada.manager.c.l.a());
        }
        if (omadacPO.getUiInterface().getTheme() == null) {
            omadacPO.getUiInterface().setTheme(y.b());
        }
        OmadacClientSettingPO omadacClientSettingPO = a.a(omadacBKDTO);
        omadacPO.setId(omadacId.a());
        omadacPO.setStartTime(this.omadacMongoRepository.a(omadacId).map(OmadacPO::getStartTime).orElse(System.currentTimeMillis()));
        String category = Optional.ofNullable(restoreCacheMap.get("omadaCategory")).orElse(com.tplink.smb.omada.common.f.b.d.a()).toString();
        log.info("OmadacSettingRestore preloadCache category:{}, omadac:{}", (Object)category, (Object)omadacId);
        omadacPO.setCategory(category);
        omadacPO.setPattern(Integer.valueOf(com.tplink.smb.omada.common.f.c.c.a(com.tplink.smb.omada.common.f.c.a((Integer)pattern)) ? com.tplink.smb.omada.common.f.c.c.a() : com.tplink.smb.omada.common.f.c.a.a()));
        if (Objects.equals(com.tplink.smb.omada.common.f.c.a.a(), omadacPO.getPattern())) {
            String mspId = (String)restoreCacheMap.get("mspId");
            omadacPO.setMspId(mspId);
            Boolean existName = this.omadacMongoRepository.a(new com.tplink.smb.omada.maintenance.common.b.a.a.c(mspId), omadacPO.getName());
            if (Boolean.TRUE.equals(existName)) {
                omadacPO.setName(omadacPO.getName() + "_" + this.getCurrentTimeStamp());
            }
        }
        Integer orgType = (Integer)restoreCacheMap.get("organization_type");
        if (OmadacType.s()) {
            omadacPO.setInitializationInfo(omadacPO.getInitializationInfo().setConfigured(Boolean.valueOf(false)));
            if (orgType == null) {
                orgType = w.b.a();
            }
            omadacPO.setOrgType(orgType);
        }
        this.omadacMongoRepository.a(omadacPO);
        com.tplink.smb.omada.dispatcher.common.access.OperationResponse globalResponse = this.globalSettingInternalApiService.a(EditGlobalSettingsDTO.builder().centralId(omadacId.a()).orgName(omadacBKDTO.getName()).region(omadacBKDTO.getRegion()).type(orgType).timeZone(omadacBKDTO.getTimeZone()).dst(omadacBKDTO.getDst() == null ? DstDTO.buildDefault() : new DstDTO().setEnable(omadacBKDTO.getDst().getEnable()).setMode(omadacBKDTO.getDst().getMode()).setStart((DstTimeDTO)Optional.ofNullable(omadacBKDTO.getDst().getStart()).map(a::a).orElse(null)).setEnd((DstTimeDTO)Optional.ofNullable(omadacBKDTO.getDst().getEnd()).map(a::a).orElse(null)).setOffset(omadacBKDTO.getDst().getOffset())).orgCategory(category).build());
        if (!globalResponse.success()) {
            log.error("Update global setting error, msg={}, omadacId={}", (Object)globalResponse.getMsg(), (Object)omadacId);
        }
        if (!(uiInRes = this.globalSettingInternalApiService.a(UserInterfaceDTO.builder().centralId(omadacId.a()).name(omadacBKDTO.getName()).build())).success()) {
            log.error("Update global setting error, msg={}, omadacId={}", (Object)globalResponse.getMsg(), (Object)omadacId);
        }
        if (!(updateIpRuleStatus = this.ipAccessRuleInternalApiService.a(IPAccessRuleStatusDTO.builder().centralId(omadacId.a()).enable(Boolean.FALSE).userIp("127.0.0.1").build())).success()) {
            log.error("Update global setting ip access error, msg={}, omadacId={}", (Object)updateIpRuleStatus.getMsg(), (Object)omadacId.a());
        }
        GeneralSettingDTO dto = GeneralSettingDTO.builder().omadacId(omadacPO.getId()).timeZone(omadacPO.getTimeZone()).omadacName(omadacPO.getName()).pattern(omadacPO.getPattern()).enableMfa(Boolean.valueOf(Boolean.TRUE.equals(omadacBKDTO.getEnableMFA()))).enableIpAccessRule(Boolean.FALSE).build();
        if (Objects.equals(g.c.a(), restoreLevel)) {
            dto.setMspId((String)restoreCacheMap.get("mspId"));
            dto.setPattern(Integer.valueOf(com.tplink.smb.omada.common.f.c.a.a()));
        }
        if (!(response = this.omadacInternalApiService.a(dto)).success()) {
            log.warn("failed to modify omada cloud general setting on restore. omadac:{}", (Object)omadacPO.getId());
        }
        omadacClientSettingPO.setOmadacId(omadacId.a());
        this.omadacClientSettingMaintRepository.save(omadacClientSettingPO);
        com.tplink.smb.omada.maintenance.domain.model.f.b dataRetentionSetting = Optional.ofNullable(omadacBKDTO.getHistoryRetention()).map(a::a).orElse(com.tplink.smb.omada.maintenance.domain.model.f.b.a());
        dataRetentionSetting = com.tplink.smb.omada.maintenance.domain.model.f.b.b((com.tplink.smb.omada.maintenance.domain.model.f.b)dataRetentionSetting);
        restoreCacheMap.put("retention", dataRetentionSetting);
        Optional settingOptional = this.maintenanceOmadacSettingRepository.a(omadacId.a());
        e setting = new e();
        if (settingOptional.isPresent()) {
            setting.a(((e)settingOptional.get()).a());
            setting.a(((e)settingOptional.get()).f());
            setting.a(((e)settingOptional.get()).h());
        }
        if (pattern != null) {
            com.tplink.smb.omada.common.f.c omadacPattern = com.tplink.smb.omada.common.f.c.a((Integer)pattern);
            if (com.tplink.smb.omada.common.f.c.a.a(omadacPattern)) {
                if (Objects.equals(g.c.a(), restoreLevel)) {
                    dataRetentionSetting.a(Optional.ofNullable(dataRetentionSetting.h()).orElse(true));
                } else if (Objects.equals(g.a.a(), restoreLevel) && settingOptional.isPresent()) {
                    this.handleCustomerRetentionFromControllerLevel((e)settingOptional.get(), dataRetentionSetting);
                }
            } else if (com.tplink.smb.omada.common.f.c.c.a(omadacPattern)) {
                dataRetentionSetting.a(null);
            }
        }
        this.maintenanceOmadacSettingRepository.a(setting.b(omadacId.a()).a(dataRetentionSetting));
        this.omadacClientInternalApiService.d(omadacId.a());
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        jsonParserWrapper.c();
        jsonParserWrapper.c();
        OmadacBKDTO omadacBKDTO = (OmadacBKDTO)jsonParserWrapper.a(OmadacBKDTO.class);
        String controllerNameInFile = omadacBKDTO.getName();
        String controllerIdInFile = omadacBKDTO.getId();
        String currentControllerName = null;
        com.tplink.smb.omada.dispatcher.common.access.OperationResponse globalRes = this.globalSettingInternalApiService.b(CentralIdDTO.builder().id(omadacId.a()).build());
        if (globalRes.success() && globalRes.getResult() != null && ((GlobalCommonSettingDTO)globalRes.getResult()).getName() != null) {
            log.info("found global setting and  use old name. omadacId:{}", (Object)omadacId.a());
            omadacBKDTO.setName(((GlobalCommonSettingDTO)globalRes.getResult()).getName());
            currentControllerName = ((GlobalCommonSettingDTO)globalRes.getResult()).getName();
        }
        if (!omadacId.a().equals(controllerIdInFile)) {
            MigrationCheckResultDTO migrationCheckResultDTO = new MigrationCheckResultDTO();
            if (!this.controllerMigrateCheckUtils.a(omadacId.a(), currentControllerName, controllerIdInFile, controllerNameInFile, migrationCheckResultDTO)) {
                restoreCacheMap.put("controller_migrate_check_info", migrationCheckResultDTO);
                log.warn("controller migrate check failed in omadacSetting. omadacId: {}", (Object)omadacId.a());
                throw new com.tplink.smb.omada.backup.api.d.c(com.tplink.smb.omada.common.g.b.eJ);
            }
        }
        this.restoreFileData(jsonParserWrapper, omadacId, omadacBKDTO);
        Optional optionalOmadacPO = this.omadacMongoRepository.a(omadacId);
        if (!optionalOmadacPO.isPresent()) {
            log.warn("Find no omadacId={} while restore omadacSetting.", (Object)omadacId);
            restoreCacheMap.put(com.tplink.smb.omada.backup.api.c.d.s.A(), omadacBKDTO);
        } else {
            OmadacPO omadacPO = (OmadacPO)optionalOmadacPO.get();
            if (Objects.nonNull(omadacBKDTO.getPrivateLabeling())) {
                omadacPO.setPrivateLabeling(new PrivateLabelingPO().setEnable(omadacBKDTO.getPrivateLabeling().getEnable()).setFileName(omadacBKDTO.getPrivateLabeling().getFileName()).setLabelUrl(omadacBKDTO.getPrivateLabeling().getLabelUrl()).setMd5(omadacBKDTO.getPrivateLabeling().getMd5()).setLength(omadacBKDTO.getPrivateLabeling().getLength()).setLabelFileId(omadacBKDTO.getPrivateLabeling().getLabelFileId()));
            }
            this.omadacMongoRepository.a(omadacPO);
            restoreCacheMap.put(com.tplink.smb.omada.backup.api.c.d.s.A(), omadacBKDTO);
        }
    }

    public void afterCompatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        if (OmadacType.s()) {
            Optional optionalOmadacPO = this.omadacMongoRepository.a(omadacId);
            if (!optionalOmadacPO.isPresent()) {
                log.error("Find no omadacId={}", (Object)omadacId);
                throw new com.tplink.smb.omada.backup.api.d.c(com.tplink.smb.omada.common.g.b.aA);
            }
            OmadacPO omadacPO = (OmadacPO)optionalOmadacPO.get();
            omadacPO.setInitializationInfo(omadacPO.getInitializationInfo().setConfigured(Boolean.valueOf(true)));
            this.omadacMongoRepository.a(omadacPO);
        }
        this.identityOmadacInternalApiService.d(omadacId.a());
    }

    private void handleCustomerRetentionFromControllerLevel(e setting, com.tplink.smb.omada.maintenance.domain.model.f.b dataRetentionSetting) {
        Optional.ofNullable(setting.d()).ifPresent(existedSetting -> {
            dataRetentionSetting.f(existedSetting.l());
            dataRetentionSetting.j(existedSetting.p());
            dataRetentionSetting.k(existedSetting.q());
            dataRetentionSetting.m(existedSetting.s());
        });
        dataRetentionSetting.a(Boolean.valueOf(true));
    }

    public String getCurrentTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddHHmm");
        Date date = new Date(System.currentTimeMillis());
        return simpleDateFormat.format(date);
    }

    private void restoreFileData(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, OmadacBKDTO omadacBKDTO) {
        OmadacBKDTO.PrivateLabelingBKDTO privateLabelingBKDTO = omadacBKDTO.getPrivateLabeling();
        try {
            JsonParser jsonParser = jsonParserWrapper.h();
            jsonParser.nextToken();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (!jsonParser.currentToken().equals((Object)JsonToken.FIELD_NAME)) continue;
                String fileData = jsonParser.nextTextValue();
                if (T.a((String)fileData)) {
                    log.warn("private labeling fileData could not be found in omadac {}", (Object)omadacId);
                    omadacBKDTO.setPrivateLabeling(new OmadacBKDTO.PrivateLabelingBKDTO().setEnable(false));
                    continue;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(c.b((String)fileData));
                String newFileId = this.fileRepository.saveFile(omadacId.a(), null, privateLabelingBKDTO.getFileName(), (InputStream)in);
                if (T.a((String)newFileId)) {
                    log.warn("Fail to save picture in omadac {}, ignore it", (Object)omadacId);
                    omadacBKDTO.setPrivateLabeling(new OmadacBKDTO.PrivateLabelingBKDTO().setEnable(false));
                    continue;
                }
                privateLabelingBKDTO.setLabelFileId(newFileId);
                omadacBKDTO.setPrivateLabeling(privateLabelingBKDTO);
            }
            jsonParser.nextToken();
        }
        catch (Exception e2) {
            log.warn("V10000100 failed to restore private labeling in omadacId {}, error message:{}", (Object)omadacId.a(), (Object)e2.getMessage());
            throw new com.tplink.smb.omada.backup.api.d.c("Failed to restore private labeling file data");
        }
    }
}

