/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.logsetting;

import com.tplink.smb.omada.backup.api.b.b;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.h;
import com.tplink.smb.omada.backup.core.unit.globalconfig.logsetting.dto.OmadaLogGlobalSettingBackupDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.global.common.dto.GlobalSysLogDTO;
import com.tplink.smb.omada.global.common.dto.MailServerDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.CentralIdDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.GlobalCommonSettingDTO;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.UpdateLogSettingsDTO;
import com.tplink.smb.omada.logmanager.port.mongo.logsetting.omada.OmadaLogGlobalSettingMaintRepository;
import com.tplink.smb.omada.logmanager.port.mongo.omadacsetting.MailServerPO;
import com.tplink.smb.omada.logmanager.port.mongo.omadacsetting.OmadaLogOmadacSettingPO;
import com.tplink.smb.omada.logmanager.port.mongo.sitesetting.RemoteLogSettingPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.a(a=d.GLOBAL_NOTIFICATION_V2)
public class OmadaLogGlobalSettingBackupUnit
extends b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadaLogGlobalSettingBackupUnit.class);
    private final OmadaLogGlobalSettingMaintRepository logOmadaSettingMaintRepository = OmadaLogGlobalSettingMaintRepository.getInstance();
    private final com.tplink.smb.omada.global.subsystem.api.internal.c globalSettingInternalApiService = (com.tplink.smb.omada.global.subsystem.api.internal.c)a.b(com.tplink.smb.omada.global.subsystem.api.internal.c.class);
    private static final OmadaLogGlobalSettingBackupUnit instance = new OmadaLogGlobalSettingBackupUnit();

    private OmadaLogGlobalSettingBackupUnit() {
    }

    public static OmadaLogGlobalSettingBackupUnit getInstance() {
        return instance;
    }

    public void backup(com.tplink.smb.omada.backup.api.e.a wrapper, c omadacId, h backupTypeEnum) throws IOException, com.tplink.smb.omada.backup.api.d.a {
        MailServerDTO mailServerDTO;
        log.debug("Backup omada log global setting, omadacId: {}", (Object)omadacId);
        OmadaLogGlobalSettingBackupDTO logOmadacSettingBackupDTO = new OmadaLogGlobalSettingBackupDTO();
        Optional logOmadacSettingPO = this.logOmadaSettingMaintRepository.findByOmadacId(omadacId);
        OperationResponse globalSettingResp = this.globalSettingInternalApiService.b(CentralIdDTO.builder().id(omadacId.a()).build());
        OperationResponse mailServerResp = this.globalSettingInternalApiService.a(CentralIdDTO.builder().id(omadacId.a()).build());
        if (globalSettingResp.success()) {
            GlobalCommonSettingDTO globalCommonSettingDTO = (GlobalCommonSettingDTO)globalSettingResp.getResult();
            GlobalSysLogDTO sysLog = globalCommonSettingDTO.getSysLog();
            log.debug("Get syslog {}, omadacId: {}", (Object)sysLog, (Object)omadacId);
            if (Objects.nonNull(sysLog)) {
                logOmadacSettingPO.ifPresent(item -> item.setRemoteLogSetting(new RemoteLogSettingPO().setEnable(sysLog.getEnable()).setHost(sysLog.getHost()).setPort(sysLog.getPort())));
            }
        }
        if (mailServerResp.success() && Objects.nonNull(mailServerDTO = (MailServerDTO)mailServerResp.getResult())) {
            log.debug("Get mail server {}, omadacId: {}", (Object)mailServerDTO, (Object)omadacId);
            logOmadacSettingPO.ifPresent(item -> {
                MailServerPO mailServer = item.getMailServer();
                mailServer.setSmtpEnable(mailServerDTO.getSmtpEnable());
                mailServer.setSmtpServer(mailServerDTO.getSmtpServer());
                mailServer.setAuthEnable(mailServerDTO.getAuthEnable());
                mailServer.setSslEnable(mailServerDTO.getSslEnable());
                mailServer.setUsername(mailServerDTO.getUsername());
                mailServer.setPassword(mailServerDTO.getPassword());
                mailServer.setPort(mailServerDTO.getPort());
                mailServer.setSenderAddress(mailServerDTO.getSenderAddress());
            });
        }
        logOmadacSettingPO.ifPresent(item -> {
            if (h.e.equals((Object)backupTypeEnum)) {
                item.setMailServer(null);
            }
            item.setId(null);
            logOmadacSettingBackupDTO.setOmadaLogOmadacSettingPO((OmadaLogOmadacSettingPO)item);
        });
        log.debug("logOmadacSettingBackupDTO: {}, omadacId: {}", (Object)logOmadacSettingBackupDTO, (Object)omadacId);
        wrapper.a(d.P.A(), (Object)logOmadacSettingBackupDTO);
    }

    public void customerCopy(c copyCustomerId, c newCustomerId, Map customerCopyCacheMap) throws com.tplink.smb.omada.backup.api.d.a {
        Optional poOptional = this.logOmadaSettingMaintRepository.findByOmadacId(copyCustomerId);
        poOptional.ifPresent(po -> {
            po.setId(null);
            po.setOmadacId(newCustomerId.a());
            this.logOmadaSettingMaintRepository.save(po);
            GlobalSysLogDTO globalSysLogDTO = GlobalSysLogDTO.buildDefault();
            if (po.getRemoteLogSetting() != null) {
                globalSysLogDTO = GlobalSysLogDTO.builder().enable(po.getRemoteLogSetting().getEnable()).host(po.getRemoteLogSetting().getHost()).port(po.getRemoteLogSetting().getPort()).build();
            }
            MailServerDTO mailServerDTO = MailServerDTO.builder().centralId(newCustomerId.a()).smtpEnable(Boolean.valueOf(false)).build();
            if (po.getMailServer() != null) {
                mailServerDTO.setSmtpEnable(po.getMailServer().getSmtpEnable());
                mailServerDTO.setSmtpServer(po.getMailServer().getSmtpServer());
                mailServerDTO.setAuthEnable(po.getMailServer().getAuthEnable());
                mailServerDTO.setSslEnable(po.getMailServer().getSslEnable());
                mailServerDTO.setUsername(po.getMailServer().getUsername());
                mailServerDTO.setPassword(po.getMailServer().getPassword());
                mailServerDTO.setPort(po.getMailServer().getPort());
                mailServerDTO.setSenderAddress(po.getMailServer().getSenderAddress());
            }
            this.globalSettingInternalApiService.a(UpdateLogSettingsDTO.builder().centralId(newCustomerId.a()).globalSysLogDTO(globalSysLogDTO).mailServerDTO(mailServerDTO).build());
        });
    }
}

