/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.firmwareupgrade.restore;

import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.globalconfig.firmwareupgrade.a;
import com.tplink.smb.omada.backup.core.unit.globalconfig.firmwareupgrade.b;
import com.tplink.smb.omada.backup.core.unit.globalconfig.firmwareupgrade.dto.FirmwareUpgradeConfigBackupDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.AutoCheckUpgradePO;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.FirmwarePO;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.PlanUpgradePO;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.UpgradeSettingsPO;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.g;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.m;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.u;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V10000800, b=d.FIRMWARE_UPGRADE_CONFIG)
public class FirmwareUpgradeConfigRestoreUnitV10800
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmwareUpgradeConfigRestoreUnitV10800.class);
    private static FirmwareUpgradeConfigRestoreUnitV10800 instance = new FirmwareUpgradeConfigRestoreUnitV10800();
    private final com.tplink.smb.omada.manager.port.mongo.device.upgrade.a autoCheckUpgradeMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.device.upgrade.a.a();
    private final g firmwareMaintMongoRepository = g.a();
    private final m planUpgradeMaintMongoRepository = m.a();
    private final u upgradeSettingsMaintMongoRepository = u.a();
    private static final String CACHE_DTO = "cacheDto";

    private FirmwareUpgradeConfigRestoreUnitV10800() {
    }

    public static FirmwareUpgradeConfigRestoreUnitV10800 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        FirmwareUpgradeConfigBackupDTO firmwareUpgradeConfigBackupDTO = (FirmwareUpgradeConfigBackupDTO)jsonParserWrapper.a(FirmwareUpgradeConfigBackupDTO.class);
        log.debug("restore firmwareUpgradeConfig,firmwareUpgradeBackupDTO:{}", (Object)firmwareUpgradeConfigBackupDTO);
        if (null == firmwareUpgradeConfigBackupDTO) {
            return;
        }
        this.restore(omadacId, firmwareUpgradeConfigBackupDTO, restoreCacheMap);
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        Map siteIdMaps = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        if (siteIdMaps.isEmpty()) {
            log.info("siteId map is empty");
            return;
        }
        FirmwareUpgradeConfigBackupDTO firmwareUpgradeConfigBackupDTO = (FirmwareUpgradeConfigBackupDTO)restoreCacheMap.get(d.O.A() + CACHE_DTO);
        if (null == firmwareUpgradeConfigBackupDTO) {
            log.error("firmwareUpgradeConfigBackupDTO is null, omadacId:{}", (Object)omadacId);
            return;
        }
        List<AutoCheckUpgradePO> autoCheckUpgradePOS = firmwareUpgradeConfigBackupDTO.getAutoCheckUpgradePOS();
        Map<String, String> autoCheckIdMap = this.restoreAutoCheckUpgrade(omadacId, siteIdMaps, autoCheckUpgradePOS);
        List<PlanUpgradePO> planUpgradePOS = firmwareUpgradeConfigBackupDTO.getPlanUpgradePOS();
        Map<String, String> planUpgradeIdMap = this.restorePlanUpgrade(omadacId, siteIdMaps, planUpgradePOS);
        List firmwarePOS = this.firmwareMaintMongoRepository.a(omadacId.a());
        ArrayList<FirmwarePO> changedPOs = new ArrayList<FirmwarePO>();
        for (FirmwarePO firmwarePO : firmwarePOS) {
            if (!Boolean.TRUE.equals(firmwarePO.getTargetEnable()) || CollectionUtils.isEmpty((Collection)firmwarePO.getTargetSites())) continue;
            List restoredSiteIds = firmwarePO.getTargetSites().stream().map(siteIdMaps::get).collect(Collectors.toList());
            firmwarePO.setTargetSites(restoredSiteIds);
            changedPOs.add(firmwarePO);
        }
        this.firmwareMaintMongoRepository.b(changedPOs);
    }

    private void restore(c omadacId, FirmwareUpgradeConfigBackupDTO firmwareUpgradeConfigBackupDTO, Map<String, Object> restoreCacheMap) {
        if (T.a((String)omadacId.a())) {
            return;
        }
        Map<Object, Object> firmwareIdMap = new HashMap();
        boolean isCloudBased = OmadacType.s();
        if (isCloudBased) {
            List<FirmwarePO> firmwarePOS = firmwareUpgradeConfigBackupDTO.getFirmwarePOS();
            firmwareIdMap = this.restoreFirmwareUpgrade(omadacId, firmwarePOS);
        }
        firmwareUpgradeConfigBackupDTO.setFirmwarePOS(null);
        List<PlanUpgradePO> planUpgradePOS = firmwareUpgradeConfigBackupDTO.getPlanUpgradePOS();
        for (PlanUpgradePO planUpgradePO : planUpgradePOS) {
            if (!T.b((String)planUpgradePO.getFirmwareId())) continue;
            planUpgradePO.setFirmwareId((String)firmwareIdMap.get(planUpgradePO.getFirmwareId()));
        }
        UpgradeSettingsPO upgradeSettingsPO = firmwareUpgradeConfigBackupDTO.getUpgradeSettingsPO();
        this.restoreUpgradeSettings(omadacId, upgradeSettingsPO);
        firmwareUpgradeConfigBackupDTO.setUpgradeSettingsPO(null);
        restoreCacheMap.put(d.O.A() + CACHE_DTO, firmwareUpgradeConfigBackupDTO);
    }

    private Map<String, String> restoreAutoCheckUpgrade(c omadacId, Map<String, String> siteIdMaps, List<AutoCheckUpgradePO> autoCheckUpgradePOS) {
        HashMap<String, String> autoCheckUpgradeIdMap = new HashMap<String, String>();
        if (CollectionUtil.isEmpty(autoCheckUpgradePOS)) {
            return autoCheckUpgradeIdMap;
        }
        for (AutoCheckUpgradePO autoCheckUpgradePO : autoCheckUpgradePOS) {
            String oldId = autoCheckUpgradePO.getId();
            String restoreIdByOldId = a.a(oldId);
            autoCheckUpgradeIdMap.put(oldId, restoreIdByOldId);
            autoCheckUpgradePO.setId(restoreIdByOldId);
            autoCheckUpgradePO.setOmadacId(omadacId.a());
            List restoredSiteIds = autoCheckUpgradePO.getSiteIds().stream().map(siteIdMaps::get).collect(Collectors.toList());
            autoCheckUpgradePO.setSiteIds(restoredSiteIds);
        }
        this.autoCheckUpgradeMaintMongoRepository.a(autoCheckUpgradePOS);
        return autoCheckUpgradeIdMap;
    }

    private Map<String, String> restoreFirmwareUpgrade(c omadacId, List<FirmwarePO> firmwarePOS) {
        HashMap<String, String> firmwareIdMap = new HashMap<String, String>();
        if (CollectionUtil.isEmpty(firmwarePOS)) {
            return firmwareIdMap;
        }
        List oldFirmwarePOIds = firmwarePOS.stream().map(FirmwarePO::getId).collect(Collectors.toList());
        for (FirmwarePO firmwarePO : firmwarePOS) {
            firmwarePO.setId(null);
            firmwarePO.setOmadacId(omadacId.a());
        }
        List restoredFirmwareIds = this.firmwareMaintMongoRepository.a(firmwarePOS);
        for (int i2 = 0; i2 < oldFirmwarePOIds.size(); ++i2) {
            firmwareIdMap.put((String)oldFirmwarePOIds.get(i2), (String)restoredFirmwareIds.get(i2));
        }
        return firmwareIdMap;
    }

    private Map<String, String> restorePlanUpgrade(c omadacId, Map<String, String> siteIdMaps, List<PlanUpgradePO> planUpgradePOS) {
        HashMap<String, String> planUpgradeIdMap = new HashMap<String, String>();
        if (CollectionUtil.isEmpty(planUpgradePOS)) {
            return planUpgradeIdMap;
        }
        boolean isCloudBased = OmadacType.s();
        if (!isCloudBased) {
            planUpgradePOS = planUpgradePOS.stream().filter(planUpgradePO -> b.f.equals(planUpgradePO.getFirmwareType())).collect(Collectors.toList());
        }
        for (PlanUpgradePO planUpgradePO2 : planUpgradePOS) {
            String oldId = planUpgradePO2.getId();
            String restoreIdByOldId = a.a(oldId);
            planUpgradeIdMap.put(oldId, restoreIdByOldId);
            planUpgradePO2.setId(restoreIdByOldId);
            planUpgradePO2.setOmadacId(omadacId.a());
            List restoredSiteIds = planUpgradePO2.getSiteIds().stream().map(siteIdMaps::get).collect(Collectors.toList());
            planUpgradePO2.setSiteIds(restoredSiteIds);
        }
        this.planUpgradeMaintMongoRepository.a(planUpgradePOS);
        return planUpgradeIdMap;
    }

    private void restoreUpgradeSettings(c omadacId, UpgradeSettingsPO restoreUpgradeSettingsPO) {
        restoreUpgradeSettingsPO.setId(null);
        restoreUpgradeSettingsPO.setOmadacId(omadacId.a());
        this.upgradeSettingsMaintMongoRepository.a(restoreUpgradeSettingsPO);
    }
}

