/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.globalconfig.autobackup;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.backup.autobackup.c;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.P;
import com.tplink.smb.omada.common.constant.W;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.a.p;
import com.tplink.smb.omada.maintenance.common.config.SchedulerCustomProperties;
import com.tplink.smb.omada.maintenance.domain.model.e.b;
import com.tplink.smb.omada.maintenance.domain.model.f.a.i;
import com.tplink.smb.omada.maintenance.domain.model.f.e;
import com.tplink.smb.omada.maintenance.port.mongo.omadac.autobackup.AutoBackupSchedulePO;
import com.tplink.smb.omada.maintenance.port.mongo.omadac.autobackup.BaseSchedulePO;
import com.tplink.smb.omada.manager.configuration.api.internal.dto.DstInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51400, b=d.AUTO_BACKUP_TASK)
public class AutoBackupTaskRestoreUnitV51400
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoBackupTaskRestoreUnitV51400.class);
    private static final AutoBackupTaskRestoreUnitV51400 instance = new AutoBackupTaskRestoreUnitV51400();
    private final b maintenanceOmadacSettingRepository = (b)a.b(b.class);
    private final c modifyAutoBackupService = (c)a.b(c.class);
    private final SchedulerCustomProperties schedulerCustomProperties = (SchedulerCustomProperties)a.b(SchedulerCustomProperties.class);
    private final com.tplink.smb.omada.manager.configuration.api.internal.a dstInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.a)a.b(com.tplink.smb.omada.manager.configuration.api.internal.a.class);
    private static final String KEY_TASK_NAME_AUTOBACKUP = "maintenance_autobackup";

    private AutoBackupTaskRestoreUnitV51400() {
    }

    public static AutoBackupTaskRestoreUnitV51400 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        try {
            AutoBackupSchedulePO autoBackupSchedulePO = (AutoBackupSchedulePO)jsonParserWrapper.a(AutoBackupSchedulePO.class);
            if (autoBackupSchedulePO == null) {
                return;
            }
            if (autoBackupSchedulePO.getSchedule() == null) {
                restoreCacheMap.put(d.G.A(), false);
                return;
            }
            Optional maintenanceOmadacSettingOptional = this.maintenanceOmadacSettingRepository.a(omadacId.a());
            if (!maintenanceOmadacSettingOptional.isPresent()) {
                log.warn("omadacId={} can not find maintenance omadac setting", (Object)omadacId);
                return;
            }
            e maintenanceOmadacSetting = (e)maintenanceOmadacSettingOptional.get();
            if (autoBackupSchedulePO.getPartitionIndex() == null) {
                this.setParamAndRefreshScheduleTask(autoBackupSchedulePO, omadacId.a(), maintenanceOmadacSetting.a());
            }
            autoBackupSchedulePO.setPartitionIndex(Integer.valueOf(maintenanceOmadacSetting.a().hashCode() & this.schedulerCustomProperties.getShardingSizeOf(KEY_TASK_NAME_AUTOBACKUP) - 1));
            String category = Optional.ofNullable(restoreCacheMap.get("omadaCategory")).orElse(com.tplink.smb.omada.common.f.b.d.a()).toString();
            if (Boolean.TRUE.equals(autoBackupSchedulePO.getSchedule().getStatus())) {
                restoreCacheMap.put(d.G.A(), this.dealAutoBackupTask(autoBackupSchedulePO, category));
            } else {
                restoreCacheMap.put(d.G.A(), false);
            }
            this.maintenanceOmadacSettingRepository.a(omadacId.a(), com.tplink.smb.omada.maintenance.port.mongo.a.a.a((AutoBackupSchedulePO)autoBackupSchedulePO));
        }
        catch (Exception e2) {
            log.warn("Autobackup task v5.x restore failed, skip, omadacId = {}", (Object)omadacId, (Object)e2);
        }
    }

    private void setParamAndRefreshScheduleTask(AutoBackupSchedulePO autoBackupSchedulePO, String omadacId, String maintenanceSettingId) {
        BaseSchedulePO schedule = autoBackupSchedulePO.getSchedule();
        if (schedule == null || !Boolean.TRUE.equals(schedule.getStatus())) {
            return;
        }
        QuerySiteDTO querySiteDTO = new QuerySiteDTO();
        querySiteDTO.setOmadacId(omadacId);
        OperationResponse dstInfoDTOResp = this.dstInternalApiService.a(querySiteDTO);
        DstInfoDTO dstInfoDTO = null;
        if (!dstInfoDTOResp.success()) {
            log.warn("Failed to get dst info, omadacId: {}", (Object)omadacId);
        } else {
            dstInfoDTO = (DstInfoDTO)dstInfoDTOResp.getResult();
        }
        TimeZone timeZone = TimeZone.getTimeZone(P.a((String)schedule.getTimezoneId()));
        if (dstInfoDTO != null && dstInfoDTO.getStatus().booleanValue()) {
            timeZone.setRawOffset(timeZone.getRawOffset() + dstInfoDTO.getOffset().intValue());
        }
        String param = timeZone.getRawOffset() + "_" + schedule.getScheduleCron();
        autoBackupSchedulePO.setParam(param);
    }

    private boolean dealAutoBackupTask(AutoBackupSchedulePO autoBackupSchedulePO, String category) {
        if (OmadacType.r()) {
            if (autoBackupSchedulePO.getRetention().equals(0)) {
                autoBackupSchedulePO.setRetention(Integer.valueOf(-1));
            }
            autoBackupSchedulePO.setPath(null);
            autoBackupSchedulePO.getSchedule().setStatus(Boolean.valueOf(false));
            return true;
        }
        if (OmadacType.s()) {
            return this.dealAutoBackupTaskCBC(autoBackupSchedulePO, category);
        }
        if (OmadacType.q() && Objects.equals(com.tplink.smb.omada.common.f.b.e.a(), category) && p.b.a(autoBackupSchedulePO.getStorageType())) {
            autoBackupSchedulePO.setStorageType(Integer.valueOf(p.c.a()));
        }
        if (!Boolean.TRUE.equals(autoBackupSchedulePO.getFileServerEnable())) {
            autoBackupSchedulePO.setPath("/data/autobackup");
        }
        return false;
    }

    private boolean dealAutoBackupTaskCBC(AutoBackupSchedulePO autoBackupSchedulePO, String category) {
        autoBackupSchedulePO.setRetention(Integer.valueOf(-1));
        if (i.b.equals((Object)i.a((int)autoBackupSchedulePO.getOccurrence().getTimingType()))) {
            autoBackupSchedulePO.getSchedule().setStatus(Boolean.valueOf(false));
            autoBackupSchedulePO.getOccurrence().setTimingType(Integer.valueOf(i.c.a()));
            autoBackupSchedulePO.getOccurrence().setDayOfWeek(String.valueOf(W.b.a()));
            return false;
        }
        if (!Boolean.TRUE.equals(autoBackupSchedulePO.getFileServerEnable())) {
            autoBackupSchedulePO.getSchedule().setStatus(Boolean.valueOf(false));
            return false;
        }
        return true;
    }

    public void afterCompatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        e setting = this.maintenanceOmadacSettingRepository.a(omadacId.a()).orElse(new e());
        this.modifyAutoBackupService.a(omadacId.a(), setting.g());
    }
}

