/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.devicebrief.siteimport;

import com.tplink.smb.omada.backup.api.c.j;
import com.tplink.smb.omada.backup.core.d.e;
import com.tplink.smb.omada.backup.core.unit.devicebrief.a;
import com.tplink.smb.omada.backup.core.unit.devicebrief.dto.BriefDeviceDTO;
import com.tplink.smb.omada.backup.core.unit.devicebrief.dto.DeviceBriefRestoreCacheDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.port.mongo.omadac.OmadacPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.UserInfoDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.ForgetByRestoreRequest;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.SitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.whitelist.DeviceWhitelistMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.whitelist.DeviceWhitelistPO;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.d(a=com.tplink.smb.omada.backup.api.c.d.DEVICE_BRIEF_INFO)
public class DeviceBriefSiteImportUnit
extends com.tplink.smb.omada.backup.api.c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceBriefSiteImportUnit.class);
    private static final DeviceBriefSiteImportUnit instance = new DeviceBriefSiteImportUnit();
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final DeviceWhitelistMaintRepository deviceWhitelistMaintRepository = DeviceWhitelistMaintRepository.getInstance();
    private final com.tplink.smb.omada.maintenance.port.c.c maintenancelMeters = (com.tplink.smb.omada.maintenance.port.c.c)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.maintenance.port.c.c.class);
    private final com.tplink.smb.omada.identityaccess.port.mongo.g omadacMaintMongoRepository = com.tplink.smb.omada.identityaccess.port.mongo.g.a();
    private final g siteMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService = (com.tplink.smb.omada.manager.device.api.internal.device.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.device.api.internal.device.b.class);
    private final a deleteAllDataService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);

    private DeviceBriefSiteImportUnit() {
    }

    public static DeviceBriefSiteImportUnit getInstance() {
        return instance;
    }

    public void siteImport(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List briefDevicesInFile = jsonParserWrapper.b(BriefDeviceDTO.class);
        if (briefDevicesInFile.isEmpty()) {
            return;
        }
        boolean isSiteRestore = Boolean.TRUE.equals(restoreCacheMap.get("restoreSite"));
        List<String> devicesInFile = briefDevicesInFile.stream().map(BriefDeviceDTO::getMac).collect(Collectors.toList());
        boolean skipCheckDuplicateMac = Objects.equals(j.d.b(), restoreCacheMap.get("operationType"));
        if (!skipCheckDuplicateMac) {
            this.checkDeviceForCustomerImport(omadacId, devicesInFile);
        }
        Set devicesInDb = this.deviceMaintRepository.listMacsByOmadacId(omadacId.a());
        Set devicesInSite = this.deviceMaintRepository.listMacsByOmadacIdAndSiteId(omadacId.a(), newSiteId.a());
        for (String mac : devicesInFile) {
            if (!devicesInDb.contains(mac) || isSiteRestore && devicesInSite.contains(mac)) continue;
            throw new com.tplink.smb.omada.backup.api.d.c(com.tplink.smb.omada.common.g.b.eq);
        }
        DeviceWhitelistPO deviceWhitelist = this.deviceWhitelistMaintRepository.findDeviceWhitelist().orElse(null);
        HashSet<CallSite> notInWhitelistModelSet = new HashSet<CallSite>(briefDevicesInFile.size());
        HashSet<String> macSetToForget = new HashSet<String>(briefDevicesInFile.size());
        boolean skipDevice = Boolean.TRUE.equals(restoreCacheMap.get("skipDevice"));
        for (BriefDeviceDTO briefDeviceDTO : briefDevicesInFile) {
            if (skipDevice) {
                macSetToForget.add(briefDeviceDTO.getMac());
                continue;
            }
            if (!e.a(briefDeviceDTO.getModel(), briefDeviceDTO.getHwVersion(), deviceWhitelist)) {
                notInWhitelistModelSet.add((CallSite)((Object)(briefDeviceDTO.getModel() + briefDeviceDTO.getHwVersion())));
                macSetToForget.add(briefDeviceDTO.getMac());
            }
            if (!Boolean.TRUE.equals(briefDeviceDTO.getAddInAdv())) continue;
            macSetToForget.add(briefDeviceDTO.getMac());
        }
        Boolean skipConfirmWhitelist = (Boolean)restoreCacheMap.get("skipConfirm");
        if (Boolean.TRUE.equals(skipConfirmWhitelist)) {
            this.cacheDeviceBriefInfo(macSetToForget, briefDevicesInFile, restoreCacheMap);
            this.maintenancelMeters.a(devicesInFile.size());
            return;
        }
        if (!CollectionUtils.isEmpty(notInWhitelistModelSet)) {
            log.info("siteImport DeviceBrief, notInWhitelistModelSet {}, omadacId {}", notInWhitelistModelSet, (Object)omadacId);
            throw new com.tplink.smb.omada.backup.api.d.b(notInWhitelistModelSet);
        }
        this.cacheDeviceBriefInfo(macSetToForget, briefDevicesInFile, restoreCacheMap);
        this.maintenancelMeters.a(devicesInFile.size());
    }

    private void checkDeviceForCustomerImport(c omadacId, List<String> devicesInFile) {
        Optional omadacOpt = this.omadacMaintMongoRepository.a(omadacId);
        if (!omadacOpt.isPresent()) {
            return;
        }
        String mspId = ((OmadacPO)omadacOpt.get()).getMspId();
        if (mspId == null) {
            return;
        }
        Set customerIds = this.omadacMaintMongoRepository.b(new b(mspId));
        HashSet<String> macSet = new HashSet<String>(devicesInFile);
        customerIds.remove(omadacId.a());
        for (String customerId : customerIds) {
            if (!this.deviceMaintRepository.existMacsByOmadacId(customerId, macSet)) continue;
            throw new com.tplink.smb.omada.backup.api.d.c(com.tplink.smb.omada.common.g.b.eA);
        }
    }

    private void cacheDeviceBriefInfo(Set<String> macSetToForget, List<BriefDeviceDTO> briefDevicesInFile, Map<String, Object> restoreCacheMap) {
        if (Boolean.TRUE.equals(restoreCacheMap.get("restoreSite"))) {
            DeviceBriefRestoreCacheDTO cacheDTO = new DeviceBriefRestoreCacheDTO();
            cacheDTO.setBriefDevicesInFile(briefDevicesInFile);
            cacheDTO.setMacsToForget(macSetToForget);
            restoreCacheMap.put(com.tplink.smb.omada.backup.api.c.d.D.A(), cacheDTO);
        } else {
            restoreCacheMap.put(com.tplink.smb.omada.backup.api.c.d.D.A(), macSetToForget);
        }
    }

    public void siteCopyWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
    }

    public void siteTemplateCopyWrite(Object dataObject, c omadacId, d newSiteTemplateId, Map<String, Map<String, String>> siteImportIdCacheMap) throws com.tplink.smb.omada.backup.api.d.c, IOException {
    }

    public void restorePreloadCache(c omadacId, d siteId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        DeviceBriefRestoreCacheDTO cacheDTO = (DeviceBriefRestoreCacheDTO)restoreCacheMap.get(com.tplink.smb.omada.backup.api.c.d.D.A());
        HashSet macsToForget = Objects.nonNull(cacheDTO) ? cacheDTO.getMacsToForget() : new HashSet();
        ArrayList briefDevicesInFile = Objects.nonNull(cacheDTO) ? cacheDTO.getBriefDevicesInFile() : new ArrayList();
        restoreCacheMap.put(com.tplink.smb.omada.backup.api.c.d.D.A(), macsToForget);
        HashSet<String> allowedDeviceMacs = new HashSet<String>();
        if (!CollectionUtils.isEmpty(briefDevicesInFile)) {
            briefDevicesInFile.forEach(briefDeviceDTO -> {
                if (!macsToForget.contains(briefDeviceDTO.getMac())) {
                    allowedDeviceMacs.add(briefDeviceDTO.getMac());
                }
            });
        }
        UserDTO currentUser = (UserDTO)restoreCacheMap.get("currentUser");
        Optional optional = this.siteMaintMongoRepository.a(omadacId, siteId);
        if (!optional.isPresent()) {
            log.warn("DeviceBrief beforeRestore, omadac {} site {} not exist", (Object)omadacId, (Object)siteId);
            return;
        }
        SitePO sitePO = (SitePO)optional.get();
        HashMap<String, String> siteNameMap = new HashMap<String, String>();
        siteNameMap.put(sitePO.getId(), sitePO.getName());
        if (Objects.nonNull(currentUser) && !this.forgetAllDevice(omadacId, siteId, currentUser, allowedDeviceMacs, siteNameMap)) {
            throw new com.tplink.smb.omada.backup.api.d.c("failed forgetAllDevice");
        }
        this.deleteAllDataService.a(omadacId, siteId);
    }

    private boolean forgetAllDevice(c omadacId, d siteId, UserDTO currentUser, Set<String> allowedDeviceMacs, Map<String, String> siteNampMap) {
        try {
            UserInfoDTO userInfoDTO = UserInfoDTO.userOperateInfo((String)currentUser.getRoleTypeName(), (String)currentUser.getUsernameOrCloudAccount().orElse(null));
            ForgetByRestoreRequest request = new ForgetByRestoreRequest(omadacId.a(), siteId.a(), allowedDeviceMacs, userInfoDTO, siteNampMap);
            com.tplink.smb.omada.manager.device.api.internal.a.a.b response = (com.tplink.smb.omada.manager.device.api.internal.a.a.b)this.deviceInternalApiService.a(request).blockingGet();
            return response.a();
        }
        catch (Exception e2) {
            log.warn("restore forgetAllDevice {} failed,", (Object)omadacId, (Object)e2);
            return false;
        }
    }
}

