/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.devicebrief;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.g;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.d.e;
import com.tplink.smb.omada.backup.core.unit.devicebrief.a;
import com.tplink.smb.omada.backup.core.unit.devicebrief.c;
import com.tplink.smb.omada.backup.core.unit.devicebrief.dto.BriefDeviceDTO;
import com.tplink.smb.omada.backup.core.unit.devicebrief.dto.DeviceBriefRestoreCacheDTO;
import com.tplink.smb.omada.backup.core.unit.globalconfig.omadacsetting.OmadacBKDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.b;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.UserInfoDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.ForgetByRestoreRequest;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.device.DeviceMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.osg.OsgPO;
import com.tplink.smb.omada.manager.port.mongo.device.whitelist.DeviceWhitelistMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.whitelist.DeviceWhitelistPO;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.DEVICE_BRIEF_INFO)
public class DeviceBriefRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceBriefRestoreUnitV50000.class);
    private static final DeviceBriefRestoreUnitV50000 instance = new DeviceBriefRestoreUnitV50000();
    private final c forgetNotInWhitelistDeviceService = (c)com.tplink.smb.omada.common.spring.a.b(c.class);
    private final a deleteAllDataService = (a)com.tplink.smb.omada.common.spring.a.b(a.class);
    private final com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService = (com.tplink.smb.omada.manager.device.api.internal.device.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.device.api.internal.device.b.class);
    private final DeviceWhitelistMaintRepository deviceWhitelistMaintRepository = DeviceWhitelistMaintRepository.getInstance();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.g siteMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.g.a();
    private final com.tplink.smb.omada.maintenance.port.c.c maintenancelMeters = (com.tplink.smb.omada.maintenance.port.c.c)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.maintenance.port.c.c.class);
    private final DeviceMaintRepository deviceMaintRepository = DeviceMaintRepository.getInstance();
    private final com.tplink.smb.omada.identityaccess.port.mongo.g omadacMaintMongoRepository = com.tplink.smb.omada.identityaccess.port.mongo.g.a();

    private DeviceBriefRestoreUnitV50000() {
    }

    public void beforeRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        String restoreLevel = (String)restoreCacheMap.get("restore_level");
        if (Objects.equals(g.c.a(), restoreLevel)) {
            return;
        }
        List siteList = this.siteMaintMongoRepository.a(omadacId);
        if (siteList == null) {
            log.warn("DeviceBrief beforeRestore, {} has not site", (Object)omadacId);
            return;
        }
        Map<String, String> siteNameMap = siteList.stream().filter(sitePO -> sitePO.getId() != null && sitePO.getName() != null).collect(Collectors.toMap(BaseSitePO::getId, BaseSitePO::getName));
        DeviceBriefRestoreCacheDTO cacheDTO = (DeviceBriefRestoreCacheDTO)restoreCacheMap.getOrDefault(d.D.A(), new DeviceBriefRestoreCacheDTO());
        cacheDTO.setSiteNameMap(siteNameMap);
        restoreCacheMap.put(d.D.A(), cacheDTO);
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        String restoreLevel = (String)restoreCacheMap.get("restore_level");
        List briefDevicesInFile = jsonParserWrapper.b(BriefDeviceDTO.class);
        if (Objects.equals(g.c.a(), restoreLevel)) {
            return;
        }
        if (Objects.equals(g.a.a(), restoreLevel)) {
            this.checkDeviceForCustomerImport(restoreCacheMap, briefDevicesInFile, omadacId);
        }
        DeviceWhitelistPO deviceWhitelist = this.deviceWhitelistMaintRepository.findDeviceWhitelist().orElse(null);
        HashSet<Object> notInWhitelistModelSet = new HashSet<Object>(briefDevicesInFile.size());
        HashSet<String> macSetToForget = new HashSet<String>(briefDevicesInFile.size());
        boolean skipDevice = Boolean.TRUE.equals(restoreCacheMap.get("skipDevice"));
        OmadacBKDTO omadacBKDTO = (OmadacBKDTO)restoreCacheMap.get(d.s.A());
        String oldOmadacId = Optional.ofNullable(omadacBKDTO).map(OmadacBKDTO::getId).orElse(null);
        boolean restoreSelf = T.a((String)oldOmadacId, (String)omadacId.a());
        for (BriefDeviceDTO briefDeviceDTO : briefDevicesInFile) {
            if (skipDevice) {
                macSetToForget.add(briefDeviceDTO.getMac());
                continue;
            }
            if (!e.a(briefDeviceDTO.getModel(), briefDeviceDTO.getHwVersion(), deviceWhitelist)) {
                macSetToForget.add(briefDeviceDTO.getMac());
                if (DeviceTypeEnum.b.c(briefDeviceDTO.getType())) {
                    notInWhitelistModelSet.add(briefDeviceDTO.getHwVersion());
                } else {
                    notInWhitelistModelSet.add(briefDeviceDTO.getModel() + " v" + briefDeviceDTO.getHwVersion());
                }
            }
            if (restoreSelf || !Boolean.TRUE.equals(briefDeviceDTO.getAddInAdv())) continue;
            macSetToForget.add(briefDeviceDTO.getMac());
        }
        DeviceBriefRestoreCacheDTO cacheDTO = new DeviceBriefRestoreCacheDTO();
        cacheDTO.setBriefDevicesInFile(briefDevicesInFile);
        cacheDTO.setMacsToForget(macSetToForget);
        restoreCacheMap.put(d.D.A(), cacheDTO);
        Boolean skipConfirmWhitelist = (Boolean)restoreCacheMap.get("skipConfirm");
        if (Boolean.TRUE.equals(skipConfirmWhitelist)) {
            return;
        }
        if (!CollectionUtils.isEmpty(notInWhitelistModelSet)) {
            log.info("restore DeviceBrief, notInWhitelistModelSet {}, omadacId {}", notInWhitelistModelSet, (Object)omadacId);
            restoreCacheMap.put("notInWhitelist", notInWhitelistModelSet);
        }
    }

    private void checkDeviceForCustomerImport(Map<String, Object> restoreCacheMap, List<BriefDeviceDTO> briefDevicesInFile, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId) {
        String mspId = Optional.ofNullable(restoreCacheMap.get("mspId")).map(Object::toString).orElse(null);
        if (mspId == null) {
            return;
        }
        Set macsInFile = briefDevicesInFile.stream().map(BriefDeviceDTO::getMac).collect(Collectors.toSet());
        Set customerIds = this.omadacMaintMongoRepository.b(new b(mspId));
        customerIds.remove(omadacId.a());
        for (String customerId : customerIds) {
            if (!this.deviceMaintRepository.existMacsByOmadacId(customerId, macsInFile)) continue;
            throw new com.tplink.smb.omada.backup.api.d.c(com.tplink.smb.omada.common.g.b.eA);
        }
    }

    public void restorePreloadCache(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        OsgPO integratedGateway;
        Set<Object> allowedDeviceMacs;
        String restoreLevel = (String)restoreCacheMap.get("restore_level");
        if (Objects.equals(g.c.a(), restoreLevel)) {
            return;
        }
        DeviceBriefRestoreCacheDTO cacheDTO = (DeviceBriefRestoreCacheDTO)restoreCacheMap.get(d.D.A());
        if (cacheDTO == null) {
            log.warn("DeviceBrief restore preload cache dto is null, {}", (Object)omadacId);
            throw new com.tplink.smb.omada.backup.api.d.c("DeviceBrief restore preload cache dto is null");
        }
        List<BriefDeviceDTO> briefDevicesInFile = cacheDTO.getBriefDevicesInFile();
        Set<String> macsToForget = cacheDTO.getMacsToForget();
        boolean skipDevice = Boolean.TRUE.equals(restoreCacheMap.get("skipDevice"));
        if (skipDevice) {
            allowedDeviceMacs = new HashSet();
            macsToForget.addAll(Optional.ofNullable(briefDevicesInFile).map(briefDevicesInFileList -> briefDevicesInFileList.stream().map(BriefDeviceDTO::getMac).collect(Collectors.toSet())).orElse(Collections.emptySet()));
        } else {
            allowedDeviceMacs = this.getAllowedDeviceMacs(briefDevicesInFile, macsToForget, omadacId.a());
        }
        if (OmadacType.t() && (integratedGateway = (OsgPO)restoreCacheMap.get("integrated_gateway")) != null) {
            allowedDeviceMacs.add(integratedGateway.getMac());
        }
        restoreCacheMap.put(d.D.A(), macsToForget);
        this.maintenancelMeters.a(allowedDeviceMacs.size());
        log.debug("restore {} allowedDeviceMacs {}", (Object)omadacId, allowedDeviceMacs);
        UserDTO currentUser = (UserDTO)restoreCacheMap.get("currentUser");
        if (currentUser != null && !this.forgetAllDevice(omadacId, currentUser, allowedDeviceMacs, cacheDTO.getSiteNameMap())) {
            throw new com.tplink.smb.omada.backup.api.d.c("failed forgetAllDevice");
        }
        this.deleteAllData(omadacId, Optional.ofNullable(cacheDTO.getSiteNameMap()).map(Map::keySet).orElse(null));
    }

    public void afterCompatible(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        String restoreLevel = (String)restoreCacheMap.get("restore_level");
        if (Objects.equals(g.c.a(), restoreLevel)) {
            return;
        }
        Set deviceMacsToForget = (Set)restoreCacheMap.get(d.D.A());
        this.forgetNotInWhitelistDeviceService.a(omadacId, this.filterIntegratedGatewayDeviceMacsToForget(deviceMacsToForget, restoreCacheMap));
    }

    private Set<String> filterIntegratedGatewayDeviceMacsToForget(Set<String> macs, Map<String, Object> restoreCacheMap) {
        if (!OmadacType.t()) {
            log.info("integratedGateway restore handle save self po, not integrateGateway,ignore");
            return macs;
        }
        try {
            String selfMac = (String)restoreCacheMap.get("integrated_gateway_mac_self");
            if (selfMac != null && macs.contains(selfMac)) {
                log.info("integratedGateway restore handle save self po,succeed filter mac:{}", (Object)com.tplink.smb.omada.common.util.e.a.a((Object)selfMac));
                return macs.stream().filter(mac -> !Objects.equals(selfMac, mac)).collect(Collectors.toSet());
            }
            log.info("integratedGateway restore handle save self po,not contains,ignore.mac:{}", (Object)com.tplink.smb.omada.common.util.e.a.a((Object)selfMac));
        }
        catch (Exception e2) {
            log.error("integratedGateway restore handle save self po, exception.", (Throwable)e2);
        }
        return macs;
    }

    private void deleteAllData(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Set<String> siteIds) {
        this.deleteAllDataService.a(omadacId, siteIds);
    }

    private boolean forgetAllDevice(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, UserDTO currentUser, Set<String> allowedDeviceMacs, Map<String, String> siteNampMap) {
        try {
            UserInfoDTO userInfoDTO = UserInfoDTO.userOperateInfo((String)currentUser.getRoleTypeName(), (String)currentUser.getUsernameOrCloudAccount().orElse(null));
            ForgetByRestoreRequest request = new ForgetByRestoreRequest(omadacId.a(), null, allowedDeviceMacs, userInfoDTO, siteNampMap);
            com.tplink.smb.omada.manager.device.api.internal.a.a.b response = (com.tplink.smb.omada.manager.device.api.internal.a.a.b)this.deviceInternalApiService.a(request).blockingGet();
            return response.a();
        }
        catch (Exception e2) {
            log.warn("restore forgetAllDevice {} failed,", (Object)omadacId, (Object)e2);
            return false;
        }
    }

    private Set<String> getAllowedDeviceMacs(List<BriefDeviceDTO> briefDevicesInFile, Set<String> macsToForget, String omadacId) {
        HashSet<String> allowedDeviceMacs = new HashSet<String>();
        if (CollectionUtils.isEmpty(briefDevicesInFile)) {
            return allowedDeviceMacs;
        }
        Comparator<BriefDeviceDTO> byType = Comparator.comparing(BriefDeviceDTO::getType);
        Comparator<BriefDeviceDTO> byLastSeen = Comparator.comparing(BriefDeviceDTO::getLastSeen).reversed();
        briefDevicesInFile.sort(byType.thenComparing(byLastSeen));
        int apNum = 0;
        int switchNum = 0;
        int gatewayNum = 0;
        int deviceNum = 0;
        if (OmadacType.y()) {
            for (BriefDeviceDTO briefDevice : briefDevicesInFile) {
                if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.b.b())) {
                    if (++gatewayNum > com.tplink.smb.omada.common.omadac.config.a.b.v()) {
                        macsToForget.add(briefDevice.getMac());
                        continue;
                    }
                } else {
                    if (DeviceTypeEnum.d.b().equals(briefDevice.getType())) {
                        deviceNum += 4;
                    }
                    if (++deviceNum > com.tplink.smb.omada.common.omadac.config.a.b.s()) {
                        macsToForget.add(briefDevice.getMac());
                        continue;
                    }
                }
                allowedDeviceMacs.add(briefDevice.getMac());
            }
            return allowedDeviceMacs;
        }
        for (BriefDeviceDTO briefDevice : briefDevicesInFile) {
            if (++deviceNum > com.tplink.smb.omada.common.omadac.config.a.b.a((String)omadacId)) {
                macsToForget.add(briefDevice.getMac());
                continue;
            }
            if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.a.b())) {
                if (++apNum > com.tplink.smb.omada.common.omadac.config.a.b.t()) {
                    macsToForget.add(briefDevice.getMac());
                    continue;
                }
            } else if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.c.b())) {
                if (++switchNum > com.tplink.smb.omada.common.omadac.config.a.b.u()) {
                    macsToForget.add(briefDevice.getMac());
                    continue;
                }
            } else if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.b.b()) && ++gatewayNum > com.tplink.smb.omada.common.omadac.config.a.b.v()) {
                macsToForget.add(briefDevice.getMac());
                continue;
            }
            allowedDeviceMacs.add(briefDevice.getMac());
        }
        return allowedDeviceMacs;
    }

    @Generated
    public static DeviceBriefRestoreUnitV50000 getInstance() {
        return instance;
    }
}

