/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.msp.mspdevicebrief;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.d.e;
import com.tplink.smb.omada.backup.core.unit.devicebrief.dto.BriefDeviceDTO;
import com.tplink.smb.omada.backup.core.unit.devicebrief.dto.DeviceBriefRestoreCacheDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.maintenance.common.b.a.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.device.api.internal.device.dto.UserInfoDTO;
import com.tplink.smb.omada.manager.device.api.internal.device.request.device.ForgetByRestoreRequest;
import com.tplink.smb.omada.manager.license.dto.RecycleCustomerLicenseDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.BaseSitePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.g;
import com.tplink.smb.omada.manager.port.mongo.device.whitelist.DeviceWhitelistMaintRepository;
import com.tplink.smb.omada.manager.port.mongo.device.whitelist.DeviceWhitelistPO;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51000, b=d.MSP_DEVICE_BRIEF_INFO)
public class MspDeviceBriefRestoreUnitV51000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspDeviceBriefRestoreUnitV51000.class);
    private static final MspDeviceBriefRestoreUnitV51000 instance = new MspDeviceBriefRestoreUnitV51000();
    private final com.tplink.smb.omada.backup.core.unit.devicebrief.c forgetNotInWhitelistDeviceService = (com.tplink.smb.omada.backup.core.unit.devicebrief.c)a.b(com.tplink.smb.omada.backup.core.unit.devicebrief.c.class);
    private final com.tplink.smb.omada.backup.core.unit.devicebrief.a deleteAllDataService = (com.tplink.smb.omada.backup.core.unit.devicebrief.a)a.b(com.tplink.smb.omada.backup.core.unit.devicebrief.a.class);
    private final com.tplink.smb.omada.manager.device.api.internal.device.b deviceInternalApiService = (com.tplink.smb.omada.manager.device.api.internal.device.b)a.b(com.tplink.smb.omada.manager.device.api.internal.device.b.class);
    private final DeviceWhitelistMaintRepository deviceWhitelistMaintRepository = DeviceWhitelistMaintRepository.getInstance();
    private final com.tplink.smb.omada.maintenance.port.c.c maintenancelMeters = (com.tplink.smb.omada.maintenance.port.c.c)a.b(com.tplink.smb.omada.maintenance.port.c.c.class);
    private final com.tplink.smb.omada.identityaccess.port.mongo.g omadacMaintMongoRepository = com.tplink.smb.omada.identityaccess.port.mongo.g.a();
    private final g siteMaintMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.license.api.internal.c licenseInternalApiService = (com.tplink.smb.omada.manager.license.api.internal.c)a.b(com.tplink.smb.omada.manager.license.api.internal.c.class);

    private MspDeviceBriefRestoreUnitV51000() {
    }

    public static MspDeviceBriefRestoreUnitV51000 getInstance() {
        return instance;
    }

    public void beforeRestore(c mspId, Map<String, Object> restoreCacheMap) {
        Set currentCustomerIds = this.omadacMaintMongoRepository.b(new b(mspId.a()));
        HashMap<String, String> siteNameMap = new HashMap<String, String>(8);
        currentCustomerIds.forEach(omadacId -> {
            List siteList = this.siteMaintMongoRepository.a(new c(omadacId));
            siteNameMap.putAll(siteList.stream().filter(sitePO -> sitePO.getId() != null && sitePO.getName() != null).collect(Collectors.toMap(BaseSitePO::getId, BaseSitePO::getName)));
        });
        DeviceBriefRestoreCacheDTO cacheDTO = (DeviceBriefRestoreCacheDTO)restoreCacheMap.getOrDefault(d.i.A(), new DeviceBriefRestoreCacheDTO());
        restoreCacheMap.put("oldCustomerIds", cacheDTO);
        cacheDTO.setCurrentCustomerIds(currentCustomerIds);
        cacheDTO.setSiteNameMap(siteNameMap);
        restoreCacheMap.put(d.i.A(), cacheDTO);
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c mspId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List briefDevicesInFile = jsonParserWrapper.b(BriefDeviceDTO.class);
        DeviceWhitelistPO deviceWhitelist = this.deviceWhitelistMaintRepository.findDeviceWhitelist().orElse(null);
        HashSet<Object> notInWhitelistModelSet = new HashSet<Object>(briefDevicesInFile.size());
        HashSet<String> macSetToForget = new HashSet<String>(briefDevicesInFile.size());
        boolean skipDevice = Boolean.TRUE.equals(restoreCacheMap.get("skipDevice"));
        String oldMspId = (String)restoreCacheMap.get("mspId");
        boolean restoreSelf = T.a((String)oldMspId, (String)mspId.a());
        for (BriefDeviceDTO briefDeviceDTO : briefDevicesInFile) {
            if (skipDevice) {
                macSetToForget.add(briefDeviceDTO.getMac());
            }
            if (!e.a(briefDeviceDTO.getModel(), briefDeviceDTO.getHwVersion(), deviceWhitelist)) {
                macSetToForget.add(briefDeviceDTO.getMac());
                if (DeviceTypeEnum.b.c(briefDeviceDTO.getType())) {
                    notInWhitelistModelSet.add(briefDeviceDTO.getHwVersion());
                } else {
                    notInWhitelistModelSet.add(briefDeviceDTO.getModel() + " v" + briefDeviceDTO.getHwVersion());
                }
            }
            if (restoreSelf || !Boolean.TRUE.equals(briefDeviceDTO.getAddInAdv())) continue;
            macSetToForget.add(briefDeviceDTO.getMac());
        }
        DeviceBriefRestoreCacheDTO cacheDTO = new DeviceBriefRestoreCacheDTO();
        cacheDTO.setBriefDevicesInFile(briefDevicesInFile);
        cacheDTO.setMacsToForget(macSetToForget);
        restoreCacheMap.put(d.i.A(), cacheDTO);
        Boolean skipConfirmWhitelist = (Boolean)restoreCacheMap.get("skipConfirm");
        if (Boolean.TRUE.equals(skipConfirmWhitelist)) {
            return;
        }
        if (!CollectionUtils.isEmpty(notInWhitelistModelSet)) {
            log.info("restore DeviceBrief, notInWhitelistModelSet {}, mspId {}", notInWhitelistModelSet, (Object)mspId);
            restoreCacheMap.put("notInWhitelist", notInWhitelistModelSet);
        }
    }

    public void restorePreloadCache(c mspId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        try {
            Set<Object> allowedDeviceMacs;
            DeviceBriefRestoreCacheDTO cacheDTO = (DeviceBriefRestoreCacheDTO)restoreCacheMap.get(d.i.A());
            if (cacheDTO == null) {
                log.warn("DeviceBrief restore preload cache dto is null, mspId {}", (Object)mspId.a());
                return;
            }
            List<BriefDeviceDTO> briefDevicesInFile = cacheDTO.getBriefDevicesInFile();
            Set<String> macsToForget = cacheDTO.getMacsToForget();
            boolean skipDevice = Boolean.TRUE.equals(restoreCacheMap.get("skipDevice"));
            if (skipDevice) {
                allowedDeviceMacs = Collections.emptySet();
                macsToForget.addAll(Optional.ofNullable(briefDevicesInFile).map(briefDevicesInFileList -> briefDevicesInFileList.stream().map(BriefDeviceDTO::getMac).collect(Collectors.toSet())).orElse(Collections.emptySet()));
            } else {
                allowedDeviceMacs = this.getAllowedDeviceMacs(briefDevicesInFile, macsToForget, mspId.a());
            }
            restoreCacheMap.put(d.i.A(), macsToForget);
            this.maintenancelMeters.a(allowedDeviceMacs.size());
            log.debug("restore msp {} allowedDeviceMacs {}", (Object)mspId.a(), allowedDeviceMacs);
            UserDTO currentUser = (UserDTO)restoreCacheMap.get("currentUser");
            if (currentUser != null) {
                cacheDTO.getCurrentCustomerIds().forEach(customerId -> {
                    if (!this.forgetAllDevice(new c(customerId), currentUser, allowedDeviceMacs, cacheDTO.getSiteNameMap())) {
                        throw new com.tplink.smb.omada.backup.api.d.c("failed forgetAllDevice");
                    }
                });
            }
            cacheDTO.getCurrentCustomerIds().forEach(customerId -> this.deleteAllData(new c(customerId)));
        }
        catch (Exception e2) {
            log.warn(e2.getMessage(), (Throwable)e2);
        }
    }

    public void afterCompatible(c mspId, Map<String, Object> restoreCacheMap) {
        Set deviceMacsToForget = (Set)restoreCacheMap.get(d.i.A());
        Set newCustomerIds = this.omadacMaintMongoRepository.b(new b(mspId.a()));
        if (!CollectionUtils.isEmpty((Collection)deviceMacsToForget)) {
            newCustomerIds.forEach(omadacId -> this.forgetNotInWhitelistDeviceService.a(new c(omadacId), deviceMacsToForget));
        }
        DeviceBriefRestoreCacheDTO cacheDTO = (DeviceBriefRestoreCacheDTO)restoreCacheMap.get("oldCustomerIds");
        Set<String> oldCustomerIds = cacheDTO.getCurrentCustomerIds();
        oldCustomerIds.forEach(omadaId -> {
            if (!newCustomerIds.contains(omadaId)) {
                this.licenseInternalApiService.a(new RecycleCustomerLicenseDTO(mspId.a(), omadaId));
            }
        });
    }

    private void deleteAllData(c omadacId) {
        this.deleteAllDataService.a(omadacId);
    }

    private boolean forgetAllDevice(c omadacId, UserDTO currentUser, Set<String> allowedDeviceMacs, Map<String, String> siteNampMap) {
        try {
            UserInfoDTO userInfoDTO = UserInfoDTO.userOperateInfo((String)currentUser.getRoleTypeName(), (String)currentUser.getUsernameOrCloudAccount().orElse(null));
            ForgetByRestoreRequest request = new ForgetByRestoreRequest(omadacId.a(), null, allowedDeviceMacs, userInfoDTO, siteNampMap);
            com.tplink.smb.omada.manager.device.api.internal.a.a.b response = (com.tplink.smb.omada.manager.device.api.internal.a.a.b)this.deviceInternalApiService.a(request).blockingGet();
            return response.a();
        }
        catch (Exception e2) {
            log.warn("restore forgetAllDevice {} failed,", (Object)omadacId, (Object)e2);
            return false;
        }
    }

    private Set<String> getAllowedDeviceMacs(List<BriefDeviceDTO> briefDevicesInFile, Set<String> macsToForget, String omadacId) {
        HashSet<String> allowedDeviceMacs = new HashSet<String>();
        if (CollectionUtils.isEmpty(briefDevicesInFile)) {
            return allowedDeviceMacs;
        }
        Comparator<BriefDeviceDTO> byType = Comparator.comparing(BriefDeviceDTO::getType);
        Comparator<BriefDeviceDTO> byLastSeen = Comparator.comparing(BriefDeviceDTO::getLastSeen).reversed();
        briefDevicesInFile.sort(byType.thenComparing(byLastSeen));
        int apNum = 0;
        int switchNum = 0;
        int gatewayNum = 0;
        int deviceNum = 0;
        if (OmadacType.y()) {
            for (BriefDeviceDTO briefDevice : briefDevicesInFile) {
                if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.b.b())) {
                    if (++gatewayNum > com.tplink.smb.omada.common.omadac.config.a.b.v()) {
                        macsToForget.add(briefDevice.getMac());
                        continue;
                    }
                } else {
                    if (DeviceTypeEnum.d.b().equals(briefDevice.getType())) {
                        deviceNum += 4;
                    }
                    if (++deviceNum > com.tplink.smb.omada.common.omadac.config.a.b.s()) {
                        macsToForget.add(briefDevice.getMac());
                        continue;
                    }
                }
                allowedDeviceMacs.add(briefDevice.getMac());
            }
            return allowedDeviceMacs;
        }
        for (BriefDeviceDTO briefDevice : briefDevicesInFile) {
            if (++deviceNum > com.tplink.smb.omada.common.omadac.config.a.b.a((String)omadacId)) {
                macsToForget.add(briefDevice.getMac());
                continue;
            }
            if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.a.b())) {
                if (++apNum > com.tplink.smb.omada.common.omadac.config.a.b.t()) {
                    macsToForget.add(briefDevice.getMac());
                    continue;
                }
            } else if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.c.b())) {
                if (++switchNum > com.tplink.smb.omada.common.omadac.config.a.b.u()) {
                    macsToForget.add(briefDevice.getMac());
                    continue;
                }
            } else if (Objects.equals(briefDevice.getType(), DeviceTypeEnum.b.b()) && ++gatewayNum > com.tplink.smb.omada.common.omadac.config.a.b.v()) {
                macsToForget.add(briefDevice.getMac());
                continue;
            }
            allowedDeviceMacs.add(briefDevice.getMac());
        }
        return allowedDeviceMacs;
    }
}

