/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.msp.mspconfig.mspuser.restore;

import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CloudUsersDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.DistributeCustomerPrivilegeForDefaultDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.port.mongo.j;
import com.tplink.smb.omada.identityaccess.port.mongo.k;
import com.tplink.smb.omada.identityaccess.port.mongo.tenant.TenantPO;
import com.tplink.smb.omada.identityaccess.port.mongo.user.UserPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51000, b=d.MSP_USER_INFO)
public class MspUserRestoreUnitV51000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspUserRestoreUnitV51000.class);
    private static final MspUserRestoreUnitV51000 instance = new MspUserRestoreUnitV51000();
    private static final String IS_MASTER_ADMIN = "is_master_admin";
    private final k userOperatorMaintMongoRepository = k.a();
    private final g identityAccessInternalApiService = (g)a.b(g.class);
    private final j tenantMaintMongoRepository = j.a();

    private MspUserRestoreUnitV51000() {
    }

    public static MspUserRestoreUnitV51000 getInstance() {
        return instance;
    }

    public void beforeRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        List clearUsers = this.userOperatorMaintMongoRepository.a(omadacId, UserTypeEnumDTO.CLOUD_USER);
        if (!CollectionUtils.isEmpty((Collection)clearUsers)) {
            List cloudUserDTOS = clearUsers.stream().map(com.tplink.smb.omada.backup.core.unit.globalconfig.user.restore.a.a::a).collect(Collectors.toList());
            this.identityAccessInternalApiService.a(CloudUsersDTO.builder().cloudUserDTOS(cloudUserDTOS).build());
        }
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List restoreUsers = jsonParserWrapper.b(UserPO.class);
        restoreCacheMap.put(d.h.A(), restoreUsers);
    }

    public void restorePreloadCache(c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        List restoreUsers = (List)((Object)restoreCacheMap.getOrDefault(d.h.A(), new HashMap()));
        Map roleIdMap = restoreCacheMap.getOrDefault("roleIdMap", new HashMap());
        Map tenantIdMap = restoreCacheMap.getOrDefault("tenantIdMap", new HashMap());
        Map idpIdMap = restoreCacheMap.getOrDefault("idpIdMap", new HashMap());
        HashMap<String, String> userIdMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)restoreUsers)) {
            restoreUsers.forEach(userPO -> {
                String oldId = userPO.getId();
                if (OmadacType.s() && Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), userPO.getUserType())) {
                    return;
                }
                if (Objects.equals(UserTypeEnumDTO.EXTERNAL_USER.getValue(), userPO.getUserType())) {
                    TenantPO tenantPO2 = new TenantPO().setName(userPO.getName()).setType(Integer.valueOf(UserTypeEnumDTO.EXTERNAL_USER.getValue())).setMsps(Collections.singleton(omadacId.a())).setCreatedTime(Calendar.getInstance().getTime());
                    TenantPO nTenantPO = this.tenantMaintMongoRepository.a(tenantPO2);
                    userPO.setOmadacId(omadacId.a());
                    userPO.setId(null);
                    userPO.setRoleId(roleIdMap.getOrDefault(userPO.getRoleId(), "msp_viewer_id"));
                    userPO.setCustomerRoleId(roleIdMap.getOrDefault(userPO.getCustomerRoleId(), "customer_viewer_id"));
                    userPO.setTenantId(nTenantPO.getId());
                    if (StringUtils.isNotBlank((CharSequence)userPO.getIdpId())) {
                        userPO.setIdpId((String)idpIdMap.get(userPO.getIdpId()));
                    }
                    String newId = this.userOperatorMaintMongoRepository.a(userPO).getId();
                    userIdMap.put(oldId, newId);
                    return;
                }
                String tenantId = (String)tenantIdMap.get(userPO.getTenantId());
                if (tenantId == null) {
                    log.error("Find no mapped tenant for msp user, mspId={}", (Object)omadacId.a());
                    return;
                }
                if (!this.userOperatorMaintMongoRepository.e(omadacId, tenantId) && !"msp_master_admin_id".equals(userPO.getRoleId())) {
                    userPO.setOmadacId(omadacId.a());
                    userPO.setId(null);
                    userPO.setRoleId(roleIdMap.getOrDefault(userPO.getRoleId(), "msp_viewer_id"));
                    userPO.setCustomerRoleId(roleIdMap.getOrDefault(userPO.getCustomerRoleId(), "customer_viewer_id"));
                    userPO.setTenantId(tenantId);
                    String newId = this.userOperatorMaintMongoRepository.a(userPO).getId();
                    this.tenantMaintMongoRepository.g(tenantId).ifPresent(tenantPO -> {
                        Set msps = Optional.ofNullable(tenantPO.getMsps()).orElse(new HashSet());
                        msps.add(omadacId.a());
                        tenantPO.setMsps(msps);
                        this.tenantMaintMongoRepository.a(tenantPO);
                    });
                    userIdMap.put(oldId, newId);
                }
            });
        }
        restoreCacheMap.put("userIdMap", userIdMap);
        this.updateParentUserIdAndParentExternalUserId(omadacId, userIdMap);
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
        List userList;
        List restoreUsers = (List)restoreCacheMap.get(d.h.A());
        ArrayList bindUsers = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)restoreUsers)) {
            restoreUsers.forEach(userPO -> {
                if (Objects.equals(UserTypeEnumDTO.CLOUD_USER.getValue(), userPO.getUserType()) && Boolean.TRUE.equals(userPO.getVerified()) && !"msp_master_admin_id".equals(userPO.getRoleId())) {
                    bindUsers.add(com.tplink.smb.omada.backup.core.unit.globalconfig.user.restore.a.a.a(userPO));
                }
            });
        }
        if (!bindUsers.isEmpty()) {
            this.identityAccessInternalApiService.c(CloudUsersDTO.builder().omadacId(omadacId.a()).cloudUserDTOS(bindUsers).build());
        }
        if (!CollectionUtils.isEmpty((Collection)(userList = this.userOperatorMaintMongoRepository.b(omadacId, UserTypeEnumDTO.EXTERNAL_USER)))) {
            Map externalUserGroupIdMap = restoreCacheMap.getOrDefault("externalUserGroupIdMap", new HashMap(2));
            userList.forEach(userPO -> {
                if (StringUtils.isNotBlank((CharSequence)userPO.getExternalUserGroupId())) {
                    userPO.setExternalUserGroupId((String)externalUserGroupIdMap.get(userPO.getExternalUserGroupId()));
                }
            });
        }
        this.userOperatorMaintMongoRepository.a(userList);
    }

    public void afterCompatible(c omadacId, Map<String, Object> restoreCacheMap) {
        Map customerIdMap = (Map)restoreCacheMap.computeIfAbsent("customerIdMap", k2 -> new HashMap());
        this.identityAccessInternalApiService.a(new DistributeCustomerPrivilegeForDefaultDTO(omadacId.a(), customerIdMap));
    }

    private void updateParentUserIdAndParentExternalUserId(c omadacId, Map<String, String> userIdMap) {
        List userPOs = this.userOperatorMaintMongoRepository.a(omadacId);
        userPOs.forEach(userPO -> {
            if (StringUtils.isNotBlank((CharSequence)userPO.getParentExternalUserId())) {
                userPO.setParentExternalUserId((String)userIdMap.get(userPO.getParentExternalUserId()));
            }
            if (StringUtils.isNotBlank((CharSequence)userPO.getParentUserId()) && !Objects.equals(IS_MASTER_ADMIN, userPO.getParentUserId())) {
                userPO.setParentUserId(userIdMap.get(userPO.getParentUserId()) == null ? IS_MASTER_ADMIN : (String)userIdMap.get(userPO.getParentUserId()));
            }
        });
        for (UserPO userPO2 : userPOs) {
            this.userOperatorMaintMongoRepository.a(userPO2);
        }
    }
}

