/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.msp.mspconfig.mspsetting.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.deprecated.msp.mspconfig.mspsetting.MspBKDTO;
import com.tplink.smb.omada.backup.core.unit.deprecated.msp.mspconfig.mspsetting.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.b.c;
import com.tplink.smb.omada.maintenance.domain.model.d.b;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.RestoreGeneralSettingDTO;
import com.tplink.smb.omada.manager.port.mongo.configuration.msp.MspSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.OmadacPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.webui.PrivateLabelingPO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51000, b=d.MSP_SETTING)
public class MspSettingRestoreUnitV51000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MspSettingRestoreUnitV51000.class);
    private static final MspSettingRestoreUnitV51000 instance = new MspSettingRestoreUnitV51000();
    private final b maintenanceMspSettingRepository = (b)com.tplink.smb.omada.common.spring.a.b(b.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c omadacSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.c.a();
    private final com.tplink.smb.omada.manager.configuration.api.internal.omadac.b omadacInternalApiService = (com.tplink.smb.omada.manager.configuration.api.internal.omadac.b)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.manager.configuration.api.internal.omadac.b.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.b mspSettingMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.b.a();
    private final FileRepository fileRepository = (FileRepository)com.tplink.smb.omada.common.spring.a.b(FileRepository.class);

    private MspSettingRestoreUnitV51000() {
    }

    public static MspSettingRestoreUnitV51000 getInstance() {
        return instance;
    }

    public void beforeRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
    }

    public void restorePreloadCache(com.tplink.smb.omada.maintenance.common.b.a.a.c mspId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        MspBKDTO mspBKDTO = (MspBKDTO)restoreCacheMap.get(d.d.A());
        if (mspBKDTO == null) {
            log.debug("No OmadacBKDTO exists, current mspId is {}.", (Object)mspId.a());
            throw new com.tplink.smb.omada.common.h.c("Find no msp setting");
        }
        restoreCacheMap.put("mspId", mspId.a());
        OmadacPO omadacPO = a.b(mspBKDTO);
        omadacPO.setId(mspId.a());
        omadacPO.setStartTime(this.omadacSettingMaintMongoRepository.a(mspId).map(OmadacPO::getStartTime).orElse(System.currentTimeMillis()));
        String category = Optional.ofNullable(restoreCacheMap.get("omadaCategory")).orElse(com.tplink.smb.omada.common.f.b.d.a()).toString();
        omadacPO.setCategory(category);
        omadacPO.setPattern(Integer.valueOf(com.tplink.smb.omada.common.f.c.b.a()));
        this.omadacSettingMaintMongoRepository.a(omadacPO);
        MspSettingPO mspSettingPO = a.a(mspBKDTO);
        mspSettingPO.setOmadacId(mspId.a());
        this.mspSettingMaintMongoRepository.a(mspSettingPO);
        com.tplink.smb.omada.maintenance.domain.model.f.b dataRetentionSetting = Optional.ofNullable(mspBKDTO.getHistoryRetention()).map(a::a).orElse(com.tplink.smb.omada.maintenance.domain.model.f.b.a());
        Boolean clientDataEnable = Optional.ofNullable(mspBKDTO.getHistoryRetention()).map(MspBKDTO.HistoryRetentionBKDTO::getClientsDataEnable).orElse(false);
        boolean clientStatEnable = Optional.ofNullable(mspBKDTO.getHistoryRetention()).map(MspBKDTO.HistoryRetentionBKDTO::getClientStatEnable).orElse(false);
        dataRetentionSetting = com.tplink.smb.omada.maintenance.domain.model.f.b.b((com.tplink.smb.omada.maintenance.domain.model.f.b)dataRetentionSetting);
        restoreCacheMap.put("retention", dataRetentionSetting);
        this.maintenanceMspSettingRepository.a(mspId.a(), dataRetentionSetting, clientDataEnable.booleanValue(), clientStatEnable);
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        jsonParserWrapper.c();
        jsonParserWrapper.c();
        MspBKDTO mspBKDTO = (MspBKDTO)jsonParserWrapper.a(MspBKDTO.class);
        this.restoreFileData(jsonParserWrapper, omadacId, mspBKDTO);
        Optional optionalMspSettingPO = this.mspSettingMaintMongoRepository.a(omadacId);
        if (!optionalMspSettingPO.isPresent()) {
            log.warn("Find no mspId= {} while restore mspSetting.", (Object)omadacId);
            restoreCacheMap.put(d.d.A(), mspBKDTO);
        } else {
            MspSettingPO mspSettingPO = (MspSettingPO)optionalMspSettingPO.get();
            if (Objects.nonNull(mspBKDTO.getPrivateLabeling())) {
                mspSettingPO.setPrivateLabeling(new PrivateLabelingPO().setEnable(mspBKDTO.getPrivateLabeling().getEnable()).setFileName(mspBKDTO.getPrivateLabeling().getFileName()).setLabelUrl(mspBKDTO.getPrivateLabeling().getLabelUrl()).setMd5(mspBKDTO.getPrivateLabeling().getMd5()).setLength(mspBKDTO.getPrivateLabeling().getLength()).setLabelFileId(mspBKDTO.getPrivateLabeling().getLabelFileId()));
            }
            this.mspSettingMaintMongoRepository.a(mspSettingPO);
            restoreCacheMap.put(d.d.A(), mspBKDTO);
        }
    }

    public void afterRestore(com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) {
        Optional optionalOmadacPO = this.omadacSettingMaintMongoRepository.a(omadacId);
        if (!optionalOmadacPO.isPresent()) {
            throw new com.tplink.smb.omada.common.h.c("Fail to find msp");
        }
        OmadacPO omadacPO = (OmadacPO)optionalOmadacPO.get();
        RestoreGeneralSettingDTO dto = RestoreGeneralSettingDTO.builder().omadacId(omadacPO.getId()).timeZone(omadacPO.getTimeZone()).omadacName(omadacPO.getName()).pattern(Integer.valueOf(com.tplink.smb.omada.common.f.c.b.a())).build();
        Map customerIdMap = (Map)restoreCacheMap.get("customerIdMap");
        if (customerIdMap != null && !customerIdMap.isEmpty()) {
            dto.setCustomers(new HashSet(customerIdMap.values()));
            omadacPO.setCustomers(new HashSet(customerIdMap.values()));
            this.omadacSettingMaintMongoRepository.a(omadacPO);
        }
        dto.setPattern(Integer.valueOf(com.tplink.smb.omada.common.f.c.b.a()));
        OperationResponse response = this.omadacInternalApiService.a(dto);
        if (!response.success()) {
            log.warn("failed to modify omada cloud general setting on restore. omadac:{}", (Object)omadacPO.getId());
        }
    }

    private void restoreFileData(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, MspBKDTO mspBKDTO) {
        MspBKDTO.PrivateLabelingBKDTO privateLabelingBKDTO = mspBKDTO.getPrivateLabeling();
        try {
            JsonParser jsonParser = jsonParserWrapper.h();
            jsonParser.nextToken();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (!jsonParser.currentToken().equals((Object)JsonToken.FIELD_NAME)) continue;
                String fileData = jsonParser.nextTextValue();
                if (T.a((String)fileData)) {
                    log.warn("private labeling fileData could not be found in msp {}", (Object)omadacId);
                    mspBKDTO.setPrivateLabeling(new MspBKDTO.PrivateLabelingBKDTO().setEnable(false));
                    continue;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(c.b((String)fileData));
                String newFileId = this.fileRepository.saveFile(omadacId.a(), null, privateLabelingBKDTO.getFileName(), (InputStream)in);
                if (T.a((String)newFileId)) {
                    log.warn("Fail to save picture in msp {}, ignore it", (Object)omadacId);
                    mspBKDTO.setPrivateLabeling(new MspBKDTO.PrivateLabelingBKDTO().setEnable(false));
                    continue;
                }
                privateLabelingBKDTO.setLabelFileId(newFileId);
                mspBKDTO.setPrivateLabeling(privateLabelingBKDTO);
            }
            jsonParser.nextToken();
        }
        catch (Exception e2) {
            log.warn("V51000 failed to restore private labeling in msp {}, error message:{}", (Object)omadacId.a(), (Object)e2.getMessage());
            throw new com.tplink.smb.omada.backup.api.d.c("Failed to restore private labeling file data");
        }
    }
}

