/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.data.sitedata.wids;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.d.c;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.monitor.port.mongo.insight.wids.WidsDataPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V51000, b=d.WIDS_DATA_SLICED)
public class WidsDataSlicedRestoreUnitV51000
extends com.tplink.smb.omada.backup.api.b {
    private static final Logger log = LoggerFactory.getLogger(WidsDataSlicedRestoreUnitV51000.class);
    private final com.tplink.smb.omada.monitor.port.mongo.a.a.c widsDataMaintMongoRepository = com.tplink.smb.omada.monitor.port.mongo.a.a.c.a();
    private static final WidsDataSlicedRestoreUnitV51000 instance = new WidsDataSlicedRestoreUnitV51000();

    private WidsDataSlicedRestoreUnitV51000() {
    }

    public static WidsDataSlicedRestoreUnitV51000 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, c {
        JsonParser jsonParser = jsonParserWrapper.h();
        if (OmadacType.s()) {
            jsonParser.nextToken();
            jsonParser.skipChildren();
            log.info("Current is CBC, Skip restore {}", (Object)d.cv);
            return;
        }
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (!"collections".equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restring {} - Skip unknown JSON member: {}", (Object)d.cv, (Object)name);
                continue;
            }
            log.debug("Restoring {} - Found JSON member: {}, promote restore", (Object)d.cv, (Object)"collections");
            while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
                if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
                String collectionName = jsonParser.getText();
                if (collectionName.startsWith("widsdata")) {
                    log.debug("Restoring {}.{} - Found JSON member: {}, promote restore", new Object[]{d.cv.A(), "collections", collectionName});
                    this.restore(collectionName, omadacId, restoreCacheMap, jsonParser);
                    continue;
                }
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restring {}.{} - Skip unknown JSON member : {}", new Object[]{d.cv.A(), "collections", collectionName});
            }
        }
    }

    private void restore(String collectionName, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap, JsonParser jsonParser) throws IOException {
        jsonParser.nextToken();
        ArrayList<WidsDataPO> widsDataPOList = new ArrayList<WidsDataPO>(1000);
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        long existCount = this.widsDataMaintMongoRepository.a(omadacId);
        long restoreLimit = (long)com.tplink.smb.omada.common.omadac.config.a.b.c() - existCount;
        long count = 0L;
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            WidsDataPO widsData = (WidsDataPO)jsonParser.readValueAs(WidsDataPO.class);
            if (count >= restoreLimit || skipData) continue;
            widsData.setId(null);
            widsData.setOmadacId(omadacId.a());
            String newSiteId = (String)siteMap.get(widsData.getSiteId());
            if (newSiteId == null) {
                log.warn("Restoring clientHistory: Cannot find mapped siteId, omadacId={}, widsData: {}", (Object)omadacId, (Object)widsData);
                return;
            }
            widsData.setSiteId(newSiteId);
            widsDataPOList.add(widsData);
            ++count;
            if (widsDataPOList.size() < 1000) continue;
            this.widsDataMaintMongoRepository.a(omadacId, widsDataPOList, collectionName);
            widsDataPOList.clear();
        }
        this.widsDataMaintMongoRepository.a(omadacId, widsDataPOList, collectionName);
    }
}

