/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.data.sitedata.ssidstat.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.deprecated.data.sitedata.c;
import com.tplink.smb.omada.common.constant.J;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.monitor.port.mongo.a.d.f.a;
import com.tplink.smb.omada.monitor.port.mongo.a.d.f.d;
import com.tplink.smb.omada.monitor.port.mongo.statistic.ssid.BaseSsidStatPO;
import com.tplink.smb.omada.monitor.port.mongo.statistic.ssid.daily.SsidStatDailyPO;
import com.tplink.smb.omada.monitor.port.mongo.statistic.ssid.fivemin.SsidStat5MinPO;
import com.tplink.smb.omada.monitor.port.mongo.statistic.ssid.hourly.SsidStatHourlyPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@com.tplink.smb.omada.backup.api.a.c(a=l.V50500, b=com.tplink.smb.omada.backup.api.c.d.SSID_STAT)
public class SsidStatRestoreUnitV50500
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SsidStatRestoreUnitV50500.class);
    @Autowired
    private com.tplink.smb.omada.monitor.port.mongo.a.d.f.b ssidStat5MinMaintMongoRepository;
    @Autowired
    private d ssidStatHourlyMaintMongoRepository;
    @Autowired
    private com.tplink.smb.omada.monitor.port.mongo.a.d.f.c ssidStatDailyMaintMongoRepository;

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        if (OmadacType.s()) {
            jsonParser.nextToken();
            jsonParser.skipChildren();
            return;
        }
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (!"collections".equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                continue;
            }
            while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
                if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
                String collectionName = jsonParser.getText();
                com.tplink.smb.omada.maintenance.domain.model.f.b retentionSetting = (com.tplink.smb.omada.maintenance.domain.model.f.b)restoreCacheMap.get("retention");
                if (collectionName.startsWith("ssidstat5min")) {
                    if (c.a(collectionName)) {
                        jsonParser.nextToken();
                        jsonParser.skipChildren();
                        log.info("Skipped restore {}, data older than 2days", (Object)collectionName);
                        continue;
                    }
                    int retention5Min = Optional.ofNullable(retentionSetting.i()).orElse(2);
                    this.restore(collectionName, (a)this.ssidStat5MinMaintMongoRepository, omadacId, restoreCacheMap, jsonParser, (Class)SsidStat5MinPO.class, this.getDataLimit5Min(), this.getDaysLimit5Min(), retention5Min);
                    continue;
                }
                if (collectionName.startsWith("ssidstathourly")) {
                    if (c.b(collectionName)) {
                        jsonParser.nextToken();
                        jsonParser.skipChildren();
                        log.info("Skipped restore {}, data older than 7days", (Object)collectionName);
                        continue;
                    }
                    int retentionHourly = Optional.ofNullable(retentionSetting.k()).orElse(7);
                    this.restore(collectionName, (a)this.ssidStatHourlyMaintMongoRepository, omadacId, restoreCacheMap, jsonParser, (Class)SsidStatHourlyPO.class, this.getDataLimitHourly(), this.getDaysLimitHourly(), retentionHourly);
                    continue;
                }
                if (collectionName.startsWith("ssidstatdaily")) {
                    int retentionDaily = Optional.ofNullable(retentionSetting.l()).orElse(90);
                    this.restore(collectionName, (a)this.ssidStatDailyMaintMongoRepository, omadacId, restoreCacheMap, jsonParser, (Class)SsidStatDailyPO.class, this.getDataLimitDaily(), this.getDaysLimitDaily(), retentionDaily);
                    continue;
                }
                jsonParser.nextToken();
                jsonParser.skipChildren();
            }
        }
    }

    private <E extends BaseSsidStatPO> void restore(String collectionName, a<E> repository, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap, JsonParser jsonParser, Class<E> clazz, int dataLimit, int daysLimit, int retention) throws IOException {
        long existCount = repository.a(omadacId);
        long restoreLimit = (long)dataLimit - existCount;
        long count = 0L;
        Map siteCacheMap = (Map)restoreCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Q.A(), k2 -> new HashMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        int days = 0;
        days = retention != 0 && daysLimit != 0 ? Math.min(retention, daysLimit) : Math.max(retention, daysLimit);
        long timestamp = days > 0 ? System.currentTimeMillis() / 1000L - (long)days * 86400L : 0L;
        jsonParser.nextToken();
        ArrayList<BaseSsidStatPO> statPOList = new ArrayList<BaseSsidStatPO>(1000);
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            BaseSsidStatPO siteStatPO = (BaseSsidStatPO)jsonParser.readValueAs(clazz);
            if (skipData || siteStatPO.getTime() < timestamp || OmadacType.r() && count >= restoreLimit) continue;
            String siteId = (String)siteCacheMap.get(siteStatPO.getSiteId());
            siteStatPO.setOmadacId(omadacId.a());
            siteStatPO.setSiteId(siteId);
            siteStatPO.setId(null);
            statPOList.add(siteStatPO);
            ++count;
            if (statPOList.size() < 1000) continue;
            repository.a(statPOList, collectionName);
            statPOList.clear();
        }
        if (CollectionUtils.isEmpty(statPOList)) {
            return;
        }
        repository.a(statPOList, collectionName);
    }

    private int getDataLimit5Min() {
        return b.f((J)J.a) + b.i((J)J.a) + b.g((J)J.a);
    }

    private int getDataLimitHourly() {
        return b.f((J)J.c) + b.i((J)J.c) + b.g((J)J.c);
    }

    private int getDataLimitDaily() {
        return b.f((J)J.d) + b.i((J)J.d) + b.g((J)J.d);
    }

    private int getDaysLimit5Min() {
        return b.a((J)J.a);
    }

    private int getDaysLimitHourly() {
        return b.a((J)J.c);
    }

    private int getDaysLimitDaily() {
        return b.a((J)J.d);
    }
}

