/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.data.sitedata.ssidclientstat;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.deprecated.data.sitedata.c;
import com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.BaseSsidClientStatPO;
import com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.a;
import com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.daily.SsidClientStatDailyPO;
import com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.fivemin.SsidClientStat5MinPO;
import com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.hourly.SsidClientStatHourlyPO;
import com.tplink.smb.omada.common.constant.J;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.omadac.config.a.b;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50500, b=d.SSID_CLIENT_STAT)
public class SsidClientStatRestoreUnitV50500
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SsidClientStatRestoreUnitV50500.class);
    private static final SsidClientStatRestoreUnitV50500 instance = new SsidClientStatRestoreUnitV50500();
    private final com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.fivemin.a ssidClientStat5MinMaintMongoRepository = com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.fivemin.a.a();
    private final com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.hourly.a ssidClientStatHourlyMaintMongoRepository = com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.hourly.a.a();
    private final com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.daily.a ssidClientStatDailyMaintMongoRepository = com.tplink.smb.omada.client.port.mongo.data.statistic.ssidclientstat.daily.a.a();

    public static SsidClientStatRestoreUnitV50500 getInstance() {
        return instance;
    }

    private SsidClientStatRestoreUnitV50500() {
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        if (OmadacType.s()) {
            jsonParser.nextToken();
            jsonParser.skipChildren();
            return;
        }
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (!"collections".equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                continue;
            }
            while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
                if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
                String collectionName = jsonParser.getText();
                com.tplink.smb.omada.maintenance.domain.model.f.b retentionSetting = (com.tplink.smb.omada.maintenance.domain.model.f.b)restoreCacheMap.get("retention");
                if (collectionName.startsWith("ssidclient5min")) {
                    if (c.a(collectionName)) {
                        jsonParser.nextToken();
                        jsonParser.skipChildren();
                        log.info("Skipped restore {}, data older than 2days", (Object)collectionName);
                        continue;
                    }
                    int retention5Min = Optional.ofNullable(retentionSetting.i()).orElse(2);
                    this.restore(collectionName, (a)this.ssidClientStat5MinMaintMongoRepository, omadacId, restoreCacheMap, jsonParser, (Class)SsidClientStat5MinPO.class, this.getDataLimit5Min(), this.getDaysLimit5Min(), retention5Min);
                    continue;
                }
                if (collectionName.startsWith("ssidclienthourly")) {
                    if (c.b(collectionName)) {
                        log.info("Skipped restore {}, data older than 7days", (Object)collectionName);
                        jsonParser.nextToken();
                        jsonParser.skipChildren();
                        continue;
                    }
                    int retentionHourly = Optional.ofNullable(retentionSetting.k()).orElse(7);
                    this.restore(collectionName, (a)this.ssidClientStatHourlyMaintMongoRepository, omadacId, restoreCacheMap, jsonParser, (Class)SsidClientStatHourlyPO.class, this.getDataLimitHourly(), this.getDaysLimitHourly(), retentionHourly);
                    continue;
                }
                if (collectionName.startsWith("ssidclientdaily")) {
                    int retentionDaily = Optional.ofNullable(retentionSetting.l()).orElse(90);
                    this.restore(collectionName, (a)this.ssidClientStatDailyMaintMongoRepository, omadacId, restoreCacheMap, jsonParser, (Class)SsidClientStatDailyPO.class, this.getDataLimitDaily(), this.getDaysLimitDaily(), retentionDaily);
                    continue;
                }
                jsonParser.nextToken();
                jsonParser.skipChildren();
            }
        }
    }

    private <E extends BaseSsidClientStatPO> void restore(String collectionName, a<E> repository, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap, JsonParser jsonParser, Class<E> clazz, int dataLimit, int daysLimit, int retention) throws IOException {
        long existCount = repository.a(omadacId);
        long restoreLimit = (long)dataLimit - existCount;
        long count = 0L;
        Map siteCacheMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        int days = 0;
        days = retention != 0 && daysLimit != 0 ? Math.min(retention, daysLimit) : Math.max(retention, daysLimit);
        long timestamp = days > 0 ? System.currentTimeMillis() / 1000L - (long)days * 86400L : 0L;
        jsonParser.nextToken();
        ArrayList<BaseSsidClientStatPO> statPOList = new ArrayList<BaseSsidClientStatPO>(1000);
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            BaseSsidClientStatPO clientStatPO = (BaseSsidClientStatPO)jsonParser.readValueAs(clazz);
            if (skipData || clientStatPO.getTime() < timestamp || OmadacType.r() && count >= restoreLimit) continue;
            String siteId = (String)siteCacheMap.get(clientStatPO.getSiteId());
            clientStatPO.setOmadacId(omadacId.a());
            clientStatPO.setSiteId(siteId);
            clientStatPO.setId(null);
            statPOList.add(clientStatPO);
            ++count;
            if (statPOList.size() < 1000) continue;
            repository.a(statPOList, collectionName);
            statPOList.clear();
        }
        if (CollectionUtils.isEmpty(statPOList)) {
            return;
        }
        repository.a(statPOList, collectionName);
    }

    private int getDataLimit5Min() {
        if (OmadacType.q()) {
            return Integer.MAX_VALUE;
        }
        return b.f((J)J.a) + b.g((J)J.a);
    }

    private int getDataLimitHourly() {
        if (OmadacType.q()) {
            return Integer.MAX_VALUE;
        }
        return b.f((J)J.c) + b.g((J)J.c);
    }

    private int getDataLimitDaily() {
        if (OmadacType.q()) {
            return Integer.MAX_VALUE;
        }
        return b.f((J)J.d) + b.g((J)J.d);
    }

    private int getDaysLimit5Min() {
        return b.a((J)J.a);
    }

    private int getDaysLimitHourly() {
        return b.a((J)J.c);
    }

    private int getDaysLimitDaily() {
        return b.a((J)J.d);
    }
}

