/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.data.sitedata.deviceclientstat;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.BaseDeviceClientStatPO;
import com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.daily.DeviceClientStatDailyPO;
import com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.fivemin.DeviceClientStat5MinPO;
import com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.fivemin.a;
import com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.hourly.DeviceClientStatHourlyPO;
import com.tplink.smb.omada.common.constant.J;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.DEVICE_CLIENT_STAT)
public class DeviceClientStatRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    private final a deviceClientStat5MinRepository = a.b();
    private final com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.hourly.a deviceClientStatHourlyRepository = com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.hourly.a.b();
    private final com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.daily.a deviceClientStatDailyRepository = (com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.daily.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.daily.a.class);
    private static final DeviceClientStatRestoreUnitV50000 instance = new DeviceClientStatRestoreUnitV50000();

    private DeviceClientStatRestoreUnitV50000() {
    }

    public static DeviceClientStatRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            com.tplink.smb.omada.maintenance.domain.model.f.b retentionSetting = (com.tplink.smb.omada.maintenance.domain.model.f.b)restoreCacheMap.get("retention");
            if ("deviceClientStat5min".equals(name)) {
                int retention5Min = Optional.ofNullable(retentionSetting.i()).orElse(2);
                this.restore((com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.a)this.deviceClientStat5MinRepository, omadacId, restoreCacheMap, jsonParser, (Class)DeviceClientStat5MinPO.class, this.getDataLimit5Min(), this.getDaysLimit5Min(), retention5Min);
                continue;
            }
            if ("deviceClientStatHourly".equals(name)) {
                int retentionHourly = Optional.ofNullable(retentionSetting.k()).orElse(7);
                this.restore((com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.a)this.deviceClientStatHourlyRepository, omadacId, restoreCacheMap, jsonParser, (Class)DeviceClientStatHourlyPO.class, this.getDataLimitHourly(), this.getDaysLimitHourly(), retentionHourly);
                continue;
            }
            if (!"deviceClientStatDaily".equals(name)) continue;
            int retentionDaily = Optional.ofNullable(retentionSetting.l()).orElse(90);
            this.restore((com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.a)this.deviceClientStatDailyRepository, omadacId, restoreCacheMap, jsonParser, (Class)DeviceClientStatDailyPO.class, this.getDataLimitDaily(), this.getDaysLimitDaily(), retentionDaily);
        }
    }

    private <E extends BaseDeviceClientStatPO> void restore(com.tplink.smb.omada.client.port.mongo.data.statistic.deviceclientstat.a<E> repository, c omadacId, Map<String, Object> restoreCacheMap, JsonParser jsonParser, Class<E> clazz, int dataLimit, int daysLimit, int retention) throws IOException {
        long existCount = repository.b(omadacId);
        long restoreLimit = (long)dataLimit - existCount;
        long count = 0L;
        Map siteCacheMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), k2 -> new HashMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        int days = 0;
        days = retention != 0 && daysLimit != 0 ? Math.min(retention, daysLimit) : Math.max(retention, daysLimit);
        long timestamp = days > 0 ? System.currentTimeMillis() / 1000L - (long)days * 86400L : 0L;
        jsonParser.nextToken();
        ArrayList<BaseDeviceClientStatPO> statPOList = new ArrayList<BaseDeviceClientStatPO>(1000);
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            BaseDeviceClientStatPO clientStatPO = (BaseDeviceClientStatPO)jsonParser.readValueAs(clazz);
            if (skipData || clientStatPO.getTime() < timestamp || OmadacType.r() && count >= restoreLimit) continue;
            String siteId = (String)siteCacheMap.get(clientStatPO.getSiteId());
            clientStatPO.setOmadacId(omadacId.a());
            clientStatPO.setSiteId(siteId);
            clientStatPO.setId(null);
            statPOList.add(clientStatPO);
            ++count;
            if (statPOList.size() < 1000) continue;
            repository.a(statPOList);
            statPOList.clear();
        }
        if (CollectionUtils.isEmpty(statPOList)) {
            return;
        }
        repository.a(statPOList);
    }

    private int getDataLimit5Min() {
        return b.f((J)J.a) + b.i((J)J.a) + b.g((J)J.a);
    }

    private int getDataLimitHourly() {
        return b.f((J)J.c) + b.i((J)J.c) + b.g((J)J.c);
    }

    private int getDataLimitDaily() {
        return b.f((J)J.d) + b.i((J)J.d) + b.g((J)J.d);
    }

    private int getDaysLimit5Min() {
        return b.a((J)J.a);
    }

    private int getDaysLimitHourly() {
        return b.a((J)J.c);
    }

    private int getDaysLimitDaily() {
        return b.a((J)J.d);
    }
}

