/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.deprecated.data.globaldata.omadalog.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.d.g;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.internal.dto.NotificationSetDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.api.internal.e;
import com.tplink.smb.omada.logmanager.port.mongo.data.m;
import com.tplink.smb.omada.logmanager.port.mongo.log.OmadaLogPO;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50700, b=d.OMADA_LOG_SLICED)
public class OmadaLogSlicedRestoreUnitV50700
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadaLogSlicedRestoreUnitV50700.class);
    private final m omadaLogMaintMongoRepository = m.a();
    private final g logLimitService = (g)a.b(g.class);
    private final e logManagerInternalApiService = (e)a.b(e.class);
    private static final OmadaLogSlicedRestoreUnitV50700 instance = new OmadaLogSlicedRestoreUnitV50700();

    private OmadaLogSlicedRestoreUnitV50700() {
    }

    public static OmadaLogSlicedRestoreUnitV50700 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        JsonParser jsonParser = jsonParserWrapper.h();
        if (OmadacType.s()) {
            jsonParser.nextToken();
            jsonParser.skipChildren();
            log.info("Current is CBC, Skip restore {}", (Object)d.bV);
            return;
        }
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (!"collections".equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restring {} - Skip unknown JSON member: {}", (Object)d.bV, (Object)name);
                continue;
            }
            log.debug("Restoring {} - Found JSON member: {}, promote restore", (Object)d.bV, (Object)"collections");
            while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
                if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
                String collectionName = jsonParser.getText();
                if (collectionName.startsWith("omadalog")) {
                    log.debug("Restoring {}.{} - Found JSON member: {}, promote restore", new Object[]{d.bV.A(), "collections", collectionName});
                    this.restore(collectionName, omadacId, restoreCacheMap, jsonParser);
                    continue;
                }
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restring {}.{} - Skip unknown JSON member : {}", new Object[]{d.bV.A(), "collections", collectionName});
            }
        }
    }

    private void restore(String collectionName, c omadacId, Map<String, Object> restoreCacheMap, JsonParser jsonParser) throws IOException {
        long existCount = this.omadaLogMaintMongoRepository.d(omadacId);
        long restoreLimit = 0L;
        boolean limitCheck = false;
        switch (OmadacType.b()) {
            case LOCAL_OMADAC_WIN: {
                break;
            }
            case LOCAL_OMADAC_LINUX: {
                break;
            }
            case CLOUD_BASE: {
                break;
            }
            case OC200_V1: {
                limitCheck = true;
                restoreLimit = this.logLimitService.a(omadacId.a()) - existCount;
                break;
            }
            case OC300_V1: 
            case OC400_V1: {
                limitCheck = true;
                restoreLimit = this.logLimitService.a(omadacId.a()) - existCount;
                break;
            }
            case C5300_V1: {
                limitCheck = true;
                restoreLimit = this.logLimitService.a(omadacId.a()) - existCount;
                break;
            }
            case ER7212P: 
            case ER7212P_V2: {
                limitCheck = true;
                restoreLimit = this.logLimitService.a(omadacId.a()) - existCount;
                break;
            }
            case ER8411C: {
                limitCheck = true;
                restoreLimit = this.logLimitService.a(omadacId.a()) - existCount;
            }
        }
        long count = 0L;
        jsonParser.nextToken();
        Map siteMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        ArrayList<OmadaLogPO> omadaLogPOList = new ArrayList<OmadaLogPO>(1000);
        OmadaLogDTO omadacDTO = OmadaLogDTO.builder().omadacId(omadacId.a()).build();
        Map notificationMap = (Map)this.logManagerInternalApiService.b(omadacDTO).orElse(null);
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            try {
                OmadaLogPO omadaLogPO = (OmadaLogPO)jsonParser.readValueAs(OmadaLogPO.class);
                if (Objects.isNull(omadaLogPO) || limitCheck && count > restoreLimit || skipData) continue;
                omadaLogPO.setId(null);
                omadaLogPO.setOmadacId(omadacId.a());
                if (!T.a((String)omadaLogPO.getSiteId())) {
                    omadaLogPO.setSiteId((String)siteMap.get(omadaLogPO.getSiteId()));
                }
                String theOmadacId = omadaLogPO.getOmadacId();
                String theSiteId = omadaLogPO.getSiteId();
                if (Objects.isNull(omadaLogPO.getAlert()) && Objects.nonNull(notificationMap)) {
                    String key2 = T.c((String)theSiteId) ? theOmadacId : theOmadacId + theSiteId;
                    NotificationSetDTO notificationSetDTO = (NotificationSetDTO)notificationMap.get(key2);
                    Set alerts = notificationSetDTO.getAlerts();
                    Set events = notificationSetDTO.getEvents();
                    omadaLogPO.setAlert(Boolean.valueOf(alerts.contains(omadaLogPO.getKey())));
                    omadaLogPO.setEvent(Boolean.valueOf(events.contains(omadaLogPO.getKey())));
                }
                omadaLogPOList.add(omadaLogPO);
                ++count;
                if (omadaLogPOList.size() < 1000) continue;
                this.omadaLogMaintMongoRepository.a(omadacId, omadaLogPOList, collectionName);
                omadaLogPOList.clear();
            }
            catch (IOException e2) {
                throw e2;
            }
            catch (Exception e2) {
                log.warn("Log restore exception, skip single data, restore continue, omadacId={}", (Object)omadacId, (Object)e2);
            }
        }
        this.omadaLogMaintMongoRepository.a(omadacId, omadaLogPOList, collectionName);
    }
}

