/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.data.ppskrecord;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.d.c;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.portal.port.mongo.data.ppskrecord.PPSKRecordMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.data.ppskrecord.PpskRegisterRecordPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V60100, b=d.PPSK_RECORD)
public class PPSKRecordRestoreUnitV60100
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PPSKRecordRestoreUnitV60100.class);
    private static final PPSKRecordRestoreUnitV60100 instance = new PPSKRecordRestoreUnitV60100();
    private final PPSKRecordMaintRepository repository = PPSKRecordMaintRepository.getInstance();

    private PPSKRecordRestoreUnitV60100() {
    }

    public static PPSKRecordRestoreUnitV60100 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, com.tplink.smb.omada.maintenance.common.b.a.a.c omadacId, Map<String, Object> restoreCacheMap) throws IOException, c {
        Map siteIdMap = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap());
        Map ssidIdMap = restoreCacheMap.getOrDefault(d.ag.A(), Collections.emptyMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        JsonParser jsonParser = jsonParserWrapper.h();
        long existCount = this.repository.countByOmadacId(omadacId);
        long restoreLimit = (long)com.tplink.smb.omada.common.omadac.config.a.b.k() - existCount;
        long count = 0L;
        jsonParser.nextToken();
        ArrayList<PpskRegisterRecordPO> poList = new ArrayList<PpskRegisterRecordPO>(1000);
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            PpskRegisterRecordPO po = (PpskRegisterRecordPO)jsonParser.readValueAs(PpskRegisterRecordPO.class);
            if (count >= restoreLimit || skipData) continue;
            String currentSiteId = (String)siteIdMap.get(po.getSiteId());
            if (currentSiteId == null) {
                log.warn("Restoring ppsk record: Cannot find mapped siteId by v5 backup ppsk record: {}", (Object)po);
                continue;
            }
            po.setSiteId(currentSiteId);
            po.setSsidId((String)Optional.ofNullable(po.getSsidId()).map(ssidIdMap::get).orElse(null));
            poList.add(po);
            ++count;
            if (poList.size() < 1000) continue;
            this.repository.insertAll(poList);
            poList.clear();
        }
        this.repository.insertAll(poList);
    }
}

