/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.data.firmwareupgrade.restore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.api.e.b;
import com.tplink.smb.omada.backup.core.unit.globalconfig.firmwareupgrade.a;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.UpgradeLogPO;
import com.tplink.smb.omada.manager.port.mongo.device.upgrade.r;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V514300, b=d.FIRMWARE_UPGRADE_LOG_SLICED)
public class FirmwareUpgradeLogRestoreUnitV514300
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmwareUpgradeLogRestoreUnitV514300.class);
    private final r upgradeLogMaintMongoRepository = (r)com.tplink.smb.omada.common.spring.a.b(r.class);
    private static final FirmwareUpgradeLogRestoreUnitV514300 instance = new FirmwareUpgradeLogRestoreUnitV514300();

    private FirmwareUpgradeLogRestoreUnitV514300() {
    }

    public static FirmwareUpgradeLogRestoreUnitV514300 getInstance() {
        return instance;
    }

    public void restore(b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        log.debug("restore firmwareUpgradeData");
        JsonParser jsonParser = jsonParserWrapper.h();
        while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
            if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
            String name = jsonParser.getText();
            if (!"collections".equals(name)) {
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restring {} - Skip unknown JSON member: {}", (Object)d.bY, (Object)name);
                continue;
            }
            log.debug("Restoring {} - Found JSON member: {}, promote restore", (Object)d.bY, (Object)"collections");
            while (JsonToken.END_OBJECT != jsonParser.nextToken()) {
                if (JsonToken.FIELD_NAME != jsonParser.currentToken()) continue;
                String collectionName = jsonParser.getText();
                if (collectionName.startsWith("upgradelog")) {
                    log.debug("Restoring {}.{} - Found JSON member: {}, promote restore", new Object[]{d.bY.A(), "collections", collectionName});
                    this.restore(collectionName, omadacId, restoreCacheMap, jsonParser);
                    continue;
                }
                jsonParser.nextToken();
                jsonParser.skipChildren();
                log.debug("Restring {}.{} - Skip unknown JSON member : {}", new Object[]{d.bY.A(), "collections", collectionName});
            }
        }
    }

    private void restore(String collectionName, c omadacId, Map<String, Object> restoreCacheMap, JsonParser jsonParser) throws IOException {
        jsonParser.nextToken();
        Map siteIdMap = (Map)restoreCacheMap.computeIfAbsent(d.Q.A(), key -> new HashMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        if (skipData) {
            return;
        }
        ArrayList<UpgradeLogPO> upgradeLogPOList = new ArrayList<UpgradeLogPO>(1000);
        try {
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                UpgradeLogPO upgradeLogPO = (UpgradeLogPO)jsonParser.readValueAs(UpgradeLogPO.class);
                if (Objects.isNull(upgradeLogPO)) continue;
                upgradeLogPO.setId(a.a(upgradeLogPO.getId()));
                upgradeLogPO.setOmadacId(omadacId.a());
                List restoredSiteIds = upgradeLogPO.getSiteIds().stream().map(siteIdMap::get).collect(Collectors.toList());
                upgradeLogPO.setSiteIds(restoredSiteIds);
                if (!T.a((String)upgradeLogPO.getFirmwareId())) {
                    upgradeLogPO.setFirmwareId(null);
                }
                upgradeLogPO.setPlanId(null);
                upgradeLogPOList.add(upgradeLogPO);
                if (upgradeLogPOList.size() < 1000) continue;
                this.upgradeLogMaintMongoRepository.a(omadacId, upgradeLogPOList, collectionName);
                upgradeLogPOList.clear();
            }
        }
        catch (Exception e2) {
            log.error("Log restore exception, skip single data, restore continue, omadacId={}", (Object)omadacId, (Object)e2);
        }
        this.upgradeLogMaintMongoRepository.a(omadacId, upgradeLogPOList, collectionName);
    }

    public void afterRestore(c omadacId, Map<String, Object> restoreCacheMap) {
    }
}

