/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.unit.data.authrecord;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.tplink.smb.omada.backup.api.c.d;
import com.tplink.smb.omada.backup.api.c.l;
import com.tplink.smb.omada.backup.core.unit.data.authrecord.dto.AuthRecordBKDTO;
import com.tplink.smb.omada.common.omadac.config.a.b;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.portal.port.mongo.data.authrecord.AuthRecordMaintRepository;
import com.tplink.smb.omada.portal.port.mongo.data.authrecord.AuthRecordPO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.tplink.smb.omada.backup.api.a.c(a=l.V50000, b=d.AUTH_RECORD)
public class AuthRecordRestoreUnitV50000
extends com.tplink.smb.omada.backup.api.b {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthRecordRestoreUnitV50000.class);
    private final AuthRecordMaintRepository authRecordMaintRepository = AuthRecordMaintRepository.getInstance();
    private static final AuthRecordRestoreUnitV50000 instance = new AuthRecordRestoreUnitV50000();

    private AuthRecordRestoreUnitV50000() {
    }

    public static AuthRecordRestoreUnitV50000 getInstance() {
        return instance;
    }

    public void restore(com.tplink.smb.omada.backup.api.e.b jsonParserWrapper, c omadacId, Map<String, Object> restoreCacheMap) throws IOException, com.tplink.smb.omada.backup.api.d.c {
        Map siteIdMap = restoreCacheMap.getOrDefault(d.Q.A(), Collections.emptyMap());
        Map portalIdMap = restoreCacheMap.getOrDefault(d.ad.A(), Collections.emptyMap());
        Map wlanIdMap = restoreCacheMap.getOrDefault(d.ag.A(), Collections.emptyMap());
        Map ssidIdMap = restoreCacheMap.getOrDefault(d.ag.A(), Collections.emptyMap());
        Map networkIdMap = restoreCacheMap.getOrDefault(d.af.A(), Collections.emptyMap());
        boolean skipData = Boolean.TRUE.equals(restoreCacheMap.get("skipData"));
        JsonParser jsonParser = jsonParserWrapper.h();
        long existCount = this.authRecordMaintRepository.countByOmadacId(omadacId);
        long restoreLimit = (long)b.k() - existCount;
        long count = 0L;
        jsonParser.nextToken();
        ArrayList<AuthRecordPO> authRecordPOList = new ArrayList<AuthRecordPO>(1000);
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            AuthRecordBKDTO dto = (AuthRecordBKDTO)jsonParser.readValueAs(AuthRecordBKDTO.class);
            if (count >= restoreLimit || skipData) continue;
            String currentSiteId = (String)siteIdMap.get(dto.getSiteId());
            if (currentSiteId == null) {
                log.warn("Restoring AuthRecord: Cannot find mapped siteId by v5 backup authRecord: {}", (Object)dto);
                continue;
            }
            String currentPortalId = portalIdMap.getOrDefault(dto.getPortalId(), dto.getPortalId());
            AuthRecordPO po = AuthRecordBKDTO.toPO(omadacId.a(), currentSiteId, currentPortalId, Optional.ofNullable(dto.getWlanId()).map(wlanIdMap::get).orElse(null), Optional.ofNullable(dto.getSsidId()).map(ssidIdMap::get).orElse(null), Optional.ofNullable(dto.getNetworkId()).map(networkIdMap::get).orElse(null), dto.getSmsTokenId(), dto);
            authRecordPOList.add(po);
            ++count;
            if (authRecordPOList.size() < 1000) continue;
            this.authRecordMaintRepository.insertAll(authRecordPOList);
            authRecordPOList.clear();
        }
        this.authRecordMaintRepository.insertAll(authRecordPOList);
    }
}

