/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitetemplatereadunit.profile;

import com.tplink.smb.component.storage.api.repository.FileRepository;
import com.tplink.smb.omada.backup.api.a.f;
import com.tplink.smb.omada.backup.api.b.e;
import com.tplink.smb.omada.backup.core.unit.siteconfig.profile.dto.CertProfileDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.profile.dto.CertProfileFileDTO;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.cert.BaseCertProfilePO;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@f(a=com.tplink.smb.omada.common.f.f.CERT_PROFILE)
public class CertProfileSiteTemplateReadUnit
extends e<CertProfileDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertProfileSiteTemplateReadUnit.class);
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.a.a certProfileMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.a.a.a();
    private final FileRepository fileRepository = (FileRepository)a.b(FileRepository.class);
    private static final CertProfileSiteTemplateReadUnit instance = new CertProfileSiteTemplateReadUnit();

    private CertProfileSiteTemplateReadUnit() {
    }

    public static CertProfileSiteTemplateReadUnit getInstance() {
        return instance;
    }

    public CertProfileDTO siteTemplateRead(c omadacId, String siteTemplateId) throws com.tplink.smb.omada.backup.api.d.a {
        CertProfileDTO certProfileDTO = new CertProfileDTO();
        List certProfileTemplatePOList = this.certProfileMaintMongoRepository.a(omadacId, siteTemplateId);
        if (!CollectionUtils.isEmpty((Collection)certProfileTemplatePOList)) {
            certProfileDTO.setCertProfileTemplates(certProfileTemplatePOList);
            ArrayList<BaseCertProfilePO> baseCertProfilePOS = new ArrayList<BaseCertProfilePO>();
            baseCertProfilePOS.addAll(certProfileTemplatePOList);
            certProfileDTO.setCertProfileFileTemplates(this.backupCertificateFile(omadacId, siteTemplateId, baseCertProfilePOS));
        }
        return certProfileDTO;
    }

    private List<CertProfileFileDTO> backupCertificateFile(c omadacId, String siteId, List<BaseCertProfilePO> certificateProfilePO) {
        HashSet<String> fileIds = new HashSet<String>();
        ArrayList<CertProfileFileDTO> ceritifications = new ArrayList<CertProfileFileDTO>();
        for (BaseCertProfilePO po : certificateProfilePO) {
            boolean fileExists;
            AtomicReference fileDataRef;
            CertProfileFileDTO dto;
            if (po.getCaCertFileId() != null && !fileIds.contains(po.getCaCertFileId())) {
                dto = new CertProfileFileDTO();
                dto.setPrefix(omadacId.a());
                dto.setFileId(po.getCaCertFileId());
                dto.setFileName(po.getFileName());
                dto.setFileMd5(po.getCertFileMd5());
                dto.setFormat(po.getFormat());
                fileDataRef = new AtomicReference();
                fileExists = this.fileRepository.readFile(dto.getFileId(), inputStream -> fileDataRef.set(this.streamToString((InputStream)inputStream, po.getFormat())));
                if (fileExists) {
                    dto.setFileData((String)fileDataRef.get());
                }
                fileIds.add(po.getCaCertFileId());
                ceritifications.add(dto);
            }
            if (po.getClientCertFileId() != null && !fileIds.contains(po.getClientCertFileId())) {
                dto = new CertProfileFileDTO();
                dto.setPrefix(omadacId.a());
                dto.setFileId(po.getClientCertFileId());
                dto.setFileName(po.getFileName());
                dto.setFileMd5(po.getCertFileMd5());
                dto.setFormat(po.getFormat());
                fileDataRef = new AtomicReference();
                fileExists = this.fileRepository.readFile(dto.getFileId(), inputStream -> fileDataRef.set(this.streamToString((InputStream)inputStream, po.getFormat())));
                if (fileExists) {
                    dto.setFileData((String)fileDataRef.get());
                }
                fileIds.add(po.getClientCertFileId());
                ceritifications.add(dto);
            }
            if (po.getPrivateKeyFileId() == null || fileIds.contains(po.getPrivateKeyFileId())) continue;
            dto = new CertProfileFileDTO();
            dto.setPrefix(omadacId.a());
            dto.setFileId(po.getPrivateKeyFileId());
            dto.setFileName(po.getPrivateKeyFileName());
            dto.setFileMd5(po.getPrivateKeyFileMd5());
            dto.setFormat(po.getFormat());
            fileDataRef = new AtomicReference();
            fileExists = this.fileRepository.readFile(dto.getFileId(), inputStream -> fileDataRef.set(this.streamToString((InputStream)inputStream, po.getFormat())));
            if (fileExists) {
                dto.setFileData((String)fileDataRef.get());
            }
            fileIds.add(po.getPrivateKeyFileId());
            ceritifications.add(dto);
        }
        return ceritifications;
    }

    private String streamToString(InputStream inputStream, Integer format) {
        if (inputStream != null) {
            try {
                if (format.equals(1)) {
                    byte[] derBytes = IOUtils.toByteArray((InputStream)inputStream);
                    return Base64.getEncoder().encodeToString(derBytes);
                }
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
                return writer.toString();
            }
            catch (IOException e2) {
                log.error("error when convert inputStream to string.", (Throwable)e2);
                return null;
            }
        }
        return null;
    }
}

