/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.wirelessnetwork;

import com.tplink.smb.eventcenter.domain.DomainEventBusHolder;
import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.dto.ClearDbDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.dto.WirelessTemplateDTO;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.restore.a;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.BaseMacFilterPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.H;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.MacFilterPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.group.MacFilterTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ppsk.PPSKProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.ppsk.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.BaseSsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.ssid.SsidTemplatePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.BaseWlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.wlan.WlanGroupTemplatePO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.WIRELESS)
public class WirelessNetworkSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WirelessNetworkSiteSyncTemplateUnit.class);
    private static final WirelessNetworkSiteSyncTemplateUnit instance = new WirelessNetworkSiteSyncTemplateUnit();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d wlanGroupMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.d.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c ssidMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.wireless.c.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d siteLimitMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.omadac.component.d.a();
    private final com.tplink.smb.omada.portal.port.mongo.omada.a.a getSequenceNumService = (com.tplink.smb.omada.portal.port.mongo.omada.a.a)com.tplink.smb.omada.common.spring.a.b(com.tplink.smb.omada.portal.port.mongo.omada.a.a.class);
    private final H macFilterMaintMongoRepository = H.a();
    private final a ppskProfileMaintMongoRepository = a.a();

    private WirelessNetworkSiteSyncTemplateUnit() {
    }

    public static WirelessNetworkSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void clearSiteBeforeSyncTemplate(ClearDbDTO clearDbDTO) {
        this.wlanGroupMaintMongoRepository.d(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
        this.ssidMaintMongoRepository.d(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
        this.macFilterMaintMongoRepository.d(clearDbDTO.getOmadacId(), clearDbDTO.getSiteId());
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        WirelessTemplateDTO wirelessTemplateDTO = (WirelessTemplateDTO)dataObject;
        if (wirelessTemplateDTO == null) {
            return;
        }
        HashMap<String, String> profileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A()) == null ? new HashMap<String, String>() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
        this.syncMacFilter(omadacId, newSiteId, wirelessTemplateDTO.getMacFilterTemplates(), profileIdMap);
        List<WlanGroupTemplatePO> wlanGroupTemplatePOS = wirelessTemplateDTO.getWlanGroupTemplates();
        List<SsidTemplatePO> ssidTemplatePOS = wirelessTemplateDTO.getSsidTemplates();
        if (CollectionUtils.isEmpty(wlanGroupTemplatePOS)) {
            log.error("The WLAN groups template is empty.");
            throw new com.tplink.smb.omada.backup.api.d.c("can not restore WLAN groups setting");
        }
        HashMap<String, WlanGroupPO> boundExistsWlanGroupMap = new HashMap<String, WlanGroupPO>();
        List existsWlanGroupList = this.wlanGroupMaintMongoRepository.a(omadacId, newSiteId);
        if (!CollectionUtils.isEmpty((Collection)existsWlanGroupList)) {
            existsWlanGroupList.forEach(exist -> {
                if (exist.getTemplateId() != null) {
                    boundExistsWlanGroupMap.put(exist.getTemplateId(), (WlanGroupPO)exist);
                }
            });
        }
        HashMap<String, SsidPO> boundExistsSsidMap = new HashMap<String, SsidPO>();
        List existsSsidList = this.ssidMaintMongoRepository.a(omadacId, newSiteId);
        if (!CollectionUtils.isEmpty((Collection)existsSsidList)) {
            existsSsidList.forEach(exist -> {
                if (exist.getTemplateId() != null) {
                    boundExistsSsidMap.put(exist.getTemplateId(), (SsidPO)exist);
                }
            });
        }
        WlanGroupPO primaryWlanGroup = this.wlanGroupMaintMongoRepository.b(omadacId, newSiteId);
        if (this.wlanGroupMaintMongoRepository.c(omadacId) + (long)wlanGroupTemplatePOS.size() > (long)this.siteLimitMaintMongoRepository.a(omadacId)) {
            log.warn("The number of WLAN groups template has reached the limit, only default WLAN Group will be copied.");
            for (WlanGroupTemplatePO wlanGroupTemplatePO : wlanGroupTemplatePOS) {
                WlanGroupPO wlanGroupPO = wlanGroupTemplatePO.copyFromTemplate();
                if (!wlanGroupPO.getPrimary().booleanValue()) continue;
                if (primaryWlanGroup != null) {
                    wlanGroupPO.setId(primaryWlanGroup.getId());
                }
                List<SsidPO> importSsids = this.findSyncSsidTemplatesBySiteIdAndWlanId(wlanGroupPO.getSiteId(), wlanGroupPO.getTemplateId(), ssidTemplatePOS);
                this.copyWlanGroupTemplateSync(omadacId, newSiteId, wlanGroupPO, siteImportIdCacheMap, importSsids, boundExistsWlanGroupMap, boundExistsSsidMap);
                break;
            }
        } else {
            for (WlanGroupTemplatePO wlanGroupTemplatePO : wlanGroupTemplatePOS) {
                WlanGroupPO wlanGroupPO = wlanGroupTemplatePO.copyFromTemplate();
                if (wlanGroupPO.getPrimary().booleanValue() && primaryWlanGroup != null) {
                    wlanGroupPO.setId(primaryWlanGroup.getId());
                }
                List<SsidPO> importSsids = this.findSyncSsidTemplatesBySiteIdAndWlanId(wlanGroupPO.getSiteId(), wlanGroupPO.getTemplateId(), ssidTemplatePOS);
                this.copyWlanGroupTemplateSync(omadacId, newSiteId, wlanGroupPO, siteImportIdCacheMap, importSsids, boundExistsWlanGroupMap, boundExistsSsidMap);
            }
        }
    }

    private void syncMacFilter(c omadacId, d newSiteId, List<MacFilterTemplatePO> macFilterTemplates, Map<String, String> profileIdMap) {
        if (!CollectionUtils.isEmpty(macFilterTemplates)) {
            HashMap boundExistsMap = new HashMap();
            List existList = this.macFilterMaintMongoRepository.a(omadacId, newSiteId);
            if (!CollectionUtils.isEmpty((Collection)existList)) {
                existList.forEach(exist -> {
                    if (exist.getTemplateId() != null) {
                        boundExistsMap.put(exist.getTemplateId(), exist);
                    }
                });
            }
            macFilterTemplates.forEach(templatePO -> {
                MacFilterPO macFilterPO = templatePO.copyFromTemplate();
                String oldMacFilterId = templatePO.getId();
                macFilterPO.setOmadacId(omadacId.a());
                macFilterPO.setSiteId(newSiteId.a());
                if (boundExistsMap.containsKey(macFilterPO.getTemplateId())) {
                    MacFilterPO exist = (MacFilterPO)boundExistsMap.get(macFilterPO.getTemplateId());
                    macFilterPO.setId(exist.getId());
                    macFilterPO.setEntryId(exist.getEntryId());
                    boundExistsMap.remove(macFilterPO.getTemplateId());
                } else {
                    macFilterPO.setId(null);
                    macFilterPO.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), newSiteId.a(), MacFilterPO.class)));
                }
                profileIdMap.put(oldMacFilterId, this.macFilterMaintMongoRepository.a(macFilterPO));
                if (!boundExistsMap.isEmpty()) {
                    Set ids = boundExistsMap.values().stream().map(BaseMacFilterPO::getId).collect(Collectors.toSet());
                    this.macFilterMaintMongoRepository.a(omadacId, newSiteId, ids);
                }
            });
        }
    }

    private List<SsidPO> findSyncSsidTemplatesBySiteIdAndWlanId(String siteId, String wlanId, List<SsidTemplatePO> ssidTemplates) {
        if (CollectionUtils.isEmpty(ssidTemplates)) {
            return Collections.emptyList();
        }
        ArrayList<SsidPO> result = new ArrayList<SsidPO>(ssidTemplates.size());
        for (SsidTemplatePO ssidTemplatePO : ssidTemplates) {
            SsidPO ssidPO = ssidTemplatePO.copyFromTemplate();
            if (!Objects.equals(ssidPO.getSiteId(), siteId) || !Objects.equals(ssidPO.getWlanId(), wlanId)) continue;
            result.add(ssidPO);
        }
        return result;
    }

    private void copyWlanGroupTemplateSync(c omadacId, d newSiteId, WlanGroupPO wlanGroupPO, Map<String, Map<String, String>> siteImportIdCacheMap, List<SsidPO> importSsids, Map<String, WlanGroupPO> boundExistsWlanGroupMap, Map<String, SsidPO> boundExistsSsidMap) {
        String oldWlanId = wlanGroupPO.getTemplateId();
        wlanGroupPO.setOmadacId(omadacId.a());
        wlanGroupPO.setSiteId(newSiteId.a());
        Map wirelessIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.ag.A(), k2 -> new HashMap());
        if (boundExistsWlanGroupMap.containsKey(wlanGroupPO.getTemplateId())) {
            WlanGroupPO exist = boundExistsWlanGroupMap.get(wlanGroupPO.getTemplateId());
            wlanGroupPO.setId(exist.getId());
            boundExistsWlanGroupMap.remove(wlanGroupPO.getTemplateId());
        } else {
            wlanGroupPO.setId(null);
        }
        String newWlanId = this.wlanGroupMaintMongoRepository.a((BaseWlanGroupPO)wlanGroupPO);
        wirelessIdMap.put(oldWlanId, newWlanId);
        siteImportIdCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
        this.copySsidTemplatesSync(omadacId, newSiteId, newWlanId, siteImportIdCacheMap, importSsids, boundExistsSsidMap);
        if (!boundExistsWlanGroupMap.isEmpty()) {
            Set needDeleteWlanGroupIds = boundExistsWlanGroupMap.values().stream().map(BaseWlanGroupPO::getId).collect(Collectors.toSet());
            this.wlanGroupMaintMongoRepository.a(omadacId, newSiteId, needDeleteWlanGroupIds);
        }
    }

    private void copySsidTemplatesSync(c omadacId, d siteId, String newWlanId, Map<String, Map<String, String>> siteImportIdCacheMap, List<SsidPO> importSsids, Map<String, SsidPO> boundExistsSsidMap) {
        Map<String, String> profileIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.Y.A());
        Map<String, String> portalIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ad.A());
        Map<String, String> radiusProfileIdMap = siteImportIdCacheMap.get("radiusProfileIdOriginToCurrent");
        HashMap<String, String> wirelessIdMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ag.A()) == null ? new HashMap<String, String>() : siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.ag.A());
        Map<String, String> wiredNetworkMap = siteImportIdCacheMap.get(com.tplink.smb.omada.backup.api.c.d.af.A());
        if (!CollectionUtils.isEmpty(importSsids)) {
            for (SsidPO ssid : importSsids) {
                String oldSsidId = ssid.getTemplateId();
                if (boundExistsSsidMap.containsKey(ssid.getTemplateId())) {
                    SsidPO exist = boundExistsSsidMap.get(ssid.getTemplateId());
                    ssid.setId(exist.getId());
                    ssid.setEntryId(exist.getEntryId());
                    boundExistsSsidMap.remove(ssid.getTemplateId());
                } else {
                    ssid.setId(null);
                    ssid.setEntryId(Integer.valueOf(this.getSequenceNumService.a(omadacId.a(), siteId.a(), SsidPO.class)));
                }
                ssid.setOmadacId(omadacId.a());
                ssid.setWlanId(newWlanId);
                ssid.setSiteId(siteId.a());
                if (ssid.getPortalId() == null) {
                    ssid.setPortalId(null);
                } else {
                    ssid.setPortalId(portalIdMap.get(ssid.getPortalId()));
                }
                if (Objects.equals(ssid.getSecurity(), 2) && !CollectionUtils.isEmpty(radiusProfileIdMap) && !T.a((String)radiusProfileIdMap.get(ssid.getWpaSetting().getRadiusProfileId()))) {
                    ssid.getWpaSetting().setRadiusProfileId(radiusProfileIdMap.get(ssid.getWpaSetting().getRadiusProfileId()));
                }
                this.updatePPSK((BaseSsidPO)ssid, radiusProfileIdMap, profileIdMap, siteId);
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getScheduleId()))) {
                    ssid.setScheduleId(profileIdMap.get(ssid.getScheduleId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getMacFilterId()))) {
                    ssid.setMacFilterId(profileIdMap.get(ssid.getMacFilterId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && ssid.getMultiCastSetting() != null && !T.a((String)profileIdMap.get(ssid.getMultiCastSetting().getMacGroupId()))) {
                    ssid.getMultiCastSetting().setMacGroupId(profileIdMap.get(ssid.getMultiCastSetting().getMacGroupId()));
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !CollectionUtils.isEmpty((Collection)ssid.getOuiProfileIds())) {
                    ArrayList newIdList = new ArrayList();
                    ssid.getOuiProfileIds().forEach(oldId -> {
                        if (!T.a((String)((String)profileIdMap.get(oldId)))) {
                            newIdList.add((String)profileIdMap.get(oldId));
                        }
                    });
                    ssid.setOuiProfileIds(newIdList);
                }
                if (!CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getRateLimit().getRateLimitId()))) {
                    ssid.getRateLimit().setRateLimitId(profileIdMap.get(ssid.getRateLimit().getRateLimitId()));
                }
                if (Objects.nonNull(ssid.getSsidRateLimit()) && !CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getSsidRateLimit().getRateLimitId()))) {
                    ssid.getSsidRateLimit().setRateLimitId(profileIdMap.get(ssid.getSsidRateLimit().getRateLimitId()));
                }
                if (ssid.getVlanSetting() != null && ssid.getVlanSetting().getLanNetworkId() != null && !CollectionUtils.isEmpty(wiredNetworkMap)) {
                    ssid.getVlanSetting().setLanNetworkId(wiredNetworkMap.get(ssid.getVlanSetting().getLanNetworkId()));
                }
                if (ssid.getVlanSetting() != null && ssid.getVlanSetting().getLanNetworkVlanIds() != null && !CollectionUtils.isEmpty(wiredNetworkMap)) {
                    HashMap newLanNetworkVlanIds = new HashMap();
                    Map lanNetworkVlanIds = ssid.getVlanSetting().getLanNetworkVlanIds();
                    lanNetworkVlanIds.keySet().forEach(lanNetworkId -> {
                        List vlanIds = (List)lanNetworkVlanIds.get(lanNetworkId);
                        newLanNetworkVlanIds.put((String)wiredNetworkMap.get(lanNetworkId), vlanIds);
                    });
                    ssid.getVlanSetting().setLanNetworkVlanIds(newLanNetworkVlanIds);
                }
                String newSsidId = this.ssidMaintMongoRepository.a((BaseSsidPO)ssid);
                wirelessIdMap.put(oldSsidId, newSsidId);
                DomainEventBusHolder.getPublisher().publishSync(((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)((a.a)((Object)com.tplink.smb.omada.backup.core.unit.siteconfig.wirelessnetwork.restore.a.a().a(omadacId))).a(siteId))).a(oldSsidId))).b(newSsidId))).a(x.a))).b());
            }
            siteImportIdCacheMap.put(com.tplink.smb.omada.backup.api.c.d.ag.A(), wirelessIdMap);
        }
        if (!boundExistsSsidMap.isEmpty()) {
            Set needDeleteSsidIds = boundExistsSsidMap.values().stream().map(BaseSsidPO::getId).collect(Collectors.toSet());
            this.ssidMaintMongoRepository.a(omadacId, siteId, needDeleteSsidIds);
        }
    }

    private void updatePPSK(BaseSsidPO ssid, Map<String, String> radiusProfileIdMap, Map<String, String> profileIdMap, d siteId) {
        if (Objects.equals(ssid.getSecurity(), 4) && !CollectionUtils.isEmpty(profileIdMap) && !T.a((String)profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()))) {
            ssid.getPpskSetting().setPpskProfileId(profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()));
            PPSKProfilePO ppskProfilePO = this.ppskProfileMaintMongoRepository.a(new c(ssid.getOmadacId()), siteId, ssid.getPpskSetting().getPpskProfileId());
            if (ppskProfilePO != null) {
                Optional.ofNullable(ssid.getPpskSetting().getPmkProfile()).map(pmkProfilePO -> pmkProfilePO.setEntryId(ppskProfilePO.getEntryId()));
            }
        }
        if (Objects.equals(ssid.getSecurity(), 5) && !CollectionUtils.isEmpty(radiusProfileIdMap) && !T.a((String)radiusProfileIdMap.get(ssid.getPpskSetting().getRadiusProfileId()))) {
            ssid.getPpskSetting().setRadiusProfileId(radiusProfileIdMap.get(ssid.getPpskSetting().getRadiusProfileId()));
        }
        if (Objects.equals(ssid.getSecurity(), 5) && !CollectionUtils.isEmpty(profileIdMap) && !T.a((String)ssid.getPpskSetting().getPpskProfileId()) && !T.a((String)profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()))) {
            ssid.getPpskSetting().setPpskProfileId(profileIdMap.get(ssid.getPpskSetting().getPpskProfileId()));
        }
    }
}

