/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.backup.core.sitetemplate.sitesyncunit.wirednetwork;

import com.tplink.smb.omada.backup.api.a.e;
import com.tplink.smb.omada.backup.api.c.n;
import com.tplink.smb.omada.backup.core.restore.q;
import com.tplink.smb.omada.backup.core.unit.siteconfig.wirednetwork.dto.WanTemplateDTO;
import com.tplink.smb.omada.common.f.f;
import com.tplink.smb.omada.maintenance.common.b.a.a.c;
import com.tplink.smb.omada.maintenance.common.b.a.a.d;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.i.g;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.apn.BaseApnProfilePO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.profile.apn.a;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.BaseInternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.DialupSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.InternetPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.LteWanSettingPO;
import com.tplink.smb.omada.manager.port.mongo.configuration.site.wired.wan.osgmodel.OsgModelConfigPO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@e(a=f.WAN)
public class WanNetworkSiteSyncTemplateUnit
extends com.tplink.smb.omada.backup.api.e {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WanNetworkSiteSyncTemplateUnit.class);
    private final g osgModelConfigMainMongoRepository = g.a();
    private final com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a internetMaintMongoRepository = com.tplink.smb.omada.manager.port.mongo.configuration.site.i.a.a();
    private final q osgTemplateConfigSyncService = (q)com.tplink.smb.omada.common.spring.a.b(q.class);
    private final a apnProfileMaintMonfoRepository = a.a();
    private static final WanNetworkSiteSyncTemplateUnit instance = new WanNetworkSiteSyncTemplateUnit();

    private WanNetworkSiteSyncTemplateUnit() {
    }

    public static WanNetworkSiteSyncTemplateUnit getInstance() {
        return instance;
    }

    public void siteTemplateSyncToSiteWrite(Object dataObject, c omadacId, d newSiteId, Map<String, Map<String, String>> siteImportIdCacheMap, boolean bindSite) throws com.tplink.smb.omada.backup.api.d.c, IOException {
        Map profileMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.Y.A(), v2 -> new HashMap());
        Map netIdMap = siteImportIdCacheMap.computeIfAbsent(com.tplink.smb.omada.backup.api.c.d.af.A(), v2 -> new HashMap());
        WanTemplateDTO wiredNetworkDTO = (WanTemplateDTO)dataObject;
        if (wiredNetworkDTO == null) {
            log.warn("omadacId={},siteId={} Wired Network SiteImport dto is null.", (Object)omadacId.a(), (Object)newSiteId.a());
            return;
        }
        Boolean templateInternetEnable = Optional.ofNullable(wiredNetworkDTO.getInternetTemplate()).map(BaseInternetPO::getEnable).orElse(false);
        this.handleInternetSyncToSite(omadacId, newSiteId, wiredNetworkDTO, profileMap, netIdMap);
        log.debug("omadacId={},siteId={} Wired Network SiteTemplateSyncToSiteWrite Success.", (Object)omadacId.a(), (Object)newSiteId.a());
    }

    private void handleInternetSyncToSite(c omadacId, d siteId, WanTemplateDTO wiredNetworkDTO, Map<String, String> profileMap, Map<String, String> netIdMap) {
        Optional oldInternetPOOpt = this.internetMaintMongoRepository.c(omadacId, siteId);
        if (wiredNetworkDTO.getOsgModelConfigTemplate() == null || wiredNetworkDTO.getInternetTemplate() == null || !Boolean.TRUE.equals(wiredNetworkDTO.getInternetTemplate().getEnable())) {
            if (oldInternetPOOpt.isPresent() && Boolean.TRUE.equals(((InternetPO)oldInternetPOOpt.get()).getEnable())) {
                this.handleInternetApnProfile(omadacId, siteId, profileMap, (BaseInternetPO)oldInternetPOOpt.get());
                this.internetMaintMongoRepository.a((InternetPO)oldInternetPOOpt.get());
            }
            return;
        }
        if (!oldInternetPOOpt.isPresent() || !Boolean.TRUE.equals(((InternetPO)oldInternetPOOpt.get()).getEnable())) {
            this.osgModelConfigMainMongoRepository.a(omadacId, siteId, n.a);
            this.internetMaintMongoRepository.b(omadacId, siteId, n.a);
            this.handleOsgModelConfigTemplate(omadacId, siteId, wiredNetworkDTO);
            this.handleInternetTemplate(omadacId, siteId, wiredNetworkDTO, profileMap);
            return;
        }
        OsgModelConfigPO oldOsgModelConfigPO = this.osgModelConfigMainMongoRepository.a(omadacId, siteId).orElse(null);
        this.osgModelConfigMainMongoRepository.a(omadacId, siteId, n.a);
        this.handleOsgModelConfigTemplate(omadacId, siteId, wiredNetworkDTO);
        InternetPO newInternetPO = this.osgTemplateConfigSyncService.a(omadacId, siteId, wiredNetworkDTO.getInternetTemplate(), oldInternetPOOpt.orElse(null), wiredNetworkDTO.getOsgModelConfigTemplate(), oldOsgModelConfigPO);
        this.handleInternetApnProfile(omadacId, siteId, profileMap, (BaseInternetPO)newInternetPO);
        this.handleLoadBalanceByVirtualWan(netIdMap, (BaseInternetPO)newInternetPO);
        this.internetMaintMongoRepository.b(omadacId, siteId, n.a);
        this.internetMaintMongoRepository.a(newInternetPO);
    }

    private void handleOsgModelConfigTemplate(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WanTemplateDTO wiredNetworkDTO) {
        Optional.ofNullable(wiredNetworkDTO.getOsgModelConfigTemplate()).ifPresent(osgModelConfigTemplatePO -> {
            OsgModelConfigPO osgModelConfigPO = osgModelConfigTemplatePO.copyFromTemplate();
            osgModelConfigPO.setOmadacId(omadacId.a());
            osgModelConfigPO.setSiteId(newSiteId.a());
            osgModelConfigPO.setId(null);
            this.osgModelConfigMainMongoRepository.a(osgModelConfigPO);
        });
    }

    private void handleInternetTemplate(@Nonnull c omadacId, @Nonnull d newSiteId, @Nonnull WanTemplateDTO wiredNetworkDTO, Map<String, String> profileMap) {
        Optional.ofNullable(wiredNetworkDTO.getInternetTemplate()).ifPresent(internetTemplatePO -> {
            InternetPO internetPO = internetTemplatePO.copyFromTemplate();
            internetPO.setOmadacId(omadacId.a());
            internetPO.setSiteId(newSiteId.a());
            internetPO.setId(null);
            this.handleInternetApnProfile(omadacId, newSiteId, profileMap, (BaseInternetPO)internetPO);
            this.internetMaintMongoRepository.a(internetPO);
        });
    }

    private void handleInternetApnProfile(@Nonnull c omadacId, @Nonnull d newSiteId, Map<String, String> profileMap, BaseInternetPO internetPO) {
        if (Objects.isNull(internetPO) || !Boolean.TRUE.equals(internetPO.getEnable())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)internetPO.getLteWanSettings())) {
            List apnProfilePOList = this.apnProfileMaintMonfoRepository.a(omadacId, newSiteId);
            Set<String> apnProfileIdSet = apnProfilePOList.stream().map(BaseApnProfilePO::getId).collect(Collectors.toSet());
            for (LteWanSettingPO lteWanSettingPO : internetPO.getLteWanSettings()) {
                this.convertInternetApnProfile(profileMap, lteWanSettingPO.getDialupSetting(), apnProfileIdSet);
                if (CollectionUtils.isEmpty((Collection)lteWanSettingPO.getDialUpSettings())) continue;
                for (DialupSettingPO dialUpSettingPO : lteWanSettingPO.getDialUpSettings()) {
                    this.convertInternetApnProfile(profileMap, dialUpSettingPO, apnProfileIdSet);
                }
            }
        }
    }

    private void convertInternetApnProfile(Map<String, String> profileMap, DialupSettingPO dialUpSettingPO, Set<String> apnProfileIdSet) {
        if (Objects.nonNull(dialUpSettingPO) && Objects.equals(dialUpSettingPO.getApnMode(), 1)) {
            if (profileMap.containsKey(dialUpSettingPO.getApn())) {
                dialUpSettingPO.setApn(profileMap.get(dialUpSettingPO.getApn()));
            }
            if (!apnProfileIdSet.contains(dialUpSettingPO.getApn())) {
                dialUpSettingPO.setApn(null);
                dialUpSettingPO.setApnMode(Integer.valueOf(0));
            }
        }
    }

    private void handleLoadBalanceByVirtualWan(Map<String, String> netIdMap, BaseInternetPO internetPO) {
        if (internetPO.getWanLoadBalance() != null && !CollectionUtils.isEmpty((Collection)internetPO.getWanLoadBalance().getVirtualWanWeights())) {
            internetPO.getWanLoadBalance().getVirtualWanWeights().forEach(virtualWanWeightPO -> virtualWanWeightPO.setVirtualWanId((String)netIdMap.get(virtualWanWeightPO.getVirtualWanId())));
        }
    }
}

